/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.AWTKeyStroke;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.beans.BeanDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TooManyListenersException;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentDragger;
import org.netbeans.modules.form.ComponentLayer;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.NewComponentDrop;
import org.netbeans.modules.form.NewComponentDropProvider;
import org.netbeans.modules.form.NonVisualTray;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.DuplicateAction;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutTestUtils;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeOperation;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class HandleLayer
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public static final int COMP_DEEPEST = 0;
    public static final int COMP_SELECTED = 1;
    public static final int COMP_ABOVE_SELECTED = 2;
    public static final int COMP_UNDER_SELECTED = 3;
    private static final int DESIGNER_RESIZING = 256;
    private static final int INBOUND_RESIZING = 512;
    private static final int RESIZE_MASK = 15;
    private static MessageFormat resizingHintFormat;
    private static MessageFormat sizeHintFormat;
    private FormDesigner formDesigner;
    private boolean viewOnly;
    private ComponentDrag draggedComponent;
    private JPanel dragPanel;
    private Point lastMousePosition;
    private int lastXPosDiff;
    private int lastYPosDiff;
    private Point lastLeftMousePoint;
    private Point prevLeftMousePoint;
    private boolean draggingEnded;
    private int resizeType;
    private boolean draggingSuspended;
    private SelectionDragger selectionDragger;
    private Image resizeHandle;
    private DropTarget dropTarget;
    private DropTargetListener dropListener;
    private String mouseHint;
    private MouseWheeler wheeler;
    private boolean wheelerBlocked;
    private static FormLoaderSettings formSettings;
    private static final int BUTTON_GROUP_OFFSET = 5;
    private static final boolean BUTTON_GROUP_COLUMNS_FIRST = false;
    private static int lastPaintWidth;
    private Stroke paintStroke;
    private JPanel darkerPanel = null;
    private static Field componentValidField;
    private Map<RADComponent, Rectangle[]> hiddenComponents = new IdentityHashMap<RADComponent, Rectangle[]>();

    HandleLayer(FormDesigner fd) {
        this.formDesigner = fd;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setLayout(null);
        this.dragPanel = new JPanel();
        this.dragPanel.setLayout(null);
        this.dragPanel.setBounds(-1, -1, 0, 0);
        this.add(this.dragPanel);
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>();
        keys.add(AWTKeyStroke.getAWTKeyStroke(9, 128, true));
        this.setFocusTraversalKeys(0, keys);
        keys.clear();
        keys.add(AWTKeyStroke.getAWTKeyStroke(9, 192, true));
        this.setFocusTraversalKeys(1, keys);
        this.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACSN_HandleLayer"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_HandleLayer"));
        this.dropListener = new NewComponentDropListener();
        this.dropTarget = new DropTarget(this, this.dropListener);
    }

    public boolean isSuspended() {
        return this.draggingSuspended;
    }

    public void suspend() {
        this.draggingSuspended = true;
    }

    public void resume() {
        this.draggingSuspended = false;
    }

    public DropTargetListener getNewComponentDropListener() {
        return this.dropListener;
    }

    public void setNewComponentDropListener(DropTargetListener l) {
        this.dropTarget.removeDropTargetListener(this.dropListener);
        this.dropListener = l;
        try {
            this.dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    void setViewOnly(boolean viewOnly) {
        if (this.viewOnly == viewOnly) {
            return;
        }
        if (viewOnly) {
            this.dropTarget.removeDropTargetListener(this.dropListener);
        } else {
            try {
                this.dropTarget.addDropTargetListener(this.dropListener);
            }
            catch (TooManyListenersException ex) {
                ex.printStackTrace();
            }
        }
        this.viewOnly = viewOnly;
    }

    private FormModel getFormModel() {
        return this.formDesigner.getFormModel();
    }

    private MetaComponentCreator getComponentCreator() {
        return this.formDesigner.getFormModel().getComponentCreator();
    }

    private LayoutModel getLayoutModel() {
        return this.formDesigner.getFormModel().getLayoutModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.formDesigner.getDesignerMode() == 1) {
            RADComponent conSource = this.formDesigner.getConnectionSource();
            RADComponent conTarget = this.formDesigner.getConnectionTarget();
            if (conSource != null || conTarget != null) {
                g2.setColor(formSettings.getConnectionBorderColor());
                if (conSource != null) {
                    this.paintSelection(g2, conSource, false);
                }
                if (conTarget != null) {
                    this.paintSelection(g2, conTarget, false);
                }
            }
            return;
        }
        if (this.draggedComponent != null) {
            if (!this.isSuspended()) {
                try {
                    FormLAF.setUseDesignerDefaults(this.getFormModel());
                    this.draggedComponent.paintFeedback(g2);
                    Area draggedArea = null;
                    for (Map.Entry<RADComponent, Rectangle[]> entry : this.hiddenComponents.entrySet()) {
                        RADComponent metacomp = entry.getKey();
                        Object object = this.formDesigner.getComponent(metacomp);
                        if (!(object instanceof Component)) continue;
                        Component comp = (Component)object;
                        Rectangle[] value = entry.getValue();
                        Rectangle bounds = new Rectangle(value[0]);
                        Rectangle visibleBounds = value[1];
                        comp.setSize(bounds.getSize());
                        HandleLayer.doLayout(comp);
                        bounds = this.convertRectangleFromComponent(bounds, comp.getParent());
                        Rectangle visibleRect = new Rectangle(bounds.x + visibleBounds.x, bounds.y + visibleBounds.y, visibleBounds.width, visibleBounds.height);
                        Area clip = new Area(visibleRect);
                        if (draggedArea == null && this.draggedComponent.movingBounds.length > 0 && this.draggedComponent.movingBounds[0].x > Integer.MIN_VALUE) {
                            draggedArea = new Area();
                            for (int i = 0; i < this.draggedComponent.showingComponents.length; ++i) {
                                Rectangle rect = new Rectangle(this.draggedComponent.movingBounds[i].x + this.draggedComponent.convertPoint.x, this.draggedComponent.movingBounds[i].y + this.draggedComponent.convertPoint.y, this.draggedComponent.movingBounds[i].width + 1, this.draggedComponent.movingBounds[i].height + 1);
                                draggedArea.add(new Area(rect));
                            }
                        }
                        if (draggedArea != null) {
                            clip.subtract(draggedArea);
                        }
                        Graphics gg = g.create();
                        gg.setClip(clip);
                        gg.translate(bounds.x, bounds.y);
                        HandleLayer.paintDraggedComponent(comp, gg, 0.3f);
                        gg.dispose();
                    }
                }
                finally {
                    FormLAF.setUseDesignerDefaults(null);
                }
            }
        } else {
            g2.setColor(formSettings.getSelectionBorderColor());
            boolean painted = false;
            try {
                boolean inLayout = this.selectedComponentsInSameVisibleContainer();
                if (inLayout || this.isNewLayoutRootSelection(true)) {
                    this.paintLayoutInnerSelection(g2);
                }
                for (RADComponent metacomp : this.formDesigner.getSelectedComponents()) {
                    RADVisualComponent layoutMetacomp = this.formDesigner.componentToLayoutComponent(metacomp);
                    if (layoutMetacomp != null) {
                        metacomp = layoutMetacomp;
                    }
                    this.paintSelection(g2, metacomp, inLayout);
                }
                this.paintButtonGroups(g2);
                painted = true;
            }
            finally {
                if (!painted) {
                    this.formDesigner.clearSelection();
                }
            }
            if (this.selectionDragger != null) {
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(this.getPaintStroke());
                this.selectionDragger.paintDragFeedback(g2);
                g2.setStroke(oldStroke);
            }
        }
    }

    private void paintSelection(Graphics2D g, RADComponent metacomp, boolean inLayout) {
        if (!(metacomp instanceof RADVisualComponent) && !(metacomp instanceof RADMenuItemComponent)) {
            return;
        }
        Object comp = this.formDesigner.getComponent(metacomp);
        if (!(comp instanceof Component)) {
            return;
        }
        Component component = (Component)comp;
        Container parent = component.getParent();
        if (parent != null && component.isShowing()) {
            Rectangle selRect = component.getBounds();
            this.convertRectangleFromComponent(selRect, parent);
            Rectangle visible = new Rectangle(0, 0, parent.getWidth(), parent.getHeight());
            visible = this.convertVisibleRectangleFromComponent(visible, parent);
            int resizable = 0;
            if (inLayout) {
                resizable = this.getComponentResizable((RADVisualComponent)metacomp);
            }
            if (resizable == 0) {
                selRect = selRect.intersection(visible);
            }
            int correction = formSettings.getSelectionBorderSize() % 2;
            int x = selRect.x - correction;
            int y = selRect.y - correction;
            int width = selRect.width + correction;
            int height = selRect.height + correction;
            Stroke oldStroke = g.getStroke();
            g.setStroke(this.getPaintStroke());
            g.drawRect(x, y, width, height);
            g.setStroke(oldStroke);
            if (inLayout) {
                Image resizeHandle = this.resizeHandle();
                int iconHeight = resizeHandle.getHeight(null);
                int iconWidth = resizeHandle.getWidth(null);
                if ((resizable & 4) != 0) {
                    g.drawImage(resizeHandle, x - iconWidth + 1, y + (height - iconHeight) / 2, null);
                    if ((resizable & 1) != 0) {
                        g.drawImage(resizeHandle, x - iconWidth + 1, y - iconHeight + 1, null);
                    }
                    if ((resizable & 2) != 0) {
                        g.drawImage(resizeHandle, x - iconWidth + 1, y + height, null);
                    }
                }
                if ((resizable & 8) != 0) {
                    g.drawImage(resizeHandle, x + width, y + (height - iconHeight) / 2, null);
                    if ((resizable & 1) != 0) {
                        g.drawImage(resizeHandle, x + width, y - iconHeight + 1, null);
                    }
                    if ((resizable & 2) != 0) {
                        g.drawImage(resizeHandle, x + width, y + height, null);
                    }
                }
                if ((resizable & 1) != 0) {
                    g.drawImage(resizeHandle, x + (width - iconWidth) / 2, y - iconHeight + 1, null);
                }
                if ((resizable & 2) != 0) {
                    g.drawImage(resizeHandle, x + (width - iconWidth) / 2, y + height, null);
                }
            }
        }
    }

    private void paintLayoutInnerSelection(Graphics2D g) {
        Component topComp;
        LayoutDesigner layoutDesigner = this.formDesigner.getLayoutDesigner();
        if (layoutDesigner != null && (topComp = this.formDesigner.getTopDesignComponentView()) != null) {
            Point convertPoint = this.convertPointFromComponent(0, 0, topComp);
            g.translate(convertPoint.x, convertPoint.y);
            Color oldColor = g.getColor();
            g.setColor(formSettings.getGuidingLineColor());
            layoutDesigner.paintSelection(g);
            g.setColor(oldColor);
            g.translate(-convertPoint.x, -convertPoint.y);
        }
    }

    private void paintButtonGroups(Graphics2D g) {
        Iterator<RADComponent> metacomps = this.formDesigner.getSelectedComponents().iterator();
        HashMap buttonGroups = null;
        while (metacomps.hasNext()) {
            LinkedList members;
            RADComponent metacomp = metacomps.next();
            Object buttonGroup = this.buttonGroupOfComponent(metacomp);
            if (buttonGroup == null && metacomp.getBeanInstance() instanceof ButtonGroup) {
                buttonGroup = metacomp.getBeanInstance();
            }
            if (buttonGroup == null) continue;
            if (buttonGroups == null) {
                buttonGroups = new HashMap();
            }
            if ((members = (LinkedList)buttonGroups.get(buttonGroup)) != null) continue;
            members = new LinkedList();
            buttonGroups.put(buttonGroup, members);
        }
        if (buttonGroups != null) {
            for (RADComponent metacomp : this.getFormModel().getComponentList()) {
                List members;
                Object buttonGroup = this.buttonGroupOfComponent(metacomp);
                if (buttonGroup == null || (members = (List)buttonGroups.get(buttonGroup)) == null) continue;
                members.add((AbstractButton)this.formDesigner.getComponent(metacomp));
            }
            for (List buttons : buttonGroups.values()) {
                if (buttons.size() <= 1) continue;
                IdentityHashMap<AbstractButton, Rectangle> bounds = new IdentityHashMap<AbstractButton, Rectangle>();
                for (AbstractButton button : buttons) {
                    Point shift = this.formDesigner.pointFromComponentToHandleLayer(new Point(0, 0), button);
                    Rectangle bound = new Rectangle(shift.x, shift.y, button.getWidth(), button.getHeight());
                    bounds.put(button, bound);
                }
                this.paintButtonGroup(g, buttons, false, true, bounds, true);
            }
        }
    }

    private Object buttonGroupOfComponent(RADComponent metacomp) {
        if (!(metacomp instanceof RADVisualComponent) || !this.formDesigner.isInDesigner((RADVisualComponent)metacomp)) {
            return null;
        }
        if (AbstractButton.class.isAssignableFrom(metacomp.getBeanClass())) {
            FormProperty prop = (FormProperty)metacomp.getPropertyByName("buttonGroup");
            try {
                return prop.getRealValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private int paintButtonGroup(Graphics g, List<AbstractButton> buttons, boolean columns, boolean root, Map<AbstractButton, Rectangle> compBounds, boolean lastSuccessful) {
        int minStart;
        int[] starts;
        TreeMap<Integer, int[]> bounds = new TreeMap<Integer, int[]>();
        for (AbstractButton button : buttons) {
            int end;
            int start;
            Rectangle bound = compBounds.get(button);
            if (columns) {
                start = bound.x;
                end = start + bound.width;
            } else {
                start = bound.y;
                end = start + bound.height;
            }
            this.paintButtonGroupInsertCount(bounds, start, true);
            this.paintButtonGroupInsertCount(bounds, end, false);
        }
        AbstractList cuts = new LinkedList();
        int between = 0;
        for (Map.Entry entry : bounds.entrySet()) {
            int[] counts = (int[])entry.getValue();
            if ((between -= counts[1]) <= 0 && counts[0] > 0) {
                cuts.add(entry.getKey());
            }
            between += counts[0];
        }
        List[] groups = new List[cuts.size()];
        for (int i = 0; i < cuts.size(); ++i) {
            groups[i] = new LinkedList();
        }
        for (AbstractButton button : buttons) {
            Integer cut;
            Rectangle bound = compBounds.get(button);
            int start = columns ? bound.x : bound.y;
            int index = 0;
            Iterator i$ = cuts.iterator();
            while (i$.hasNext() && (cut = (Integer)i$.next()) <= start) {
                ++index;
            }
            groups[--index].add(button);
        }
        if (!lastSuccessful && cuts.size() == 1) {
            return -1;
        }
        boolean ok = false;
        block5: do {
            starts = new int[cuts.size()];
            minStart = Integer.MAX_VALUE;
            boolean succesful = cuts.size() > 1;
            for (int i = 0; i < cuts.size(); ++i) {
                if (groups[i].size() > 1) {
                    starts[i] = this.paintButtonGroup(g, groups[i], !columns, root && !succesful, compBounds, succesful);
                    if (starts[i] == -1) {
                        assert (cuts.size() == 1);
                        ArrayList<int[]> cutOrder = new ArrayList<int[]>(buttons.size());
                        int j = 0;
                        while (j < buttons.size()) {
                            AbstractButton button = buttons.get(j);
                            Rectangle bound = compBounds.get(button);
                            cutOrder.add(new int[]{columns ? bound.x : bound.y, j++});
                        }
                        Collections.sort(cutOrder, new Comparator<int[]>(){

                            @Override
                            public int compare(int[] i1, int[] i2) {
                                return i1[0] == i2[0] ? i1[1] - i2[1] : i1[0] - i2[0];
                            }
                        });
                        cuts = new ArrayList(buttons.size());
                        groups = new List[buttons.size()];
                        for (int[] ii : cutOrder) {
                            AbstractButton button = buttons.get(ii[1]);
                            groups[cuts.size()] = Collections.singletonList(button);
                            cuts.add(ii[0]);
                        }
                        continue block5;
                    }
                } else {
                    Rectangle bound = compBounds.get(groups[i].get(0));
                    int n = starts[i] = columns ? bound.y : bound.x;
                }
                if (minStart <= starts[i]) continue;
                minStart = starts[i];
            }
            minStart -= 5;
            ok = true;
        } while (!ok);
        int count = 0;
        int min = 0;
        int max = 0;
        for (Integer cut : cuts) {
            int off = 0;
            if (groups[count].size() == 1) {
                AbstractButton button = (AbstractButton)groups[count].get(0);
                Rectangle bound = compBounds.get(button);
                if (button instanceof JRadioButton || button instanceof JCheckBox) {
                    int oppAlignment;
                    int alignment;
                    Dimension dim = button.getPreferredSize();
                    Insets insets = button.getInsets();
                    int textPos = columns ? button.getHorizontalTextPosition() : button.getVerticalTextPosition();
                    Icon icon = button.getIcon();
                    if (icon == null) {
                        icon = UIManager.getIcon(button instanceof JRadioButton ? "RadioButton.icon" : "CheckBox.icon");
                    }
                    if (icon != null) {
                        off = columns ? icon.getIconWidth() : icon.getIconHeight();
                        off /= 2;
                        if (textPos == 10 || textPos == 1 || textPos == 2) {
                            off = (columns ? dim.width : dim.height) - off;
                            off -= columns ? insets.right : insets.bottom;
                        } else {
                            off = textPos == 0 ? (columns ? (dim.width + insets.left - insets.right) / 2 : (dim.height + insets.top - insets.bottom) / 2) : (off += columns ? insets.left : insets.top);
                        }
                    }
                    int n = count;
                    starts[n] = starts[n] + (columns ? insets.top : insets.left);
                    int diff = columns ? bound.width - dim.width : bound.height - dim.height;
                    int n2 = alignment = columns ? button.getHorizontalAlignment() : button.getVerticalAlignment();
                    if (alignment == 11 || alignment == 3 || alignment == 4) {
                        off += diff;
                    } else if (alignment == 0) {
                        off += diff / 2;
                    }
                    int oppDiff = columns ? bound.height - dim.height : bound.width - dim.width;
                    int n3 = oppAlignment = columns ? button.getVerticalAlignment() : button.getHorizontalAlignment();
                    if (oppAlignment == 11 || oppAlignment == 3 || oppAlignment == 4) {
                        int n4 = count;
                        starts[n4] = starts[n4] + oppDiff;
                    } else if (oppAlignment == 0) {
                        int n5 = count;
                        starts[n5] = starts[n5] + oppDiff / 2;
                    }
                } else {
                    off = (columns ? bound.width : bound.height) / 2;
                }
            } else {
                off = -5;
            }
            if (count == 0) {
                min = cut + off;
            }
            if (count == cuts.size() - 1) {
                max = cut + off;
            }
            if (cuts.size() > 1) {
                if (columns) {
                    g.drawLine(cut + off, starts[count], cut + off, minStart);
                } else {
                    g.drawLine(starts[count], cut + off, minStart, cut + off);
                }
            }
            ++count;
        }
        if (cuts.size() > 1) {
            if (!root) {
                min = (Integer)bounds.firstKey();
            }
            if (columns) {
                g.drawLine(min, minStart, max, minStart);
            } else {
                g.drawLine(minStart, min, minStart, max);
            }
        }
        return (Integer)bounds.firstKey();
    }

    private void paintButtonGroupInsertCount(SortedMap<Integer, int[]> bounds, int value, boolean start) {
        int[] counts = (int[])bounds.get(value);
        if (counts == null) {
            counts = new int[2];
            bounds.put(value, counts);
        }
        int n = start ? 0 : 1;
        counts[n] = counts[n] + 1;
    }

    private Image resizeHandle() {
        if (this.resizeHandle == null) {
            this.resizeHandle = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/resize_handle.png", (boolean)false).getImage();
        }
        return this.resizeHandle;
    }

    private Stroke getPaintStroke() {
        int width = formSettings.getSelectionBorderSize();
        if (lastPaintWidth != width) {
            this.paintStroke = null;
        }
        if (this.paintStroke == null) {
            this.paintStroke = new BasicStroke(width);
            lastPaintWidth = width;
        }
        return this.paintStroke;
    }

    void maskDraggingComponents() {
        if (this.draggedComponent != null) {
            this.draggedComponent.maskDraggingComponents();
        }
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 9 || e.getKeyChar() == '\t') {
            if (!e.isControlDown()) {
                RADComponent nextComp;
                if (e.getID() == 401 && (nextComp = this.formDesigner.getNextVisualComponent(!e.isShiftDown())) != null) {
                    this.formDesigner.setSelectedComponent(nextComp);
                }
                e.consume();
                return;
            }
        } else {
            if (keyCode == 32 || keyCode == 113) {
                List<RADComponent> selected;
                if (!this.viewOnly && e.getID() == 402 && (selected = this.formDesigner.getSelectedComponents()).size() == 1) {
                    RADComponent comp = selected.get(0);
                    if (this.formDesigner.getDesignerMode() == 0) {
                        this.formDesigner.startInPlaceEditing(comp);
                    }
                }
                e.consume();
                return;
            }
            if (keyCode == 27) {
                if (this.formDesigner.getDesignerMode() != 0) {
                    this.formDesigner.toggleSelectionMode();
                    this.repaint();
                    e.consume();
                    return;
                }
                if (this.endDragging(null)) {
                    this.repaint();
                    e.consume();
                    return;
                }
            } else if (keyCode == 525 || keyCode == 121 && e.isShiftDown()) {
                Point p = null;
                List<RADComponent> selected = this.formDesigner.getSelectedComponents();
                if (selected.size() > 0) {
                    RADComponent metacomp = selected.get(0);
                    Component sel = (Component)this.formDesigner.getComponent(metacomp);
                    if (sel instanceof Component) {
                        Component comp = sel;
                        p = this.convertPointFromComponent(comp.getLocation(), comp.getParent());
                    } else {
                        p = new Point(6, 6);
                    }
                    this.showContextMenu(p);
                    e.consume();
                    return;
                }
            } else if (e.getID() == 401 && (keyCode == 40 || keyCode == 38 || keyCode == 37 || keyCode == 39)) {
                if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown()) {
                    DuplicateAction.performAction(this.formDesigner.getSelectedNodes(), keyCode);
                    e.consume();
                    return;
                }
            } else if ((keyCode == 68 || keyCode == 69) && e.isAltDown() && e.isControlDown() && e.getID() == 401) {
                FormModel formModel = this.formDesigner.getFormModel();
                LayoutModel layoutModel = formModel.getLayoutModel();
                if (layoutModel != null) {
                    HashMap<String, String> idToNameMap = new HashMap<String, String>();
                    for (RADComponent comp : formModel.getAllComponents()) {
                        if (comp == formModel.getTopRADComponent()) continue;
                        idToNameMap.put(comp.getId(), comp.getName());
                    }
                    RADVisualComponent top = this.formDesigner.getTopDesignComponent();
                    System.out.println(layoutModel.dump(idToNameMap, top != null ? top.getId() : null, e.isShiftDown()));
                }
            } else if (keyCode == 87 && e.isAltDown() && e.isControlDown() && e.getID() == 401) {
                FormModel formModel;
                LayoutModel layoutModel;
                if (this.formDesigner.getLayoutDesigner().logTestCode() && (layoutModel = (formModel = this.formDesigner.getFormModel()).getLayoutModel()) != null) {
                    HashMap<String, String> idToNameMap = new HashMap<String, String>();
                    for (RADComponent comp : formModel.getAllComponents()) {
                        idToNameMap.put(comp.getId(), comp.getName());
                    }
                    FormDataObject formDO = this.formDesigner.getFormEditor().getFormDataObject();
                    LayoutTestUtils.writeTest(this.formDesigner, formDO, idToNameMap, layoutModel);
                    LayoutDesigner ld = this.formDesigner.getLayoutDesigner();
                    ld.setModelCounter(ld.getModelCounter() + 1);
                }
            } else if (keyCode == 83 && e.isAltDown() && e.isControlDown() && e.getID() == 401) {
                if (LayoutDesigner.testMode()) {
                    FormDataObject formDO = this.formDesigner.getFormEditor().getFormDataObject();
                    FileObject formFile = formDO.getFormFile();
                    SaveCookie saveCookie = formDO.getCookie(SaveCookie.class);
                    try {
                        if (saveCookie != null) {
                            saveCookie.save();
                        }
                        FileObject copied = formFile.copy(LayoutTestUtils.getTargetFolder(formFile), formFile.getName() + "Test-StartingForm", formFile.getExt());
                        this.formDesigner.getLayoutDesigner().setModelCounter(0);
                        this.formDesigner.resetTopDesignComponent(true);
                        StatusDisplayer.getDefault().setStatusText("The form was successfully copied to: " + FileUtil.getFileDisplayName((FileObject)copied));
                    }
                    catch (IOException ioe) {}
                }
            } else if (keyCode == 82 && e.isControlDown() && e.getID() == 401) {
                FormEditor formEditor = this.formDesigner.getFormEditor();
                EditorSupport editorSupport = formEditor.getEditorSupport();
                editorSupport.reloadForm();
                e.consume();
            }
        }
        super.processKeyEvent(e);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public RADComponent getMetaComponentAt(Point point, int mode) {
        Component[] deepComps = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), point);
        if (deepComps == null) {
            return null;
        }
        int dIndex = 0;
        Component comp = deepComps[dIndex];
        RADVisualComponent topMetaComp = this.formDesigner.getTopDesignComponent();
        RADComponent firstMetaComp = null;
        RADComponent prevMetaComp = null;
        do {
            RADComponent currMetaComp;
            if ((currMetaComp = this.formDesigner.getMetaComponent(comp)) == null || this.isDraggedComponent(currMetaComp)) continue;
            if (firstMetaComp == null) {
                firstMetaComp = currMetaComp;
            }
            switch (mode) {
                case 0: {
                    return currMetaComp;
                }
                case 1: {
                    if (this.formDesigner.isComponentSelected(currMetaComp)) {
                        return currMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return firstMetaComp;
                }
                case 2: {
                    if (prevMetaComp != null && this.formDesigner.isComponentSelected(prevMetaComp)) {
                        return currMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return firstMetaComp;
                }
                case 3: {
                    if (this.formDesigner.isComponentSelected(currMetaComp)) {
                        return prevMetaComp != null ? prevMetaComp : topMetaComp;
                    }
                    if (currMetaComp != topMetaComp) break;
                    return topMetaComp;
                }
            }
            prevMetaComp = currMetaComp;
        } while ((comp = dIndex + 1 < deepComps.length ? deepComps[++dIndex] : comp.getParent()) != null);
        return firstMetaComp;
    }

    private static Component[] getDeepestComponentsAt(Container parent, Point point) {
        Component deepestComp = SwingUtilities.getDeepestComponentAt(parent, point.x, point.y);
        if (deepestComp == null) {
            return null;
        }
        Container deepestParent = deepestComp.getParent();
        Point deepestPosition = SwingUtilities.convertPoint(parent, point, deepestParent);
        ArrayList<Component> compList = null;
        int n = deepestParent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component comp = deepestParent.getComponent(i);
            Point p = comp.getLocation();
            if (comp == deepestComp || !comp.isVisible() || !comp.contains(deepestPosition.x - p.x, deepestPosition.y - p.y)) continue;
            if (compList == null) {
                compList = new ArrayList<Component>(n - i + 1);
                compList.add(deepestComp);
            }
            compList.add(comp);
        }
        if (compList == null) {
            return new Component[]{deepestComp};
        }
        return compList.toArray(new Component[compList.size()]);
    }

    private RADVisualContainer getMetaContainerAt(Point point, int mode) {
        RADComponent metacomp = this.getMetaComponentAt(point, mode);
        if (metacomp == null) {
            return null;
        }
        if (metacomp instanceof RADVisualContainer) {
            return (RADVisualContainer)metacomp;
        }
        if (metacomp instanceof RADVisualComponent) {
            return (RADVisualContainer)metacomp.getParentComponent();
        }
        return null;
    }

    private RADComponent selectComponent(MouseEvent e, boolean mousePressed) {
        RADComponent hitMetaComp;
        if (this.formDesigner.getSelectedComponents().size() > 1 && mousePressed && !e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && (hitMetaComp = this.selectedComponentAt(e.getPoint(), 0, true)) != null) {
            return hitMetaComp;
        }
        int selMode = !e.isAltDown() ? 0 : (!e.isShiftDown() ? 2 : 3);
        hitMetaComp = this.getMetaComponentAt(e.getPoint(), selMode);
        if (hitMetaComp != null && !e.isAltDown() && hitMetaComp.getAuxValue("autoScrollPane") != null && hitMetaComp instanceof RADVisualContainer) {
            RADVisualComponent[] sub = ((RADVisualContainer)hitMetaComp).getSubComponents();
            Component scroll = (Component)this.formDesigner.getComponent(hitMetaComp);
            if (sub.length > 0 && scroll instanceof JScrollPane) {
                Point p = e.getPoint();
                this.convertPointToComponent(p, scroll);
                for (Component clicked = SwingUtilities.getDeepestComponentAt(scroll, p.x, p.y); clicked != null && clicked != scroll; clicked = clicked.getParent()) {
                    if (!(clicked instanceof JViewport)) continue;
                    hitMetaComp = sub[0];
                    break;
                }
            }
        }
        if ((e.isControlDown() || e.isShiftDown()) && !e.isAltDown()) {
            if (hitMetaComp != null) {
                if (!this.formDesigner.isComponentSelected(hitMetaComp)) {
                    this.formDesigner.addComponentToSelection(hitMetaComp);
                } else if (!e.isShiftDown()) {
                    this.formDesigner.removeComponentFromSelection(hitMetaComp);
                }
            }
        } else if (hitMetaComp != null) {
            this.formDesigner.setSelectedComponent(hitMetaComp);
        } else {
            this.formDesigner.clearSelection();
        }
        return hitMetaComp;
    }

    private void selectOtherComponentsNode() {
        this.formDesigner.setSelectedNodes(new Node[]{this.formDesigner.getFormEditor().getOthersContainerNode()});
    }

    private boolean processDoubleClick(MouseEvent e) {
        Action action;
        RADComponentNode node;
        if (e.isShiftDown() || e.isControlDown()) {
            return false;
        }
        RADComponent metacomp = this.getMetaComponentAt(e.getPoint(), 1);
        if (metacomp == null) {
            return true;
        }
        if (e.isAltDown()) {
            if (metacomp == this.formDesigner.getTopDesignComponent()) {
                if ((metacomp = metacomp.getParentComponent()) == null) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((node = metacomp.getNodeReference()) != null && (action = node.getPreferredAction()) != null) {
            action.actionPerformed(new ActionEvent(node, 1001, ""));
            this.prevLeftMousePoint = null;
            return true;
        }
        return false;
    }

    private void processMouseClickInLayout(RADComponent metacomp, MouseEvent e) {
        RADVisualContainer metacont;
        if (this.formDesigner.getMenuEditLayer().isVisible() && !this.formDesigner.getMenuEditLayer().isMenuLayerComponent(metacomp)) {
            this.formDesigner.getMenuEditLayer().hideMenuLayer();
        }
        if (metacomp != null && metacomp.getBeanClass().getName().equals(JMenu.class.getName())) {
            this.formDesigner.openMenu(metacomp);
        }
        if (!(metacomp instanceof RADVisualComponent)) {
            return;
        }
        RADVisualContainer rADVisualContainer = metacont = metacomp instanceof RADVisualContainer ? (RADVisualContainer)metacomp : (RADVisualContainer)metacomp.getParentComponent();
        if (metacont == null) {
            return;
        }
        LayoutSupportManager laysup = metacont.getLayoutSupport();
        if (laysup == null) {
            Point p = this.convertPointToComponent(e.getPoint(), this.formDesigner.getTopDesignComponentView());
            if (this.formDesigner.getLayoutDesigner().selectInside(p)) {
                FormEditor.getAssistantModel(this.getFormModel()).setContext("layoutGaps", "selectedLayoutGaps");
                this.repaint();
                this.mouseHint = this.formDesigner.getLayoutDesigner().getToolTipText(p);
                this.showToolTip(e);
            }
        } else {
            Container cont = (Container)this.formDesigner.getComponent(metacont);
            Container contDelegate = metacont.getContainerDelegate(cont);
            Point p = this.convertPointToComponent(e.getPoint(), contDelegate);
            laysup.processMouseClick(p, cont, contDelegate);
        }
    }

    private void showContextMenu(Point popupPos) {
        this.formDesigner.componentActivated();
        Node[] selectedNodes = this.formDesigner.getSelectedNodes();
        JPopupMenu popup = NodeOp.findContextMenu((Node[])selectedNodes);
        if (popup != null) {
            popup.show(this, popupPos.x, popupPos.y);
        }
    }

    private boolean anyDragger() {
        return this.draggedComponent != null || this.selectionDragger != null;
    }

    private RADVisualComponent[] getComponentsToDrag() {
        assert ((this.resizeType & 0x100) == 0);
        List<RADComponent> selectedComps = this.formDesigner.getSelectedComponents();
        ArrayList<RADComponent> workingComps = new ArrayList<RADComponent>(selectedComps.size());
        List<String> workingIds = null;
        RADVisualContainer parent = null;
        if (selectedComps.isEmpty()) {
            return null;
        }
        for (RADComponent sc : selectedComps) {
            if (!(sc instanceof RADVisualComponent)) continue;
            RADVisualComponent metacomp = (RADVisualComponent)sc;
            boolean subcontained = false;
            for (RADComponent metacomp2 : selectedComps) {
                if (metacomp2 == metacomp || !metacomp2.isParentComponent(metacomp)) continue;
                subcontained = true;
                break;
            }
            if (subcontained) continue;
            metacomp = (this.resizeType & 0x200) != 0 ? FormDesigner.substituteWithSubComponent(metacomp) : this.formDesigner.substituteWithContainer(metacomp);
            RADVisualContainer metacont = (RADVisualContainer)metacomp.getParentComponent();
            if (parent != null) {
                if (parent != metacont) {
                    return null;
                }
            } else {
                if ((this.resizeType & 0x200) != 0 && this.isNewLayoutRootSelection(false)) {
                    metacont = (RADVisualContainer)metacomp;
                } else if (metacont == null || !this.formDesigner.isInDesigner(metacont)) {
                    return null;
                }
                parent = metacont;
                if (metacont.getLayoutSupport() == null) {
                    workingIds = new ArrayList<String>(selectedComps.size());
                }
            }
            workingComps.add(metacomp);
            if (workingIds == null) continue;
            workingIds.add(metacomp.getId());
        }
        if (parent != null && parent.getLayoutSupport() == null && (workingIds = this.formDesigner.getLayoutDesigner().getDraggableComponents(workingIds)).size() != workingComps.size()) {
            workingComps.clear();
            FormModel formModel = this.getFormModel();
            for (String compId : workingIds) {
                workingComps.add(formModel.getMetaComponent(compId));
            }
        }
        return workingComps.isEmpty() ? null : workingComps.toArray(new RADVisualComponent[workingComps.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endDragging(MouseEvent e) {
        if (!this.anyDragger()) {
            return false;
        }
        if (this.resizeType != 0) {
            this.resizeType = 0;
            Cursor cursor = this.getCursor();
            if (cursor != null && cursor.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (this.getToolTipText() != null) {
                this.setToolTipText(null);
            }
        }
        boolean done = true;
        if (this.draggedComponent != null) {
            boolean retVal = true;
            try {
                retVal = this.draggedComponent.end(e);
            }
            finally {
                if (retVal) {
                    this.draggedComponent = null;
                    this.draggingEnded = true;
                    this.repaint();
                } else {
                    done = false;
                }
            }
        } else if (this.selectionDragger != null) {
            if (e != null) {
                this.selectionDragger.drop(e.getPoint());
            }
            this.selectionDragger = null;
        }
        if (done) {
            this.draggingEnded = true;
            StatusDisplayer.getDefault().setStatusText("");
        }
        FormEditor.getAssistantModel(this.getFormModel()).setContext("select");
        return done;
    }

    private boolean isDraggedComponent(RADComponent metacomp) {
        if (this.draggedComponent != null && this.draggedComponent.movingComponents != null) {
            for (RADVisualComponent c : this.draggedComponent.movingComponents) {
                if (c != metacomp && !c.isParentComponent(metacomp)) continue;
                return true;
            }
        }
        return false;
    }

    private void highlightPanel(MouseEvent e, boolean recheck) {
        JPanel panel;
        Component[] comps = HandleLayer.getDeepestComponentsAt(this.formDesigner.getComponentLayer(), e.getPoint());
        if (comps == null) {
            return;
        }
        Component comp = comps[comps.length - 1];
        RADComponent radcomp = this.formDesigner.getMetaComponent(comp);
        if (radcomp != null && !(radcomp instanceof RADVisualContainer)) {
            Component component = comp = (radcomp = radcomp.getParentComponent()) != null ? (Component)this.formDesigner.getComponent(radcomp) : null;
        }
        if (radcomp == null || radcomp == this.formDesigner.getTopDesignComponent() || !(comp instanceof JPanel)) {
            comp = null;
        }
        if (this.darkerPanel != (panel = (JPanel)comp) || recheck && !this.shouldHighlightPanel(panel, radcomp)) {
            if (this.darkerPanel != null) {
                if (this.darkerPanel.getBorder() instanceof HighlightBorder) {
                    this.darkerPanel.setBorder(null);
                }
                this.darkerPanel = null;
            }
            if (this.shouldHighlightPanel(panel, radcomp)) {
                panel.setBorder(new HighlightBorder(HandleLayer.darkerPanelColor(panel.getBackground()), 1));
                this.darkerPanel = panel;
            }
        }
    }

    private boolean shouldHighlightPanel(JPanel panel, RADComponent radPanel) {
        if (panel != null) {
            RADVisualContainer metacont;
            RADVisualContainer parent;
            if (panel.getBorder() != null) {
                return false;
            }
            if (!(panel.getBackground() instanceof UIResource)) {
                return false;
            }
            if (radPanel == this.formDesigner.getTopDesignComponent()) {
                return false;
            }
            if (this.formDesigner.getDesignerMode() == 0 && this.formDesigner.getSelectedLayoutComponents().contains(radPanel)) {
                return false;
            }
            if (radPanel instanceof RADVisualContainer && (parent = (metacont = (RADVisualContainer)radPanel).getParentContainer()) != null) {
                LayoutSupportManager manager = parent.getLayoutSupport();
                if (manager != null && manager.isDedicated()) {
                    return false;
                }
                JPanel realPanel = (JPanel)this.formDesigner.getComponent(radPanel);
                Component parentBean = (Component)parent.getBeanInstance();
                Component realParent = (Component)this.formDesigner.getComponent(parent);
                if (realPanel != null && realParent != null && realParent.getSize().equals(realPanel.getSize()) && realPanel.getLocation().equals(new Point(0, 0))) {
                    if (parentBean instanceof JPanel) {
                        return this.shouldHighlightPanel((JPanel)parentBean, parent);
                    }
                    return false;
                }
            }
        }
        return panel != null;
    }

    private static Color darkerPanelColor(Color color) {
        double factor = 0.9;
        return new Color((int)((double)color.getRed() * factor), (int)((double)color.getGreen() * factor), (int)((double)color.getBlue() * factor));
    }

    private void checkResizing(MouseEvent e) {
        if (this.formDesigner.getTopDesignComponent() == null) {
            return;
        }
        this.resizeType = 0;
        int resizing = 0;
        if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown())) {
            Point p = e.getPoint();
            boolean compInLayout = this.selectedComponentsInSameVisibleContainer();
            if (compInLayout || this.isNewLayoutRootSelection(false)) {
                resizing = this.checkLayoutResizing(p);
            }
            if (resizing == 0 && compInLayout) {
                resizing = this.checkComponentsResizing(p);
            }
            if (resizing == 0) {
                resizing = this.checkDesignerResizing(p);
            }
        }
        if (resizing != 0 && !this.viewOnly) {
            this.setResizingCursor(resizing);
        } else {
            Cursor cursor = this.getCursor();
            if (cursor != null && cursor.getType() != 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private int checkDesignerResizing(Point p) {
        ComponentLayer compLayer = this.formDesigner.getComponentLayer();
        int resizing = this.getSelectionResizable(p, compLayer.getComponentContainer(), compLayer.getDesignerOutsets().right + 2);
        if (this.validDesignerResizing(resizing)) {
            this.resizeType = resizing | 0x100;
            if (this.mouseHint == null) {
                MessageFormat mf;
                Dimension size = this.formDesigner.getComponentLayer().getDesignerSize();
                if (this.viewOnly) {
                    if (sizeHintFormat == null) {
                        sizeHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerSize"));
                    }
                    mf = sizeHintFormat;
                } else {
                    if (resizingHintFormat == null) {
                        resizingHintFormat = new MessageFormat(FormUtils.getBundleString("FMT_HINT_DesignerResizing"));
                    }
                    mf = resizingHintFormat;
                }
                this.mouseHint = mf.format(new Object[]{new Integer(size.width), new Integer(size.height)});
            }
        } else {
            this.resizeType = 0;
        }
        return this.resizeType;
    }

    private boolean validDesignerResizing(int resizing) {
        return resizing == 10 || resizing == 2 || resizing == 8;
    }

    private int checkComponentsResizing(Point p) {
        RADComponent compAtPoint = this.selectedComponentAt(p, 6, true);
        if (!(compAtPoint instanceof RADVisualComponent)) {
            return 0;
        }
        this.resizeType = this.getComponentResizable(p, (RADVisualComponent)compAtPoint);
        return this.resizeType;
    }

    private int checkLayoutResizing(Point p) {
        LayoutDesigner layoutDesigner = this.formDesigner.getLayoutDesigner();
        if (layoutDesigner != null) {
            int[] resizability = layoutDesigner.getInnerResizability(p = this.convertPointToComponent(new Point(p), this.formDesigner.getTopDesignComponentView()));
            if (resizability != null) {
                if (resizability[0] == 0) {
                    this.resizeType |= 4;
                } else if (resizability[0] == 1) {
                    this.resizeType |= 8;
                }
                if (resizability[1] == 0) {
                    this.resizeType |= 1;
                } else if (resizability[1] == 1) {
                    this.resizeType |= 2;
                }
                this.resizeType |= 0x200;
            }
            this.mouseHint = layoutDesigner.getToolTipText(p);
        }
        return this.resizeType;
    }

    private boolean selectedComponentsInSameVisibleContainer() {
        RADVisualContainer parent = null;
        Iterator<RADComponent> selected = this.formDesigner.getSelectedComponents().iterator();
        while (selected.hasNext()) {
            RADVisualComponent comp = this.formDesigner.componentToLayoutComponent(selected.next());
            if (comp == null) {
                return false;
            }
            if (!(parent == null ? !this.formDesigner.isInDesigner(parent = comp.getParentContainer()) : comp.getParentContainer() != parent)) continue;
            return false;
        }
        return true;
    }

    private boolean isNewLayoutRootSelection(boolean checkVisibility) {
        List<RADVisualComponent> selectedLayoutComponents = this.formDesigner.getSelectedLayoutComponents();
        if (selectedLayoutComponents.size() == 1) {
            RADVisualComponent metacomp = selectedLayoutComponents.get(0);
            if ((metacomp = FormDesigner.substituteWithSubComponent(metacomp)) instanceof RADVisualContainer && ((RADVisualContainer)metacomp).getLayoutSupport() == null && (!checkVisibility || this.formDesigner.isInDesigner(metacomp))) {
                return true;
            }
        }
        return false;
    }

    private RADComponent selectedComponentAt(Point p, int borderSize, boolean inLayout) {
        RADComponent compAtPoint = null;
        for (RADComponent metacomp : inLayout ? this.formDesigner.getSelectedLayoutComponents() : this.formDesigner.getSelectedComponents()) {
            if (!(metacomp instanceof RADVisualComponent) || !this.formDesigner.isInDesigner((RADVisualComponent)metacomp)) continue;
            Component comp = (Component)this.formDesigner.getComponent(metacomp);
            Rectangle rect = new Rectangle(-borderSize, -borderSize, comp.getWidth() + 2 * borderSize, comp.getHeight() + 2 * borderSize);
            this.convertRectangleFromComponent(rect, comp);
            if (!rect.contains(p)) continue;
            compAtPoint = metacomp;
        }
        return compAtPoint;
    }

    private int getComponentResizable(Point p, RADVisualComponent metacomp) {
        int resizable = this.getComponentResizable(metacomp);
        if (resizable != 0) {
            Component comp = (Component)this.formDesigner.getComponent(metacomp);
            resizable &= this.getSelectionResizable(p, comp, 6);
        }
        return resizable;
    }

    private int getComponentResizable(RADVisualComponent metacomp) {
        RADVisualContainer metacont = metacomp.getParentContainer();
        if (metacont == null || metacomp == this.formDesigner.getTopDesignComponent()) {
            return 0;
        }
        Component comp = (Component)this.formDesigner.getComponent(metacomp);
        int resizable = 0;
        LayoutSupportManager laySup = metacont.getLayoutSupport();
        if (laySup == null) {
            List<RADComponent> selectedComps = this.formDesigner.getSelectedComponents();
            if (selectedComps.size() == 1) {
                resizable = 15;
            }
        } else {
            Container cont = (Container)this.formDesigner.getComponent(metacont);
            if (cont != null) {
                Container contDel = metacont.getContainerDelegate(cont);
                resizable = laySup.getResizableDirections(cont, contDel, comp, metacont.getIndexOf(metacomp));
            }
        }
        return resizable;
    }

    private int getSelectionResizable(Point p, Component comp, int borderWidth) {
        if (comp == null) {
            return 0;
        }
        int resizable = 0;
        Rectangle r = new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
        this.convertRectangleFromComponent(r, comp);
        r.grow(borderWidth, borderWidth);
        if (r.contains(p)) {
            r.grow(-borderWidth, -borderWidth);
            r.grow(-3, -3);
            if (r.width < 0) {
                r.width = 0;
            }
            if (r.height < 0) {
                r.height = 0;
            }
            if (p.y >= r.y + r.height) {
                resizable |= 2;
            } else if (p.y < r.y) {
                resizable |= 1;
            }
            if (p.x >= r.x + r.width) {
                resizable |= 8;
            } else if (p.x < r.x) {
                resizable |= 4;
            }
        }
        return resizable;
    }

    private void setResizingCursor(int resizeType) {
        Cursor cursor = null;
        if ((resizeType & 1) != 0) {
            cursor = (resizeType & 4) != 0 ? Cursor.getPredefinedCursor(6) : ((resizeType & 8) != 0 ? Cursor.getPredefinedCursor(7) : Cursor.getPredefinedCursor(8));
        } else if ((resizeType & 2) != 0) {
            cursor = (resizeType & 4) != 0 ? Cursor.getPredefinedCursor(4) : ((resizeType & 8) != 0 ? Cursor.getPredefinedCursor(5) : Cursor.getPredefinedCursor(9));
        } else if ((resizeType & 4) != 0) {
            cursor = Cursor.getPredefinedCursor(10);
        } else if ((resizeType & 8) != 0) {
            cursor = Cursor.getPredefinedCursor(11);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    private void setUserDesignerSize() {
        String txt;
        int i;
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_SetDesignerSize_Label"), FormUtils.getBundleString("CTL_SetDesignerSize_Title"));
        Dimension size = this.formDesigner.getComponentLayer().getDesignerSize();
        input.setInputText(Integer.toString(size.width) + ", " + Integer.toString(size.height));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION && (i = (txt = input.getInputText()).indexOf(44)) > 0) {
            int n = txt.length();
            try {
                int w = Integer.parseInt(txt.substring(0, i));
                while (++i < n && txt.charAt(i) == ' ') {
                }
                int h = Integer.parseInt(txt.substring(i, n));
                if (w >= 0 && h >= 0) {
                    size = new Dimension(w, h);
                    this.formDesigner.setDesignerSize(size, null);
                    this.setToolTipText(null);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    private Object getConstraintsAtPoint(RADComponent metacomp, Point point, Point hotSpot) {
        int index;
        Point p;
        Container contDel;
        Container cont;
        if (!(metacomp instanceof RADVisualComponent)) {
            return null;
        }
        RADVisualContainer metacont = metacomp instanceof RADVisualContainer ? (RADVisualContainer)metacomp : (RADVisualContainer)metacomp.getParentComponent();
        LayoutSupportManager laysup = metacont != null ? metacont.getLayoutSupport() : null;
        Object constraints = laysup.getNewConstraints(cont = (Container)this.formDesigner.getComponent(metacont), contDel = metacont.getContainerDelegate(cont), null, -1, p = this.convertPointToComponent(point.x, point.y, contDel), hotSpot);
        if (constraints == null && metacomp.getBeanInstance() instanceof Component && (index = laysup.getNewIndex(cont, contDel, (Component)metacomp.getBeanInstance(), -1, p, hotSpot)) != -1) {
            constraints = new Integer(index);
        }
        return constraints;
    }

    boolean mouseOnVisual(Point p) {
        Rectangle r = this.formDesigner.getComponentLayer().getDesignerOuterBounds();
        return r.contains(p);
    }

    boolean mouseOnNonVisualTray(Point p) {
        NonVisualTray tray = this.formDesigner.getNonVisualTray();
        return tray != null ? tray.getBounds().contains(p) : false;
    }

    private Point convertPointFromComponent(Point p, Component sourceComp) {
        return this.formDesigner.pointFromComponentToHandleLayer(p, sourceComp);
    }

    private Point convertPointFromComponent(int x, int y, Component sourceComp) {
        return this.formDesigner.pointFromComponentToHandleLayer(new Point(x, y), sourceComp);
    }

    private Point convertPointToComponent(Point p, Component targetComp) {
        return this.formDesigner.pointFromHandleToComponentLayer(p, targetComp);
    }

    private Point convertPointToComponent(int x, int y, Component targetComp) {
        return this.formDesigner.pointFromHandleToComponentLayer(new Point(x, y), targetComp);
    }

    private Rectangle convertRectangleFromComponent(Rectangle rect, Component sourceComp) {
        Point p = this.convertPointFromComponent(rect.x, rect.y, sourceComp);
        rect.x = p.x;
        rect.y = p.y;
        return rect;
    }

    Rectangle convertRectangleToComponent(Rectangle rect, Component targetComp) {
        Point p = this.convertPointToComponent(rect.x, rect.y, targetComp);
        rect.x = p.x;
        rect.y = p.y;
        return rect;
    }

    Rectangle convertVisibleRectangleFromComponent(Rectangle rect, Component comp) {
        while (!this.formDesigner.isCoordinatesRoot(comp)) {
            Container parent = comp.getParent();
            Rectangle size = new Rectangle(0, 0, parent.getWidth(), parent.getHeight());
            rect.translate(comp.getX(), comp.getY());
            rect = rect.intersection(size);
            comp = parent;
        }
        comp = this;
        while (!this.formDesigner.isCoordinatesRoot(comp)) {
            rect.translate(-comp.getX(), -comp.getY());
            comp = comp.getParent();
        }
        return rect;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && !this.draggingEnded && !this.endDragging(null)) {
            if (this.mouseOnNonVisualTray(e.getPoint())) {
                this.dispatchToNonVisualTray(e);
            } else {
                this.showContextMenu(e.getPoint());
            }
        }
        this.highlightPanel(e, true);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.formDesigner.getDesignerMode() == 0 && !this.draggingEnded && !this.endDragging(e)) {
                boolean modifier;
                boolean bl = modifier = e.isControlDown() || e.isAltDown() || e.isShiftDown();
                if ((this.resizeType & 0x100) != 0 && e.getClickCount() == 2 && !modifier && !this.viewOnly) {
                    this.setUserDesignerSize();
                } else if (this.mouseOnNonVisualTray(e.getPoint())) {
                    this.dispatchToNonVisualTray(e);
                } else if (this.prevLeftMousePoint != null && this.prevLeftMousePoint.distance(e.getPoint()) <= 3.0 && !modifier) {
                    RADComponent metacomp = this.getMetaComponentAt(e.getPoint(), 1);
                    if (metacomp != null) {
                        this.formDesigner.startInPlaceEditing(metacomp);
                    }
                } else if (e.getClickCount() == 1 && !e.isAltDown() && !e.isControlDown() && this.mouseOnVisual(e.getPoint())) {
                    this.selectComponent(e, false);
                }
            }
            this.prevLeftMousePoint = this.lastLeftMousePoint;
            this.lastLeftMousePoint = null;
        } else if (this.mouseOnNonVisualTray(e.getPoint())) {
            this.dispatchToNonVisualTray(e);
        }
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.formDesigner.getDesignerMode() == 2) {
            Node itemNode;
            this.formDesigner.requestActive();
            PaletteItem item = PaletteUtils.getSelectedItem();
            if (this.formDesigner.getMenuEditLayer().isPossibleNewMenuComponent(item)) {
                this.formDesigner.getMenuEditLayer().startNewMenuComponentPickAndPlop(item, e.getPoint());
                return;
            }
            if (item != null && (itemNode = item.getNode()) != null) {
                StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_MSG_AddingComponent", itemNode.getDisplayName()));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.draggedComponent != null && this.formDesigner.getDesignerMode() == 2) {
            this.draggedComponent.move(null);
            this.repaint();
            StatusDisplayer.getDefault().setStatusText("");
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.formDesigner.componentActivated();
        if (!this.isVisible()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.formDesigner.getDesignerMode() != 0) {
                this.formDesigner.toggleSelectionMode();
                this.repaint();
            } else if (this.endDragging(null)) {
                this.repaint();
            } else if (!SwingUtilities.isLeftMouseButton(e)) {
                if (this.mouseOnNonVisualTray(e.getPoint())) {
                    this.dispatchToNonVisualTray(e);
                } else if (!this.mouseOnVisual(e.getPoint())) {
                    this.selectOtherComponentsNode();
                } else {
                    RADComponent hitMetaComp = this.selectComponent(e, true);
                    this.processMouseClickInLayout(hitMetaComp, e);
                }
                this.draggingEnded = false;
            }
            e.consume();
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            boolean modifier;
            this.lastLeftMousePoint = e.getPoint();
            boolean bl = modifier = e.isControlDown() || e.isAltDown() || e.isShiftDown();
            if (this.formDesigner.getDesignerMode() == 0) {
                if (this.mouseOnNonVisualTray(e.getPoint())) {
                    this.dispatchToNonVisualTray(e);
                } else {
                    this.checkResizing(e);
                    if (!(e.isShiftDown() && e.isAltDown() && e.isControlDown())) {
                        if (!this.mouseOnVisual(this.lastLeftMousePoint)) {
                            if (this.resizeType == 0 && this.selectedComponentAt(this.lastLeftMousePoint, 0, true) == null) {
                                this.selectOtherComponentsNode();
                            }
                        } else if (!(e.getClickCount() == 2 && this.processDoubleClick(e) || this.resizeType != 0 || e.isShiftDown() && !e.isAltDown())) {
                            RADComponent hitMetaComp = this.selectComponent(e, true);
                            if (!modifier) {
                                this.processMouseClickInLayout(hitMetaComp, e);
                            }
                        }
                    }
                }
                this.draggingEnded = false;
            } else if (!this.viewOnly) {
                if (this.formDesigner.getDesignerMode() == 1) {
                    this.selectComponent(e, true);
                } else if (this.formDesigner.getDesignerMode() == 2) {
                    this.endDragging(e);
                    if (!e.isShiftDown()) {
                        this.formDesigner.toggleSelectionMode();
                    }
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.formDesigner.getDesignerMode() != 0) {
            return;
        }
        Point p = e.getPoint();
        if (this.lastMousePosition != null) {
            this.lastXPosDiff = p.x - this.lastMousePosition.x;
            this.lastYPosDiff = p.y - this.lastMousePosition.y;
        }
        if (!this.draggingEnded && !this.anyDragger() && this.lastLeftMousePoint != null) {
            if (!(this.viewOnly || e.isControlDown() || e.isShiftDown() && !e.isAltDown() || this.resizeType == 0 && !(this.lastLeftMousePoint.distance(p) > 6.0))) {
                RADVisualComponent[] rADVisualComponentArray;
                if ((this.resizeType & 0x100) == 0) {
                    rADVisualComponentArray = this.getComponentsToDrag();
                } else {
                    RADVisualComponent[] rADVisualComponentArray2 = new RADVisualComponent[1];
                    rADVisualComponentArray = rADVisualComponentArray2;
                    rADVisualComponentArray2[0] = this.formDesigner.getTopDesignComponent();
                }
                RADVisualComponent[] draggedComps = rADVisualComponentArray;
                if (draggedComps != null) {
                    this.draggedComponent = this.resizeType == 0 ? new ExistingComponentDrag(draggedComps, this.lastLeftMousePoint, e.getModifiers()) : new ResizeComponentDrag(draggedComps, this.lastLeftMousePoint, this.resizeType);
                }
            }
            if (this.draggedComponent == null && this.lastLeftMousePoint.distance(p) > 4.0 && !e.isAltDown() && !e.isControlDown()) {
                RADVisualComponent topComp = this.formDesigner.getTopDesignComponent();
                RADComponent comp = this.getMetaComponentAt(this.lastLeftMousePoint, 0);
                if (topComp != null && (e.isShiftDown() || comp == null || comp == topComp || comp.getParentComponent() == null)) {
                    this.selectionDragger = new SelectionDragger(this.lastLeftMousePoint);
                }
            }
        }
        if (this.draggedComponent != null) {
            this.draggedComponent.move(e);
            this.highlightPanel(e, false);
            this.repaint();
        } else if (this.selectionDragger != null) {
            this.selectionDragger.drag(p);
            this.repaint();
        }
        this.lastMousePosition = p;
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (this.lastMousePosition != null) {
            this.lastXPosDiff = p.x - this.lastMousePosition.x;
            this.lastYPosDiff = p.y - this.lastMousePosition.y;
        }
        if (this.formDesigner.getDesignerMode() == 2) {
            PaletteItem item = PaletteUtils.getSelectedItem();
            if (null == item) {
                if (null != this.draggedComponent) {
                    this.endDragging(e);
                }
                return;
            }
            if (this.draggedComponent == null) {
                this.draggedComponent = new NewComponentDrag(item);
            }
            if (this.draggedComponent.isValid()) {
                this.draggedComponent.move(e);
                this.repaint();
            } else {
                this.formDesigner.toggleSelectionMode();
            }
        } else if (this.formDesigner.getDesignerMode() == 0 && !this.anyDragger()) {
            this.mouseHint = null;
            this.checkResizing(e);
            this.updateToolTip(e);
        }
        this.highlightPanel(e, false);
        this.lastMousePosition = p;
    }

    private void updateToolTip(MouseEvent e) {
        if (this.mouseHint != null) {
            boolean was = this.getToolTipText() != null;
            this.setToolTipText(this.mouseHint);
            if (!was) {
                ToolTipManager.sharedInstance().mouseEntered(e);
            }
        } else if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
    }

    private void showToolTip(MouseEvent e) {
        this.updateToolTip(e);
        if (this.mouseHint != null) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            int ttDelay = ttm.getInitialDelay();
            ttm.setInitialDelay(0);
            ttm.mouseMoved(e);
            ttm.setInitialDelay(ttDelay);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Serializable p;
        RADVisualComponent metacomp = HandleLayer.getMouseWheelComponent(this.formDesigner, false);
        if (metacomp instanceof RADVisualContainer && this.formDesigner.isInDesigner(metacomp) && ((RADVisualContainer)metacomp).getLayoutSupport() == null) {
            p = this.convertPointToComponent(e.getPoint(), this.formDesigner.getTopDesignComponentView());
            if (!this.viewOnly && this.formDesigner.getLayoutDesigner().acceptsMouseWheel((Point)p)) {
                if (this.wheeler == null) {
                    this.wheeler = new MouseWheeler(metacomp);
                    if (!this.wheelerBlocked) {
                        EventQueue.invokeLater(this.wheeler);
                    }
                }
                this.wheeler.addEvent(e);
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            for (p = this.getParent(); p != null && !(p instanceof JScrollPane); p = p.getParent()) {
            }
            if (p != null) {
                p.dispatchEvent(e);
            }
        }
    }

    private static RADVisualComponent getMouseWheelComponent(FormDesigner designer, boolean later) {
        List<RADComponent> selected;
        if ((!later || designer.getFormEditor() != null && designer.getFormEditor().isFormLoaded() && designer.getDesignerMode() == 0) && (selected = designer.getSelectedComponents()).size() == 1 && selected.get(0) instanceof RADVisualComponent) {
            return (RADVisualComponent)selected.get(0);
        }
        return null;
    }

    private void dispatchToNonVisualTray(MouseEvent e) {
        NonVisualTray tray = this.formDesigner.getNonVisualTray();
        if (tray == null) {
            return;
        }
        Point point = SwingUtilities.convertPoint(this, e.getPoint(), tray);
        Component component = SwingUtilities.getDeepestComponentAt(tray, point.x, point.y);
        point = SwingUtilities.convertPoint(tray, point, component);
        component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), point.x, point.y, e.getClickCount(), e.isPopupTrigger()));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.mouseOnNonVisualTray(e.getPoint())) {
            NonVisualTray tray = this.formDesigner.getNonVisualTray();
            Point point = SwingUtilities.convertPoint(this, e.getPoint(), tray);
            JComponent component = (JComponent)SwingUtilities.getDeepestComponentAt(tray, point.x, point.y);
            point = SwingUtilities.convertPoint(tray, point, component);
            return component.getToolTipText(new MouseEvent(tray, e.getID(), e.getWhen(), e.getModifiers(), point.x, point.y, e.getClickCount(), e.isPopupTrigger()));
        }
        return super.getToolTipText(e);
    }

    private static void doLayout(Component component) {
        if (component instanceof Container) {
            Container cont = (Container)component;
            cont.doLayout();
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                HandleLayer.doLayout(cont.getComponent(i));
            }
        }
    }

    private static void paintDraggedComponent(Component comp, Graphics g) {
        HandleLayer.paintDraggedComponent(comp, g, 0.7f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintDraggedComponent(Component comp, Graphics g, float opacity) {
        HandleLayer.issue71257Hack(comp);
        Graphics2D g2 = (Graphics2D)g;
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, opacity));
        try {
            if (comp instanceof JComponent) {
                comp.paint(g);
            } else {
                int width = comp.getWidth();
                int height = comp.getHeight();
                if (width > 0 && height > 0) {
                    Image image = comp.createImage(width, height);
                    Graphics gImage = image.getGraphics();
                    gImage.setClip(0, 0, width, height);
                    comp.getPeer().paint(gImage);
                    g.drawImage(image, 0, 0, null);
                }
            }
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            g2.setComposite(originalComposite);
        }
    }

    private static void issue71257Hack(Component comp) {
        Container cont = comp.getParent();
        if (cont != null && cont.getLayout() instanceof GroupLayout) {
            while (cont != null && !(cont instanceof ComponentLayer)) {
                if (cont instanceof JTabbedPane && !cont.isValid() && componentValidField != null) {
                    try {
                        componentValidField.set(cont, true);
                    }
                    catch (IllegalArgumentException ex) {
                        FormUtils.LOGGER.log(Level.INFO, null, ex);
                    }
                    catch (IllegalAccessException ex) {
                        FormUtils.LOGGER.log(Level.INFO, null, ex);
                    }
                }
                cont = cont.getParent();
            }
        }
    }

    void updateHiddentComponent(RADComponent metacomp, Rectangle bounds, Rectangle visibleBounds) {
        if (bounds == null) {
            this.hiddenComponents.remove(metacomp);
        } else {
            this.hiddenComponents.put(metacomp, new Rectangle[]{bounds, visibleBounds});
        }
    }

    static {
        formSettings = FormLoaderSettings.getInstance();
        lastPaintWidth = -1;
        try {
            Field field = Component.class.getDeclaredField("valid");
            field.setAccessible(true);
            componentValidField = field;
        }
        catch (NoSuchFieldException ex) {
            FormUtils.LOGGER.log(Level.INFO, null, ex);
        }
        catch (SecurityException ex) {
            FormUtils.LOGGER.log(Level.INFO, null, ex);
        }
    }

    private class NewComponentDropListener
    implements DropTargetListener {
        private NewComponentDrop newComponentDrop;
        private int dropAction;
        private String dropContext;
        private String additionalDropContext;

        private NewComponentDropListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            try {
                PaletteItem item;
                block13: {
                    Transferable transferable;
                    block14: {
                        block12: {
                            this.dropAction = dtde.getDropAction();
                            this.newComponentDrop = null;
                            transferable = dtde.getTransferable();
                            item = null;
                            if (!dtde.isDataFlavorSupported(PaletteController.ITEM_DATA_FLAVOR)) break block12;
                            Lookup itemLookup = (Lookup)transferable.getTransferData(PaletteController.ITEM_DATA_FLAVOR);
                            item = (PaletteItem)itemLookup.lookup(PaletteItem.class);
                            break block13;
                        }
                        ClassSource classSource = CopySupport.getCopiedBeanClassSource(transferable);
                        if (classSource == null) break block14;
                        Class componentClass = HandleLayer.this.getComponentCreator().prepareClass(classSource);
                        if (componentClass == null) break block13;
                        item = new PaletteItem(classSource, componentClass);
                        break block13;
                    }
                    Lookup.Template template = new Lookup.Template(NewComponentDropProvider.class);
                    Collection providers = Lookup.getDefault().lookup(template).allInstances();
                    for (NewComponentDropProvider provider : providers) {
                        this.newComponentDrop = provider.processTransferable(HandleLayer.this.getFormModel(), transferable);
                        if (this.newComponentDrop == null) continue;
                        this.dropContext = null;
                        AssistantModel aModel = FormEditor.getAssistantModel(HandleLayer.this.getFormModel());
                        String preContext = aModel.getContext();
                        item = this.newComponentDrop.getPaletteItem(dtde);
                        String postContext = aModel.getContext();
                        if (preContext.equals(postContext)) break;
                        this.dropContext = postContext;
                        this.additionalDropContext = aModel.getAdditionalContext();
                        break;
                    }
                }
                if (item != null && MenuEditLayer.isMenuRelatedComponentClass(item.getComponentClass()) && !JMenuBar.class.isAssignableFrom(item.getComponentClass()) && !HandleLayer.this.formDesigner.getMenuEditLayer().isDragProxying()) {
                    HandleLayer.this.formDesigner.getMenuEditLayer().startNewMenuComponentDragAndDrop(item);
                    return;
                }
                if (item != null) {
                    if (item.getComponentClassName().indexOf(46) != -1 || FormJavaSource.isInDefaultPackage(HandleLayer.this.getFormModel())) {
                        HandleLayer.this.draggedComponent = new NewComponentDrag(item);
                        if (HandleLayer.this.draggedComponent.isValid()) {
                            HandleLayer.this.draggedComponent.move(dtde.getLocation(), 0);
                            HandleLayer.this.repaint();
                        } else {
                            if (HandleLayer.this.formDesigner.getDesignerMode() == 2) {
                                HandleLayer.this.formDesigner.toggleSelectionMode();
                            } else {
                                HandleLayer.this.draggedComponent = null;
                            }
                            dtde.rejectDrag();
                        }
                    } else {
                        dtde.rejectDrag();
                    }
                } else {
                    dtde.rejectDrag();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (HandleLayer.this.draggedComponent != null) {
                if (this.newComponentDrop != null && this.dropAction != dtde.getDropAction()) {
                    this.dragExit(dtde);
                    this.dragEnter(dtde);
                    return;
                }
                HandleLayer.this.draggedComponent.move(dtde.getLocation(), 0);
                if (this.dropContext != null) {
                    FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext(this.dropContext, this.additionalDropContext);
                }
                HandleLayer.this.repaint();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            if (HandleLayer.this.draggedComponent != null) {
                HandleLayer.this.endDragging(null);
                HandleLayer.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (HandleLayer.this.draggedComponent != null) {
                NewComponentDrag newComponentDrag = (NewComponentDrag)HandleLayer.this.draggedComponent;
                try {
                    newComponentDrag.end(dtde.getLocation(), 0);
                }
                finally {
                    HandleLayer.this.draggedComponent = null;
                    HandleLayer.this.draggingEnded = true;
                }
                if (newComponentDrag.addedComponent != null) {
                    String id = newComponentDrag.addedComponent.getId();
                    if (this.newComponentDrop != null) {
                        RADComponent comp;
                        String droppedOverId = null;
                        if (!(newComponentDrag.addedComponent instanceof RADVisualComponent) && (comp = HandleLayer.this.getMetaComponentAt(dtde.getLocation(), 0)) != null) {
                            droppedOverId = comp.getId();
                        }
                        this.newComponentDrop.componentAdded(id, droppedOverId);
                    }
                }
                HandleLayer.this.formDesigner.toggleSelectionMode();
                HandleLayer.this.formDesigner.requestActive();
            }
        }
    }

    private class NewComponentDrag
    extends ComponentDrag {
        private PaletteItem paletteItem;
        RADComponent addedComponent;
        private int index;
        private LayoutConstraints constraints;
        Boolean doubleBuffered;

        NewComponentDrag(PaletteItem paletteItem) {
            this.index = -1;
            this.doubleBuffered = null;
            this.paletteItem = paletteItem;
            this.showingComponents = new Component[1];
            this.init();
        }

        @Override
        void init() {
            boolean failed = true;
            RADVisualComponent precreated = null;
            try {
                precreated = HandleLayer.this.getComponentCreator().precreateVisualComponent(this.paletteItem);
                failed = false;
            }
            catch (Exception ex) {
            }
            catch (LinkageError ex) {
                // empty catch block
            }
            if (precreated != null) {
                if (this.movingComponents == null) {
                    this.setMovingComponents(new RADVisualComponent[]{precreated});
                } else {
                    this.movingComponents[0] = precreated;
                }
                LayoutComponent precreatedLC = this.isDraggableLayoutComponent() ? HandleLayer.this.getComponentCreator().getPrecreatedLayoutComponent() : null;
                this.showingComponents[0] = (Component)precreated.getBeanInstance();
                if (!(this.showingComponents[0] instanceof JComponent)) {
                    FakePeerSupport.attachFakePeer(this.showingComponents[0]);
                    if (this.showingComponents[0] instanceof Container) {
                        FakePeerSupport.attachFakePeerRecursively((Container)this.showingComponents[0]);
                    }
                }
                Dimension size = this.showingComponents[0].getPreferredSize();
                if (this.originalBounds == null) {
                    this.hotSpot = new Point();
                    this.originalBounds = new Rectangle[]{new Rectangle(this.convertPoint.x, this.convertPoint.y, size.width, size.height)};
                    this.movingBounds = new Rectangle[]{new Rectangle(0, 0, size.width, size.height)};
                } else {
                    this.movingBounds[0].width = size.width;
                    this.movingBounds[0].height = size.height;
                    this.originalBounds[0] = this.movingBounds[0];
                    this.movingBounds[0] = new Rectangle(this.movingBounds[0]);
                    this.originalBounds[0].x += this.convertPoint.x;
                    this.originalBounds[0].y += this.convertPoint.y;
                }
                this.compoundBounds = this.originalBounds[0];
                this.hotSpot.x = this.movingBounds[0].x + size.width / 2 - 4;
                this.hotSpot.y = this.movingBounds[0].y + size.height / 2;
                if (this.hotSpot.x < this.movingBounds[0].x) {
                    this.hotSpot.x = this.movingBounds[0].x;
                }
                if (precreatedLC != null) {
                    LayoutComponent[] layoutComponents = new LayoutComponent[]{precreatedLC};
                    if (HandleLayer.this.formDesigner.getLayoutDesigner() != null) {
                        HandleLayer.this.formDesigner.getLayoutDesigner().startAdding(layoutComponents, this.movingBounds, this.hotSpot, this.targetContainer != null && this.targetContainer.getLayoutSupport() == null ? this.targetContainer.getId() : null);
                    }
                }
                this.oldDrag = true;
                this.newDrag = true;
            } else if (!failed) {
                Image icon;
                Node node = this.paletteItem.getNode();
                if (node == null) {
                    icon = this.paletteItem.getIcon(1);
                    if (icon == null) {
                        icon = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/form.gif");
                    }
                } else {
                    icon = node.getIcon(1);
                }
                this.showingComponents[0] = new JLabel(new ImageIcon(icon));
                Dimension dim = this.showingComponents[0].getPreferredSize();
                this.hotSpot = new Point(dim.width / 2, dim.height / 2);
                if (this.hotSpot.x < 0) {
                    this.hotSpot.x = 0;
                }
                this.originalBounds = new Rectangle[]{new Rectangle(this.convertPoint.x, this.convertPoint.y, dim.width, dim.height)};
                this.showingComponents[0].setBounds(this.originalBounds[0]);
                this.movingBounds = new Rectangle[]{this.showingComponents[0].getBounds()};
                this.oldDrag = false;
                this.newDrag = false;
            } else {
                this.showingComponents = null;
                this.movingBounds = new Rectangle[0];
            }
            super.init();
        }

        @Override
        protected void avoidDoubleBuffering(Component comp) {
            if (this.doubleBuffered == null) {
                this.doubleBuffered = comp.isDoubleBuffered();
            }
            super.avoidDoubleBuffering(comp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean end(Point p, int modifiers) {
            HandleLayer.this.formDesigner.getMenuEditLayer().clearRollover();
            if (p != null) {
                BeanDescriptor bDesc;
                if (this.movingComponents != null) {
                    Object constraints;
                    boolean newLayout;
                    if (this.targetContainer != null) {
                        newLayout = this.targetContainer.getLayoutSupport() == null;
                        boolean oldLayout = !newLayout;
                        Point posInComp = new Point(this.hotSpot.x - this.originalBounds[0].x + this.convertPoint.x, this.hotSpot.y - this.originalBounds[0].y + this.convertPoint.y);
                        constraints = oldLayout && this.isDraggableLayoutComponent() ? HandleLayer.this.getConstraintsAtPoint(this.targetContainer, p, posInComp) : null;
                    } else {
                        boolean oldLayout = false;
                        newLayout = false;
                        constraints = null;
                    }
                    if (this.doubleBuffered != null && this.showingComponents[0] instanceof JComponent) {
                        ((JComponent)this.showingComponents[0]).setDoubleBuffered(this.doubleBuffered);
                    }
                    this.addedComponent = this.movingComponents[0];
                    LayoutComponent layoutComponent = this.isDraggableLayoutComponent() ? HandleLayer.this.getComponentCreator().getPrecreatedLayoutComponent() : null;
                    boolean added = HandleLayer.this.getComponentCreator().addPrecreatedComponent(this.targetContainer, constraints);
                    if (layoutComponent != null && HandleLayer.this.getLayoutModel() != null) {
                        this.createLayoutUndoableEdit();
                        boolean autoUndo = true;
                        try {
                            HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(added && newLayout);
                            if (added) {
                                if (layoutComponent.isLayoutContainer() && !newLayout) {
                                    HandleLayer.this.getLayoutModel().addRootComponent(layoutComponent);
                                }
                            } else {
                                HandleLayer.this.repaint();
                            }
                            autoUndo = false;
                        }
                        finally {
                            this.placeLayoutUndoableEdit(autoUndo);
                        }
                    }
                } else {
                    RADComponent targetComponent = this.targetContainer;
                    Class clazz = this.paletteItem.getComponentClass();
                    if (clazz != null && Border.class.isAssignableFrom(clazz)) {
                        int mode = (modifiers & 8) != 0 ? 1 : 0;
                        targetComponent = HandleLayer.this.getMetaComponentAt(p, mode);
                    }
                    this.addedComponent = HandleLayer.this.getComponentCreator().createComponent(this.paletteItem.getComponentClassSource(), targetComponent, null, false);
                    if (this.addedComponent == null) {
                        HandleLayer.this.repaint();
                    }
                }
                if (this.addedComponent != null && (bDesc = this.addedComponent.getBeanInfo().getBeanDescriptor()) != null && bDesc.getValue("customizeOnCreation") != null) {
                    modifiers &= 0xFFFFFFFE;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RADComponentNode node = NewComponentDrag.this.addedComponent.getNodeReference();
                            if (node.hasCustomizer()) {
                                NodeOperation.getDefault().customize((Node)node);
                            }
                        }
                    });
                }
                if ((modifiers & 1) != 0) {
                    return false;
                }
            } else {
                if (HandleLayer.this.formDesigner.getLayoutDesigner() != null) {
                    HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                }
                HandleLayer.this.getComponentCreator().releasePrecreatedComponent();
            }
            HandleLayer.this.formDesigner.toggleSelectionMode();
            return true;
        }

        @Override
        void oldMove(Point p) {
            LayoutSupportManager laysup = this.targetContainer.getLayoutSupport();
            Container cont = (Container)HandleLayer.this.formDesigner.getComponent(this.targetContainer);
            Container contDel = this.targetContainer.getContainerDelegate(cont);
            Point posInCont = HandleLayer.this.convertPointToComponent(p.x, p.y, contDel);
            Point posInComp = new Point(this.hotSpot.x - this.originalBounds[0].x + this.convertPoint.x, this.hotSpot.y - this.originalBounds[0].y + this.convertPoint.y);
            this.index = laysup.getNewIndex(cont, contDel, this.showingComponents[0], -1, posInCont, posInComp);
            this.constraints = laysup.getNewConstraints(cont, contDel, this.showingComponents[0], -1, posInCont, posInComp);
        }

        @Override
        void oldPaintFeedback(Graphics2D g, Graphics gg, int index) {
            LayoutSupportManager laysup = this.targetContainer.getLayoutSupport();
            Container cont = (Container)HandleLayer.this.formDesigner.getComponent(this.targetContainer);
            Container contDel = this.targetContainer.getContainerDelegate(cont);
            Point contPos = HandleLayer.this.convertPointFromComponent(0, 0, contDel);
            g.setColor(formSettings.getSelectionBorderColor());
            g.setStroke(ComponentDragger.dashedStroke1);
            g.translate(contPos.x, contPos.y);
            laysup.paintDragFeedback(cont, contDel, this.showingComponents[0], this.constraints, this.index, g);
            g.translate(-contPos.x, -contPos.y);
            HandleLayer.paintDraggedComponent(this.showingComponents[0], gg);
        }
    }

    private class ResizeComponentDrag
    extends ComponentDrag {
        private int resizeType;
        private boolean inboundResizing;
        private Dimension originalSize;
        private ComponentDragger oldDragger;

        ResizeComponentDrag(RADVisualComponent[] comps, Point hotspot, int resizeType) {
            super(comps, hotspot);
            this.inboundResizing = (resizeType & 0x200) != 0;
            this.resizeType = resizeType & 0xF;
            this.init();
        }

        @Override
        final void init() {
            RADVisualContainer sourceCont;
            if (this.isTopComponent() || this.inboundResizing) {
                LayoutModel layoutModel = HandleLayer.this.getLayoutModel();
                this.newDrag = layoutModel != null && layoutModel.getLayoutComponent(this.movingComponents[0].getId()) != null;
                this.oldDrag = !this.newDrag;
                sourceCont = null;
                if (this.inboundResizing) {
                    if (this.movingComponents[0] instanceof RADVisualContainer) {
                        this.fixedTarget = (RADVisualContainer)this.movingComponents[0];
                    }
                } else {
                    this.originalSize = HandleLayer.this.formDesigner.getComponentLayer().getDesignerSize();
                }
            } else {
                sourceCont = this.getSourceContainer();
                if (sourceCont != null) {
                    if (sourceCont.getLayoutSupport() == null) {
                        this.newDrag = true;
                    } else {
                        this.oldDrag = true;
                    }
                    this.fixedTarget = sourceCont;
                }
            }
            if (this.newDrag) {
                String[] compIds = new String[this.showingComponents.length];
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    compIds[i] = this.movingComponents[i].getId();
                    this.originalBounds[i].x -= this.convertPoint.x;
                    this.originalBounds[i].y -= this.convertPoint.y;
                }
                int[] res = new int[2];
                int horiz = this.resizeType & 0xC;
                res[0] = horiz == 4 ? 0 : (horiz == 8 ? 1 : -1);
                int vert = this.resizeType & 3;
                res[1] = vert == 1 ? 0 : (vert == 2 ? 1 : -1);
                HandleLayer.this.formDesigner.getLayoutDesigner().startResizing(compIds, this.originalBounds, this.hotSpot, res, sourceCont != null);
                if (this.inboundResizing) {
                    this.componentsMoving = false;
                    this.movingBounds[0].x = this.originalBounds[0].x;
                    this.movingBounds[0].y = this.originalBounds[0].y;
                    this.movingBounds[0].width = this.originalBounds[0].width;
                    this.movingBounds[0].height = this.originalBounds[0].height;
                }
                for (int i = 0; i < this.originalBounds.length; ++i) {
                    this.originalBounds[i].x += this.convertPoint.x;
                    this.originalBounds[i].y += this.convertPoint.y;
                }
            } else if (this.oldDrag) {
                this.oldDragger = new ComponentDragger(HandleLayer.this.formDesigner, HandleLayer.this, this.movingComponents, this.originalBounds, new Point(this.hotSpot.x + this.convertPoint.x, this.hotSpot.y + this.convertPoint.y), this.resizeType);
            }
            if (!this.inboundResizing) {
                super.init();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean end(Point p, int modifiers) {
            if (p != null) {
                if (this.newDrag) {
                    if (!this.inboundResizing) {
                        this.showingComponents[0].setSize(this.movingBounds[0].width, this.movingBounds[0].height);
                        HandleLayer.doLayout(this.showingComponents[0]);
                    }
                    this.createLayoutUndoableEdit();
                    boolean autoUndo = true;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(true);
                        for (int i = 0; i < this.movingComponents.length; ++i) {
                            RADVisualContainer visCont;
                            RADVisualComponent metacomp = this.movingComponents[i];
                            if (!(metacomp instanceof RADVisualContainer) || (visCont = (RADVisualContainer)metacomp).getLayoutSupport() != null) continue;
                            HandleLayer.this.getFormModel().fireContainerLayoutChanged(visCont, null, null, null);
                        }
                        autoUndo = false;
                    }
                    finally {
                        if (this.targetContainer != null) {
                            HandleLayer.this.getFormModel().fireContainerLayoutChanged(this.targetContainer, null, null, null);
                        }
                        this.placeLayoutUndoableEdit(autoUndo);
                    }
                } else if (this.targetContainer != null) {
                    this.oldDragger.dropComponents(p, this.targetContainer);
                }
                if (this.isTopComponent()) {
                    HandleLayer.this.formDesigner.setDesignerSize(new Dimension(this.movingBounds[0].width, this.movingBounds[0].height), this.originalSize);
                }
            } else {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                if (this.isTopComponent()) {
                    ComponentLayer compLayer = HandleLayer.this.formDesigner.getComponentLayer();
                    if (!compLayer.getDesignerSize().equals(this.originalSize)) {
                        compLayer.setDesignerSize(this.originalSize);
                        compLayer.revalidate();
                    }
                    compLayer.repaint();
                } else {
                    HandleLayer.this.formDesigner.updateContainerLayout(this.getSourceContainer());
                }
            }
            return true;
        }

        @Override
        void move(Point p, int modifiers) {
            if (this.isTopComponent()) {
                if (this.newDrag) {
                    p.x -= this.convertPoint.x;
                    p.y -= this.convertPoint.y;
                    HandleLayer.this.formDesigner.getLayoutDesigner().move(p, null, (modifiers & 8) == 0, (modifiers & 2) != 0, this.movingBounds);
                    this.showingComponents[0].setSize(this.movingBounds[0].width, this.movingBounds[0].height);
                    HandleLayer.this.mouseHint = HandleLayer.this.formDesigner.getLayoutDesigner().getToolTipText(p);
                } else {
                    Rectangle r = HandleLayer.this.formDesigner.getComponentLayer().getDesignerInnerBounds();
                    int w = r.width;
                    int h = r.height;
                    if ((this.resizeType & 2) != 0 && (h = p.y - r.y) < 0) {
                        h = 0;
                    }
                    if ((this.resizeType & 8) != 0 && (w = p.x - r.x) < 0) {
                        w = 0;
                    }
                    this.movingBounds[0].width = w;
                    this.movingBounds[0].height = h;
                }
                Dimension size = new Dimension(this.movingBounds[0].width, this.movingBounds[0].height);
                HandleLayer.this.formDesigner.getComponentLayer().setDesignerSize(size);
                HandleLayer.doLayout(HandleLayer.this.formDesigner.getComponentLayer());
            } else if (this.oldDrag && (this.targetContainer = this.getTargetContainer(p, modifiers)) != null && this.targetContainer.getLayoutSupport() != null) {
                this.oldMove(p);
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    int xchange = p.x - this.convertPoint.x - this.hotSpot.x;
                    if ((this.resizeType & 4) != 0) {
                        this.movingBounds[i].x = this.originalBounds[i].x - this.convertPoint.x + xchange;
                        xchange = -xchange;
                    } else {
                        this.movingBounds[i].x = this.originalBounds[i].x - this.convertPoint.x;
                    }
                    if ((this.resizeType & 0xC) != 0) {
                        this.movingBounds[i].width = this.originalBounds[i].width + xchange;
                    }
                    int ychange = p.y - this.convertPoint.y - this.hotSpot.y;
                    if ((this.resizeType & 1) != 0) {
                        this.movingBounds[i].y = this.originalBounds[i].y - this.convertPoint.y + ychange;
                        ychange = -ychange;
                    } else {
                        this.movingBounds[i].y = this.originalBounds[i].y - this.convertPoint.y;
                    }
                    if ((this.resizeType & 3) == 0) continue;
                    this.movingBounds[i].height = this.originalBounds[i].height + ychange;
                }
            } else {
                super.move(p, modifiers);
            }
        }

        @Override
        void oldMove(Point p) {
            this.oldDragger.drag(p, this.targetContainer);
            FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext("generalResizing");
        }

        @Override
        void oldPaintFeedback(Graphics2D g, Graphics gg, int index) {
            HandleLayer.paintDraggedComponent(this.showingComponents[index], gg);
            this.oldDragger.paintDragFeedback(g);
        }
    }

    private class ExistingComponentDrag
    extends ComponentDrag {
        private int modifiers;
        private ComponentDragger oldDragger;

        ExistingComponentDrag(RADVisualComponent[] comps, Point hotspot, int modifiers) {
            super(comps, hotspot);
            this.modifiers = modifiers;
            this.init();
        }

        @Override
        void init() {
            int i;
            RADVisualContainer metacont = this.getSourceContainer();
            String[] compIds = new String[this.showingComponents.length];
            for (i = 0; i < this.showingComponents.length; ++i) {
                compIds[i] = this.movingComponents[i].getId();
                this.originalBounds[i].x -= this.convertPoint.x;
                this.originalBounds[i].y -= this.convertPoint.y;
            }
            if (metacont.getLayoutSupport() == null) {
                HandleLayer.this.formDesigner.getLayoutDesigner().startMoving(compIds, this.originalBounds, this.hotSpot);
            } else {
                LayoutComponent[] layoutComps = new LayoutComponent[compIds.length];
                for (int i2 = 0; i2 < compIds.length; ++i2) {
                    layoutComps[i2] = HandleLayer.this.getLayoutModel().getLayoutComponent(compIds[i2]);
                    if (layoutComps[i2] != null) continue;
                    layoutComps[i2] = new LayoutComponent(compIds[i2], false);
                }
                HandleLayer.this.formDesigner.getLayoutDesigner().startAdding(layoutComps, this.originalBounds, this.hotSpot, null);
            }
            if ((this.modifiers & 8) != 0) {
                this.fixedTarget = (this.modifiers & 1) != 0 || HandleLayer.this.formDesigner.getTopDesignComponent() == metacont ? metacont : metacont.getParentContainer();
            }
            for (i = 0; i < this.originalBounds.length; ++i) {
                this.originalBounds[i].x += this.convertPoint.x;
                this.originalBounds[i].y += this.convertPoint.y;
            }
            this.oldDragger = new ComponentDragger(HandleLayer.this.formDesigner, HandleLayer.this, this.movingComponents, this.originalBounds, new Point(this.hotSpot.x + this.convertPoint.x, this.hotSpot.y + this.convertPoint.y), this.fixedTarget);
            this.oldDrag = true;
            this.newDrag = true;
            super.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean end(Point p, int modifiers) {
            HandleLayer.this.formDesigner.getMenuEditLayer().clearRollover();
            RADVisualContainer originalCont = this.getSourceContainer();
            if (MenuEditLayer.containsMenuTypeComponent(this.movingComponents) && !MenuEditLayer.isValidMenuContainer(this.targetContainer)) {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                HandleLayer.this.formDesigner.updateContainerLayout(originalCont);
                return true;
            }
            if (!MenuEditLayer.containsMenuTypeComponent(this.movingComponents) && MenuEditLayer.isValidMenuContainer(this.targetContainer)) {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                HandleLayer.this.formDesigner.updateContainerLayout(originalCont);
                return true;
            }
            if (p != null) {
                if (this.targetContainer == null || this.targetContainer.getLayoutSupport() != null) {
                    this.createLayoutUndoableEdit();
                    boolean autoUndo = true;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().removeDraggedComponents();
                        this.oldDragger.dropComponents(p, this.targetContainer);
                        autoUndo = false;
                    }
                    finally {
                        this.placeLayoutUndoableEdit(autoUndo);
                    }
                } else {
                    if (this.targetContainer != originalCont) {
                        int i;
                        for (i = 0; i < this.movingComponents.length; ++i) {
                            HandleLayer.this.getFormModel().removeComponent(this.movingComponents[i], false);
                        }
                        for (i = 0; i < this.movingComponents.length; ++i) {
                            HandleLayer.this.getFormModel().addVisualComponent(this.movingComponents[i], this.targetContainer, null, false);
                        }
                    }
                    this.createLayoutUndoableEdit();
                    boolean autoUndo = true;
                    try {
                        HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(true);
                        autoUndo = false;
                    }
                    finally {
                        HandleLayer.this.getFormModel().fireContainerLayoutChanged(this.targetContainer, null, null, null);
                        this.placeLayoutUndoableEdit(autoUndo);
                    }
                }
            } else {
                HandleLayer.this.formDesigner.getLayoutDesigner().endMoving(false);
                HandleLayer.this.formDesigner.updateContainerLayout(originalCont);
            }
            return true;
        }

        @Override
        void oldMove(Point p) {
            this.oldDragger.drag(p, this.targetContainer);
        }

        @Override
        void oldPaintFeedback(Graphics2D g, Graphics gg, int index) {
            this.oldDragger.paintDragFeedback(g);
            Component comp = this.showingComponents[index];
            HandleLayer.paintDraggedComponent(comp, gg);
        }
    }

    private abstract class ComponentDrag {
        RADVisualComponent[] movingComponents;
        boolean draggableLayoutComponents;
        boolean componentsMoving;
        RADVisualContainer targetContainer;
        RADVisualContainer fixedTarget;
        boolean fixedDimension;
        Component[] showingComponents;
        Rectangle[] originalBounds;
        Rectangle compoundBounds;
        Rectangle[] movingBounds;
        Point hotSpot;
        Point convertPoint;
        boolean newDrag;
        boolean oldDrag;
        Object layoutUndoMark;
        UndoableEdit layoutUndoEdit;

        ComponentDrag() {
            this.convertPoint = HandleLayer.this.formDesigner.getTopDesignComponentView() == null ? new Point(0, 0) : HandleLayer.this.convertPointFromComponent(0, 0, HandleLayer.this.formDesigner.getTopDesignComponentView());
            this.componentsMoving = true;
        }

        ComponentDrag(RADVisualComponent[] components, Point hotspot) {
            this();
            this.setMovingComponents(components);
            int count = components.length;
            this.showingComponents = new Component[count];
            this.originalBounds = new Rectangle[count];
            this.movingBounds = new Rectangle[count];
            for (int i = 0; i < count; ++i) {
                this.showingComponents[i] = (Component)handleLayer.formDesigner.getComponent(this.movingComponents[i]);
                this.originalBounds[i] = this.showingComponents[i].getBounds();
                handleLayer.convertRectangleFromComponent(this.originalBounds[i], this.showingComponents[i].getParent());
                this.compoundBounds = this.compoundBounds != null ? this.compoundBounds.union(this.originalBounds[i]) : this.originalBounds[i];
                this.movingBounds[i] = new Rectangle();
                this.movingBounds[i].width = this.originalBounds[i].width;
                this.movingBounds[i].height = this.originalBounds[i].height;
            }
            this.hotSpot = hotspot == null ? new Point(4, 4) : new Point(hotspot.x - this.convertPoint.x, hotspot.y - this.convertPoint.y);
        }

        boolean isValid() {
            return this.showingComponents != null;
        }

        final void setMovingComponents(RADVisualComponent[] components) {
            this.movingComponents = components;
            this.draggableLayoutComponents = components != null && components.length > 0 && components[0] != null ? !components[0].isMenuComponent() : false;
        }

        final RADVisualContainer getSourceContainer() {
            return this.movingComponents != null && this.movingComponents.length > 0 && HandleLayer.this.formDesigner.getTopDesignComponent() != this.movingComponents[0] ? this.movingComponents[0].getParentContainer() : null;
        }

        final boolean isTopComponent() {
            return this.movingComponents != null && this.movingComponents.length > 0 && HandleLayer.this.formDesigner.getTopDesignComponent() == this.movingComponents[0];
        }

        final boolean isDraggableLayoutComponent() {
            return this.draggableLayoutComponents;
        }

        final boolean isComponentMoving() {
            return this.componentsMoving;
        }

        final RADVisualContainer getTargetContainer(Point p, int modifiers) {
            RADVisualContainer parent;
            RADVisualContainer dirMetacont;
            if (this.fixedTarget != null) {
                return this.fixedTarget;
            }
            int mode = (modifiers & 8) != 0 ? 1 : 0;
            RADVisualContainer metacont = HandleLayer.this.getMetaContainerAt(p, mode);
            if (metacont != null && metacont.getLayoutSupport() == null && (dirMetacont = HandleLayer.this.getMetaContainerAt(this.getMoveDirectionSensitivePoint(p, modifiers), mode)) != null && dirMetacont.getLayoutSupport() == null) {
                metacont = dirMetacont;
            }
            if (this.movingComponents != null) {
                List<RADVisualComponent> comps = Arrays.asList(this.movingComponents);
                while (comps.contains(metacont)) {
                    metacont = metacont.getParentContainer();
                }
            }
            if (FormDesigner.isTransparentContainer(metacont) && (parent = metacont.getParentContainer()) != null && HandleLayer.this.formDesigner.isInDesigner(parent)) {
                metacont = parent;
            }
            return metacont;
        }

        private Point getMoveDirectionSensitivePoint(Point p, int modifiers) {
            if (HandleLayer.this.lastMousePosition != null && this.compoundBounds != null && (modifiers & 0xB) == 0) {
                int y;
                int x;
                if (this.compoundBounds.width <= 0 || this.compoundBounds.height <= 0) {
                    return p;
                }
                if (HandleLayer.this.lastXPosDiff != 0 && HandleLayer.this.lastYPosDiff != 0) {
                    double r;
                    double dx = HandleLayer.this.lastXPosDiff;
                    double dy = HandleLayer.this.lastYPosDiff;
                    double d = Math.abs(dy / dx);
                    if (d > (r = this.compoundBounds.getHeight() / this.compoundBounds.getWidth())) {
                        x = p.x + (int)Math.round(this.compoundBounds.getHeight() / d / 2.0) * (HandleLayer.this.lastXPosDiff > 0 ? 1 : -1);
                        y = p.y - this.convertPoint.y - this.hotSpot.y + this.compoundBounds.y + (HandleLayer.this.lastYPosDiff > 0 ? this.compoundBounds.height : 0);
                    } else {
                        x = p.x - this.convertPoint.x - this.hotSpot.x + this.compoundBounds.x + (HandleLayer.this.lastXPosDiff > 0 ? this.compoundBounds.width : 0);
                        y = p.y + (int)Math.round(this.compoundBounds.getWidth() * d / 2.0) * (HandleLayer.this.lastYPosDiff > 0 ? 1 : -1);
                    }
                } else {
                    int n = HandleLayer.this.lastXPosDiff == 0 ? p.x : (x = p.x - this.convertPoint.x - this.hotSpot.x + this.compoundBounds.x + (HandleLayer.this.lastXPosDiff > 0 ? this.compoundBounds.width : 0));
                    y = HandleLayer.this.lastYPosDiff == 0 ? p.y : p.y - this.convertPoint.y - this.hotSpot.y + this.compoundBounds.y + (HandleLayer.this.lastYPosDiff > 0 ? this.compoundBounds.height : 0);
                }
                Rectangle boundaries = HandleLayer.this.formDesigner.getComponentLayer().getDesignerInnerBounds();
                if (x < boundaries.x && x + 8 >= boundaries.x) {
                    x = boundaries.x;
                } else if (x > boundaries.x + boundaries.width && x - 8 < boundaries.x + boundaries.width) {
                    x = boundaries.x + boundaries.width - 1;
                }
                if (y < boundaries.y && y + 8 >= boundaries.y) {
                    y = boundaries.y;
                } else if (y > boundaries.y + boundaries.height && y - 8 < boundaries.y + boundaries.height) {
                    y = boundaries.y + boundaries.height - 1;
                }
                return new Point(x, y);
            }
            return p;
        }

        final void move(MouseEvent e) {
            if (e == null) {
                this.move(null, 0);
            } else {
                this.move(e.getPoint(), e.getModifiers());
                HandleLayer.this.showToolTip(e);
            }
        }

        void move(Point p, int modifiers) {
            boolean lockDimension;
            if (p == null) {
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    this.movingBounds[i].x = Integer.MIN_VALUE;
                }
                return;
            }
            boolean bl = lockDimension = (modifiers & 2) != 0;
            if (!lockDimension && this.fixedDimension) {
                this.fixedTarget = null;
                this.fixedDimension = false;
            }
            this.targetContainer = this.getTargetContainer(p, modifiers);
            if (this.movingComponents != null) {
                RADVisualComponent moveComp = this.movingComponents[0];
                if (this.newDrag && HandleLayer.this.formDesigner.getMenuEditLayer().canHighlightContainer(this.targetContainer, moveComp)) {
                    HandleLayer.this.formDesigner.getMenuEditLayer().rolloverContainer(this.targetContainer);
                } else {
                    HandleLayer.this.formDesigner.getMenuEditLayer().rolloverContainer(null);
                }
            }
            if (this.newDrag && this.isDraggableLayoutComponent() && this.targetContainer != null && this.targetContainer.getLayoutSupport() == null) {
                p.x -= this.convertPoint.x;
                p.y -= this.convertPoint.y;
                LayoutDesigner layoutDesigner = HandleLayer.this.formDesigner.getLayoutDesigner();
                layoutDesigner.move(p, this.targetContainer.getId(), (modifiers & 8) == 0, lockDimension, this.movingBounds);
                if (lockDimension && (this.fixedTarget == null || this.fixedDimension)) {
                    RADComponent targetComp;
                    this.fixedDimension = true;
                    String targetId = layoutDesigner.getDragTargetContainer();
                    if (targetId != null && (targetComp = HandleLayer.this.getFormModel().getMetaComponent(targetId)) instanceof RADVisualContainer) {
                        this.fixedTarget = (RADVisualContainer)targetComp;
                    }
                }
                String[] position = layoutDesigner.positionCode();
                FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext(position[0], position[1]);
                HandleLayer.this.mouseHint = HandleLayer.this.formDesigner.getLayoutDesigner().getToolTipText(p);
            } else {
                if (this.oldDrag && this.isDraggableLayoutComponent() && this.targetContainer != null && this.targetContainer.getLayoutSupport() != null) {
                    this.oldMove(p);
                } else {
                    FormEditor.getAssistantModel(HandleLayer.this.getFormModel()).setContext("generalPosition");
                }
                for (int i = 0; i < this.movingBounds.length; ++i) {
                    this.movingBounds[i].x = p.x - this.convertPoint.x - this.hotSpot.x + this.originalBounds[i].x - this.convertPoint.x;
                    this.movingBounds[i].y = p.y - this.convertPoint.y - this.hotSpot.y + this.originalBounds[i].y - this.convertPoint.y;
                }
            }
        }

        final void maskDraggingComponents() {
            if (!this.isTopComponent() && this.showingComponents != null && this.isComponentMoving() && this.movingBounds.length > 0 && this.movingBounds[0].x > Integer.MIN_VALUE) {
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    Rectangle r = this.movingBounds[i];
                    this.showingComponents[i].setBounds(r.x + Short.MIN_VALUE, r.y + Short.MIN_VALUE, r.width, r.height);
                }
            }
        }

        final void paintFeedback(Graphics2D g) {
            if (this.movingBounds.length < 1 || this.movingBounds[0].x == Integer.MIN_VALUE) {
                return;
            }
            for (int i = 0; i < this.showingComponents.length; ++i) {
                if (this.newDrag && this.isDraggableLayoutComponent() && (this.targetContainer != null && this.targetContainer.getLayoutSupport() == null || this.targetContainer == null && this.isTopComponent())) {
                    if (this.isComponentMoving()) {
                        Graphics gg = this.dragCompGraphics(g, this.movingBounds[i]);
                        if (!this.isTopComponent()) {
                            HandleLayer.doLayout(this.showingComponents[i]);
                            HandleLayer.paintDraggedComponent(this.showingComponents[i], gg);
                        }
                        gg.setColor(formSettings.getSelectionBorderColor());
                        gg.drawRect(0, 0, this.movingBounds[i].width, this.movingBounds[i].height);
                    }
                    g.translate(this.convertPoint.x, this.convertPoint.y);
                    g.setColor(formSettings.getGuidingLineColor());
                    HandleLayer.this.formDesigner.getLayoutDesigner().paintMoveFeedback(g);
                    g.translate(-this.convertPoint.x, -this.convertPoint.y);
                    continue;
                }
                if (this.oldDrag && this.isDraggableLayoutComponent() && (this.targetContainer != null && this.targetContainer.getLayoutSupport() != null || this.targetContainer == null && this.isTopComponent())) {
                    if (this.isTopComponent()) continue;
                    HandleLayer.doLayout(this.showingComponents[i]);
                    this.oldPaintFeedback(g, this.dragCompGraphics(g, this.movingBounds[i]), i);
                    continue;
                }
                HandleLayer.doLayout(this.showingComponents[i]);
                HandleLayer.paintDraggedComponent(this.showingComponents[i], this.dragCompGraphics(g, this.movingBounds[i]));
            }
        }

        private Graphics dragCompGraphics(Graphics2D g, Rectangle bounds) {
            return g.create(bounds.x + this.convertPoint.x, bounds.y + this.convertPoint.y, bounds.width + 1, bounds.height + 1);
        }

        final boolean end(final MouseEvent e) {
            HandleLayer.this.dragPanel.removeAll();
            boolean retVal = e == null ? this.end(null, 0) : this.end(e.getPoint(), e.getModifiers());
            if (retVal) {
                this.movingComponents = null;
                this.targetContainer = null;
                this.fixedTarget = null;
                this.showingComponents = null;
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComponentDrag.this.init();
                        ComponentDrag.this.move(e);
                    }
                });
            }
            return retVal;
        }

        void init() {
            if (this.showingComponents != null) {
                RADVisualContainer sourceCont = this.getSourceContainer();
                boolean oldSource = sourceCont != null && sourceCont.getLayoutSupport() != null;
                HandleLayer.this.dragPanel.removeAll();
                for (int i = 0; i < this.showingComponents.length; ++i) {
                    Component comp = this.showingComponents[i];
                    if (comp.getParent() == null) {
                        HandleLayer.this.dragPanel.add(comp);
                    } else if (oldSource) {
                        comp.setVisible(false);
                    }
                    this.avoidDoubleBuffering(comp);
                }
            }
        }

        protected void avoidDoubleBuffering(Component comp) {
            if (comp instanceof JComponent) {
                ((JComponent)comp).setDoubleBuffered(false);
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    this.avoidDoubleBuffering(cont.getComponent(i));
                }
            }
        }

        boolean end(Point p, int modifiers) {
            HandleLayer.this.formDesigner.getMenuEditLayer().clearRollover();
            return true;
        }

        void oldMove(Point p) {
        }

        void oldPaintFeedback(Graphics2D g, Graphics gg, int index) {
        }

        final void createLayoutUndoableEdit() {
            this.layoutUndoMark = HandleLayer.this.getLayoutModel().getChangeMark();
            this.layoutUndoEdit = HandleLayer.this.getLayoutModel().getUndoableEdit();
        }

        final void placeLayoutUndoableEdit(boolean autoUndo) {
            if (!this.layoutUndoMark.equals(HandleLayer.this.getLayoutModel().getChangeMark())) {
                HandleLayer.this.getFormModel().addUndoableEdit(this.layoutUndoEdit);
            }
            if (autoUndo) {
                HandleLayer.this.getFormModel().forceUndoOfCompoundEdit();
            }
            this.layoutUndoMark = null;
            this.layoutUndoEdit = null;
        }
    }

    private class SelectionDragger {
        private Point startPoint;
        private Point lastPoint;

        public SelectionDragger(Point startPoint) {
            this.startPoint = startPoint;
        }

        public void paintDragFeedback(Graphics g) {
            if (this.startPoint != null && this.lastPoint != null) {
                Rectangle r = this.getRectangle();
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }

        public void drag(Point p) {
            this.lastPoint = p;
        }

        public void drop(Point endPoint) {
            if (this.startPoint != null && endPoint != null) {
                this.lastPoint = endPoint;
                ArrayList<RADComponent> toSelect = new ArrayList<RADComponent>();
                this.collectSelectedComponents(this.getRectangle(), HandleLayer.this.formDesigner.getComponentLayer().getComponentContainer(), toSelect);
                RADComponent[] selected = new RADComponent[toSelect.size()];
                toSelect.toArray(selected);
                HandleLayer.this.formDesigner.setSelectedComponents(selected);
            }
        }

        private Rectangle getRectangle() {
            int h;
            int x = this.startPoint.x <= this.lastPoint.x ? this.startPoint.x : this.lastPoint.x;
            int y = this.startPoint.y <= this.lastPoint.y ? this.startPoint.y : this.lastPoint.y;
            int w = this.lastPoint.x - this.startPoint.x;
            if (w < 0) {
                w = -w;
            }
            if ((h = this.lastPoint.y - this.startPoint.y) < 0) {
                h = -h;
            }
            return new Rectangle(x, y, w, h);
        }

        private boolean collectSelectedComponents(Rectangle selRect, Container cont, List<RADComponent> toSelect) {
            Component[] comps;
            ArrayList<Component> subContainers = new ArrayList<Component>();
            if (cont instanceof JTabbedPane) {
                Component[] componentArray;
                Component selectedTab = ((JTabbedPane)cont).getSelectedComponent();
                if (selectedTab == null) {
                    componentArray = new Component[]{};
                } else {
                    Component[] componentArray2 = new Component[1];
                    componentArray = componentArray2;
                    componentArray2[0] = selectedTab;
                }
                comps = componentArray;
            } else {
                comps = cont.getComponents();
            }
            boolean contains = false;
            for (int i = 0; i < comps.length; ++i) {
                RADComponent metacomp;
                Component comp = comps[i];
                Rectangle bounds = HandleLayer.this.convertRectangleFromComponent(comp.getBounds(), cont);
                if (!selRect.intersects(bounds)) continue;
                if (selRect.contains(bounds)) {
                    contains = true;
                }
                if ((metacomp = HandleLayer.this.formDesigner.getMetaComponent(comp)) != null) {
                    toSelect.add(metacomp);
                }
                if (!(comp instanceof Container)) continue;
                subContainers.add(comp);
            }
            if (toSelect.size() > 1 || toSelect.size() == 1 && (subContainers.isEmpty() || contains)) {
                return true;
            }
            RADComponent theOnlyOne = toSelect.size() == 1 ? toSelect.get(0) : null;
            for (int i = 0; i < subContainers.size(); ++i) {
                toSelect.clear();
                if (!this.collectSelectedComponents(selRect, (Container)subContainers.get(i), toSelect)) continue;
                return true;
            }
            if (theOnlyOne != null) {
                toSelect.add(theOnlyOne);
                return true;
            }
            return false;
        }
    }

    private class MouseWheeler
    implements Runnable {
        private int coalesced;
        private int units;
        private RADVisualComponent component;
        private MouseEvent lastEvent;

        MouseWheeler(RADVisualComponent comp) {
            this.component = comp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (HandleLayer.this.wheelerBlocked) {
                HandleLayer.this.wheelerBlocked = false;
                if (HandleLayer.this.wheeler != null) {
                    EventQueue.invokeLater(HandleLayer.this.wheeler);
                }
                return;
            }
            HandleLayer.this.wheeler = null;
            RADVisualComponent comp = HandleLayer.getMouseWheelComponent(HandleLayer.this.formDesigner, true);
            if (comp == this.component) {
                FormModel formModel = HandleLayer.this.getFormModel();
                LayoutModel layoutModel = HandleLayer.this.getLayoutModel();
                Object layoutUndoMark = layoutModel.getChangeMark();
                UndoableEdit ue = layoutModel.getUndoableEdit();
                boolean autoUndo = true;
                try {
                    HandleLayer.this.mouseHint = HandleLayer.this.formDesigner.getLayoutDesigner().mouseWheelMoved(this.coalesced, this.units);
                    autoUndo = false;
                    HandleLayer.this.showToolTip(this.lastEvent);
                }
                finally {
                    formModel.fireContainerLayoutChanged((RADVisualContainer)comp, null, null, null);
                    if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                        formModel.addUndoableEdit(ue);
                    }
                    if (autoUndo) {
                        formModel.forceUndoOfCompoundEdit();
                    } else {
                        HandleLayer.this.wheelerBlocked = true;
                        EventQueue.invokeLater(this);
                    }
                }
            }
        }

        void addEvent(MouseWheelEvent e) {
            if (e.getScrollType() == 0) {
                ++this.coalesced;
                this.units += e.getUnitsToScroll();
                this.lastEvent = e;
            }
        }
    }

    private static class HighlightBorder
    extends LineBorder {
        HighlightBorder(Color color, int thickness) {
            super(color, thickness);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 0);
        }
    }
}

