/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Dialog;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConnectionCustomEditor
extends JPanel {
    private RADConnectionPropertyEditor propertyEditor;
    private FormModel formModel;
    private Class valueType;
    private List<RADComponent> beanList;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private boolean initialized = false;
    private JComboBox beanCombo;
    private JRadioButton beanRadio;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JButton methodDetailsButton;
    private JTextField methodField;
    private JRadioButton methodRadio;
    private JButton propertyDetailsButton;
    private JTextField propertyField;
    private JRadioButton propertyRadio;

    public ConnectionCustomEditor(RADConnectionPropertyEditor propertyEditor, FormModel formModel, Class valueType) {
        this.propertyEditor = propertyEditor;
        this.formModel = formModel;
        this.valueType = valueType;
        this.initComponents();
        ConnectionCustomEditor.setupBrowseButton(this.propertyDetailsButton);
        ConnectionCustomEditor.setupBrowseButton(this.methodDetailsButton);
        this.beanList = new ArrayList<RADComponent>();
        for (RADComponent radComp : formModel.getAllComponents()) {
            if (!valueType.isAssignableFrom(radComp.getBeanClass())) continue;
            this.beanList.add(radComp);
        }
        if (this.beanList.size() > 0) {
            Collections.sort(this.beanList, new ParametersPicker.ComponentComparator());
            this.beanCombo.addItem(FormUtils.getBundleString("CTL_CW_SelectBean"));
            for (RADComponent metacomp : this.beanList) {
                if (metacomp == formModel.getTopRADComponent()) {
                    this.beanCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                    continue;
                }
                this.beanCombo.addItem(metacomp.getName());
            }
        } else {
            this.beanRadio.setEnabled(false);
        }
        this.initialized = true;
    }

    private static void setupBrowseButton(JButton button) {
        Insets margin = button.getMargin();
        if (margin.left > 4) {
            margin.left = 4;
            margin.right = 4;
            button.setMargin(margin);
        }
    }

    void setValue(RADConnectionPropertyEditor.RADConnectionDesignValue value) {
        if (value == null) {
            this.updateControls();
            return;
        }
        switch (value.type) {
            case 4: {
                this.beanRadio.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                int index = this.beanList.indexOf(this.selectedComponent);
                if (index <= -1) break;
                this.beanCombo.setSelectedIndex(index + 1);
                break;
            }
            case 0: {
                this.propertyRadio.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedProperty = value.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyField.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                    break;
                }
                if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyField.setText(this.selectedProperty.getName());
                    break;
                }
                this.propertyField.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                break;
            }
            case 1: {
                this.methodRadio.setSelected(true);
                this.selectedComponent = value.getRADComponent();
                this.selectedMethod = value.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodField.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                    break;
                }
                if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodField.setText(this.selectedMethod.getName());
                    break;
                }
                this.methodField.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
        }
        this.updateControls();
    }

    private void updateControls() {
        this.beanCombo.setEnabled(this.beanRadio.isSelected());
        this.propertyField.setEnabled(this.propertyRadio.isSelected());
        this.propertyDetailsButton.setEnabled(this.propertyRadio.isSelected());
        if (!this.propertyRadio.isSelected()) {
            this.propertyField.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        }
        this.methodField.setEnabled(this.methodRadio.isSelected());
        this.methodDetailsButton.setEnabled(this.methodRadio.isSelected());
        if (!this.methodRadio.isSelected()) {
            this.methodField.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.beanRadio = new JRadioButton();
        this.propertyRadio = new JRadioButton();
        this.methodRadio = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyField = new JTextField();
        this.methodField = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodDetailsButton = new JButton();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.jLabel1.text"));
        this.buttonGroup1.add(this.beanRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.beanRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanRadio.text"));
        this.beanRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.beanRadio.setMargin(new Insets(0, 0, 0, 0));
        this.beanRadio.addActionListener(formListener);
        this.buttonGroup1.add(this.propertyRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.propertyRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyRadio.text"));
        this.propertyRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.propertyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.propertyRadio.addActionListener(formListener);
        this.buttonGroup1.add(this.methodRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.methodRadio, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodRadio.text"));
        this.methodRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.methodRadio.setMargin(new Insets(0, 0, 0, 0));
        this.methodRadio.addActionListener(formListener);
        this.beanCombo.addActionListener(formListener);
        this.propertyField.setEditable(false);
        this.propertyField.setText(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"CTL_CW_NoProperty"));
        this.methodField.setEditable(false);
        this.methodField.setText(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"CTL_CW_NoMethod"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyDetailsButton, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyDetailsButton.text"));
        this.propertyDetailsButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.methodDetailsButton, (String)NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodDetailsButton.text"));
        this.methodDetailsButton.addActionListener(formListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.beanRadio).addComponent(this.propertyRadio).addComponent(this.methodRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.beanCombo, 0, 270, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.propertyField, -1, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertyDetailsButton)).addGroup(layout.createSequentialGroup().addComponent(this.methodField, -1, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.methodDetailsButton)))).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.beanRadio).addComponent(this.beanCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.propertyRadio).addComponent(this.propertyDetailsButton).addComponent(this.propertyField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.methodRadio).addComponent(this.methodField, -2, -1, -2).addComponent(this.methodDetailsButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.beanRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanRadio.accessibleDescription"));
        this.propertyRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyRadio.accessibleDescription"));
        this.methodRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodRadio.accessibleDescription"));
        this.beanCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.beanCombo.accessibleDescription"));
        this.propertyField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyField.accessibleDescription"));
        this.methodField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodField.accessibleDescription"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.propertyDetailsButton.accessibleDescription"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionCustomEditor.class, (String)"ConnectionCustomEditor.methodDetailsButton.accessibleDescription"));
    }

    private void beanComboActionPerformed(ActionEvent evt) {
        if (!this.initialized) {
            return;
        }
        int index = this.beanCombo.getSelectedIndex();
        if (index > 0) {
            this.selectedComponent = this.beanList.get(index - 1);
            this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent));
        } else {
            this.selectedComponent = null;
            this.propertyEditor.setValue(BeanSupport.NO_VALUE);
        }
    }

    private void methodDetailsButtonActionPerformed(ActionEvent evt) {
        MethodPicker picker = new MethodPicker(this.formModel, null, this.valueType);
        picker.setSelectedComponent(this.selectedComponent);
        picker.setSelectedMethod(this.selectedMethod);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectMethod", this.valueType.getSimpleName());
        final DialogDescriptor dd = new DialogDescriptor((Object)picker, title);
        dd.setValid(picker.isPickerValid());
        picker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = picker.getSelectedComponent();
            MethodPicker.MethodPickerItem selectedItem = picker.getSelectedMethod();
            this.selectedMethod = selectedItem.getMethodDescriptor();
            this.methodField.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodField.setText(selectedItem.getMethodName());
            } else {
                this.methodField.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            if (this.selectedComponent != null && this.selectedMethod != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod));
            } else if (selectedItem.getMethodName() != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(selectedItem.getMethodName()));
            } else {
                this.propertyEditor.setValue(BeanSupport.NO_VALUE);
            }
        }
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent evt) {
        PropertyPicker propertyPicker = new PropertyPicker(this.formModel, null, this.valueType);
        propertyPicker.setSelectedComponent(this.selectedComponent);
        propertyPicker.setSelectedProperty(this.selectedProperty);
        String title = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectProperty", this.valueType.getSimpleName());
        final DialogDescriptor dd = new DialogDescriptor((Object)propertyPicker, title);
        dd.setValid(propertyPicker.isPickerValid());
        propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt2) {
                dd.setValid(((Boolean)evt2.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = propertyPicker.getSelectedComponent();
            PropertyPicker.PropertyPickerItem selectedItem = propertyPicker.getSelectedProperty();
            this.propertyField.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyField.setText(selectedItem.getPropertyName());
            } else {
                this.propertyField.setText(this.selectedComponent.getName() + "." + selectedItem.getPropertyName());
            }
            this.selectedProperty = selectedItem.getPropertyDescriptor();
            if (this.selectedProperty == null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(selectedItem.getReadMethodName()));
            } else if (this.selectedComponent != null && this.selectedProperty != null) {
                this.propertyEditor.setValue(new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty));
            } else {
                this.propertyEditor.setValue(BeanSupport.NO_VALUE);
            }
        }
    }

    private void methodRadioActionPerformed(ActionEvent evt) {
        if (this.methodRadio.isSelected()) {
            this.methodDetailsButton.requestFocus();
        }
        this.updateControls();
    }

    private void propertyRadioActionPerformed(ActionEvent evt) {
        if (this.propertyRadio.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        }
        this.updateControls();
    }

    private void beanRadioActionPerformed(ActionEvent evt) {
        if (this.beanRadio.isSelected()) {
            this.beanCombo.requestFocus();
        }
        this.updateControls();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ConnectionCustomEditor.this.beanRadio) {
                ConnectionCustomEditor.this.beanRadioActionPerformed(evt);
            } else if (evt.getSource() == ConnectionCustomEditor.this.propertyRadio) {
                ConnectionCustomEditor.this.propertyRadioActionPerformed(evt);
            } else if (evt.getSource() == ConnectionCustomEditor.this.methodRadio) {
                ConnectionCustomEditor.this.methodRadioActionPerformed(evt);
            } else if (evt.getSource() == ConnectionCustomEditor.this.beanCombo) {
                ConnectionCustomEditor.this.beanComboActionPerformed(evt);
            } else if (evt.getSource() == ConnectionCustomEditor.this.propertyDetailsButton) {
                ConnectionCustomEditor.this.propertyDetailsButtonActionPerformed(evt);
            } else if (evt.getSource() == ConnectionCustomEditor.this.methodDetailsButton) {
                ConnectionCustomEditor.this.methodDetailsButtonActionPerformed(evt);
            }
        }
    }
}

