/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentCookie;
import org.netbeans.spi.navigator.NavigatorPanelWithUndo;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class ComponentInspector
extends JPanel
implements NavigatorPanelWithUndo,
ExplorerManager.Provider {
    private FormDesigner formDesigner;
    private ExplorerManager explorerManager;
    private ExplorerManagerLookup lookup;
    private PropertyChangeListener nodeSelectionListener;
    private PasteAction pasteAction = (PasteAction)SystemAction.findObject(PasteAction.class, (boolean)true);
    private CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private DeleteActionPerformer deleteActionPerformer = new DeleteActionPerformer();
    private ClipboardListener clipboardListener;
    private BeanTreeView treeView;
    private static ComponentInspector instance;

    public static synchronized ComponentInspector getInstance() {
        if (instance == null) {
            instance = new ComponentInspector();
        }
        return instance;
    }

    static boolean exists() {
        return instance != null;
    }

    private ComponentInspector() {
        this.lookup = new ExplorerManagerLookup();
        this.setLayout(new BorderLayout());
        this.createComponents();
        this.setupActionMap(this.getActionMap());
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.component-inspector");
    }

    final ActionMap setupActionMap(ActionMap map) {
        map.put("copy-to-clipboard", this.copyActionPerformer);
        map.put("cut-to-clipboard", this.cutActionPerformer);
        map.put("delete", this.deleteActionPerformer);
        return map;
    }

    private void createComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setDragSource(true);
        this.treeView.setDropTarget(true);
        this.treeView.getAccessibleContext().setAccessibleName(FormUtils.getBundleString("ACS_ComponentTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ComponentTree"));
        this.add((Component)this.treeView, "Center");
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo.Manager ur;
        FormModel formModel;
        if (this.formDesigner != null && (formModel = this.formDesigner.getFormModel()) != null && (ur = formModel.getUndoRedoManager()) != null) {
            return ur;
        }
        return UndoRedo.NONE;
    }

    public String getDisplayName() {
        return FormUtils.getBundleString("CTL_InspectorNavigatorCaption");
    }

    public String getDisplayHint() {
        return FormUtils.getBundleString("HINT_ComponentInspector");
    }

    public JComponent getComponent() {
        return this;
    }

    public void panelActivated(Lookup context) {
        this.attachActions();
    }

    public void panelDeactivated() {
        this.detachActions();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    FormDesigner getFormDesigner() {
        return this.formDesigner;
    }

    void setFormDesigner(final FormDesigner designer) {
        if (designer != this.formDesigner) {
            if (EventQueue.isDispatchThread()) {
                this.setFormDesignerImpl(designer);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ComponentInspector.this.setFormDesignerImpl(designer);
                    }
                });
            }
        }
    }

    private void setFormDesignerImpl(FormDesigner designer) {
        if (this.explorerManager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
            if (this.nodeSelectionListener != null) {
                this.explorerManager.removePropertyChangeListener(this.nodeSelectionListener);
            }
        }
        this.formDesigner = designer;
        if (designer == null) {
            this.lookup.setLookupFromExplorerManager(null, null);
            this.explorerManager = null;
            this.removeAll();
            this.createComponents();
            this.revalidate();
        } else {
            this.explorerManager = designer.getExplorerManager();
            this.remove((Component)this.treeView);
            this.add((Component)this.treeView, "Center");
            this.lookup.setLookupFromExplorerManager(this.explorerManager, this.getActionMap());
            if (this.nodeSelectionListener == null) {
                this.nodeSelectionListener = new NodeSelectionListener();
            }
            this.explorerManager.addPropertyChangeListener(this.nodeSelectionListener);
        }
    }

    void attachActions() {
        if (this.explorerManager == null) {
            return;
        }
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.updatePasteAction();
        Clipboard c = this.getClipboard();
        if (c instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            if (this.clipboardListener == null) {
                this.clipboardListener = new ClipboardChangesListener();
            } else {
                clip.removeClipboardListener(this.clipboardListener);
            }
            clip.addClipboardListener(this.clipboardListener);
        }
    }

    void detachActions() {
        Clipboard c;
        if (this.explorerManager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        }
        if ((c = this.getClipboard()) instanceof ExClipboard) {
            ExClipboard clip = (ExClipboard)c;
            clip.removeClipboardListener(this.clipboardListener);
        }
    }

    private Node[] getSelectedRootNodes() {
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length > 1) {
            ArrayList<Node> list = new ArrayList<Node>(selected.length);
            for (int i = 0; i < selected.length; ++i) {
                Node node = selected[i];
                boolean subcontained = false;
                for (int j = 0; j < selected.length; ++j) {
                    if (j == i || !ComponentInspector.isSubcontainedNode(node, selected[j])) continue;
                    subcontained = true;
                    break;
                }
                if (subcontained) continue;
                list.add(node);
            }
            if (list.size() < selected.length) {
                selected = list.toArray(new Node[list.size()]);
            }
        }
        return selected;
    }

    private static boolean isSubcontainedNode(Node node, Node maybeParent) {
        RADComponent comp;
        RADComponentCookie cookie = (RADComponentCookie)node.getCookie(RADComponentCookie.class);
        RADComponent rADComponent = comp = cookie != null ? cookie.getRADComponent() : null;
        if (comp != null) {
            RADComponent parentComp;
            cookie = (RADComponentCookie)maybeParent.getCookie(RADComponentCookie.class);
            RADComponent rADComponent2 = parentComp = cookie != null ? cookie.getRADComponent() : null;
            if (parentComp != null && parentComp.isParentComponent(comp)) {
                return true;
            }
        }
        return false;
    }

    private void updatePasteAction() {
        if (EventQueue.isDispatchThread()) {
            this.updatePasteActionInAwtThread();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentInspector.this.updatePasteActionInAwtThread();
                }
            });
        }
    }

    private void updatePasteActionInAwtThread() {
        Clipboard clipboard;
        Transferable trans;
        Node[] selected = this.getExplorerManager().getSelectedNodes();
        if (selected != null && selected.length >= 1 && (trans = (clipboard = this.getClipboard()).getContents(this)) != null) {
            Node node = selected[0];
            PasteType[] pasteTypes = node.getPasteTypes(trans);
            if (pasteTypes.length != 0) {
                this.pasteAction.setPasteTypes(pasteTypes);
                return;
            }
            boolean multiFlavor = false;
            try {
                multiFlavor = trans.isDataFlavorSupported(ExTransferable.multiFlavor);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (multiFlavor) {
                try {
                    int i;
                    MultiTransferObject mto = (MultiTransferObject)trans.getTransferData(ExTransferable.multiFlavor);
                    int n = mto.getCount();
                    Transferable[] t = new Transferable[n];
                    PasteType[] p = new PasteType[n];
                    for (i = 0; i < n; ++i) {
                        t[i] = mto.getTransferableAt(i);
                        pasteTypes = node.getPasteTypes(t[i]);
                        if (pasteTypes.length == 0) break;
                        p[i] = pasteTypes[0];
                    }
                    if (i == n) {
                        this.pasteAction.setPasteTypes(new PasteType[]{new MultiPasteType(t, p)});
                        return;
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
        this.pasteAction.setPasteTypes(null);
    }

    private Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    @Override
    public void requestFocus() {
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457544L;

        public Object readResolve() {
            return new TopComponent(){

                protected void componentOpened() {
                    this.close();
                }

                public int getPersistenceType() {
                    return 2;
                }
            };
        }
    }

    private static class MultiPasteType
    extends PasteType
    implements Mutex.ExceptionAction<Transferable> {
        private Transferable[] transIn;
        private PasteType[] pasteTypes;

        MultiPasteType(Transferable[] t, PasteType[] p) {
            this.transIn = t;
            this.pasteTypes = p;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                return ExTransferable.EMPTY;
            }
        }

        public Transferable run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            Transferable[] transOut = new Transferable[this.transIn.length];
            for (int i = 0; i < this.pasteTypes.length; ++i) {
                Transferable newTrans = this.pasteTypes[i].paste();
                transOut[i] = newTrans != null ? newTrans : this.transIn[i];
            }
            return new ExTransferable.Multi(transOut);
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction
    implements ActionPerformer {
        private boolean copy;

        public CopyCutActionPerformer(boolean copy) {
            this.copy = copy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
            Transferable trans;
            Node[] selected = ComponentInspector.this.getSelectedRootNodes();
            if (selected == null || selected.length == 0) {
                trans = null;
            } else if (selected.length == 1) {
                trans = this.getTransferableOwner(selected[0]);
            } else {
                Transferable[] transArray = new Transferable[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    transArray[i] = this.getTransferableOwner(selected[i]);
                    if (transArray[i] != null) continue;
                    return;
                }
                trans = new ExTransferable.Multi(transArray);
            }
            if (trans != null) {
                Clipboard clipboard = ComponentInspector.this.getClipboard();
                clipboard.setContents(trans, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copy ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements ActionPerformer,
    Mutex.Action<Object> {
        private Node[] nodesToDestroy;

        private DeleteActionPerformer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(null);
        }

        public void performAction(SystemAction action) {
            Node[] selected = ComponentInspector.this.getSelectedRootNodes();
            if (selected == null || selected.length == 0) {
                return;
            }
            for (int i = 0; i < selected.length; ++i) {
                if (selected[i].canDestroy()) continue;
                return;
            }
            try {
                ComponentInspector.this.getExplorerManager().setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.nodesToDestroy = selected;
            if (EventQueue.isDispatchThread()) {
                this.doDelete();
            } else {
                Mutex.EVENT.readAccess((Mutex.Action)this);
            }
        }

        public Object run() {
            this.doDelete();
            return null;
        }

        private void doDelete() {
            if (this.nodesToDestroy != null) {
                for (int i = 0; i < this.nodesToDestroy.length; ++i) {
                    try {
                        this.nodesToDestroy[i].destroy();
                        continue;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.nodesToDestroy = null;
            }
        }
    }

    private class ClipboardChangesListener
    implements ClipboardListener {
        private ClipboardChangesListener() {
        }

        public void clipboardChanged(ClipboardEvent ev) {
            if (!ev.isConsumed()) {
                ComponentInspector.this.updatePasteAction();
            }
        }
    }

    private class NodeSelectionListener
    implements PropertyChangeListener,
    ActionListener,
    Runnable {
        private Timer timer = new Timer(150, this);

        NodeSelectionListener() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName()) && ComponentInspector.this.formDesigner != null && ComponentInspector.this.formDesigner.getFormModel() != null) {
                for (Node node : ComponentInspector.this.getExplorerManager().getSelectedNodes()) {
                    ((FormNode)node).updateCookies();
                }
                this.timer.restart();
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            ComponentInspector.this.updatePasteAction();
            this.timer.stop();
        }
    }

    private static class ExplorerManagerLookup
    extends ProxyLookup {
        private ExplorerManagerLookup() {
        }

        void setLookupFromExplorerManager(ExplorerManager manager, ActionMap actionMap) {
            this.setLookups(new Lookup[]{manager != null ? ExplorerUtils.createLookup((ExplorerManager)manager, (ActionMap)actionMap) : Lookup.EMPTY});
        }
    }
}

