/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.ComboBoxWithTree;
import org.netbeans.modules.form.DataImporter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ListSelector;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BindingCustomizer
extends JPanel {
    private BindingDesignSupport designSupport;
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private RADComponent selectedComponent;
    private List<RADComponent> allComponents;
    private FormProperty nullValueProperty;
    private FormProperty incompletePathValueProperty;
    private FormProperty converterProperty;
    private FormProperty validatorProperty;
    private FormProperty nameProperty;
    private FormProperty.ValueWithEditor oldNullValue;
    private FormProperty.ValueWithEditor oldIncompletePathValue;
    private FormProperty.ValueWithEditor oldConverter;
    private FormProperty.ValueWithEditor oldValidator;
    private FormProperty.ValueWithEditor oldName;
    private ComboBoxWithTree expressionCombo;
    private ComboBoxWithTree displayExpressionCombo;
    private ListSelector columnSelector;
    private DefaultTreeModel expressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private DefaultTreeModel displayExpressionModel = new DefaultTreeModel(new DefaultMutableTreeNode(null, false));
    private Dialog dialog;
    private ActionListener dialogListener;
    private JButton okButton;
    private JButton cancelButton;
    private PropertyChangeSupport typeChangeSupport = new PropertyChangeSupport(this);
    JPanel advancedPanel;
    JPanel bindingPanel;
    JLabel conversionLabel;
    JLabel converterLabel;
    JLabel converterMessage;
    PropertyPanel converterPanel;
    JPanel detailPanel;
    JLabel displayExpressionLabel;
    JLabel displayValuesLabel;
    JLabel expressionLabel;
    JLabel identificationLabel;
    JCheckBox ignoreAdjustingChoice;
    JButton importDataButton;
    JCheckBox incompletePathValueCheckBox;
    PropertyPanel incompletePathValuePanel;
    JLabel infoLabel;
    JLabel nameLabel;
    PropertyPanel namePanel;
    JCheckBox nullValueCheckBox;
    PropertyPanel nullValuePanel;
    JComboBox sourceCombo;
    JLabel sourceLabel;
    JLabel specialValuesLabel;
    JTabbedPane tabbedPane;
    JComboBox treeCombo;
    JComboBox treeCombo2;
    JLabel updateLabel;
    JComboBox updateModeCombo;
    JLabel updateModeLabel;
    JLabel updatePropertiesLabel;
    JComboBox updateWhenCombo;
    JLabel updateWhenLabel;
    JLabel validationLabel;
    JLabel validatorLabel;
    JLabel validatorMessage;
    PropertyPanel validatorPanel;
    private Map<String, String> columnToType;
    private FormUtils.TypeHelper lastElemType;

    public BindingCustomizer(BindingProperty property) {
        this.bindingComponent = property.getBindingComponent();
        this.bindingDescriptor = property.getBindingDescriptor();
        this.designSupport = FormEditor.getBindingSupport(this.bindingComponent.getFormModel());
        this.initExpressionCombo();
        this.initComponents();
        this.expressionLabel.setLabelFor(this.expressionCombo);
        this.displayExpressionLabel.setLabelFor(this.displayExpressionCombo);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode1"));
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode2"));
        model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateMode3"));
        this.updateModeCombo.setModel(model);
        boolean showUpdateWhen = this.showUpdateWhen();
        this.updateWhenLabel.setVisible(showUpdateWhen);
        this.updateWhenCombo.setVisible(showUpdateWhen);
        if (showUpdateWhen) {
            model = new DefaultComboBoxModel();
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen1"));
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen2"));
            model.addElement(FormUtils.getBundleString("MSG_BindingCustomizer_UpdateWhen3"));
            this.updateWhenCombo.setModel(model);
        }
        this.ignoreAdjustingChoice.setVisible(this.showIgnoreAdjusting());
        this.importDataButton.setVisible(this.showImportData());
        if (this.showColumnSelector()) {
            this.columnSelector = new ListSelector();
            ((GroupLayout)this.bindingPanel.getLayout()).replace(this.detailPanel, this.columnSelector);
        }
        boolean showDisplayExpression = this.showDisplayExpression();
        this.displayExpressionLabel.setVisible(showDisplayExpression);
        this.displayExpressionCombo.setVisible(showDisplayExpression);
        this.nullValueProperty = property.getNullValueProperty();
        this.configurePropertyPanel(this.nullValuePanel);
        if (this.nullValueProperty != null) {
            this.nullValuePanel.setProperty((Node.Property)this.nullValueProperty);
        }
        this.incompletePathValueProperty = property.getIncompleteValueProperty();
        this.configurePropertyPanel(this.incompletePathValuePanel);
        if (this.incompletePathValueProperty != null) {
            this.incompletePathValuePanel.setProperty((Node.Property)this.incompletePathValueProperty);
        }
        this.converterProperty = property.getConverterProperty();
        if (this.converterProperty != null) {
            this.converterPanel.setProperty((Node.Property)this.converterProperty);
        }
        this.validatorProperty = property.getValidatorProperty();
        if (this.validatorProperty != null) {
            this.validatorPanel.setProperty((Node.Property)this.validatorProperty);
        }
        this.nameProperty = property.getNameProperty();
        if (this.nameProperty != null) {
            this.namePanel.setProperty((Node.Property)this.nameProperty);
        }
        this.updatePropertiesLabel.setMinimumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMinimumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMinimumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMinimumSize(this.specialValuesLabel.getPreferredSize());
        this.updatePropertiesLabel.setMaximumSize(this.updatePropertiesLabel.getPreferredSize());
        this.conversionLabel.setMaximumSize(this.conversionLabel.getPreferredSize());
        this.validatorLabel.setMaximumSize(this.validatorLabel.getPreferredSize());
        this.specialValuesLabel.setMaximumSize(this.specialValuesLabel.getPreferredSize());
    }

    private void configurePropertyPanel(PropertyPanel propertyPanel) {
        if (Boolean.TYPE.equals(this.bindingDescriptor.getValueType())) {
            propertyPanel.setPreferences(8);
        } else {
            propertyPanel.setPreferences(4);
        }
    }

    private boolean showUpdateWhen() {
        String path = this.bindingDescriptor.getPath();
        return "text".equals(path) && JTextComponent.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    private boolean showIgnoreAdjusting() {
        String path = this.bindingDescriptor.getPath();
        Class<? extends Object> beanClass = this.bindingComponent.getBeanClass();
        return "value".equals(path) && JSlider.class.isAssignableFrom(beanClass) || ("selectedElement".equals(path) || "selectedElements".equals(path)) && (JList.class.isAssignableFrom(beanClass) || JTable.class.isAssignableFrom(beanClass) || JComboBox.class.isAssignableFrom(beanClass));
    }

    private boolean showImportData() {
        boolean show;
        String path = this.bindingDescriptor.getPath();
        Class<? extends Object> clazz = this.bindingComponent.getBeanClass();
        boolean bl = show = "elements".equals(path) && (JList.class.isAssignableFrom(clazz) || JComboBox.class.isAssignableFrom(clazz) || JTable.class.isAssignableFrom(clazz));
        if (show) {
            FormModel model = this.bindingComponent.getFormModel();
            DataImporter importer = (DataImporter)Lookup.getDefault().lookup(DataImporter.class);
            show = importer != null && importer.canImportData(model);
        }
        return show;
    }

    private boolean showDisplayExpression() {
        String path = this.bindingDescriptor.getPath();
        Class<? extends Object> clazz = this.bindingComponent.getBeanClass();
        return "elements".equals(path) && JList.class.isAssignableFrom(clazz);
    }

    private boolean showColumnSelector() {
        return "elements".equals(this.bindingDescriptor.getPath()) && JTable.class.isAssignableFrom(this.bindingComponent.getBeanClass());
    }

    public MetaBinding getBinding() {
        return this.binding;
    }

    public void setBinding(MetaBinding binding) {
        this.binding = binding;
        String info = MessageFormat.format(this.infoLabel.getText(), this.bindingComponent.getName(), this.bindingDescriptor.getPath(), this.bindingDescriptor.getValueType().getName());
        this.infoLabel.setText(info);
        this.setBindingToUI();
    }

    public Dialog getDialog(ActionListener listener) {
        if (this.dialog == null) {
            ResourceBundle bundle = NbBundle.getBundle(BindingCustomizer.class);
            this.initButtons(bundle);
            String pattern = bundle.getString("MSG_BindingCustomizer_Binding");
            String title = MessageFormat.format(pattern, this.bindingComponent.getName(), this.bindingDescriptor.getPath());
            final DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, (Object[])new JButton[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx("gui.binding-customizer.basic"), null);
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    dd.setHelpCtx(new HelpCtx(BindingCustomizer.this.tabbedPane.getSelectedIndex() == 1 ? "gui.binding-customizer.advanced" : "gui.binding-customizer.basic"));
                }
            });
            dd.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
            this.dialog = DialogDisplayer.getDefault().createDialog(dd);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    this.restore(BindingCustomizer.this.nullValueProperty, BindingCustomizer.this.oldNullValue);
                    this.restore(BindingCustomizer.this.incompletePathValueProperty, BindingCustomizer.this.oldIncompletePathValue);
                    this.restore(BindingCustomizer.this.converterProperty, BindingCustomizer.this.oldConverter);
                    this.restore(BindingCustomizer.this.validatorProperty, BindingCustomizer.this.oldValidator);
                    this.restore(BindingCustomizer.this.nameProperty, BindingCustomizer.this.oldName);
                }

                private void restore(FormProperty property, Object value) {
                    if (value != null) {
                        try {
                            property.setValue(value);
                        }
                        catch (IllegalAccessException iaex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iaex.getMessage(), iaex);
                        }
                        catch (InvocationTargetException itex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, itex.getMessage(), itex);
                        }
                    }
                }
            });
        }
        this.dialogListener = listener;
        this.updatePropertyPanels();
        return this.dialog;
    }

    public JComponent getBindingPanel() {
        this.infoLabel.setVisible(false);
        if (this.columnSelector.getParent() != null) {
            this.detailPanel.setVisible(false);
            ((GroupLayout)this.bindingPanel.getLayout()).replace(this.columnSelector, this.detailPanel);
        }
        return this.bindingPanel;
    }

    public ComboBoxWithTree getSubExpressionCombo() {
        return this.displayExpressionCombo;
    }

    public TreeModel getSubExpressionModel() {
        return this.displayExpressionModel;
    }

    private void initButtons(ResourceBundle bundle) {
        this.okButton = new JButton(bundle.getString("MSG_BindingCustomizer_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (BindingCustomizer.this.getBindingFromUI()) {
                    BindingCustomizer.this.oldNullValue = null;
                    BindingCustomizer.this.oldIncompletePathValue = null;
                    BindingCustomizer.this.oldConverter = null;
                    BindingCustomizer.this.oldValidator = null;
                    BindingCustomizer.this.oldName = null;
                    if (BindingCustomizer.this.dialogListener != null) {
                        BindingCustomizer.this.dialogListener.actionPerformed(ev);
                    }
                }
            }
        });
        this.cancelButton = new JButton(bundle.getString("MSG_BindingCustomizer_Cancel"));
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    private void setBindingToUI() {
        this.fillSourceComponentsCombo();
        if (this.binding != null) {
            int index = this.allComponents.indexOf(this.binding.getSource());
            if (index >= 0) {
                this.sourceCombo.setSelectedIndex(index + 1);
                this.setSelectedComponent(this.binding.getSource());
                String sourcePath = this.binding.getSourcePath();
                this.expressionCombo.setSelectedItem(sourcePath == null ? "null" : sourcePath);
            }
            this.updateModeCombo.setSelectedIndex(this.binding.getUpdateStrategy());
            if (this.showUpdateWhen()) {
                int updateWhen = 2;
                String value = this.binding.getParameter("javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY");
                if ("javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST".equals(value)) {
                    updateWhen = 0;
                } else if ("javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST".equals(value)) {
                    updateWhen = 1;
                } else if ("javax.swing.binding.TextChangeStrategy.ON_TYPE".equals(value)) {
                    updateWhen = 2;
                }
                this.updateWhenCombo.setSelectedIndex(updateWhen);
            }
            if (this.showIgnoreAdjusting()) {
                String value = this.binding.getParameter("IGNORE_ADJUSTING");
                boolean ignoreAdjusting = "Y".equals(value);
                this.ignoreAdjustingChoice.setSelected(ignoreAdjusting);
            }
            if (this.showDisplayExpression()) {
                String displayPath = this.binding.getParameter("DISPLAY");
                this.displayExpressionCombo.setSelectedItem(displayPath == null ? "null" : displayPath);
            }
            this.updateColumnSelector();
            if (this.columnSelector != null) {
                if (this.binding.hasSubBindings()) {
                    LinkedList available = new LinkedList(this.columnSelector.getSelectedItems());
                    LinkedList<String> selected = new LinkedList<String>();
                    for (MetaBinding subBinding : this.binding.getSubBindings()) {
                        String column = subBinding.getSourcePath();
                        if (!available.contains(column = this.designSupport.unwrapSimpleExpression(column))) continue;
                        selected.add(column);
                        available.remove(column);
                    }
                    this.columnSelector.setItems(available, selected);
                } else {
                    this.columnSelector.setItems(this.columnSelector.getSelectedItems(), Collections.emptyList());
                }
            }
            this.nullValueCheckBox.setSelected(this.binding.isNullValueSpecified());
            this.incompletePathValueCheckBox.setSelected(this.binding.isIncompletePathValueSpecified());
            if (this.binding.isNullValueSpecified()) {
                this.oldNullValue = this.propertyValue(this.nullValueProperty);
            }
            if (this.binding.isIncompletePathValueSpecified()) {
                this.oldIncompletePathValue = this.propertyValue(this.incompletePathValueProperty);
            }
            if (this.binding.isConverterSpecified()) {
                this.oldConverter = this.propertyValue(this.converterProperty);
            }
            if (this.binding.isValidatorSpecified()) {
                this.oldValidator = this.propertyValue(this.validatorProperty);
            }
            if (this.binding.isNameSpecified()) {
                this.oldName = this.propertyValue(this.nameProperty);
            }
        } else {
            this.sourceCombo.setSelectedIndex(0);
            this.updateModeCombo.setSelectedIndex(0);
            if (this.showUpdateWhen()) {
                this.updateWhenCombo.setSelectedIndex(2);
            }
            if (this.showIgnoreAdjusting()) {
                this.ignoreAdjustingChoice.setSelected(false);
            }
            this.nullValueCheckBox.setSelected(false);
            this.incompletePathValueCheckBox.setSelected(false);
            this.oldNullValue = null;
            this.oldIncompletePathValue = null;
            this.oldConverter = null;
            this.oldValidator = null;
            this.oldName = null;
        }
        this.updatePropertyPanels();
    }

    private void updatePropertyPanels() {
        if (this.binding != null) {
            this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
            this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
        } else {
            this.nullValuePanel.setEnabled(false);
            this.incompletePathValuePanel.setEnabled(false);
        }
    }

    private FormProperty.ValueWithEditor propertyValue(FormProperty property) {
        FormProperty.ValueWithEditor value = null;
        try {
            value = new FormProperty.ValueWithEditor(property.getValue(), property.getCurrentEditor());
        }
        catch (IllegalAccessException iaex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, itex.getMessage(), itex);
        }
        return value;
    }

    private void fillSourceComponentsCombo() {
        FormModel formModel = this.getFormModel();
        List<RADComponent> nonvisualList = formModel.getNonVisualComponents();
        List<RADComponent> visualList = formModel.getVisualComponents();
        RADComponent topcomp = formModel.getTopRADComponent();
        if (topcomp != null) {
            nonvisualList.remove(topcomp);
            visualList.remove(topcomp);
        }
        RADComponentComparator c = new RADComponentComparator();
        Collections.sort(nonvisualList, c);
        Collections.sort(visualList, c);
        this.allComponents = new ArrayList<RADComponent>(nonvisualList.size() + visualList.size() + 1);
        this.allComponents.addAll(nonvisualList);
        this.allComponents.addAll(visualList);
        if (topcomp != null) {
            this.allComponents.add(topcomp);
        }
        this.sourceCombo.removeAllItems();
        String select = NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_None");
        this.sourceCombo.addItem(select);
        for (RADComponent metacomp : this.allComponents) {
            this.sourceCombo.addItem(metacomp.getName());
        }
    }

    private void setSelectedComponent(RADComponent metacomp) {
        if (metacomp != this.selectedComponent) {
            this.selectedComponent = metacomp;
        }
    }

    public boolean getBindingFromUI() {
        if (this.selectedComponent != null) {
            String sourcePath = this.expressionCombo.getSelectedItem().toString();
            if ("null".equals(sourcePath)) {
                sourcePath = null;
            }
            this.binding = new MetaBinding(this.selectedComponent, sourcePath, this.bindingComponent, this.bindingDescriptor.getPath());
            this.binding.setNullValueSpecified(this.nullValueCheckBox.isSelected());
            this.binding.setIncompletePathValueSpecified(this.incompletePathValueCheckBox.isSelected());
            this.binding.setUpdateStrategy(this.updateModeCombo.getSelectedIndex());
            if (this.showUpdateWhen()) {
                int index = this.updateWhenCombo.getSelectedIndex();
                String updateWhen = null;
                switch (index) {
                    case 0: {
                        updateWhen = "javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST";
                        break;
                    }
                    case 1: {
                        updateWhen = "javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST";
                        break;
                    }
                    case 2: {
                        updateWhen = "javax.swing.binding.TextChangeStrategy.ON_TYPE";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.binding.setParameter("javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY", updateWhen);
            }
            if (this.showIgnoreAdjusting()) {
                String ignoreAdjusting = this.ignoreAdjustingChoice.isSelected() ? "Y" : "N";
                this.binding.setParameter("IGNORE_ADJUSTING", ignoreAdjusting);
            }
            if (this.showDisplayExpression()) {
                String displayExpression = this.displayExpressionCombo.getSelectedItem().toString();
                if ("null".equals(displayExpression)) {
                    displayExpression = null;
                }
                if (displayExpression != null) {
                    this.binding.setParameter("DISPLAY", displayExpression);
                }
            }
            if (this.columnSelector != null) {
                this.binding.setBindImmediately(true);
                if (this.columnSelector.isVisible()) {
                    List items = this.columnSelector.getSelectedItems();
                    for (int i = 0; i < items.size(); ++i) {
                        String item = items.get(i).toString();
                        MetaBinding subBinding = this.binding.addSubBinding(this.designSupport.elWrap(item), null);
                        String columnType = this.columnToType.get(item);
                        if (columnType == null || columnType.equals("java.lang.Object")) continue;
                        String clazz = FormUtils.autobox(columnType);
                        if (clazz.startsWith("java.lang.")) {
                            clazz = clazz.substring(10);
                        }
                        clazz = clazz + ".class";
                        subBinding.setParameter("javax.swing.binding.ParameterKeys.COLUMN_CLASS", clazz);
                    }
                }
            }
            String path = this.bindingDescriptor.getPath();
            FormModel model = this.bindingComponent.getFormModel();
            FormProperty.ValueWithEditor newName = this.propertyValue(this.nameProperty);
            if (this.oldName == null ? this.nameProperty.isChanged() : newName.getValue() != this.oldName.getValue()) {
                model.fireBindingChanged(this.bindingComponent, path, "name", this.oldName, newName);
            }
            FormProperty.ValueWithEditor newNullValue = this.propertyValue(this.nullValueProperty);
            if (this.oldNullValue == null ? this.nullValueProperty.isChanged() : newNullValue.getValue() != this.oldNullValue.getValue()) {
                model.fireBindingChanged(this.bindingComponent, path, "nullValue", this.oldNullValue, newNullValue);
            }
            FormProperty.ValueWithEditor newIncompletePathValue = this.propertyValue(this.incompletePathValueProperty);
            if (this.oldIncompletePathValue == null ? this.incompletePathValueProperty.isChanged() : newIncompletePathValue.getValue() != this.oldIncompletePathValue.getValue()) {
                model.fireBindingChanged(this.bindingComponent, path, "incompleteValue", this.oldIncompletePathValue, newIncompletePathValue);
            }
            FormProperty.ValueWithEditor newConverter = this.propertyValue(this.converterProperty);
            if (this.oldConverter == null ? this.converterProperty.isChanged() : newConverter.getValue() != this.oldConverter.getValue()) {
                model.fireBindingChanged(this.bindingComponent, path, "converter", this.oldConverter, newConverter);
            }
            FormProperty.ValueWithEditor newValidator = this.propertyValue(this.validatorProperty);
            if (this.oldValidator == null ? this.validatorProperty.isChanged() : newValidator.getValue() != this.oldValidator.getValue()) {
                model.fireBindingChanged(this.bindingComponent, path, "validator", this.oldValidator, newValidator);
            }
        } else {
            this.binding = null;
        }
        return true;
    }

    private void initExpressionCombo() {
        TreeComboRenderer renderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullExpression"));
        this.expressionCombo = new ComboBoxWithTree(this.expressionModel, renderer, new Converter(this.expressionModel));
        this.expressionCombo.setSelectedItem("null");
        renderer = new TreeComboRenderer(FormUtils.getBundleString("MSG_BindingCustomizer_NullDisplayExpression"));
        this.displayExpressionCombo = new ComboBoxWithTree(this.displayExpressionModel, renderer, new Converter(this.displayExpressionModel));
        this.displayExpressionCombo.setSelectedItem("null");
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.bindingPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.expressionLabel = new JLabel();
        this.treeCombo = this.expressionCombo;
        this.importDataButton = new JButton();
        this.displayExpressionLabel = new JLabel();
        this.treeCombo2 = this.displayExpressionCombo;
        this.detailPanel = new JPanel();
        this.advancedPanel = new JPanel();
        this.updatePropertiesLabel = new JLabel();
        this.updateModeLabel = new JLabel();
        this.updateModeCombo = new JComboBox();
        this.updateWhenLabel = new JLabel();
        this.updateWhenCombo = new JComboBox();
        this.nullValuePanel = new PropertyPanel();
        this.incompletePathValuePanel = new PropertyPanel();
        this.nullValueCheckBox = new JCheckBox();
        this.displayValuesLabel = new JLabel();
        this.incompletePathValueCheckBox = new JCheckBox();
        this.conversionLabel = new JLabel();
        this.validationLabel = new JLabel();
        this.validatorLabel = new JLabel();
        this.converterLabel = new JLabel();
        this.converterPanel = new PropertyPanel();
        this.validatorPanel = new PropertyPanel();
        this.specialValuesLabel = new JLabel();
        this.updateLabel = new JLabel();
        this.converterMessage = new JLabel();
        this.validatorMessage = new JLabel();
        this.identificationLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.namePanel = new PropertyPanel();
        this.ignoreAdjustingChoice = new JCheckBox();
        FormListener formListener = new FormListener();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Bind"));
        this.sourceLabel.setLabelFor(this.sourceCombo);
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source"));
        this.sourceCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.expressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression"));
        this.treeCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.importDataButton, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ImportData"));
        this.importDataButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayExpressionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression"));
        GroupLayout detailPanelLayout = new GroupLayout(this.detailPanel);
        this.detailPanel.setLayout(detailPanelLayout);
        detailPanelLayout.setHorizontalGroup(detailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 307, Short.MAX_VALUE));
        detailPanelLayout.setVerticalGroup(detailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 297, Short.MAX_VALUE));
        GroupLayout bindingPanelLayout = new GroupLayout(this.bindingPanel);
        this.bindingPanel.setLayout(bindingPanelLayout);
        bindingPanelLayout.setHorizontalGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bindingPanelLayout.createSequentialGroup().addContainerGap().addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel).addGroup(bindingPanelLayout.createSequentialGroup().addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayExpressionLabel).addComponent(this.expressionLabel).addComponent(this.sourceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bindingPanelLayout.createSequentialGroup().addComponent(this.sourceCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importDataButton)).addComponent(this.treeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.treeCombo2, 0, -1, Short.MAX_VALUE))).addComponent(this.detailPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        bindingPanelLayout.setVerticalGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bindingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceLabel).addComponent(this.sourceCombo, -2, -1, -2).addComponent(this.importDataButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expressionLabel).addComponent(this.treeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bindingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayExpressionLabel).addComponent(this.treeCombo2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.sourceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source_ACSD"));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Source_ACSD"));
        this.expressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression_ACSD"));
        this.treeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Expression_ACSD"));
        this.importDataButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ImportData_ACSD"));
        this.displayExpressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression_ACSD"));
        this.treeCombo2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayExpression_ACSD"));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_BindingTab"), this.bindingPanel);
        Mnemonics.setLocalizedText((JLabel)this.updatePropertiesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateProperties"));
        this.updateModeLabel.setLabelFor(this.updateModeCombo);
        Mnemonics.setLocalizedText((JLabel)this.updateModeLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateMode"));
        this.updateWhenLabel.setLabelFor(this.updateWhenCombo);
        Mnemonics.setLocalizedText((JLabel)this.updateWhenLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateWhen"));
        GroupLayout nullValuePanelLayout = new GroupLayout((Container)this.nullValuePanel);
        this.nullValuePanel.setLayout((LayoutManager)nullValuePanelLayout);
        nullValuePanelLayout.setHorizontalGroup(nullValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        nullValuePanelLayout.setVerticalGroup(nullValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        GroupLayout incompletePathValuePanelLayout = new GroupLayout((Container)this.incompletePathValuePanel);
        this.incompletePathValuePanel.setLayout((LayoutManager)incompletePathValuePanelLayout);
        incompletePathValuePanelLayout.setHorizontalGroup(incompletePathValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 160, Short.MAX_VALUE));
        incompletePathValuePanelLayout.setVerticalGroup(incompletePathValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.nullValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue"));
        this.nullValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.nullValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.nullValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.displayValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_DisplayValues"));
        Mnemonics.setLocalizedText((AbstractButton)this.incompletePathValueCheckBox, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue"));
        this.incompletePathValueCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.incompletePathValueCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.incompletePathValueCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.conversionLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Conversion"));
        Mnemonics.setLocalizedText((JLabel)this.validationLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validation"));
        this.validatorLabel.setLabelFor((Component)this.validatorPanel);
        Mnemonics.setLocalizedText((JLabel)this.validatorLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validator"));
        this.converterLabel.setLabelFor((Component)this.converterPanel);
        Mnemonics.setLocalizedText((JLabel)this.converterLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Converter"));
        GroupLayout converterPanelLayout = new GroupLayout((Container)this.converterPanel);
        this.converterPanel.setLayout((LayoutManager)converterPanelLayout);
        converterPanelLayout.setHorizontalGroup(converterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 197, Short.MAX_VALUE));
        converterPanelLayout.setVerticalGroup(converterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        GroupLayout validatorPanelLayout = new GroupLayout((Container)this.validatorPanel);
        this.validatorPanel.setLayout((LayoutManager)validatorPanelLayout);
        validatorPanelLayout.setHorizontalGroup(validatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 197, Short.MAX_VALUE));
        validatorPanelLayout.setVerticalGroup(validatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.specialValuesLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_SpecialValues"));
        Mnemonics.setLocalizedText((JLabel)this.updateLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Update"));
        Mnemonics.setLocalizedText((JLabel)this.converterMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ConversionTxt"));
        Mnemonics.setLocalizedText((JLabel)this.validatorMessage, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ValidationTxt"));
        Mnemonics.setLocalizedText((JLabel)this.identificationLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Identification"));
        this.nameLabel.setLabelFor((Component)this.namePanel);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Name"));
        GroupLayout namePanelLayout = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)namePanelLayout);
        namePanelLayout.setHorizontalGroup(namePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 197, Short.MAX_VALUE));
        namePanelLayout.setVerticalGroup(namePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreAdjustingChoice, (String)NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IgnoreAdjusting"));
        GroupLayout advancedPanelLayout = new GroupLayout(this.advancedPanel);
        this.advancedPanel.setLayout(advancedPanelLayout);
        advancedPanelLayout.setHorizontalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.converterLabel).addComponent(this.validatorLabel).addComponent(this.nameLabel).addComponent(this.updateModeLabel).addComponent(this.updateWhenLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.namePanel, -1, -1, Short.MAX_VALUE).addComponent(this.updateModeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.updateWhenCombo, 0, -1, Short.MAX_VALUE).addComponent((Component)this.converterPanel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.validatorPanel, -1, -1, Short.MAX_VALUE))).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.validationLabel, -2, -1, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.validatorMessage)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.converterMessage)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.conversionLabel, -2, -1, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayValuesLabel)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nullValueCheckBox).addComponent(this.incompletePathValueCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.incompletePathValuePanel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.nullValuePanel, -1, -1, Short.MAX_VALUE))).addGroup(advancedPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.updatePropertiesLabel, -2, -1, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.specialValuesLabel, -2, -1, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.updateLabel)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.identificationLabel, -2, -1, -2)).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ignoreAdjustingChoice))).addContainerGap()));
        advancedPanelLayout.setVerticalGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.identificationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.namePanel, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updatePropertiesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateModeLabel).addComponent(this.updateModeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateWhenLabel).addComponent(this.updateWhenCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreAdjustingChoice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.conversionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.converterMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.converterLabel).addComponent((Component)this.converterPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validatorMessage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.validatorLabel).addComponent((Component)this.validatorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.specialValuesLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayValuesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nullValueCheckBox, GroupLayout.Alignment.CENTER).addComponent((Component)this.nullValuePanel, GroupLayout.Alignment.CENTER, -2, -1, -2)).addGap(7, 7, 7).addGroup(advancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.incompletePathValueCheckBox, GroupLayout.Alignment.CENTER).addComponent((Component)this.incompletePathValuePanel, GroupLayout.Alignment.CENTER, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.updateModeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateMode_ACSD"));
        this.updateWhenCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_UpdateWhen_ACSD"));
        this.nullValuePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue_ACSD"));
        this.incompletePathValuePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue_ACSD"));
        this.nullValueCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_NullValue_ACSD"));
        this.incompletePathValueCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_IncompletePathValue_ACSD"));
        this.converterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Converter_ACSD"));
        this.validatorPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Validator_ACSD"));
        this.namePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_Name_ACSD"));
        this.tabbedPane.addTab(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_AdvancedTab"), this.advancedPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BindingCustomizer.class, (String)"MSG_BindingCustomizer_ACSD"));
    }

    private void importDataButtonActionPerformed(ActionEvent evt) {
        Future<RADComponent> task;
        DataImporter importer = (DataImporter)Lookup.getDefault().lookup(DataImporter.class);
        if (importer != null && (task = importer.importData(this.bindingComponent.getFormModel())) != null) {
            final ProgressHandle handle = ProgressHandleFactory.createHandle(null, (Cancellable)null);
            JPanel handlePanel = BindingCustomizer.panelForHandle(handle);
            handle.start();
            handle.progress(FormUtils.getBundleString("MSG_BindingCustomizer_Importing"));
            String cancelString = FormUtils.getBundleString("MSG_BindingCustomizer_Cancel");
            DialogDescriptor dd = new DialogDescriptor((Object)handlePanel, FormUtils.getBundleString("MSG_BindingCustomizer_Please_Wait"), true, new Object[]{cancelString}, (Object)cancelString, 0, null, null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final RADComponent data = (RADComponent)task.get();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (data != null) {
                                    BindingCustomizer.this.fillSourceComponentsCombo();
                                    BindingCustomizer.this.sourceCombo.setSelectedItem(data.getName());
                                }
                                dialog.setVisible(false);
                                handle.finish();
                            }
                        });
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                    }
                }
            }).start();
            dialog.setVisible(true);
        }
    }

    private void treeComboActionPerformed(ActionEvent evt) {
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    private void incompletePathValueCheckBoxActionPerformed(ActionEvent evt) {
        this.incompletePathValuePanel.setEnabled(this.incompletePathValueCheckBox.isSelected());
    }

    private void nullValueCheckBoxActionPerformed(ActionEvent evt) {
        this.nullValuePanel.setEnabled(this.nullValueCheckBox.isSelected());
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        int index = this.sourceCombo.getSelectedIndex();
        if (index >= 0) {
            this.setSelectedComponent(index > 0 ? this.allComponents.get(index - 1) : null);
            if (index > 0) {
                this.expressionModel.setRoot(new ExpressionNode(this.allComponents.get(index - 1)));
            } else {
                this.expressionCombo.setSelectedItem("null");
                this.expressionModel.setRoot(new DefaultMutableTreeNode(null, false));
            }
            if (this.tabbedPane.getTabCount() > 1) {
                this.tabbedPane.setEnabledAt(1, index > 0);
            }
        }
        this.expressionCombo.setEnabled(index > 0);
        this.displayExpressionCombo.setEnabled(index > 0);
        this.updateColumnSelector();
        this.fireTypeChange();
    }

    private static JPanel panelForHandle(ProgressHandle handle) {
        JLabel label = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label).addComponent(progress)).addContainerGap()));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(progress).addContainerGap());
        return panel;
    }

    public FormUtils.TypeHelper getSelectedType() {
        FormUtils.TypeHelper type = null;
        if (this.selectedComponent != null) {
            String path;
            Object value = this.expressionCombo.getSelectedItem();
            type = value == null || "null".equals(value) ? this.designSupport.determineType(this.selectedComponent) : (this.designSupport.isSimpleExpression(path = value.toString()) ? this.designSupport.determineType(this.selectedComponent, this.designSupport.unwrapSimpleExpression(path)) : new FormUtils.TypeHelper((Type)((Object)String.class)));
        }
        return type;
    }

    private void updateColumnSelector() {
        boolean showDisplayExpression = this.showDisplayExpression();
        if (!showDisplayExpression && this.columnSelector == null) {
            return;
        }
        FormUtils.TypeHelper type = this.getSelectedType();
        if (type != null && Collection.class.isAssignableFrom(FormUtils.typeToClass(type))) {
            FormUtils.TypeHelper elemType = type.typeOfElement();
            if (elemType != null && elemType.equals(this.lastElemType)) {
                return;
            }
            this.lastElemType = elemType;
            if (this.columnSelector != null) {
                List<BindingDescriptor> descriptors = this.designSupport.getAllBindingDescriptors(elemType);
                this.columnSelector.setVisible(descriptors.size() > 0);
                LinkedList<String> available = new LinkedList<String>();
                this.columnToType = new HashMap<String, String>();
                for (BindingDescriptor desc : descriptors) {
                    FormUtils.TypeHelper t = desc.getGenericValueType();
                    String className = t.getName();
                    if (className == null) {
                        Class clazz = desc.getValueType();
                        className = clazz.getName();
                    }
                    this.columnToType.put(desc.getPath(), className);
                    available.add(desc.getPath());
                }
                this.columnSelector.setItems(Collections.EMPTY_LIST, available);
            }
            this.displayExpressionModel.setRoot(new ExpressionNode(elemType));
        } else {
            this.lastElemType = null;
            if (this.columnSelector != null) {
                this.columnSelector.setVisible(false);
            } else {
                this.displayExpressionCombo.setSelectedItem("null");
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(null, true);
            node.add(new DefaultMutableTreeNode(null, false));
            this.displayExpressionModel.setRoot(node);
        }
    }

    public void addTypeChangeListener(PropertyChangeListener listener) {
        this.typeChangeSupport.addPropertyChangeListener(listener);
    }

    public void removeTypeChangeListener(PropertyChangeListener listener) {
        this.typeChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireTypeChange() {
        this.typeChangeSupport.firePropertyChange(null, null, null);
    }

    private static class TreeComboRenderer
    extends DefaultTreeCellRenderer {
        private String nullString;
        private int baseSize;

        TreeComboRenderer(String nullString) {
            this.nullString = nullString;
            this.baseSize = new JLabel().getFont().getSize() + 1;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object object;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ExpressionNode) {
                ExpressionNode node2 = (ExpressionNode)value;
                Object object2 = node2.getUserObject();
                if (object2 == null) {
                    TreeComboRenderer.updateFont(label, this.baseSize);
                    label.setText(this.nullString);
                } else {
                    BindingDescriptor descriptor = node2.getDescriptor();
                    if (descriptor != null) {
                        TreeComboRenderer.updateFont(label, this.baseSize - node2.getCategory());
                        label.setText("<html><b>" + descriptor.getPath() + "</b> " + this.nameOfClass(descriptor.getGenericValueType()));
                    }
                }
            } else if (value instanceof DefaultMutableTreeNode && (object = (node = (DefaultMutableTreeNode)value).getUserObject()) == null) {
                TreeComboRenderer.updateFont(label, this.baseSize);
                label.setText("null");
            }
            return label;
        }

        private static void updateFont(JLabel label, int size) {
            if (label.getFont().getSize() != size) {
                label.setFont(label.getFont().deriveFont((float)size));
            }
        }

        private String nameOfClass(FormUtils.TypeHelper type) {
            String name = type.getName();
            if (name == null && (name = FormUtils.typeToClass(type).getName()).startsWith("[")) {
                StringBuilder sb = new StringBuilder();
                while (name.startsWith("[")) {
                    sb.append("[]");
                    name = name.substring(1);
                }
                if ("Z".equals(name)) {
                    sb.insert(0, "boolean");
                } else if ("B".equals(name)) {
                    sb.insert(0, "byte");
                } else if ("C".equals(name)) {
                    sb.insert(0, "char");
                } else if ("D".equals(name)) {
                    sb.insert(0, "double");
                } else if ("F".equals(name)) {
                    sb.insert(0, "float");
                } else if ("I".equals(name)) {
                    sb.insert(0, "int");
                } else if ("J".equals(name)) {
                    sb.insert(0, "long");
                } else if ("S".equals(name)) {
                    sb.insert(0, "short");
                } else {
                    sb.insert(0, name.substring(1, name.length() - 1));
                }
                name = sb.toString();
            }
            return name;
        }
    }

    private class Converter
    implements ComboBoxWithTree.Converter {
        private DefaultTreeModel treeModel;

        Converter(DefaultTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public String pathToString(TreePath path) {
            String value;
            StringBuilder sb = new StringBuilder();
            Object[] items = path.getPath();
            for (int i = 1; i < items.length; ++i) {
                sb.append(items[i]).append('.');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return "null".equals(value = sb.toString().trim()) ? "null" : BindingCustomizer.this.designSupport.elWrap(sb.toString());
        }

        @Override
        public TreePath stringToPath(String value) {
            int index;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeModel.getRoot();
            if (!BindingCustomizer.this.designSupport.isSimpleExpression(value)) {
                if ("null".equals(value)) {
                    return new TreePath(new Object[]{node, node.getChildAt(0)});
                }
                return null;
            }
            value = BindingCustomizer.this.designSupport.unwrapSimpleExpression(value);
            LinkedList<DefaultMutableTreeNode> path = new LinkedList<DefaultMutableTreeNode>();
            path.add(node);
            while ((index = value.indexOf(46)) != -1) {
                String item = value.substring(0, index);
                if ((node = this.findNode(node, item)) == null) {
                    return null;
                }
                path.add(node);
                value = value.substring(index + 1);
            }
            if ((node = this.findNode(node, value)) == null) {
                return null;
            }
            path.add(node);
            return new TreePath(path.toArray());
        }

        private DefaultMutableTreeNode findNode(DefaultMutableTreeNode parent, String userObject) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (!userObject.equals(child.getUserObject())) continue;
                return child;
            }
            return null;
        }
    }

    public class ExpressionNode
    extends JTree.DynamicUtilTreeNode {
        private BindingDescriptor descriptor;
        private RADComponent comp;
        private int category;
        private FormUtils.TypeHelper type;

        ExpressionNode(RADComponent comp) {
            this(bindingCustomizer.designSupport.determineType(comp));
            this.comp = comp;
        }

        ExpressionNode(FormUtils.TypeHelper type) {
            super((Object)"-root-", BindingCustomizer.this.designSupport.getBindingDescriptors(type));
            this.type = type;
            this.setAllowsChildren(true);
        }

        private ExpressionNode(BindingDescriptor descriptor) {
            super((Object)descriptor.getPath(), BindingCustomizer.this.designSupport.getBindingDescriptors(descriptor.getGenericValueType()));
            this.descriptor = descriptor;
            this.type = descriptor.getGenericValueType();
            this.updateLeafStatus();
        }

        private ExpressionNode() {
            super(null, null);
        }

        private void updateLeafStatus() {
            boolean leaf = true;
            if (this.childValue instanceof List[]) {
                List[] lists = (List[])this.childValue;
                for (int i = 0; i < lists.length; ++i) {
                    if (lists[i].size() <= 0) continue;
                    leaf = false;
                    break;
                }
            }
            this.setAllowsChildren(!leaf);
        }

        BindingDescriptor getDescriptor() {
            return this.descriptor;
        }

        int getCategory() {
            return this.category;
        }

        public String getTypeName() {
            String name;
            String string = name = this.type == null ? null : this.type.getName();
            if (name == null) {
                name = FormUtils.typeToClass(this.type).getName();
            }
            return name;
        }

        @Override
        protected void loadChildren() {
            this.loadedChildren = true;
            if ("-root-".equals(this.getUserObject())) {
                this.add(new ExpressionNode());
            }
            if (this.childValue instanceof List[]) {
                List[] lists = (List[])this.childValue;
                for (int i = 0; i < lists.length; ++i) {
                    this.loadChildren(lists[i], i);
                }
            }
        }

        private void loadChildren(List<BindingDescriptor> descriptors, int category) {
            for (BindingDescriptor descriptor : descriptors) {
                ExpressionNode child;
                if (descriptor.isValueTypeRelative()) {
                    StringBuilder sb = new StringBuilder(descriptor.getPath());
                    ExpressionNode node = this;
                    while (node.comp == null) {
                        sb.insert(0, node.getDescriptor().getPath() + ".");
                        node = (ExpressionNode)this.getParent();
                    }
                    FormUtils.TypeHelper type = BindingCustomizer.this.designSupport.determineType(node.comp, sb.toString());
                    child = new ExpressionNode(new BindingDescriptor(descriptor.getPath(), type));
                } else {
                    child = new ExpressionNode(descriptor);
                }
                child.category = category;
                this.add(child);
            }
        }
    }

    private static class RADComponentComparator
    implements Comparator<RADComponent> {
        private RADComponentComparator() {
        }

        @Override
        public int compare(RADComponent o1, RADComponent o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == BindingCustomizer.this.sourceCombo) {
                BindingCustomizer.this.sourceComboActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.treeCombo) {
                BindingCustomizer.this.treeComboActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.importDataButton) {
                BindingCustomizer.this.importDataButtonActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.nullValueCheckBox) {
                BindingCustomizer.this.nullValueCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == BindingCustomizer.this.incompletePathValueCheckBox) {
                BindingCustomizer.this.incompletePathValueCheckBoxActionPerformed(evt);
            }
        }
    }
}

