/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.parsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;

public class TwigSyntaxValidationTask
extends ParserResultTask {
    public void run(Parser.Result r, SchedulerEvent se) {
        TwigParserResult result = (TwigParserResult)r;
        Document document = result.getSnapshot().getSource().getDocument(false);
        if (document != null) {
            ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
            for (TwigParserResult.Error error : result.getErrors()) {
                try {
                    String description = error.getDescription();
                    errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)(description == null ? "" : description), (Document)document, (Position)document.createPosition(error.getOffset()), (Position)document.createPosition(error.getOffset() + error.getLength())));
                }
                catch (BadLocationException ex) {}
            }
            HintsController.setErrors((Document)document, (String)"Twig", errors);
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snpsht) {
            return Collections.singleton(new TwigSyntaxValidationTask());
        }
    }
}

