/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.lexer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopLexerState;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class TwigTopLexer
implements Lexer<TwigTopTokenId> {
    protected TwigTopLexerState state;
    protected final TokenFactory<TwigTopTokenId> tokenFactory;
    protected final LexerInput input;
    static String OPEN_BLOCK = "{%";
    static String OPEN_VAR = "{{";
    static String OPEN_COMMENT = "{#";
    static String CLOSE_BLOCK = "%}";
    static String CLOSE_VAR = "}}";
    static String CLOSE_COMMENT = "#}";
    static Pattern START_RAW = Pattern.compile("^\\{%[\\s]raw");
    static Pattern END_RAW = Pattern.compile("\\{%[\\s]*endraw[\\s]*%\\}$");

    private TwigTopLexer(LexerRestartInfo<TwigTopTokenId> info) {
        this.tokenFactory = info.tokenFactory();
        this.input = info.input();
        this.state = info.state() == null ? new TwigTopLexerState() : new TwigTopLexerState((TwigTopLexerState)info.state());
    }

    public static synchronized TwigTopLexer create(LexerRestartInfo<TwigTopTokenId> info) {
        return new TwigTopLexer(info);
    }

    public Token<TwigTopTokenId> nextToken() {
        TwigTopTokenId tokenId = this.findNextToken();
        return tokenId == null ? null : this.tokenFactory.createToken((TokenId)tokenId);
    }

    public Object state() {
        return new TwigTopLexerState(this.state);
    }

    public void release() {
    }

    TwigTopLexerState.Type findTag(CharSequence text, boolean open) {
        if (open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)OPEN_BLOCK)) {
            return TwigTopLexerState.Type.BLOCK;
        }
        if (!open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_BLOCK)) {
            return TwigTopLexerState.Type.BLOCK;
        }
        if (open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)OPEN_VAR)) {
            return TwigTopLexerState.Type.VAR;
        }
        if (!open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_VAR)) {
            return TwigTopLexerState.Type.VAR;
        }
        if (open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)OPEN_COMMENT)) {
            return TwigTopLexerState.Type.COMMENT;
        }
        if (!open && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_COMMENT)) {
            return TwigTopLexerState.Type.COMMENT;
        }
        return TwigTopLexerState.Type.NONE;
    }

    public TwigTopTokenId findNextToken() {
        int c = this.input.read();
        if (c == -1) {
            return null;
        }
        while (c != -1) {
            CharSequence text = this.input.readText();
            switch (this.state.main) {
                case RAW: {
                    Matcher matcher;
                    if (!CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)"%}") || !(matcher = END_RAW.matcher(text)).find()) break;
                    String captured = matcher.group();
                    this.state.main = TwigTopLexerState.Main.OPEN;
                    this.state.type = TwigTopLexerState.Type.BLOCK;
                    if (text.length() - captured.length() <= 0) break;
                    this.input.backup(captured.length());
                    return TwigTopTokenId.T_TWIG_RAW;
                }
                case INIT: 
                case HTML: {
                    TwigTopLexerState.Type result = this.findTag(text, true);
                    if (result == TwigTopLexerState.Type.NONE) break;
                    this.state.main = TwigTopLexerState.Main.OPEN;
                    this.state.type = result;
                    if (this.input.readLength() > 2) {
                        this.input.backup(2);
                        return TwigTopTokenId.T_HTML;
                    }
                }
                case OPEN: {
                    if (this.input.readLength() != 2) break;
                    this.state.main = TwigTopLexerState.Main.TWIG;
                    break;
                }
                case TWIG: {
                    TwigTopLexerState.Type result = this.findTag(text, false);
                    if (result == TwigTopLexerState.Type.NONE || result != this.state.type) break;
                    boolean escape = false;
                    boolean doubleQuotes = false;
                    boolean singleQuotes = false;
                    if (result != TwigTopLexerState.Type.COMMENT) {
                        for (int i = 0; i < text.length() - 2; ++i) {
                            char q = text.charAt(i);
                            if (q == '\\') {
                                escape = true;
                                continue;
                            }
                            if (!escape) {
                                if (q == '\"' && !singleQuotes) {
                                    doubleQuotes = !doubleQuotes;
                                    continue;
                                }
                                if (q != '\'' || doubleQuotes) continue;
                                singleQuotes = !singleQuotes;
                                continue;
                            }
                            escape = false;
                        }
                    }
                    if (singleQuotes || doubleQuotes) break;
                    this.state.main = result == TwigTopLexerState.Type.BLOCK && START_RAW.matcher(text).find() ? TwigTopLexerState.Main.CLOSE_RAW : TwigTopLexerState.Main.CLOSE;
                    if (this.input.readLength() <= 2) break;
                    this.input.backup(2);
                    break;
                }
                case CLOSE_RAW: 
                case CLOSE: {
                    if (!(this.state.type == TwigTopLexerState.Type.BLOCK && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_BLOCK) || this.state.type == TwigTopLexerState.Type.VAR && CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_VAR)) && (this.state.type != TwigTopLexerState.Type.COMMENT || !CharSequenceUtilities.endsWith((CharSequence)text, (CharSequence)CLOSE_COMMENT))) break;
                    this.state.main = this.state.main == TwigTopLexerState.Main.CLOSE ? TwigTopLexerState.Main.HTML : TwigTopLexerState.Main.RAW;
                    return TwigTopTokenId.T_TWIG;
                }
            }
            c = this.input.read();
        }
        switch (this.state.main) {
            case RAW: {
                return TwigTopTokenId.T_TWIG_RAW;
            }
            case TWIG: {
                return TwigTopTokenId.T_TWIG;
            }
            case HTML: {
                return TwigTopTokenId.T_HTML;
            }
        }
        return TwigTopTokenId.T_HTML;
    }
}

