/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.lexer;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.twig.editor.lexer.TwigTokenId;

public final class TwigLexerUtils {
    private TwigLexerUtils() {
    }

    public static TokenSequence<? extends TwigTokenId> getTwigMarkupTokenSequence(Snapshot snapshot, int offset) {
        return TwigLexerUtils.getTokenSequence(snapshot.getTokenHierarchy(), offset, TwigTokenId.language());
    }

    public static TokenSequence<? extends TwigTokenId> getTwigMarkupTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return TwigLexerUtils.getTokenSequence(th, offset, TwigTokenId.language());
    }

    public static <L> TokenSequence<? extends L> getTokenSequence(TokenHierarchy<?> th, int offset, Language<? extends L> language) {
        TokenSequence ts = th.tokenSequence(language);
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != language) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != language) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static boolean isDelimiter(TwigTokenId tokenId) {
        return TwigTokenId.T_TWIG_VAR_START.equals((Object)tokenId) || TwigTokenId.T_TWIG_BLOCK_START.equals((Object)tokenId) || TwigLexerUtils.isEndingDelimiter(tokenId);
    }

    public static boolean isEndingDelimiter(TwigTokenId tokenId) {
        return TwigTokenId.T_TWIG_BLOCK_END.equals((Object)tokenId) || TwigTokenId.T_TWIG_VAR_END.equals((Object)tokenId);
    }
}

