/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.embedding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.php.twig.editor.lexer.TwigTopTokenId;

public class TwigHtmlEmbeddingProvider
extends EmbeddingProvider {
    public static final String TARGET_MIME_TYPE = "text/html";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), TwigTopTokenId.language());
        TokenSequence sequence = th.tokenSequence(TwigTopTokenId.language());
        if (sequence == null) {
            return Collections.emptyList();
        }
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int offset = -1;
        int length = 0;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == TwigTopTokenId.T_HTML) {
                if (offset < 0) {
                    offset = sequence.offset();
                }
                length += t.length();
                continue;
            }
            if (offset < 0) continue;
            embeddings.add(snapshot.create(offset, length, TARGET_MIME_TYPE));
            offset = -1;
            length = 0;
        }
        if (offset >= 0) {
            embeddings.add(snapshot.create(offset, length, TARGET_MIME_TYPE));
        }
        if (embeddings.isEmpty()) {
            return Collections.singletonList(snapshot.create((CharSequence)"", TARGET_MIME_TYPE));
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 200;
    }

    public void cancel() {
    }
}

