/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.completion;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigTokenId;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;

public class TwigCompletionContextFinder {
    private static final List<Object[]> FILTER_TOKEN_CHAINS = Arrays.asList({ValuedTokenId.FILTER_PUNCTUATION_TOKEN}, {ValuedTokenId.FILTER_PUNCTUATION_TOKEN, TwigTokenId.T_TWIG_NAME}, {ValuedTokenId.FILTER_TAG_TOKEN}, {ValuedTokenId.FILTER_TAG_TOKEN, TwigTokenId.T_TWIG_WHITESPACE}, {ValuedTokenId.FILTER_TAG_TOKEN, TwigTokenId.T_TWIG_WHITESPACE, TwigTokenId.T_TWIG_NAME});

    public static CompletionContext find(TwigParserResult parserResult, int offset) {
        assert (parserResult != null);
        CompletionContext result = CompletionContext.NONE;
        TokenSequence<? extends TwigTokenId> tokenSequence = TwigLexerUtils.getTwigMarkupTokenSequence(parserResult.getSnapshot(), offset);
        if (tokenSequence != null) {
            tokenSequence.move(offset);
            if (TwigCompletionContextFinder.canComplete(tokenSequence, offset)) {
                result = TwigCompletionContextFinder.findContext(tokenSequence);
            }
        }
        return result;
    }

    private static boolean canComplete(TokenSequence<? extends TwigTokenId> tokenSequence, int caretOffset) {
        boolean result = true;
        if (tokenSequence.moveNext()) {
            result = tokenSequence.token() != null && (!TwigLexerUtils.isDelimiter((TwigTokenId)tokenSequence.token().id()) || tokenSequence.offset() == caretOffset);
        } else if (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            result = token == null || !TwigLexerUtils.isEndingDelimiter((TwigTokenId)token.id());
            tokenSequence.moveNext();
        }
        return result;
    }

    private static CompletionContext findContext(TokenSequence<? extends TwigTokenId> tokenSequence) {
        Token token;
        CompletionContext result = CompletionContext.ALL;
        while ((token = tokenSequence.token()) != null) {
            TwigTokenId tokenId = (TwigTokenId)token.id();
            if (TwigTokenId.T_TWIG_OTHER.equals((Object)tokenId)) {
                result = CompletionContext.NONE;
                break;
            }
            if (TwigCompletionContextFinder.acceptTokenChains(tokenSequence, FILTER_TOKEN_CHAINS, true)) {
                result = CompletionContext.FILTER;
                break;
            }
            if (TwigTokenId.T_TWIG_BLOCK_START.equals((Object)tokenId) || TwigTokenId.T_TWIG_BLOCK_END.equals((Object)tokenId)) {
                result = CompletionContext.BLOCK;
                break;
            }
            if (TwigTokenId.T_TWIG_VAR_START.equals((Object)tokenId) || TwigTokenId.T_TWIG_VAR_END.equals((Object)tokenId)) {
                result = CompletionContext.VARIABLE;
                break;
            }
            if (tokenSequence.movePrevious()) continue;
        }
        return result;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        boolean result = false;
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!TwigCompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int originalPosition = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenId = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenId instanceof TwigTokenId) {
                if (tokenSequence.token().id() == tokenId) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            if (tokenId instanceof ValuedTokenId) {
                ValuedTokenId valuedToken = (ValuedTokenId)((Object)tokenId);
                Token token = tokenSequence.token();
                if (token != null && valuedToken.getId().equals(token.id()) && token.text().equals(valuedToken.getValue())) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenId.getClass().getName();
        }
        tokenSequence.move(originalPosition);
        tokenSequence.moveNext();
        return accept;
    }

    private static enum ValuedTokenId {
        FILTER_PUNCTUATION_TOKEN(TwigTokenId.T_TWIG_PUNCTUATION, "|"),
        FILTER_TAG_TOKEN(TwigTokenId.T_TWIG_TAG, "filter");

        private final TwigTokenId id;
        private final String value;

        private ValuedTokenId(TwigTokenId id, String value) {
            this.id = id;
            this.value = value;
        }

        public TwigTokenId getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum CompletionContext {
        VARIABLE,
        BLOCK,
        FILTER,
        NONE,
        ALL;

    }
}

