/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.openide.filesystems.FileObject;

public final class ElementGrip
implements Openable {
    private TreePathHandle delegateElementHandle;
    private ElementHandle handle;
    private String toString;
    private FileObject fileObject;
    private Icon icon;

    public ElementGrip(TreePath treePath, CompilationInfo info) {
        this(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), info.getTrees().getElement(treePath), info);
    }

    public ElementGrip(Element elm, CompilationInfo info) {
        this(TreePathHandle.create((Element)elm, (CompilationInfo)info), elm, info);
    }

    private ElementGrip(TreePathHandle delegateElementHandle, Element elm, CompilationInfo info) {
        this.delegateElementHandle = delegateElementHandle;
        ElementHandle elementHandle = this.handle = elm == null ? null : ElementHandle.create((Element)elm);
        if (elm != null) {
            if (elm.getKind() == ElementKind.CLASS && elm.getSimpleName().length() == 0) {
                this.toString = ((Object)((TypeElement)elm).asType()).toString();
                this.icon = ElementIcons.getElementIcon((ElementKind)elm.getKind(), elm.getModifiers());
            } else if (elm.getKind() == ElementKind.ENUM && elm.getSimpleName().length() == 0 && elm.getEnclosingElement() != null) {
                Element enclosingElement = elm.getEnclosingElement();
                this.toString = enclosingElement.getSimpleName().toString();
                this.icon = ElementIcons.getElementIcon((ElementKind)enclosingElement.getKind(), enclosingElement.getModifiers());
            } else {
                this.toString = elm.getKind() != ElementKind.CONSTRUCTOR ? elm.getSimpleName().toString() : elm.getEnclosingElement().getSimpleName().toString();
                this.icon = ElementIcons.getElementIcon((ElementKind)elm.getKind(), elm.getModifiers());
            }
        }
        this.fileObject = info.getFileObject();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.toString;
    }

    public ElementGrip getParent() {
        return ElementGripFactory.getDefault().getParent(this);
    }

    public TreePath resolve(CompilationInfo info) {
        return this.delegateElementHandle.resolve(info);
    }

    public Element resolveElement(CompilationInfo info) {
        return this.handle == null ? null : this.handle.resolve(info);
    }

    public Tree.Kind getKind() {
        return this.delegateElementHandle.getKind();
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public TreePathHandle getHandle() {
        return this.delegateElementHandle;
    }

    public void open() {
        if (this.fileObject != null && this.handle != null) {
            ElementOpen.open((FileObject)this.fileObject, (ElementHandle)this.handle);
        }
    }
}

