/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.PullUpAction;
import org.netbeans.modules.refactoring.java.ui.PullUpPanel;
import org.netbeans.modules.refactoring.java.ui.PushDownRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PullUpRefactoringUI
implements RefactoringUI,
JavaRefactoringUIFactory {
    private PullUpRefactoring refactoring;
    private Set initialMembers;
    private PullUpPanel panel;
    private String description;

    public PullUpRefactoringUI(TreePathHandle selectedElements, CompilationInfo info) {
        this.initialMembers = new HashSet();
        TreePathHandle selectedPath = PushDownRefactoringUI.resolveSelection(selectedElements, info);
        if (selectedPath != null) {
            Element selected = selectedPath.resolveElement(info);
            this.initialMembers.add(MemberInfo.create(selected, info));
            if (!(selected instanceof TypeElement)) {
                selected = info.getElementUtilities().enclosingTypeElement(selected);
            }
            TreePath tp = info.getTrees().getPath(selected);
            TreePathHandle sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)info);
            this.description = ElementHeaders.getHeader((TreePath)tp, (CompilationInfo)info, (String)"%name%");
            this.refactoring = new PullUpRefactoring(sourceType);
            this.refactoring.getContext().add((Object)info.getClasspathInfo());
        } else {
            this.refactoring = new PullUpRefactoring(selectedElements);
        }
    }

    private PullUpRefactoringUI() {
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new PullUpPanel(this.refactoring, this.initialMembers, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PullUpAction.class, (String)"DSC_PullUp", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PullUpAction.class, (String)"LBL_PullUp");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.PullUpRefactoringUI");
    }

    private void captureParameters() {
        this.refactoring.setTargetType((ElementHandle<TypeElement>)this.panel.getTargetType().getElementHandle());
        this.refactoring.setMembers(this.panel.getMembers());
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        assert (handles.length == 1);
        TreePathHandle selectedElement = PullUpRefactoringUI.findSelectedClassMemberDeclaration(handles[0], info);
        return selectedElement != null ? new PullUpRefactoringUI(selectedElement, info) : null;
    }

    public static JavaRefactoringUIFactory factory() {
        return new PullUpRefactoringUI();
    }

    static TreePathHandle findSelectedClassMemberDeclaration(TreePathHandle path, CompilationInfo info) {
        TreePath resolved = path.resolve(info);
        TreePath selected = PullUpRefactoringUI.findSelectedClassMemberDeclaration(resolved, info);
        if (selected == null) {
            path = null;
        } else if (selected != resolved) {
            path = TreePathHandle.create((TreePath)selected, (CompilationInfo)info);
        }
        return path;
    }

    private static TreePath findSelectedClassMemberDeclaration(TreePath path, CompilationInfo javac) {
        List<? extends Tree> typeDecls;
        TreePath currentPath = path;
        TreePath selection = null;
        while (currentPath != null && selection == null) {
            switch (currentPath.getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case NEW_CLASS: 
                case METHOD: {
                    selection = currentPath;
                    break;
                }
                case VARIABLE: {
                    Element elm = javac.getTrees().getElement(currentPath);
                    if (elm == null || !elm.getKind().isField()) break;
                    selection = currentPath;
                }
            }
            if (selection != null && javac.getTreeUtilities().isSynthetic(selection)) {
                selection = null;
            }
            if (selection != null) continue;
            currentPath = currentPath.getParentPath();
        }
        if (selection == null && path != null && !(typeDecls = path.getCompilationUnit().getTypeDecls()).isEmpty() && typeDecls.get(0).getKind().asInterface() == ClassTree.class) {
            selection = TreePath.getPath(path.getCompilationUnit(), typeDecls.get(0));
        }
        return selection;
    }
}

