/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.java.ui.MoveClassesUI;
import org.netbeans.modules.refactoring.java.ui.MoveMembersUI;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class MoveClassUI
implements RefactoringUI,
RefactoringUIBypass {
    private DataObject javaObject;
    private MoveClassPanel panel;
    private MoveRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private final boolean needsByPass;
    private TreePathHandle javaClass;
    private FileObject targetFolder;
    private PasteType pasteType;
    private final String sourceName;

    public MoveClassUI(DataObject javaObject) {
        this(javaObject, null, null, false);
    }

    public MoveClassUI(DataObject javaObject, FileObject targetFolder, PasteType pasteType) {
        this(javaObject, targetFolder, pasteType, false);
    }

    public MoveClassUI(TreePathHandle javaClass, String sourceName) {
        this(javaClass, null, null, sourceName);
    }

    public MoveClassUI(DataObject javaObject, FileObject targetFolder, PasteType pasteType, boolean needsByPass) {
        this.needsByPass = needsByPass;
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.javaObject = javaObject;
        this.sourceName = javaObject.getName();
        this.pasteType = pasteType;
        this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])new Object[]{javaObject.getPrimaryFile()}));
        this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(javaObject.getPrimaryFile()));
    }

    public MoveClassUI(TreePathHandle javaClass, FileObject targetFolder, PasteType pasteType, String sourceName) {
        this.needsByPass = false;
        this.disable = targetFolder != null;
        this.javaClass = javaClass;
        this.sourceName = sourceName;
        this.targetFolder = targetFolder;
        this.pasteType = pasteType;
        this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])new Object[]{javaClass}));
        this.refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor(javaClass.getFileObject()));
    }

    public String getName() {
        return NbBundle.getMessage(MoveClassUI.class, (String)"LBL_MoveClass");
    }

    public String getDescription() {
        return NbBundle.getMessage(MoveClassUI.class, (String)"DSC_MoveClass", (Object)this.sourceName, (Object)this.packageName());
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            String pkgName = this.targetFolder != null ? MoveClassUI.getPackageName(this.targetFolder) : (this.javaObject != null ? MoveClassUI.getPackageName(this.javaObject.getPrimaryFile().getParent()) : MoveClassUI.getPackageName(this.javaClass.getFileObject().getParent()));
            FileObject target = this.targetFolder != null ? this.targetFolder : (this.javaObject != null ? this.javaObject.getPrimaryFile() : this.javaClass.getFileObject());
            this.panel = new MoveClassPanel(parent, pkgName, NbBundle.getMessage(MoveClassUI.class, (String)"LBL_MoveClassNamed", (Object)this.sourceName), NbBundle.getMessage(MoveClassUI.class, (String)"LBL_MoveWithoutReferences"), target);
            this.panel.setCombosEnabled(!this.disable);
            this.panel.setRefactoringBypassRequired(this.needsByPass);
        }
        return this.panel;
    }

    private static String getPackageName(FileObject file) {
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        return cp.getResourceName(file, '.', false);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? NbBundle.getMessage(MoveClassUI.class, (String)"LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        URL url = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            TreePathHandle targetClass = this.panel.getTargetClass();
            if (targetClass != null) {
                this.refactoring.setTarget(Lookups.singleton((Object)targetClass));
            } else {
                this.refactoring.setTarget(Lookups.singleton((Object)new URL(url.toExternalForm() + this.panel.getPackageName().replace('.', '/'))));
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.MoveClassUI");
    }

    public boolean isRefactoringBypassRequired() {
        return this.needsByPass || this.panel != null && this.panel.isRefactoringBypassRequired();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    public static JavaRefactoringUIFactory factory(Lookup lookup) {
        return new RefactoringUIFactory(lookup);
    }

    private static class RefactoringUIFactory
    implements JavaRefactoringUIFactory {
        private final Lookup lookup;

        public RefactoringUIFactory(Lookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
            int endOffset;
            PasteType paste = RefactoringActionsProvider.getPaste(this.lookup);
            FileObject tar = RefactoringActionsProvider.getTarget(this.lookup);
            if (files != null && (files.length > 1 || files.length == 1 && files[0].isFolder())) {
                HashSet<FileObject> s = new HashSet<FileObject>();
                s.addAll(Arrays.asList(files));
                return new MoveClassesUI(s, tar, paste);
            }
            if (handles.length < 1) {
                if (tar != null) {
                    try {
                        assert (files.length > 0);
                        return new MoveClassUI(DataObject.find((FileObject)files[0]), tar, paste, true);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return null;
                    }
                }
                return null;
            }
            EditorCookie ec = (EditorCookie)this.lookup.lookup(EditorCookie.class);
            if (ec == null) {
                try {
                    if (files == null) {
                        if (handles.length == 1 && handles[0].getElementHandle() != null && handles[0].getElementHandle().getKind() == ElementKind.CLASS) {
                            CompilationUnitTree compilationUnit = handles[0].resolve(info).getCompilationUnit();
                            if (compilationUnit.getTypeDecls().size() == 1) {
                                return new MoveClassUI(DataObject.find((FileObject)handles[0].getFileObject()), tar, paste);
                            }
                            return new MoveClassUI(handles[0], tar, paste, handles[0].resolveElement(info).getSimpleName().toString());
                        }
                        return new MoveMembersUI(handles);
                    }
                    return new MoveClassUI(DataObject.find((FileObject)files[0]), tar, paste);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            TreePathHandle selectedElement = handles[0];
            TreePath enclosingClassPath = JavaRefactoringUtils.findEnclosingClass(info, selectedElement.resolve(info), true, true, true, true, true);
            Element e = info.getTrees().getElement(enclosingClassPath);
            if (e == null) {
                return null;
            }
            JEditorPane textC = NbDocument.findRecentEditorPane((EditorCookie)ec);
            if (textC == null) {
                try {
                    return new MoveClassUI(DataObject.find((FileObject)files[0]), tar, paste);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            int startOffset = textC.getSelectionStart();
            if (startOffset == (endOffset = textC.getSelectionEnd())) {
                return this.doCursorPosition(info, selectedElement, startOffset);
            }
            if (!e.getKind().isClass() && !e.getKind().isInterface()) {
                e = info.getElementUtilities().enclosingTypeElement(e);
            }
            ArrayList<TreePathHandle> tphs = new ArrayList<TreePathHandle>();
            SourcePositions sourcePositions = info.getTrees().getSourcePositions();
            for (Element element : e.getEnclosedElements()) {
                Tree leaf = info.getTrees().getPath(element).getLeaf();
                long start = sourcePositions.getStartPosition(info.getCompilationUnit(), leaf);
                long end = sourcePositions.getEndPosition(info.getCompilationUnit(), leaf);
                if ((start < (long)startOffset || start > (long)endOffset) && (end < (long)startOffset || end > (long)endOffset)) continue;
                tphs.add(TreePathHandle.create((Element)element, (CompilationInfo)info));
            }
            if (tphs.isEmpty()) {
                return this.doCursorPosition(info, selectedElement, startOffset);
            }
            return new MoveMembersUI(tphs.toArray(new TreePathHandle[tphs.size()]));
        }

        private RefactoringUI doCursorPosition(CompilationInfo info, TreePathHandle selectedElement, int position) throws RuntimeException {
            List topLevelElements = info.getTopLevelElements();
            Trees trees = info.getTrees();
            SourcePositions sourcePositions = trees.getSourcePositions();
            CompilationUnitTree compilationUnit = info.getCompilationUnit();
            for (TypeElement typeElement : topLevelElements) {
                ClassTree topLevelClass = trees.getTree(typeElement);
                long startPosition = sourcePositions.getStartPosition(compilationUnit, topLevelClass);
                long endPosition = sourcePositions.getEndPosition(compilationUnit, topLevelClass);
                if ((long)position <= startPosition || (long)position >= endPosition) continue;
                for (Element element : typeElement.getEnclosedElements()) {
                    Tree member = trees.getTree(element);
                    long startMember = sourcePositions.getStartPosition(compilationUnit, member);
                    long endMember = sourcePositions.getEndPosition(compilationUnit, member);
                    if ((long)position <= startMember || (long)position >= endMember) continue;
                    TreePathHandle tph = TreePathHandle.create((Element)element, (CompilationInfo)info);
                    return new MoveMembersUI(tph);
                }
                try {
                    if (topLevelElements.size() == 1) {
                        return new MoveClassUI(DataObject.find((FileObject)info.getFileObject()));
                    }
                    return new MoveClassUI(TreePathHandle.create((Element)typeElement, (CompilationInfo)info), typeElement.getSimpleName().toString());
                }
                catch (DataObjectNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                return new MoveClassUI(DataObject.find((FileObject)info.getFileObject()));
            }
            catch (DataObjectNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

