/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.IntroduceParameterRefactoring;
import org.netbeans.modules.refactoring.java.ui.IntroduceParameterPanel;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IntroduceParameterUI
implements RefactoringUI,
JavaRefactoringUIFactory {
    private TreePathHandle expression;
    private IntroduceParameterPanel panel;
    private IntroduceParameterRefactoring refactoring;
    private Lookup lookup;
    private static final Set<TypeKind> NOT_ACCEPTED_TYPES = EnumSet.of(TypeKind.ERROR, TypeKind.NONE, TypeKind.OTHER, TypeKind.VOID, TypeKind.EXECUTABLE);

    private IntroduceParameterUI(TreePathHandle expression, CompilationInfo info) {
        this.refactoring = new IntroduceParameterRefactoring(expression);
        this.expression = expression;
    }

    private IntroduceParameterUI(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        int endOffset;
        EditorCookie ec = (EditorCookie)this.lookup.lookup(EditorCookie.class);
        JEditorPane textC = NbDocument.findRecentEditorPane((EditorCookie)ec);
        int startOffset = textC.getSelectionStart();
        TreePath tp = IntroduceParameterUI.validateSelection(info, startOffset, endOffset = textC.getSelectionEnd());
        if (tp == null) {
            return null;
        }
        return new IntroduceParameterUI(TreePathHandle.create((TreePath)tp, (CompilationInfo)info), info);
    }

    public static JavaRefactoringUIFactory factory(Lookup lookup) {
        return new IntroduceParameterUI(lookup);
    }

    public String getDescription() {
        return NbBundle.getMessage(IntroduceParameterUI.class, (String)"DSC_IntroduceParameterRootNode", (Object)this.refactoring.getParameterName());
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new IntroduceParameterPanel(this.expression, parent);
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isQuery() {
        return false;
    }

    private Problem setParameters(boolean checkOnly) {
        Problem problem = null;
        this.refactoring.setFinal(this.panel.isDeclareFinal());
        this.refactoring.setParameterName(this.panel.getParameterName());
        this.refactoring.setOverloadMethod(this.panel.isCompatible());
        this.refactoring.setReplaceAll(this.panel.isReplaceAll());
        this.refactoring.getContext().add((Object)this.panel.getJavadoc());
        problem = checkOnly ? this.refactoring.fastCheckParameters() : this.refactoring.checkParameters();
        return problem;
    }

    public String getName() {
        return NbBundle.getMessage(IntroduceParameterUI.class, (String)"LBL_IntroduceParameter");
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.IntroduceParameterUI");
    }

    private static TreePath validateSelection(CompilationInfo ci, int start, int end) {
        return IntroduceParameterUI.validateSelection(ci, start, end, NOT_ACCEPTED_TYPES);
    }

    private static TreePath validateSelection(CompilationInfo ci, int start, int end, Set<TypeKind> ignoredTypes) {
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!ExpressionTree.class.isAssignableFrom(leaf.getKind().asInterface()) && (leaf.getKind() != Tree.Kind.VARIABLE || ((VariableTree)leaf).getInitializer() == null)) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart > (long)start || treeEnd < (long)end) continue;
            TypeMirror type = ci.getTrees().getTypeMirror(tp);
            if (type != null && type.getKind() == TypeKind.ERROR) {
                type = ci.getTrees().getOriginalType((ErrorType)type);
            }
            if (type == null || ignoredTypes.contains((Object)type.getKind()) || tp.getLeaf().getKind() == Tree.Kind.ASSIGNMENT || tp.getLeaf().getKind() == Tree.Kind.ANNOTATION) continue;
            if (!IntroduceParameterUI.isInsideClass(tp)) {
                return null;
            }
            TreePath candidate = tp;
            for (tp = tp.getParentPath(); tp != null; tp = tp.getParentPath()) {
                switch (tp.getLeaf().getKind()) {
                    case VARIABLE: {
                        VariableTree vt = (VariableTree)tp.getLeaf();
                        if (vt.getInitializer() == leaf) {
                            return candidate;
                        }
                        return null;
                    }
                    case NEW_CLASS: {
                        NewClassTree nct = (NewClassTree)tp.getLeaf();
                        if (!nct.getIdentifier().equals(candidate.getLeaf())) break;
                        for (ExpressionTree expressionTree : nct.getArguments()) {
                            if (expressionTree != leaf) continue;
                            return candidate;
                        }
                        return null;
                    }
                }
                leaf = tp.getLeaf();
            }
            return candidate;
        }
        return null;
    }

    private static boolean isInsideClass(TreePath tp) {
        while (tp != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }
}

