/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.ExtractSuperclassAction;
import org.netbeans.modules.refactoring.java.ui.ExtractSuperclassPanel;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExtractSuperclassRefactoringUI
implements RefactoringUI,
JavaRefactoringUIFactory {
    private ExtractSuperclassRefactoring refactoring;
    private TreePathHandle sourceType;
    private ExtractSuperclassPanel panel;
    private String name;

    private ExtractSuperclassRefactoringUI() {
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        assert (handles.length == 1);
        TreePath path = handles[0].resolve(info);
        if ((path = JavaRefactoringUtils.findEnclosingClass(info, path, true, false, false, false, false)) != null) {
            return new ExtractSuperclassRefactoringUI(path, info);
        }
        return null;
    }

    private ExtractSuperclassRefactoringUI(TreePath path, CompilationInfo info) {
        this.name = ElementHeaders.getHeader((TreePath)path, (CompilationInfo)info, (String)"%name%");
        this.sourceType = TreePathHandle.create((TreePath)path, (CompilationInfo)info);
        this.refactoring = new ExtractSuperclassRefactoring(this.sourceType);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new ExtractSuperclassPanel(this.refactoring, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(ExtractSuperclassAction.class, (String)"DSC_ExtractSC", (Object)this.name);
    }

    public String getName() {
        return NbBundle.getMessage(ExtractSuperclassAction.class, (String)"LBL_ExtractSC");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.ExtractSuperclassRefactoringUI");
    }

    private void captureParameters() {
        this.refactoring.setSuperClassName(this.panel.getSuperClassName());
        this.refactoring.setMembers(this.panel.getMembers());
    }

    public static JavaRefactoringUIFactory factory() {
        return new ExtractSuperclassRefactoringUI();
    }
}

