/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.ui.CopyClassesUI;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class CopyClassRefactoringUI
implements RefactoringUI,
RefactoringUIBypass,
JavaRefactoringUIFactory {
    private SingleCopyRefactoring refactoring;
    private MoveClassPanel panel;
    private FileObject resource;
    private FileObject targetFolder;
    private Lookup lookup;
    private boolean needsByPass;

    private CopyClassRefactoringUI(FileObject resource, FileObject target) {
        this(resource, target, false);
    }

    private CopyClassRefactoringUI(FileObject resource, FileObject target, boolean needsByPass) {
        this.refactoring = new SingleCopyRefactoring(Lookups.singleton((Object)resource));
        this.resource = resource;
        this.targetFolder = target;
        this.needsByPass = needsByPass;
    }

    private CopyClassRefactoringUI(Lookup lookup) {
        this.lookup = lookup;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            FileObject target = this.targetFolder != null ? this.targetFolder : this.resource.getParent();
            this.panel = new MoveClassPanel(parent, RefactoringUtils.getPackageName(target), this.getName() + " - " + this.resource.getName(), NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"LBL_CopyWithoutRefactoring"), target, this.resource.getName(), false);
            this.panel.setCombosEnabled(this.targetFolder == null);
            this.panel.setRefactoringBypassRequired(this.needsByPass);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.setupRefactoring();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.panel == null) {
            return null;
        }
        this.setupRefactoring();
        return this.refactoring.fastCheckParameters();
    }

    private void setupRefactoring() {
        this.refactoring.setNewName(this.panel.getNewName());
        FileObject rootFolder = this.panel.getRootFolder();
        Lookup target = Lookup.EMPTY;
        if (rootFolder != null) {
            try {
                URL url = URLMapper.findURL((FileObject)rootFolder, (int)1);
                URL targetURL = new URL(url.toExternalForm() + this.panel.getPackageName().replace('.', '/'));
                target = Lookups.singleton((Object)targetURL);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.refactoring.setTarget(target);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"DSC_CopyClass", (Object)this.refactoring.getNewName());
    }

    public String getName() {
        return NbBundle.getMessage(CopyClassRefactoringUI.class, (String)"LBL_CopyClass");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI");
    }

    public boolean isRefactoringBypassRequired() {
        return this.needsByPass || this.panel != null && this.panel.isRefactoringBypassRequired();
    }

    public void doRefactoringBypass() throws IOException {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject source = (FileObject)CopyClassRefactoringUI.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                    if (source != null) {
                        DataObject sourceDo = DataObject.find((FileObject)source);
                        DataFolder targetDataFolder = DataFolder.findFolder((FileObject)CopyClassRefactoringUI.this.targetFolder);
                        sourceDo.copy(targetDataFolder).rename(CopyClassRefactoringUI.this.panel.getNewName());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        PasteType paste = RefactoringActionsProvider.getPaste(this.lookup);
        FileObject tar = RefactoringActionsProvider.getTarget(this.lookup);
        if (files != null && (files.length > 1 || files.length == 1 && files[0].isFolder())) {
            HashSet<FileObject> s = new HashSet<FileObject>();
            s.addAll(Arrays.asList(files));
            return new CopyClassesUI(s, tar, paste);
        }
        if (handles.length < 1) {
            if (tar != null) {
                assert (files.length > 0);
                return new CopyClassRefactoringUI(files[0], tar, true);
            }
            return null;
        }
        if (info == null) {
            return new CopyClassRefactoringUI(handles[0].getFileObject(), tar);
        }
        TreePathHandle selectedElement = handles[0];
        Element e = selectedElement.resolveElement(info);
        if (e == null) {
            return null;
        }
        if ((e.getKind().isClass() || e.getKind().isInterface()) && SourceUtils.getOutermostEnclosingTypeElement((Element)e) == e) {
            try {
                DataObject d;
                FileObject fo = SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo());
                if (fo != null && (d = DataObject.find((FileObject)SourceUtils.getFile((Element)e, (ClasspathInfo)info.getClasspathInfo()))).getName().equals(e.getSimpleName().toString())) {
                    return new CopyClassRefactoringUI(d.getPrimaryFile(), tar);
                }
            }
            catch (DataObjectNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new CopyClassRefactoringUI(info.getFileObject(), tar);
    }

    public static JavaRefactoringUIFactory factory(Lookup lookup) {
        return new CopyClassRefactoringUI(lookup);
    }
}

