/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.VarUsageVisitor;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class UseSuperTypeRefactoringPlugin
extends JavaRefactoringPlugin {
    private final UseSuperTypeRefactoring refactoring;

    public UseSuperTypeRefactoringPlugin(UseSuperTypeRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        TreePathHandle subClassHandle = this.refactoring.getTypeElement();
        this.replaceSubtypeUsages(subClassHandle, refactoringElements);
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)this.refactoring.getTypeElement().getFileObject());
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        if (this.refactoring.getTargetSuperType() == null) {
            return new Problem(true, NbBundle.getMessage(UseSuperTypeRefactoringPlugin.class, (String)"ERR_UseSuperTypeNoSuperType"));
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    private void replaceSubtypeUsages(final TreePathHandle subClassHandle, final RefactoringElementsBag elemsBag) {
        JavaSource javaSrc = JavaSource.forFileObject((FileObject)subClassHandle.getFileObject());
        try {
            javaSrc.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationController complController) throws IOException {
                    complController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject fo = subClassHandle.getFileObject();
                    ClasspathInfo classpathInfo = RefactoringUtils.getClasspathInfoFor(true, true, fo);
                    ClassIndex clsIndx = classpathInfo.getClassIndex();
                    TypeElement javaClassElement = (TypeElement)subClassHandle.resolveElement((CompilationInfo)complController);
                    EnumSet<ClassIndex.SearchKind> typeRefSearch = EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES);
                    Set refFileObjSet = clsIndx.getResources(ElementHandle.create((Element)javaClassElement), typeRefSearch, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    if (!refFileObjSet.isEmpty()) {
                        UseSuperTypeRefactoringPlugin.this.fireProgressListenerStart(3, refFileObjSet.size());
                        try {
                            Collection results = UseSuperTypeRefactoringPlugin.this.processFiles(refFileObjSet, (CancellableTask<WorkingCopy>)new FindRefTask(subClassHandle, UseSuperTypeRefactoringPlugin.this.refactoring.getTargetSuperType()));
                            elemsBag.registerTransaction(JavaRefactoringPlugin.createTransaction(results));
                            for (ModificationResult result : results) {
                                for (FileObject fileObj : result.getModifiedFileObjects()) {
                                    for (ModificationResult.Difference diff : result.getDifferences(fileObj)) {
                                        String old = diff.getOldText();
                                        if (old == null) continue;
                                        elemsBag.add((AbstractRefactoring)UseSuperTypeRefactoringPlugin.this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fileObj, result));
                                    }
                                }
                            }
                        }
                        finally {
                            UseSuperTypeRefactoringPlugin.this.fireProgressListenerStop();
                        }
                    }
                }
            }, false);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    private static class ReferencesVisitor
    extends RefactoringVisitor {
        private final TypeElement superTypeElement;
        private final TypeElement subTypeElement;

        private ReferencesVisitor(WorkingCopy workingCopy, Element subClassElement, Element superClassElement) {
            try {
                this.setWorkingCopy(workingCopy);
            }
            catch (ToPhaseException phase) {
                Exceptions.printStackTrace((Throwable)phase);
            }
            this.superTypeElement = (TypeElement)superClassElement;
            this.subTypeElement = (TypeElement)subClassElement;
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree memSelTree, Element elemToFind) {
            Element elem = this.asElement(memSelTree);
            if (elem != null && this.isStatic(elem)) {
                Element expreElem = this.asElement(memSelTree.getExpression());
                if (expreElem == null || !ElementKind.CLASS.equals((Object)expreElem.getKind()) && !ElementKind.INTERFACE.equals((Object)expreElem.getKind())) {
                    return (Tree)super.visitMemberSelect(memSelTree, elemToFind);
                }
                TypeElement type = (TypeElement)expreElem;
                if (!this.subTypeElement.equals(type)) {
                    return (Tree)super.visitMemberSelect(memSelTree, elemToFind);
                }
                if (this.hidesSupTypeMember(elem, this.superTypeElement)) {
                    this.replaceType(memSelTree, this.superTypeElement);
                }
            }
            return (Tree)super.visitMemberSelect(memSelTree, elemToFind);
        }

        @Override
        public Tree visitVariable(VariableTree varTree, Element elementToMatch) {
            TypeMirror elToMatchErasure;
            TypeMirror varTypeErasure;
            TreePath treePath = this.getCurrentPath();
            VariableElement varElement = (VariableElement)this.workingCopy.getTrees().getElement(treePath);
            if (varElement == null) {
                return (Tree)super.visitVariable(varTree, elementToMatch);
            }
            TreePath parentPath = treePath.getParentPath();
            if (parentPath != null && parentPath.getLeaf().getKind() == Tree.Kind.CATCH) {
                return (Tree)super.visitVariable(varTree, elementToMatch);
            }
            Types types = this.workingCopy.getTypes();
            if (types.isSameType(varTypeErasure = this.erasureOf(varElement.asType()), elToMatchErasure = this.erasureOf(this.subTypeElement.asType())) && this.isReplaceCandidate(varElement)) {
                this.replaceWithSuperType(varTree, this.superTypeElement);
            }
            return (Tree)super.visitVariable(varTree, elementToMatch);
        }

        @Override
        public Tree visitTypeCast(TypeCastTree castTree, Element elementToMatch) {
            VariableElement varElement;
            TypeMirror varTypeErasure;
            TreePath path = this.getCurrentPath();
            Types types = this.workingCopy.getTypes();
            TypeMirror castTypeErasure = this.erasureOf(this.workingCopy.getTrees().getTypeMirror(path));
            TypeMirror elToMatchErasure = this.erasureOf(this.subTypeElement.asType());
            path = path.getParentPath();
            Element element = this.workingCopy.getTrees().getElement(path);
            if (element instanceof VariableElement && types.isSameType(castTypeErasure, elToMatchErasure) && types.isSameType(varTypeErasure = this.erasureOf((varElement = (VariableElement)element).asType()), elToMatchErasure) && this.isReplaceCandidate(varElement)) {
                TypeCastTree newTree = this.make.TypeCast((Tree)this.make.Identifier((Element)this.superTypeElement), castTree.getExpression());
                this.rewrite(castTree, newTree);
            }
            return (Tree)super.visitTypeCast(castTree, elementToMatch);
        }

        private boolean hidesSupTypeMember(Element methElement, TypeElement superTypeElement) {
            Elements elements = this.workingCopy.getElements();
            List<? extends Element> containedElements = elements.getAllMembers(superTypeElement);
            for (Element element : containedElements) {
                boolean isPresentInSuperType;
                boolean bl = isPresentInSuperType = ((Object)methElement).equals(element) || elements.hides(methElement, element);
                if (element == null || !this.isStatic(element) || !isPresentInSuperType) continue;
                return true;
            }
            return false;
        }

        private boolean isReplaceCandidate(VariableElement varElement) {
            VarUsageVisitor varUsagesVisitor = new VarUsageVisitor(this.subTypeElement, this.workingCopy, this.superTypeElement);
            varUsagesVisitor.scan(this.workingCopy.getCompilationUnit(), varElement);
            return varUsagesVisitor.isReplaceCandidate();
        }

        private boolean isStatic(Element element) {
            Set<Modifier> modifiers = element.getModifiers();
            return modifiers.contains((Object)Modifier.STATIC);
        }

        private void replaceType(MemberSelectTree memSelTree, Element superTypeElement) {
            MemberSelectTree newTree = this.make.MemberSelect((ExpressionTree)this.make.Identifier(superTypeElement), (CharSequence)memSelTree.getIdentifier());
            this.rewrite(memSelTree, newTree);
        }

        private void replaceWithSuperType(VariableTree oldVarTree, Element superTypeElement) {
            TypeMirror supTypeErasure = this.erasureOf(superTypeElement.asType());
            Tree superTypeTree = this.make.Type(supTypeErasure);
            ExpressionTree oldInitTree = oldVarTree.getInitializer();
            ModifiersTree oldModifiers = oldVarTree.getModifiers();
            VariableTree newTree = this.make.Variable(oldModifiers, (CharSequence)oldVarTree.getName(), superTypeTree, oldInitTree);
            this.rewrite(oldVarTree, newTree);
        }

        private Element asElement(Tree tree) {
            Trees treeUtil = this.workingCopy.getTrees();
            TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
            Element element = treeUtil.getElement(treePath);
            return element;
        }

        private TypeMirror erasureOf(TypeMirror type) {
            Types types = this.workingCopy.getTypes();
            return types.erasure(type);
        }
    }

    private final class FindRefTask
    implements CancellableTask<WorkingCopy> {
        private final TreePathHandle subClassHandle;
        private final ElementHandle superClassHandle;

        private FindRefTask(TreePathHandle subClassHandle, ElementHandle superClassHandle) {
            this.subClassHandle = subClassHandle;
            this.superClassHandle = superClassHandle;
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(WorkingCopy compiler) throws Exception {
            try {
                if (compiler.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                    return;
                }
                CompilationUnitTree cu = compiler.getCompilationUnit();
                if (cu == null) {
                    ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                    return;
                }
                Element subClassElement = this.subClassHandle.resolveElement((CompilationInfo)compiler);
                Element superClassElement = this.superClassHandle.resolve((CompilationInfo)compiler);
                if (superClassElement == null) {
                    return;
                }
                assert (subClassElement != null);
                ReferencesVisitor findRefVisitor = new ReferencesVisitor(compiler, subClassElement, superClassElement);
                findRefVisitor.scan(compiler.getCompilationUnit(), subClassElement);
            }
            finally {
                UseSuperTypeRefactoringPlugin.this.fireProgressListenerStep();
            }
        }
    }
}

