/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithBuilderRefactoring;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.java.hints.support.TransformationSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReplaceConstructorWithBuilderPlugin
extends JavaRefactoringPlugin {
    private final ReplaceConstructorWithBuilderRefactoring refactoring;
    private final AtomicBoolean cancel = new AtomicBoolean();
    private TreePathHandle treePathHandle;

    public ReplaceConstructorWithBuilderPlugin(ReplaceConstructorWithBuilderRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        Element constr = this.treePathHandle.resolveElement((CompilationInfo)javac);
        if (constr.getKind() != ElementKind.CONSTRUCTOR) {
            return new Problem(true, Bundle.ERR_ReplaceWrongType());
        }
        Element enclosingElement = constr.getEnclosingElement();
        if (enclosingElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return new Problem(true, Bundle.ERR_ReplaceAbstract());
        }
        if (!enclosingElement.getModifiers().contains((Object)Modifier.STATIC) && enclosingElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return new Problem(true, Bundle.ERR_ReplaceWrongInnerType());
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        String name;
        String builderName = this.refactoring.getBuilderName();
        if (builderName == null || builderName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_NoFactory"));
        }
        if (!SourceVersion.isName(builderName)) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_NotIdentifier", (Object)builderName));
        }
        TreePathHandle constr = this.treePathHandle;
        ClassPath classPath = ClassPath.getClassPath((FileObject)constr.getFileObject(), (String)"classpath/source");
        FileObject resource = classPath.findResource(name = this.refactoring.getBuilderName().replace(".", "/") + ".java");
        if (resource != null) {
            return new Problem(true, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"ERR_FileExists", (Object)name));
        }
        Problem problem = null;
        for (ReplaceConstructorWithBuilderRefactoring.Setter set : this.refactoring.getSetters()) {
            if (!set.isOptional() || set.getDefaultValue() != null) continue;
            problem = JavaPluginUtils.chainProblems(problem, new Problem(false, NbBundle.getMessage(ReplaceConstructorWithBuilderPlugin.class, (String)"WRN_NODEFAULT", (Object)set.getVarName())));
        }
        return problem;
    }

    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        final TreePathHandle constr = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        final String[] ruleCode = new String[1];
        final String[] parentSimpleName = new String[1];
        try {
            ModificationResult mod = JavaSource.forFileObject((FileObject)constr.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                /*
                 * WARNING - void declaration
                 */
                public void run(WorkingCopy workingCopy) throws Exception {
                    void var17_33;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath constrPath = constr.resolve((CompilationInfo)workingCopy);
                    ExecutableElement element = (ExecutableElement)workingCopy.getTrees().getElement(constrPath);
                    MethodTree constructor = (MethodTree)constrPath.getLeaf();
                    TypeElement parent = (TypeElement)workingCopy.getTrees().getElement(constrPath.getParentPath());
                    parentSimpleName[0] = parent.getSimpleName().toString();
                    TreeMaker make = workingCopy.getTreeMaker();
                    StringBuilder parameters = new StringBuilder();
                    StringBuilder constraints = new StringBuilder();
                    StringBuilder realParameters = new StringBuilder();
                    for (int count = 0; count < constructor.getParameters().size(); ++count) {
                        VariableTree vt = constructor.getParameters().get(count);
                        if (count > 0) {
                            parameters.append(", ");
                            constraints.append(" && ");
                            realParameters.append(", ");
                        }
                        realParameters.append(vt.getName());
                        parameters.append("$").append(count + 1);
                        if (count == constructor.getParameters().size() - 1 && element.isVarArgs()) {
                            parameters.append("$");
                            continue;
                        }
                        constraints.append("$").append(count + 1).append(" instanceof ").append(workingCopy.getTrees().getTypeMirror(new TreePath(new TreePath(constrPath, vt), vt.getType())));
                    }
                    ArrayList<Tree> members = new ArrayList<Tree>();
                    String simpleName = ReplaceConstructorWithBuilderPlugin.this.refactoring.getBuilderName().substring(ReplaceConstructorWithBuilderPlugin.this.refactoring.getBuilderName().lastIndexOf(46) + 1);
                    StringBuilder args = null;
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.refactoring.getSetters()) {
                        void var17_21;
                        String type = set.getType();
                        boolean varargs = false;
                        if (type.endsWith("...")) {
                            type = type.substring(0, type.length() - 3);
                            varargs = true;
                        }
                        ExpressionTree expressionTree = make.QualIdent(type);
                        if (varargs) {
                            ExpressionTree expressionTree2 = (ExpressionTree)((Object)make.ArrayType((Tree)expressionTree));
                        }
                        members.add(make.Variable(make.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)set.getVarName(), (Tree)var17_21, set.getDefaultValue() == null ? null : make.Identifier((CharSequence)set.getDefaultValue())));
                        if (args == null) {
                            args = new StringBuilder();
                        } else {
                            args.append(", ");
                        }
                        args.append(set.getVarName());
                    }
                    members.add(make.Constructor(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{}"));
                    for (ReplaceConstructorWithBuilderRefactoring.Setter set : ReplaceConstructorWithBuilderPlugin.this.refactoring.getSetters()) {
                        void var17_27;
                        LinkedList<StatementTree> stmts = new LinkedList<StatementTree>();
                        stmts.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)("this." + set.getVarName())), (ExpressionTree)make.Identifier((CharSequence)set.getVarName()))));
                        stmts.add(make.Return((ExpressionTree)make.Identifier((CharSequence)"this")));
                        BlockTree body = make.Block(stmts, false);
                        String string = set.getType();
                        boolean bl = false;
                        if (string.endsWith("...")) {
                            String string2 = string.substring(0, string.length() - 3);
                            bl = true;
                        }
                        ExpressionTree ident2 = make.QualIdent((String)var17_27);
                        members.add(make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)set.getName(), make.Type(simpleName), Collections.emptyList(), Collections.singletonList(make.Variable(make.Modifiers(Collections.emptySet()), (CharSequence)set.getVarName(), (Tree)ident2, null)), Collections.emptyList(), body, null, bl));
                    }
                    ClassTree parentTree = (ClassTree)constrPath.getParentPath().getLeaf();
                    List<? extends TypeParameterTree> typeParameters = parentTree.getTypeParameters();
                    LinkedList<IdentifierTree> arguments = new LinkedList<IdentifierTree>();
                    for (VariableTree variableTree : constructor.getParameters()) {
                        arguments.add(make.Identifier((CharSequence)variableTree.getName()));
                    }
                    LinkedList<IdentifierTree> typeArguments = new LinkedList<IdentifierTree>();
                    for (TypeParameterTree typeParameterTree : typeParameters) {
                        typeArguments.add(make.Identifier((CharSequence)typeParameterTree.getName()));
                    }
                    ExpressionTree expressionTree = make.QualIdent((Element)parent);
                    if (!typeArguments.isEmpty()) {
                        ExpressionTree expressionTree3 = (ExpressionTree)((Object)make.ParameterizedType((Tree)expressionTree, typeArguments));
                    }
                    BlockTree blockTree = make.Block(Collections.singletonList(make.Return((ExpressionTree)make.NewClass(null, Collections.EMPTY_LIST, (ExpressionTree)var17_33, arguments, null))), false);
                    members.add(make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)("create" + parent.getSimpleName()), make.Type(parent.asType()), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null));
                    ClassTree builder = make.Class(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), (CharSequence)simpleName, typeParameters, null, Collections.EMPTY_LIST, members);
                    FileObject root = ClassPath.getClassPath((FileObject)constr.getFileObject(), (String)"classpath/source").findOwnerRoot(constr.getFileObject());
                    CompilationUnitTree builderUnit = make.CompilationUnit(root, ReplaceConstructorWithBuilderPlugin.this.refactoring.getBuilderName().replace('.', '/') + ".java", Collections.EMPTY_LIST, Collections.singletonList(builder));
                    workingCopy.rewrite(null, (Tree)builderUnit);
                    StringBuilder rule = new StringBuilder();
                    boolean hasTypeParams = !parent.getTypeParameters().isEmpty();
                    rule.append("new ").append(parent.getQualifiedName()).append(hasTypeParams ? "<$modifiers$>(" : "(").append((CharSequence)parameters).append(")");
                    if (constraints.length() > 0) {
                        rule.append(" :: ").append((CharSequence)constraints);
                    }
                    rule.append(";;");
                    ruleCode[0] = rule.toString();
                }
            });
            ArrayList<ModificationResult> results = new ArrayList<ModificationResult>();
            results.add(mod);
            results.addAll(TransformationSupport.create((String)ruleCode[0], (TransformationSupport.Transformer)new TransformationSupport.Transformer(){

                public void transform(WorkingCopy copy, Occurrence occurrence) {
                    TreeMaker make = copy.getTreeMaker();
                    Element element = copy.getTrees().getElement(occurrence.getOccurrenceRoot());
                    ExecutableElement constrElement = (ExecutableElement)constr.resolveElement((CompilationInfo)copy);
                    if (!constrElement.equals(element)) {
                        return;
                    }
                    Collection modifiers = (Collection)occurrence.getMultiVariables().get("$modifiers$");
                    ExpressionTree ident = make.QualIdent(ReplaceConstructorWithBuilderPlugin.this.refactoring.getBuilderName());
                    if (modifiers != null) {
                        LinkedList<Tree> arguments = new LinkedList<Tree>();
                        for (TreePath treePath : modifiers) {
                            arguments.add(treePath.getLeaf());
                        }
                        ident = (ExpressionTree)((Object)make.ParameterizedType((Tree)ident, arguments));
                    }
                    ExpressionTree expression = make.NewClass(null, Collections.EMPTY_LIST, ident, Collections.EMPTY_LIST, null);
                    Map variables = occurrence.getVariables();
                    Map multiVariables = occurrence.getMultiVariables();
                    for (int i = 1; i <= ReplaceConstructorWithBuilderPlugin.this.refactoring.getSetters().size(); ++i) {
                        List arguments;
                        Object value;
                        ReplaceConstructorWithBuilderRefactoring.Setter set = ReplaceConstructorWithBuilderPlugin.this.refactoring.getSetters().get(i - 1);
                        if (variables.containsKey("$" + i)) {
                            value = ((TreePath)variables.get("$" + i)).getLeaf();
                            if (set.isOptional() && ReplaceConstructorWithBuilderPlugin.this.treeEquals(copy, (Tree)value, set.getDefaultValue())) continue;
                            arguments = Collections.singletonList((ExpressionTree)value);
                        } else {
                            value = (Collection)multiVariables.get("$" + i + "$");
                            if (set.isOptional() && ReplaceConstructorWithBuilderPlugin.this.treeEquals(copy, (Collection)value, set.getDefaultValue())) continue;
                            arguments = ReplaceConstructorWithBuilderPlugin.this.createArguments(copy, (Collection)value);
                        }
                        expression = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(expression, (CharSequence)set.getName()), arguments);
                    }
                    MethodInvocationTree create = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(expression, (CharSequence)("create" + parentSimpleName[0])), Collections.emptyList());
                    copy.rewrite(occurrence.getOccurrenceRoot().getLeaf(), (Tree)create);
                }
            }).setCancel(this.cancel).processAllProjects());
            ReplaceConstructorWithBuilderPlugin.createAndAddElements(this.refactoring, refactoringElements, results);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static void createAndAddElements(AbstractRefactoring refactoring, RefactoringElementsBag elements, Collection<ModificationResult> results) {
        elements.registerTransaction(JavaRefactoringPlugin.createTransaction(results));
        for (ModificationResult result : results) {
            for (FileObject jfo : result.getModifiedFileObjects()) {
                for (ModificationResult.Difference diff : result.getDifferences(jfo)) {
                    elements.add(refactoring, (RefactoringElementImplementation)DiffElement.create(diff, jfo, result));
                }
            }
        }
    }

    private boolean treeEquals(WorkingCopy copy, Tree value, String defaultValue) {
        ExpressionTree parseExpression;
        if (defaultValue == null) {
            return false;
        }
        defaultValue = defaultValue.trim();
        if (value instanceof LiteralTree && (parseExpression = copy.getTreeUtilities().parseExpression(defaultValue, new SourcePositions[1])) instanceof LiteralTree) {
            return ((LiteralTree)value).getValue().equals(((LiteralTree)parseExpression).getValue());
        }
        return defaultValue.equals(value.toString());
    }

    private boolean treeEquals(WorkingCopy copy, Collection<? extends TreePath> value, String defaultValue) {
        if (defaultValue == null) {
            return false;
        }
        String[] values = defaultValue.split(",");
        if (values.length != value.size()) {
            return false;
        }
        for (String defValue : values) {
            ExpressionTree parseExpression;
            defValue = defValue.trim();
            boolean parsed = false;
            if (value instanceof LiteralTree && (parsed = (parseExpression = copy.getTreeUtilities().parseExpression(defValue, new SourcePositions[1])) instanceof LiteralTree) && !((LiteralTree)((Object)value)).getValue().equals(((LiteralTree)parseExpression).getValue())) {
                return false;
            }
            if (parsed || defValue.equals(value.toString())) continue;
            return false;
        }
        return true;
    }

    private List<ExpressionTree> createArguments(WorkingCopy copy, Collection<? extends TreePath> value) {
        LinkedList<ExpressionTree> arguments = new LinkedList<ExpressionTree>();
        for (TreePath treePath : value) {
            arguments.add((ExpressionTree)treePath.getLeaf());
        }
        return arguments;
    }

    @Override
    public void cancelRequest() {
        this.cancel.set(true);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
    }
}

