/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

public class RenamePropertyRefactoringPlugin
extends JavaRefactoringPlugin {
    private RenameRefactoring refactoring;
    private TreePathHandle property;
    private RenameRefactoring getterDelegate;
    private RenameRefactoring setterDelegate;
    private RenameRefactoring parameterDelegate;
    private boolean inited = false;

    public RenamePropertyRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        this.property = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.property.getFileObject());
    }

    @Override
    public Problem checkParameters() {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.checkParameters())) != null && p.isFatal()) {
            return p;
        }
        p = JavaPluginUtils.chainProblems(p, super.checkParameters());
        return p;
    }

    @Override
    public Problem fastCheckParameters() {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        if (this.getterDelegate != null) {
            this.getterDelegate.setNewName(RefactoringUtils.getGetterName(this.refactoring.getNewName()));
            p = JavaPluginUtils.chainProblems(p, this.getterDelegate.fastCheckParameters());
            if (p != null && p.isFatal()) {
                return p;
            }
        }
        if (this.setterDelegate != null) {
            this.setterDelegate.setNewName(RefactoringUtils.getSetterName(this.refactoring.getNewName()));
            p = JavaPluginUtils.chainProblems(p, this.setterDelegate.fastCheckParameters());
            if (p != null && p.isFatal()) {
                return p;
            }
        }
        if (this.parameterDelegate != null) {
            this.parameterDelegate.setNewName(this.refactoring.getNewName());
            p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.fastCheckParameters());
            if (p != null && p.isFatal()) {
                return p;
            }
        }
        p = JavaPluginUtils.chainProblems(p, super.fastCheckParameters());
        return p;
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.preCheck())) != null && p.isFatal()) {
            return p;
        }
        p = JavaPluginUtils.chainProblems(p, super.preCheck(javac));
        return p;
    }

    public Problem prepare(RefactoringElementsBag reb) {
        if (!this.isRenameProperty()) {
            return null;
        }
        this.initDelegates();
        this.fireProgressListenerStart(3, 3);
        Problem p = null;
        if (this.getterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.getterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        if (this.setterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.setterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        if (this.parameterDelegate != null && (p = JavaPluginUtils.chainProblems(p, this.parameterDelegate.prepare(reb.getSession()))) != null && p.isFatal()) {
            return p;
        }
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return p;
    }

    private boolean isRenameProperty() {
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        return renameProps != null && renameProps.isIsRenameGettersSetters();
    }

    private void initDelegates() {
        if (this.inited) {
            return;
        }
        try {
            this.getJavaSource(JavaRefactoringPlugin.Phase.PREPARE).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController p) throws Exception {
                    p.toPhase(JavaSource.Phase.RESOLVED);
                    Element propertyElement = RenamePropertyRefactoringPlugin.this.property.resolveElement((CompilationInfo)p);
                    for (ExecutableElement el : ElementFilter.methodsIn(propertyElement.getEnclosingElement().getEnclosedElements())) {
                        if (RefactoringUtils.isGetter((CompilationInfo)p, el, propertyElement)) {
                            RenamePropertyRefactoringPlugin.this.getterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((Element)el, (CompilationInfo)p)));
                            RenamePropertyRefactoringPlugin.this.getterDelegate.setNewName(RefactoringUtils.getGetterName(RenamePropertyRefactoringPlugin.this.refactoring.getNewName()));
                            continue;
                        }
                        if (!RefactoringUtils.isSetter((CompilationInfo)p, el, propertyElement)) continue;
                        RenamePropertyRefactoringPlugin.this.setterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((Element)el, (CompilationInfo)p)));
                        RenamePropertyRefactoringPlugin.this.setterDelegate.setNewName(RefactoringUtils.getSetterName(RenamePropertyRefactoringPlugin.this.refactoring.getNewName()));
                        VariableElement par = el.getParameters().iterator().next();
                        if (!par.getSimpleName().contentEquals(propertyElement.getSimpleName())) continue;
                        RenamePropertyRefactoringPlugin.this.parameterDelegate = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)p.getTrees().getPath(par), (CompilationInfo)p)));
                        RenamePropertyRefactoringPlugin.this.parameterDelegate.setNewName(RenamePropertyRefactoringPlugin.this.refactoring.getNewName());
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.inited = true;
    }
}

