/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;

public class PullUpTransformer
extends RefactoringVisitor {
    private MemberInfo<ElementHandle<? extends Element>>[] members;
    private TypeElement targetType;
    private TypeElement sourceType;
    private PullUpRefactoring refactoring;

    public PullUpTransformer(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
        this.members = refactoring.getMembers();
    }

    @Override
    public void setWorkingCopy(WorkingCopy copy) throws ToPhaseException {
        super.setWorkingCopy(copy);
        this.targetType = (TypeElement)this.refactoring.getTargetType().resolve((CompilationInfo)copy);
        this.sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)copy);
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        Element classElement = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        AtomicBoolean classIsAbstract = new AtomicBoolean(classElement.getKind().isInterface());
        if (((Object)classElement).equals(this.targetType)) {
            this.addMembersToTarget(tree, classIsAbstract, classElement, genUtils);
        } else if (((Object)classElement).equals(this.sourceType)) {
            this.removeMembersFromSource(tree, classIsAbstract);
        }
        return (Tree)super.visitClass(tree, p);
    }

    private void addMembersToTarget(ClassTree tree, AtomicBoolean classIsAbstract, Element classElement, GeneratorUtilities genUtils) {
        ClassTree njuClass = tree;
        for (int i = 0; i < this.members.length; ++i) {
            Element member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            MemberInfo.Group group = this.members[i].getGroup();
            if (group == MemberInfo.Group.IMPLEMENTS) {
                njuClass = this.make.addClassImplementsClause(njuClass, (Tree)this.make.QualIdent(member));
                continue;
            }
            if (this.members[i].isMakeAbstract()) {
                if (classIsAbstract.compareAndSet(false, true)) {
                    this.makeClassAbstract(njuClass);
                }
                njuClass = this.addAbstractMemberToTarget(njuClass, member, classElement, genUtils);
                continue;
            }
            if (member.getModifiers().contains((Object)Modifier.ABSTRACT) && classIsAbstract.compareAndSet(false, true)) {
                this.makeClassAbstract(njuClass);
            }
            njuClass = this.addMemberToTarget(njuClass, member, group, genUtils);
        }
        if (njuClass != tree) {
            this.rewrite(tree, njuClass);
        }
    }

    private void removeMembersFromSource(ClassTree tree, AtomicBoolean classIsAbstract) {
        ClassTree njuClass = tree;
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                for (Tree tree2 : njuClass.getImplementsClause()) {
                    Element currentInterface = this.workingCopy.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree2));
                    if (!((Object)currentInterface).equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                    njuClass = this.make.removeClassImplementsClause(njuClass, tree2);
                    this.rewrite(tree, njuClass);
                }
                continue;
            }
            Element current = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            Element element = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            if (!((Object)element.getEnclosingElement()).equals(current)) continue;
            if (classIsAbstract.get() || !this.members[i].isMakeAbstract() || element.getModifiers().contains((Object)Modifier.ABSTRACT) && this.targetType.getKind().isInterface()) {
                njuClass = this.make.removeClassMember(njuClass, this.workingCopy.getTrees().getTree(element));
                this.rewrite(tree, njuClass);
                continue;
            }
            if (!this.members[i].isMakeAbstract() || !element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            MethodTree method = (MethodTree)this.workingCopy.getTrees().getTree(element);
            ModifiersTree mods = this.make.removeModifiersModifier(method.getModifiers(), Modifier.PRIVATE);
            mods = this.make.addModifiersModifier(mods, this.targetType.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PROTECTED);
            this.rewrite(method.getModifiers(), mods);
        }
    }

    private ClassTree addAbstractMemberToTarget(ClassTree njuClass, Element methodElm, Element classElement, GeneratorUtilities genUtils) {
        MethodTree method = (MethodTree)this.workingCopy.getTrees().getTree(methodElm);
        EnumSet<Modifier> mod = EnumSet.copyOf(method.getModifiers().getFlags());
        mod.add(Modifier.ABSTRACT);
        mod.remove((Object)Modifier.FINAL);
        mod.remove((Object)Modifier.SYNCHRONIZED);
        if (classElement.getKind().isInterface()) {
            mod.remove((Object)Modifier.PUBLIC);
            mod.remove((Object)Modifier.PROTECTED);
            mod.remove((Object)Modifier.PRIVATE);
            mod.remove((Object)Modifier.ABSTRACT);
        }
        if (mod.contains((Object)Modifier.PRIVATE)) {
            mod.remove((Object)Modifier.PRIVATE);
            mod.add(Modifier.PROTECTED);
        }
        MethodTree newMethod = this.make.Method(this.make.Modifiers(mod), (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameters(), method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
        newMethod = (MethodTree)genUtils.importFQNs((Tree)newMethod);
        method = (MethodTree)genUtils.importComments((Tree)method, this.workingCopy.getTrees().getPath(methodElm).getCompilationUnit());
        genUtils.copyComments((Tree)method, (Tree)newMethod, false);
        genUtils.copyComments((Tree)method, (Tree)newMethod, true);
        njuClass = genUtils.insertClassMember(njuClass, (Tree)newMethod);
        return njuClass;
    }

    private void makeClassAbstract(ClassTree njuClass) {
        EnumSet<Modifier> mod = EnumSet.copyOf(njuClass.getModifiers().getFlags());
        mod.add(Modifier.ABSTRACT);
        mod.remove((Object)Modifier.FINAL);
        ModifiersTree modifiers = this.make.Modifiers(mod);
        this.rewrite(njuClass.getModifiers(), modifiers);
    }

    private ClassTree addMemberToTarget(ClassTree njuClass, Element member, MemberInfo.Group group, GeneratorUtilities genUtils) {
        TreePath mpath = this.workingCopy.getTrees().getPath(member);
        Tree memberTree = genUtils.importComments(mpath.getLeaf(), mpath.getCompilationUnit());
        memberTree = genUtils.importFQNs(memberTree);
        memberTree = this.fixGenericTypes(memberTree, mpath, member);
        if (member.getModifiers().contains((Object)Modifier.PRIVATE)) {
            Tree newMemberTree = null;
            if (group == MemberInfo.Group.METHOD) {
                MethodTree oldOne = (MethodTree)memberTree;
                BlockTree body = this.updateSuperThisReferences(oldOne.getBody(), mpath);
                newMemberTree = this.make.Method(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), body, (ExpressionTree)oldOne.getDefaultValue());
            } else if (group == MemberInfo.Group.FIELD) {
                VariableTree oldOne = (VariableTree)memberTree;
                newMemberTree = this.make.Variable(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getType(), oldOne.getInitializer());
            } else if (group == MemberInfo.Group.TYPE) {
                ClassTree oldOne = (ClassTree)memberTree;
                switch (member.getKind()) {
                    case CLASS: {
                        newMemberTree = this.make.Class(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getExtendsClause(), oldOne.getImplementsClause(), oldOne.getMembers());
                        break;
                    }
                    case INTERFACE: {
                        newMemberTree = this.make.Interface(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getTypeParameters(), oldOne.getImplementsClause(), oldOne.getMembers());
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        newMemberTree = this.make.AnnotationType(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getMembers());
                        break;
                    }
                    case ENUM: {
                        newMemberTree = this.make.Enum(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getSimpleName(), oldOne.getImplementsClause(), oldOne.getMembers());
                    }
                }
            }
            if (newMemberTree != null) {
                genUtils.copyComments(memberTree, newMemberTree, false);
                genUtils.copyComments(memberTree, newMemberTree, true);
                njuClass = genUtils.insertClassMember(njuClass, newMemberTree);
            }
        } else if (group == MemberInfo.Group.METHOD) {
            MethodTree oldOne = (MethodTree)memberTree;
            BlockTree body = this.updateSuperThisReferences(oldOne.getBody(), mpath);
            MethodTree newMemberTree = this.make.Method(oldOne.getModifiers(), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), body, (ExpressionTree)oldOne.getDefaultValue());
            genUtils.copyComments(memberTree, (Tree)newMemberTree, false);
            genUtils.copyComments(memberTree, (Tree)newMemberTree, true);
            njuClass = genUtils.insertClassMember(njuClass, (Tree)newMemberTree);
        } else {
            njuClass = genUtils.insertClassMember(njuClass, memberTree);
        }
        return njuClass;
    }

    private <E extends Tree> E fixGenericTypes(E tree, final TreePath path, final Element member) {
        final HashMap<TypeMirror, TypeParameterElement> mappings = new HashMap<TypeMirror, TypeParameterElement>();
        DeclaredType declaredType = (DeclaredType)this.sourceType.asType();
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            DeclaredType currentElement = declaredType;
            this.deepSearchTypes(currentElement, typeMirror, typeMirror, mappings);
        }
        final Types types = this.workingCopy.getTypes();
        final HashMap hashMap = new HashMap();
        TreeScanner<Void, Void> scanner = new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                TypeParameterElement parameterElement;
                Element genericElement;
                Element typeElement;
                Element element = PullUpTransformer.this.workingCopy.getTrees().getElement(new TreePath(path, node));
                if (element != null && element.getKind() == ElementKind.TYPE_PARAMETER && (typeElement = types.asElement(element.asType())) != null && typeElement.getKind() == ElementKind.TYPE_PARAMETER && (genericElement = (parameterElement = (TypeParameterElement)typeElement).getGenericElement()) != member) {
                    List<? extends TypeMirror> bounds;
                    TypeParameterElement target = (TypeParameterElement)mappings.get(parameterElement.asType());
                    Tree type = target != null ? PullUpTransformer.this.make.Type(target.asType()) : ((bounds = parameterElement.getBounds()).isEmpty() ? PullUpTransformer.this.make.Type("Object") : PullUpTransformer.this.make.Type(bounds.get(0)));
                    hashMap.put(node, type);
                }
                return (Void)super.visitIdentifier(node, p);
            }
        };
        scanner.scan(tree, null);
        Tree result = this.workingCopy.getTreeUtilities().translate(tree, hashMap);
        return (E)result;
    }

    private BlockTree updateSuperThisReferences(BlockTree body, final TreePath mpath) {
        boolean update;
        final HashMap original2Translated = new HashMap();
        final Trees trees = this.workingCopy.getTrees();
        TreeScanner<Boolean, Void> idScan = new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitMemberSelect(MemberSelectTree node, Void nothing) {
                TreePath currentPath;
                Element el;
                String isThis = node.getExpression().toString();
                if ((isThis.equals("super") || isThis.endsWith(".super")) && ((Object)(el = trees.getElement(currentPath = new TreePath(mpath, node))).getEnclosingElement()).equals(PullUpTransformer.this.targetType)) {
                    original2Translated.put(node, PullUpTransformer.this.make.Identifier((CharSequence)node.getIdentifier()));
                    return Boolean.TRUE;
                }
                return (Boolean)super.visitMemberSelect(node, nothing);
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        };
        boolean bl = update = idScan.scan(body, null) == Boolean.TRUE;
        if (update) {
            body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)body, original2Translated);
        }
        return body;
    }

    private boolean deepSearchTypes(DeclaredType currentElement, TypeMirror orig, TypeMirror something, Map<TypeMirror, TypeParameterElement> mappings) {
        Types types = this.workingCopy.getTypes();
        List<? extends TypeMirror> directSupertypes = types.directSupertypes(currentElement);
        for (TypeMirror typeMirror : directSupertypes) {
            DeclaredType type = (DeclaredType)typeMirror;
            List<? extends TypeMirror> typeArguments = type.getTypeArguments();
            for (int i = 0; i < typeArguments.size(); ++i) {
                TypeMirror typeArgument = typeArguments.get(i);
                if (!((Object)something).equals(typeArgument)) continue;
                TypeElement asElement = (TypeElement)type.asElement();
                mappings.put(orig, asElement.getTypeParameters().get(i));
                if (((Object)types.erasure(this.targetType.asType())).equals(types.erasure(typeMirror))) {
                    return true;
                }
                if (this.deepSearchTypes(type, orig, typeArgument, mappings)) break;
            }
            if (!((Object)types.erasure(this.targetType.asType())).equals(types.erasure(typeMirror))) continue;
            mappings.remove(orig);
            return true;
        }
        return false;
    }
}

