/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.ui.FiltersDescription;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin
implements FiltersDescription.Provider {
    private boolean fromLibrary;
    private WhereUsedQuery refactoring;
    private ClasspathInfo cp;
    private volatile CancellableTask queryTask;
    private EnumSet<JavaWhereUsedFilters.ReadWrite> usedAccessFilters = EnumSet.noneOf(JavaWhereUsedFilters.ReadWrite.class);
    private LinkedList<String> usedFilters = new LinkedList();

    public JavaWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject());
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        TreePathHandle handle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (!handle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        if (handle.getKind() == Tree.Kind.ARRAY_TYPE) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_FindUsagesArrayType"));
        }
        return null;
    }

    @Override
    protected ClasspathInfo getClasspathInfo(AbstractRefactoring refactoring) {
        Collection handles = refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        ClasspathInfo cpInfo = !handles.isEmpty() ? RefactoringUtils.getClasspathInfoFor(handles.toArray(new TreePathHandle[handles.size()])) : JavaRefactoringUtils.getClasspathInfoFor(new FileObject[]{null});
        refactoring.getContext().add((Object)cpInfo);
        return cpInfo;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle tph) {
        Scope customScope;
        this.cp = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        boolean bl = this.fromLibrary = tph.getFileObject() == null || tph.getFileObject().getNameExt().endsWith("class");
        if (this.isSearchFromBaseClass()) {
            TreePathHandle sourceHandle = (TreePathHandle)this.refactoring.getContext().lookup(TreePathHandle.class);
            this.cp = this.fromLibrary && sourceHandle != null ? RefactoringUtils.getClasspathInfoFor(sourceHandle, tph) : RefactoringUtils.getClasspathInfoFor(tph);
        }
        if ((customScope = (Scope)this.refactoring.getContext().lookup(Scope.class)) != null) {
            ClasspathInfo cpath;
            TreeSet<FileObject> fileSet = new TreeSet<FileObject>(new FileComparator());
            fileSet.addAll(customScope.getFiles());
            FileObject fo = null;
            if (this.fromLibrary && (fo = RefactoringUtils.getFileObject(tph)) == null) {
                fo = tph.getFileObject();
            }
            if (!customScope.getSourceRoots().isEmpty()) {
                if (this.isSearchFromBaseClass() && fo != null) {
                    HashSet<FileObject> fileobjects = new HashSet<FileObject>(customScope.getSourceRoots());
                    fileobjects.add(fo);
                    cpath = RefactoringUtils.getClasspathInfoFor(false, fileobjects.toArray(new FileObject[0]));
                } else {
                    cpath = RefactoringUtils.getClasspathInfoFor(false, customScope.getSourceRoots().toArray(new FileObject[0]));
                }
                fileSet.addAll(JavaWhereUsedQueryPlugin.getRelevantFiles(tph, cpath, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), null, this.cancelRequested));
            }
            HashMap<FileObject, HashSet<NonRecursiveFolder>> folders = new HashMap<FileObject, HashSet<NonRecursiveFolder>>();
            for (NonRecursiveFolder nonRecursiveFolder : customScope.getFolders()) {
                FileObject folder = nonRecursiveFolder.getFolder();
                ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
                FileObject sourceRoot = classPath.findOwnerRoot(folder);
                HashSet<NonRecursiveFolder> packages = (HashSet<NonRecursiveFolder>)folders.get(sourceRoot);
                if (packages == null) {
                    packages = new HashSet<NonRecursiveFolder>();
                    folders.put(sourceRoot, packages);
                }
                packages.add(nonRecursiveFolder);
            }
            for (FileObject sourceRoot : folders.keySet()) {
                Set packages = (Set)folders.get(sourceRoot);
                if (packages == null || packages.isEmpty()) continue;
                cpath = this.isSearchFromBaseClass() && fo != null ? RefactoringUtils.getClasspathInfoFor(false, sourceRoot, fo) : RefactoringUtils.getClasspathInfoFor(false, sourceRoot);
                fileSet.addAll(JavaWhereUsedQueryPlugin.getRelevantFiles(tph, cpath, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), packages, this.cancelRequested));
            }
            return fileSet;
        }
        Set<FileObject> fileSet = JavaWhereUsedQueryPlugin.getRelevantFiles(tph, this.cp, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages(), null, this.cancelRequested);
        return fileSet;
    }

    public static Set<FileObject> getRelevantFiles(final TreePathHandle tph, final ClasspathInfo cpInfo, final boolean isFindSubclasses, final boolean isFindDirectSubclassesOnly, final boolean isFindOverridingMethods, final boolean isFindUsages, Set<NonRecursiveFolder> folders, final AtomicBoolean cancel) {
        final ClassIndex idx = cpInfo.getClassIndex();
        final TreeSet<FileObject> set = new TreeSet<FileObject>(new FileComparator());
        final Set<Object> packages = folders == null ? Collections.emptySet() : folders;
        FileObject file = tph.getFileObject();
        JavaSource source = JavaPluginUtils.createSource(file, cpInfo, tph);
        if (cancel != null && cancel.get()) {
            return Collections.emptySet();
        }
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element el = tph.resolveElement((CompilationInfo)info);
                if (el == null) {
                    throw new NullPointerException(String.format("#145291: Cannot resolve handle: %s\n%s", tph, info.getClasspathInfo()));
                }
                HashSet<Object> searchScopeType = new HashSet<Object>(1);
                if (packages.isEmpty()) {
                    searchScopeType.add(ClassIndex.SearchScope.SOURCE);
                } else {
                    final HashSet<String> packageSet = new HashSet<String>(packages.size());
                    for (NonRecursiveFolder nonRecursiveFolder : packages) {
                        String resourceName = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(nonRecursiveFolder.getFolder());
                        packageSet.add(resourceName.replace('/', '.'));
                    }
                    searchScopeType.add(new ClassIndex.SearchScopeType(){

                        public Set<? extends String> getPackages() {
                            return packageSet;
                        }

                        public boolean isSources() {
                            return true;
                        }

                        public boolean isDependencies() {
                            return false;
                        }
                    });
                }
                if (cancel != null && cancel.get()) {
                    set.clear();
                    return;
                }
                if (el.getKind().isField()) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), searchScopeType));
                } else if (el.getKind().isClass() || el.getKind().isInterface()) {
                    if (isFindSubclasses || isFindDirectSubclassesOnly) {
                        if (isFindDirectSubclassesOnly) {
                            EnumSet<ClassIndex.SearchKind> searchKind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), searchKind, searchScopeType));
                        } else {
                            set.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(idx, cpInfo, (TypeElement)el, cancel));
                        }
                    } else {
                        set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType));
                    }
                } else if (el.getKind() == ElementKind.METHOD && isFindOverridingMethods) {
                    TypeElement type = (TypeElement)el.getEnclosingElement();
                    set.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(idx, cpInfo, type, cancel));
                }
                if (el.getKind() == ElementKind.METHOD && isFindUsages) {
                    Set<ElementHandle<TypeElement>> s = RefactoringUtils.getImplementorsAsHandles(idx, cpInfo, (TypeElement)el.getEnclosingElement(), cancel);
                    for (ElementHandle elementHandle : s) {
                        if (cancel != null && cancel.get()) {
                            set.clear();
                            return;
                        }
                        TypeElement te = (TypeElement)elementHandle.resolve((CompilationInfo)info);
                        if (te == null) continue;
                        for (Element element : te.getEnclosedElements()) {
                            if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !info.getElements().overrides((ExecutableElement)element, (ExecutableElement)el, te)) continue;
                            set.addAll(idx.getResources(ElementHandle.create((Element)te), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType));
                        }
                    }
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType));
                } else if (el.getKind() == ElementKind.CONSTRUCTOR) {
                    set.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType));
                }
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        HashSet<FileObject> set2 = new HashSet<FileObject>(set.size());
        ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        for (FileObject fo : set) {
            if (cp.contains(fo)) {
                set2.add(fo);
            }
            if (cancel == null || !cancel.get()) continue;
            return Collections.emptySet();
        }
        return set;
    }

    private static Collection<FileObject> getImplementorsRecursive(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el, AtomicBoolean cancel) {
        Set<ElementHandle<? extends Element>> implementorsAsHandles = RefactoringUtils.getImplementorsAsHandles(idx, cpInfo, el, cancel);
        if (cancel != null && cancel.get()) {
            return Collections.emptySet();
        }
        Collection<FileObject> set = SourceUtilsEx.getFiles(implementorsAsHandles, cpInfo, cancel);
        ClassPath source = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> set2 = new ArrayList<FileObject>(set.size());
        for (FileObject fo : set) {
            if (source.contains(fo)) {
                set2.add(fo);
            }
            if (cancel == null || !cancel.get()) continue;
            return Collections.emptySet();
        }
        return set2;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        this.fireProgressListenerStart(1, -1);
        Set<FileObject> a = this.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class));
        this.fireProgressListenerStep(a.size());
        Problem problem = null;
        try {
            FindTask findTask = new FindTask(elements);
            this.queryFiles(a, findTask);
        }
        catch (IOException e) {
            problem = this.createProblemAndLog(null, e);
        }
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public void cancelRequest() {
        super.cancelRequest();
        CancellableTask t = this.queryTask;
        if (t != null) {
            t.cancel();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        if (((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Object obj = dob.getLookup().lookup(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getLookup().lookup(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    public void addFilters(FiltersDescription filtersDescription) {
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.READ.getKey(), "Read filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_read.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.WRITE.getKey(), "Write filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_write.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.READ_WRITE.getKey(), "Read/Write filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_readwrite.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.IMPORT.getKey(), "Import filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_import.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.COMMENT.getKey(), "Comment filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_comment.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.TESTFILE.getKey(), "Test filter", true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_test.png", (boolean)false));
    }

    public void enableFilters(FiltersDescription filtersDescription) {
        for (JavaWhereUsedFilters.ReadWrite filter : this.usedAccessFilters) {
            filtersDescription.enable(filter.getKey());
        }
        for (String string : this.usedFilters) {
            filtersDescription.enable(string);
        }
    }

    private static class FileComparator
    implements Comparator<FileObject> {
        private FileComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private class FindTask
    implements CancellableTask<CompilationController> {
        private RefactoringElementsBag elements;
        private volatile AtomicBoolean cancelled;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
            this.cancelled = new AtomicBoolean(false);
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        public void run(CompilationController compiler) throws IOException {
            if (this.cancelled.get()) {
                return;
            }
            if (compiler.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            TreePathHandle handle = (TreePathHandle)JavaWhereUsedQueryPlugin.this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            Element element = handle.resolveElement((CompilationInfo)compiler);
            if (element == null) {
                ErrorManager.getDefault().log(65536, "element is null for handle " + handle);
                return;
            }
            boolean fromTestRoot = RefactoringUtils.isFromTestRoot(compiler.getFileObject(), compiler.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE));
            AtomicBoolean inImport = new AtomicBoolean();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                FindUsagesVisitor findVisitor = new FindUsagesVisitor(compiler, this.cancelled, JavaWhereUsedQueryPlugin.this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS"), fromTestRoot, inImport);
                findVisitor.scan(compiler.getCompilationUnit(), element);
                Collection<WhereUsedElement> foundElements = findVisitor.getElements();
                for (WhereUsedElement el : foundElements) {
                    JavaWhereUsedFilters.ReadWrite access = el.getAccess();
                    if (access != null) {
                        JavaWhereUsedQueryPlugin.this.usedAccessFilters.add(access);
                    }
                    this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)el);
                }
                if (fromTestRoot && !foundElements.isEmpty()) {
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.TESTFILE.getKey());
                }
                if (!foundElements.isEmpty() && findVisitor.usagesInComments()) {
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.COMMENT.getKey());
                }
            }
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                FindOverridingVisitor override = new FindOverridingVisitor(compiler);
                override.scan(compiler.getCompilationUnit(), element);
                result.addAll(override.getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                FindSubtypesVisitor subtypes = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), compiler);
                subtypes.scan(compiler.getCompilationUnit(), element);
                result.addAll(subtypes.getUsages());
            }
            for (TreePath tree : result) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)compiler, tree, fromTestRoot, inImport));
            }
            if (fromTestRoot && !result.isEmpty()) {
                JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.TESTFILE.getKey());
            }
            if (inImport.get()) {
                JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.IMPORT.getKey());
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }
    }
}

