/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Iterator;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.refactoring.java.plugins.OperatorPrecedence;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;

public class InlineVariableTransformer
extends RefactoringVisitor {
    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        this.replaceUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        this.replaceUsageIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    private void replaceUsageIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element el = this.workingCopy.getTrees().getElement(path);
        if (el == null) {
            if ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)path.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id == null || id.contentEquals("*")) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                path = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(path);
                if (el == null) {
                    return;
                }
                Iterator iter = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return ((Object)id).equals(e.getSimpleName());
                    }
                }).iterator();
                if (iter.hasNext()) {
                    el = (Element)iter.next();
                }
                if (iter.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (((Object)el).equals(elementToFind)) {
            ExpressionTree body = ((VariableTree)trees.getTree(elementToFind)).getInitializer();
            boolean parenthesize = OperatorPrecedence.needsParentheses(path, elementToFind, ((VariableTree)trees.getTree(elementToFind)).getInitializer(), this.workingCopy);
            if (parenthesize) {
                body = this.make.Parenthesized(body);
            }
            this.rewrite(tree, body);
        }
    }

    @Override
    public Tree visitVariable(VariableTree node, Element p) {
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)p).equals(el)) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            switch (el.getKind()) {
                case LOCAL_VARIABLE: {
                    Tree newOne = null;
                    newOne = parent.getKind() == Tree.Kind.CASE ? this.make.removeCaseStatement((CaseTree)parent, (StatementTree)node) : this.make.removeBlockStatement((BlockTree)parent, (StatementTree)node);
                    if (newOne == null) break;
                    this.rewrite(parent, newOne);
                    break;
                }
                case FIELD: {
                    ClassTree removeClassMember = this.make.removeClassMember((ClassTree)parent, (Tree)node);
                    if (removeClassMember == null) break;
                    this.rewrite(parent, removeClassMember);
                }
            }
        }
        return (Tree)super.visitVariable(node, p);
    }
}

