/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class FindUsagesVisitor
extends TreePathScanner<Tree, Element> {
    private Collection<TreePath> usages = new ArrayList<TreePath>();
    private List<WhereUsedElement> elements = new ArrayList<WhereUsedElement>();
    protected CompilationController workingCopy;
    private boolean findInComments = false;
    private final boolean fromTestRoot;
    private final AtomicBoolean inImport;
    private Boolean usagesInComments;
    private final AtomicBoolean isCancelled;

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled) {
        this(workingCopy, isCancelled, false);
    }

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled, boolean findInComments) {
        this(workingCopy, isCancelled, findInComments, RefactoringUtils.isFromTestRoot(workingCopy.getFileObject(), workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE)), new AtomicBoolean());
    }

    public FindUsagesVisitor(CompilationController workingCopy, AtomicBoolean isCancelled, boolean findInComments, boolean fromTestRoot, AtomicBoolean inImport) {
        try {
            this.setWorkingCopy(workingCopy);
        }
        catch (ToPhaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.findInComments = findInComments;
        this.fromTestRoot = fromTestRoot;
        this.inImport = inImport;
        this.isCancelled = isCancelled;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        if (this.findInComments) {
            String originalName = p.getSimpleName().toString();
            TokenSequence ts = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            while (ts.moveNext()) {
                if (this.isCancelled.get()) {
                    return null;
                }
                Token t = ts.token();
                if (t.id() != JavaTokenId.BLOCK_COMMENT && t.id() != JavaTokenId.LINE_COMMENT && t.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                Scanner tokenizer = new Scanner(((Object)t.text()).toString());
                tokenizer.useDelimiter("[^a-zA-Z0-9_]");
                while (tokenizer.hasNext()) {
                    String current = tokenizer.next();
                    if (!current.equals(originalName)) continue;
                    WhereUsedElement comment = WhereUsedElement.create(ts.offset() + tokenizer.match().start(), ts.offset() + tokenizer.match().end(), (CompilationInfo)this.workingCopy, this.fromTestRoot);
                    this.elements.add(comment);
                    this.usagesInComments = true;
                }
            }
        }
        return (Tree)super.visitCompilationUnit(node, p);
    }

    private void addIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.isCancelled.get()) {
            return;
        }
        if (this.workingCopy.getTreeUtilities().isSynthetic(path) && (ElementKind.CONSTRUCTOR != elementToFind.getKind() || tree.getKind() != Tree.Kind.IDENTIFIER || !"super".contentEquals(((IdentifierTree)tree).getName()))) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element el = trees.getElement(path);
        if (el == null) {
            if ((path = path.getParentPath()) != null && path.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree impTree = (ImportTree)path.getLeaf();
                if (!impTree.isStatic()) {
                    return;
                }
                Tree idTree = impTree.getQualifiedIdentifier();
                if (idTree.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name id = ((MemberSelectTree)idTree).getIdentifier();
                if (id.contentEquals("*")) {
                    return;
                }
                ExpressionTree classTree = ((MemberSelectTree)idTree).getExpression();
                path = trees.getPath(this.workingCopy.getCompilationUnit(), classTree);
                el = trees.getElement(path);
                if (el == null) {
                    return;
                }
                Iterator iter = this.workingCopy.getElementUtilities().getMembers(el.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        return ((Object)id).equals(e.getSimpleName());
                    }
                }).iterator();
                if (iter.hasNext()) {
                    el = (Element)iter.next();
                }
                if (iter.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (elementToFind != null && elementToFind.getKind() == ElementKind.METHOD && el.getKind() == ElementKind.METHOD) {
            if (((Object)el).equals(elementToFind) || this.workingCopy.getElements().overrides((ExecutableElement)el, (ExecutableElement)elementToFind, (TypeElement)elementToFind.getEnclosingElement())) {
                this.addUsage(path);
            }
        } else if (((Object)el).equals(elementToFind)) {
            ElementKind kind = elementToFind.getKind();
            if (kind.isField() || kind == ElementKind.LOCAL_VARIABLE || kind == ElementKind.RESOURCE_VARIABLE) {
                JavaWhereUsedFilters.ReadWrite access = JavaWhereUsedFilters.ReadWrite.READ;
                TreePath parentPath = path.getParentPath();
                Tree parentTree = parentPath.getLeaf();
                Tree.Kind parentKind = parentTree.getKind();
                switch (parentKind) {
                    case ARRAY_ACCESS: 
                    case MEMBER_SELECT: {
                        break;
                    }
                    case POSTFIX_INCREMENT: 
                    case POSTFIX_DECREMENT: 
                    case PREFIX_INCREMENT: 
                    case PREFIX_DECREMENT: {
                        access = JavaWhereUsedFilters.ReadWrite.READ_WRITE;
                        break;
                    }
                    case ASSIGNMENT: {
                        AssignmentTree assignmentTree = (AssignmentTree)parentTree;
                        ExpressionTree left = assignmentTree.getVariable();
                        if (!left.equals(tree)) break;
                        access = JavaWhereUsedFilters.ReadWrite.WRITE;
                        break;
                    }
                    case MULTIPLY_ASSIGNMENT: 
                    case DIVIDE_ASSIGNMENT: 
                    case REMAINDER_ASSIGNMENT: 
                    case PLUS_ASSIGNMENT: 
                    case MINUS_ASSIGNMENT: 
                    case LEFT_SHIFT_ASSIGNMENT: 
                    case RIGHT_SHIFT_ASSIGNMENT: 
                    case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                    case AND_ASSIGNMENT: 
                    case XOR_ASSIGNMENT: 
                    case OR_ASSIGNMENT: {
                        CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)parentTree;
                        ExpressionTree left = compoundAssignmentTree.getVariable();
                        if (!left.equals(tree)) break;
                        access = JavaWhereUsedFilters.ReadWrite.READ_WRITE;
                        break;
                    }
                }
                this.addUsage(path, access);
            } else {
                this.addUsage(path);
            }
        }
    }

    public final void setWorkingCopy(CompilationController workingCopy) throws ToPhaseException {
        this.workingCopy = workingCopy;
        try {
            if (this.workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                throw new ToPhaseException();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    protected void addUsage(TreePath tp, JavaWhereUsedFilters.ReadWrite access) {
        assert (tp != null);
        this.elements.add(WhereUsedElement.create((CompilationInfo)this.workingCopy, tp, access, this.fromTestRoot, this.inImport));
        this.usages.add(tp);
    }

    public boolean isInImport() {
        return this.inImport.get();
    }

    protected void addUsage(TreePath tp) {
        assert (tp != null);
        this.elements.add(WhereUsedElement.create((CompilationInfo)this.workingCopy, tp, this.fromTestRoot, this.inImport));
        this.usages.add(tp);
    }

    public Collection<WhereUsedElement> getElements() {
        if (this.findInComments) {
            Collections.sort(this.elements, new Comparator<WhereUsedElement>(){

                @Override
                public int compare(WhereUsedElement o1, WhereUsedElement o2) {
                    return o1.getPosition().getBegin().getOffset() - o2.getPosition().getBegin().getOffset();
                }
            });
        }
        return this.elements;
    }

    public Collection<TreePath> getUsages() {
        return this.usages;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitIdentifier(node, p);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        this.addIfMatch(this.getCurrentPath(), node, p);
        return (Tree)super.visitMemberSelect(node, p);
    }

    @Override
    public Tree visitNewClass(NewClassTree node, Element p) {
        if (this.isCancelled.get()) {
            return null;
        }
        Trees trees = this.workingCopy.getTrees();
        ClassTree classTree = node.getClassBody();
        if (classTree != null && p.getKind() == ElementKind.CONSTRUCTOR) {
            Element anonClass = this.workingCopy.getTrees().getElement(TreePath.getPath(this.workingCopy.getCompilationUnit(), (Tree)classTree));
            if (anonClass == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").log(Level.SEVERE, "FindUsages cannot resolve {0}", classTree);
            } else {
                for (ExecutableElement c : ElementFilter.constructorsIn(anonClass.getEnclosedElements())) {
                    MethodTree t = this.workingCopy.getTrees().getTree(c);
                    TreePath superCall = trees.getPath(this.workingCopy.getCompilationUnit(), ((ExpressionStatementTree)t.getBody().getStatements().get(0)).getExpression());
                    Element superCallElement = trees.getElement(superCall);
                    if (superCallElement == null || !((Object)superCallElement).equals(p) || this.workingCopy.getTreeUtilities().isSynthetic(superCall)) continue;
                    this.addUsage(superCall);
                }
            }
        } else {
            this.addIfMatch(this.getCurrentPath(), node, p);
        }
        return (Tree)super.visitNewClass(node, p);
    }

    public boolean usagesInComments() {
        return Boolean.TRUE == this.usagesInComments;
    }
}

