/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;

public class ChangeParamsJavaDocTransformer
extends RefactoringVisitor {
    private static final int NOPOS = -2;
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private boolean synthConstructor;
    private Boolean constructorRefactoring;
    private final ChangeParametersRefactoring.ParameterInfo[] paramInfos;
    private String returnType;
    private boolean compatible;
    private final ChangeParametersPanel.Javadoc javaDoc;
    private final TreePathHandle refactoringSource;
    private MethodTree origMethod;
    private Problem problem;

    public ChangeParamsJavaDocTransformer(ChangeParametersRefactoring.ParameterInfo[] paramInfo, String returnType, boolean compatible, ChangeParametersPanel.Javadoc javaDoc, Set<ElementHandle<ExecutableElement>> am, TreePathHandle refactoringSource) {
        this.paramInfos = paramInfo;
        this.returnType = returnType;
        this.compatible = compatible;
        this.javaDoc = javaDoc;
        this.allMethods = am;
        this.refactoringSource = refactoringSource;
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        if (this.origMethod == null && workingCopy.getFileObject().equals(this.refactoringSource.getFileObject())) {
            TreePath resolvedPath = this.refactoringSource.resolve((CompilationInfo)workingCopy);
            TreePath meth = JavaPluginUtils.findMethod(resolvedPath);
            this.origMethod = (MethodTree)meth.getLeaf();
        }
    }

    private void init() {
        if (this.constructorRefactoring == null) {
            Element el;
            ElementHandle<ExecutableElement> handle = this.allMethods.iterator().next();
            this.constructorRefactoring = handle.getKind() == ElementKind.CONSTRUCTOR;
            this.synthConstructor = this.constructorRefactoring != false && (el = handle.resolve((CompilationInfo)this.workingCopy)) != null && this.workingCopy.getElementUtilities().isSynthetic(el);
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.init();
        return (Tree)super.visitCompilationUnit(node, p);
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> currentArguments, boolean passThrough, ExecutableElement method) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            ExpressionTree vt;
            int originalIndex = pi[i].getOriginalIndex();
            if (originalIndex < 0) {
                String value;
                SourcePositions[] pos = new SourcePositions[1];
                if (passThrough) {
                    value = pi[i].getName();
                    vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
                } else {
                    value = pi[i].getDefaultValue();
                    if (i == pi.length - 1 && pi[i].getType().endsWith("...")) {
                        MethodInvocationTree parsedExpression = (MethodInvocationTree)this.workingCopy.getTreeUtilities().parseExpression("method(" + value + ")", pos);
                        for (ExpressionTree expressionTree : parsedExpression.getArguments()) {
                            arguments.add(this.translateExpression(expressionTree, currentArguments, method));
                        }
                        break;
                    }
                    vt = this.translateExpression(this.workingCopy.getTreeUtilities().parseExpression(value, pos), currentArguments, method);
                }
            } else {
                if (i == pi.length - 1 && pi[i].getType().endsWith("...") && method.isVarArgs() && method.getParameters().size() - 1 == originalIndex) {
                    for (int j = originalIndex; j < currentArguments.size(); ++j) {
                        arguments.add(currentArguments.get(j));
                    }
                    break;
                }
                vt = currentArguments.get(originalIndex);
            }
            arguments.add(vt);
        }
        return arguments;
    }

    @Override
    public Tree visitMethod(MethodTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && this.isSyntheticConstructorOfAnnonymousClass(this.workingCopy.getTrees().getElement(this.getCurrentPath()))) {
            return tree;
        }
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, p);
    }

    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        if (this.javaDoc != null) {
            GeneratorUtilities genutils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
            Element el = this.workingCopy.getTrees().getElement(path);
            if (this.isMethodMatch(el, elementToFind)) {
                MethodTree current = (MethodTree)genutils.importComments((Tree)((MethodTree)tree), this.workingCopy.getCompilationUnit());
                List<? extends VariableTree> currentParameters = current.getParameters();
                ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>(this.paramInfos.length);
                ChangeParametersRefactoring.ParameterInfo[] p = this.paramInfos;
                for (int i = 0; i < p.length; ++i) {
                    VariableTree vt;
                    int originalIndex = p[i].getOriginalIndex();
                    if (originalIndex < 0) {
                        boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                        vt = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)p[i].getName(), (Tree)this.make.Identifier((CharSequence)(isVarArgs ? p[i].getType().replace("...", "") : p[i].getType())), null);
                    } else {
                        String newType;
                        VariableTree originalVt = currentParameters.get(originalIndex);
                        boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                        String string = newType = isVarArgs ? p[i].getType().replace("...", "") : p[i].getType();
                        Tree typeTree = this.origMethod != null ? (p[i].getType().equals(this.origMethod.getParameters().get(originalIndex).getType().toString()) ? originalVt.getType() : this.make.Identifier((CharSequence)newType)) : this.make.Identifier((CharSequence)newType);
                        vt = this.make.Variable(originalVt.getModifiers(), (CharSequence)originalVt.getName(), typeTree, originalVt.getInitializer());
                    }
                    newParameters.add(vt);
                }
                MethodTree copy = this.make.Method(current.getModifiers(), (CharSequence)current.getName(), current.getReturnType(), current.getTypeParameters(), current.getParameters(), current.getThrows(), current.getBody(), (ExpressionTree)current.getDefaultValue());
                genutils.copyComments((Tree)current, (Tree)copy, true);
                genutils.copyComments((Tree)current, (Tree)copy, false);
                Comment comment = null;
                switch (this.javaDoc) {
                    case UPDATE: {
                        comment = ChangeParamsJavaDocTransformer.updateJavadoc((ExecutableElement)el, this.paramInfos, this.workingCopy);
                        List comments = this.workingCopy.getTreeUtilities().getComments((Tree)copy, true);
                        if (comments.isEmpty()) {
                            comment = null;
                            break;
                        }
                        if (((Comment)comments.get(0)).isDocComment()) {
                            this.make.removeComment((Tree)copy, 0, true);
                            break;
                        }
                        comment = null;
                        break;
                    }
                    case GENERATE: {
                        String returnTypeString;
                        Tree returnType = copy.getReturnType();
                        if (this.returnType == null) {
                            boolean hasReturn = false;
                            if (returnType != null && returnType.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && !((PrimitiveTypeTree)returnType).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
                                hasReturn = true;
                            }
                            returnTypeString = hasReturn ? returnType.toString() : null;
                        } else {
                            returnTypeString = this.returnType.equals("void") ? null : this.returnType;
                        }
                        comment = ChangeParamsJavaDocTransformer.generateJavadoc(newParameters, returnTypeString, current);
                    }
                }
                if (comment != null) {
                    this.make.addComment((Tree)copy, comment, true);
                }
                this.rewrite(current, copy);
            }
        }
    }

    static Comment updateJavadoc(ExecutableElement method, ChangeParametersRefactoring.ParameterInfo[] parameters, WorkingCopy workingCopy) {
        Doc javadoc = workingCopy.getElementUtilities().javaDocFor((Element)method);
        List<? extends VariableElement> origParams = method.getParameters();
        LinkedList<Tag> paramTags = new LinkedList<Tag>();
        LinkedList<Tag> otherTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags()));
        LinkedList<Tag> returnTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@return")));
        LinkedList<Tag> throwsTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@throws")));
        LinkedList<Tag> oldParamTags = new LinkedList<Tag>(Arrays.asList(javadoc.tags("@param")));
        otherTags.removeAll(returnTags);
        otherTags.removeAll(throwsTags);
        otherTags.removeAll(oldParamTags);
        block0: for (ChangeParametersRefactoring.ParameterInfo parameter : parameters) {
            if (parameter.getOriginalIndex() == -1) {
                ParamTagImpl newTag = new ParamTagImpl(parameter.getName(), "the value of " + parameter.getName(), javadoc);
                paramTags.add((Tag)newTag);
                continue;
            }
            VariableElement origVar = origParams.get(parameter.getOriginalIndex());
            for (Tag tag : oldParamTags) {
                ParamTag paramTag = (ParamTag)tag;
                if (!origVar.getSimpleName().toString().equals(paramTag.parameterName())) continue;
                paramTags.add((Tag)ChangeParamsJavaDocTransformer.updateTag(paramTag, paramTag.parameterName(), parameter.getName()));
                continue block0;
            }
        }
        StringBuilder text = new StringBuilder(javadoc.commentText()).append("\n\n");
        text.append(ChangeParamsJavaDocTransformer.tagsToString(paramTags));
        text.append(ChangeParamsJavaDocTransformer.tagsToString(returnTags));
        text.append(ChangeParamsJavaDocTransformer.tagsToString(throwsTags));
        text.append(ChangeParamsJavaDocTransformer.tagsToString(otherTags));
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)text.toString());
        return comment;
    }

    static Comment generateJavadoc(List<VariableTree> newParameters, String returnType, MethodTree current) {
        StringBuilder builder = new StringBuilder("\n");
        for (VariableTree variableTree : newParameters) {
            builder.append(String.format("@param %s the value of %s", variableTree.getName(), variableTree.getName()));
            builder.append("\n");
        }
        if (returnType != null) {
            builder.append("@return the ").append(returnType).append("\n");
        }
        for (ExpressionTree expressionTree : current.getThrows()) {
            builder.append("@throws ").append(expressionTree).append("\n");
        }
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)builder.toString());
        return comment;
    }

    private boolean isMethodMatch(Element method, Element p) {
        if (this.compatible) {
            return (method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR) && method == p;
        }
        if ((method.getKind() == ElementKind.METHOD || method.getKind() == ElementKind.CONSTRUCTOR) && this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + mh);
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntheticConstructorOfAnnonymousClass(Element el) {
        if (el != null && el.getKind() == ElementKind.CONSTRUCTOR && this.workingCopy.getElementUtilities().isSynthetic(el)) {
            Element enclosingElement = el.getEnclosingElement();
            return enclosingElement != null && enclosingElement.getKind().isClass() && ((TypeElement)enclosingElement).getNestingKind() == NestingKind.ANONYMOUS;
        }
        return false;
    }

    static String tagsToString(List<Tag> tags) {
        StringBuilder sb = new StringBuilder();
        for (Tag tag : tags) {
            sb.append(tag.name()).append(" ").append(tag.text()).append("\n");
        }
        return sb.toString();
    }

    private ExpressionTree translateExpression(ExpressionTree expressionTree, final List<? extends ExpressionTree> currentArguments, ExecutableElement p) {
        final HashMap original2Translated = new HashMap();
        boolean changed = false;
        do {
            original2Translated.clear();
            TreeScanner<Void, Void> idScan = new TreeScanner<Void, Void>(){

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    String name = node.getName().toString();
                    if (ChangeParamsJavaDocTransformer.this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                        for (int i = 0; i < ChangeParamsJavaDocTransformer.this.paramInfos.length; ++i) {
                            ChangeParametersRefactoring.ParameterInfo parameterInfo = ChangeParamsJavaDocTransformer.this.paramInfos[i];
                            if (parameterInfo.getOriginalIndex() < 0 || !parameterInfo.getName().equals(name)) continue;
                            original2Translated.put(node, currentArguments.get(parameterInfo.getOriginalIndex()));
                        }
                    }
                    return (Void)super.visitIdentifier(node, p);
                }
            };
            idScan.scan(expressionTree, null);
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
            original2Translated.clear();
            TreeScanner<Boolean, ExecutableElement> methodScanner = new TreeScanner<Boolean, ExecutableElement>(){

                @Override
                public Boolean visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                    Element el;
                    boolean changed = false;
                    TreePath path = ChangeParamsJavaDocTransformer.this.workingCopy.getTrees().getPath(ChangeParamsJavaDocTransformer.this.workingCopy.getCompilationUnit(), node);
                    if (path != null && (el = ChangeParamsJavaDocTransformer.this.workingCopy.getTrees().getElement(path)) != null && ChangeParamsJavaDocTransformer.this.isMethodMatch(el, p)) {
                        List arguments = ChangeParamsJavaDocTransformer.this.getNewArguments(node.getArguments(), false, p);
                        MethodInvocationTree nju = ChangeParamsJavaDocTransformer.this.make.MethodInvocation(node.getTypeArguments(), node.getMethodSelect(), arguments);
                        original2Translated.put(node, nju);
                        changed = true;
                    }
                    return (Boolean)super.visitMethodInvocation(node, p) != false || changed;
                }

                @Override
                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }
            };
            boolean bl = changed = methodScanner.scan(expressionTree, p) == Boolean.TRUE;
            if (!changed) continue;
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
        } while (changed);
        return expressionTree;
    }

    private static ParamTag updateTag(ParamTag tag, String oldName, String newName) {
        if (oldName.contentEquals(newName)) {
            return tag;
        }
        String comment = tag.parameterComment().replaceAll("\\b" + oldName + "\\b", newName);
        return new ParamTagImpl(newName, comment, tag.holder());
    }

    private static class ParamTagImpl
    implements ParamTag {
        private final String name;
        private final String comment;
        private final Doc holder;

        public ParamTagImpl(String name, String comment, Doc holder) {
            this.name = name;
            this.comment = comment;
            this.holder = holder;
        }

        public String parameterName() {
            return this.name;
        }

        public String parameterComment() {
            return this.comment;
        }

        public boolean isTypeParameter() {
            return false;
        }

        public String name() {
            return "@param";
        }

        public Doc holder() {
            return this.holder;
        }

        public String kind() {
            return this.name();
        }

        public String text() {
            return this.parameterName() + " " + this.parameterComment();
        }

        public Tag[] inlineTags() {
            return null;
        }

        public Tag[] firstSentenceTags() {
            return null;
        }

        public SourcePosition position() {
            return null;
        }
    }
}

