/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.callhierarchy.CallDescriptor;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.netbeans.modules.refactoring.java.callhierarchy.CallOccurrence;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

final class Call
implements CallDescriptor {
    private static final String TYPE_COLOR = "#707070";
    private List<Call> references;
    private List<CallOccurrence> occurrences;
    CallHierarchyModel model;
    private String displayName;
    private String htmlDisplayName;
    private Icon icon;
    TreePathHandle selection;
    TreePathHandle declaration;
    private TreePathHandle overridden;
    private ElementHandle identity;
    private Call parent;
    private boolean leaf;
    private boolean canceled = false;
    private State state;

    private Call() {
    }

    public List<Call> getReferences() {
        return this.references != null ? this.references : Collections.emptyList();
    }

    void setReferences(List<Call> references) {
        this.references = references;
    }

    public List<CallOccurrence> getOccurrences() {
        return this.occurrences;
    }

    CallHierarchyModel getModel() {
        return this.model;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isCanceled() {
        return this.state == State.CANCELED;
    }

    void setCanceled(boolean canceled) {
        if (canceled) {
            this.state = State.CANCELED;
        }
    }

    void setIncomplete(boolean state) {
        if (state) {
            this.state = State.INCOMPLETE;
        }
    }

    public boolean isIncomplete() {
        return this.state == State.INCOMPLETE;
    }

    void setBroken() {
        this.state = State.BROKEN;
    }

    public boolean isBroken() {
        return this.state == State.BROKEN;
    }

    TreePathHandle getSourceToQuery() {
        return this.overridden != null ? this.overridden : (this.declaration != null ? this.declaration : this.selection);
    }

    @Override
    public void open() {
        if (this.occurrences != null && !this.occurrences.isEmpty()) {
            this.occurrences.get(0).open();
        }
    }

    public static Call createEmpty() {
        Call c = new Call();
        c.setIncomplete(true);
        return c;
    }

    public static Call createRoot(CompilationInfo javac, TreePath selection, Element selectionElm, boolean isCallerGraph) {
        List<TreePath> occurrences = Arrays.asList(selection);
        return Call.createReference(javac, selection, selectionElm, null, isCallerGraph, occurrences);
    }

    public static Call createUsage(CompilationInfo javac, TreePath selection, Element selectionElm, Call parent, List<TreePath> occurrences) {
        return Call.createReference(javac, selection, selectionElm, parent, parent.model.getType() == CallHierarchyModel.HierarchyType.CALLER, occurrences);
    }

    private static Call createReference(CompilationInfo javac, TreePath selection, Element selectionElm, Call parent, boolean isCallerGraph, List<TreePath> occurrences) {
        TreePath declarationPath;
        Collection<ExecutableElement> overridenMethods;
        Call c = new Call();
        if (selectionElm.getKind() == ElementKind.INSTANCE_INIT || selectionElm.getKind() == ElementKind.STATIC_INIT) {
            c.displayName = "<init>";
            c.identity = null;
        } else {
            c.displayName = ElementHeaders.getHeader((Element)selectionElm, (CompilationInfo)javac, (String)"%name%");
            c.identity = ElementHandle.create((Element)selectionElm);
        }
        c.htmlDisplayName = Call.createHtmlHeader(selectionElm, occurrences.size(), javac);
        Icon i = ElementIcons.getElementIcon((ElementKind)selectionElm.getKind(), selectionElm.getModifiers());
        c.icon = isCallerGraph ? (parent != null ? ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)i), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/up.png"), (int)0, (int)0)) : i) : ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.icon2Image((Icon)i), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/down.png"), (int)0, (int)0));
        c.selection = TreePathHandle.create((TreePath)selection, (CompilationInfo)javac);
        c.parent = parent;
        if (parent != null) {
            c.model = parent.model;
        }
        Element wanted = javac.getTrees().getElement(selection);
        if (isCallerGraph && wanted != null && wanted.getKind() == ElementKind.METHOD && !(overridenMethods = JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)wanted, javac)).isEmpty()) {
            ExecutableElement next = overridenMethods.iterator().next();
            c.overridden = TreePathHandle.create((Element)next, (CompilationInfo)javac);
            c.identity = ElementHandle.create((Element)next);
        }
        if (wanted != null && (declarationPath = javac.getTrees().getPath(wanted)) != null) {
            c.declaration = TreePathHandle.create((TreePath)declarationPath, (CompilationInfo)javac);
        }
        if (c.identity != null) {
            boolean[] recursion = new boolean[]{false};
            c.leaf = Call.isLeaf(selectionElm, c.identity, parent, isCallerGraph, recursion);
            if (recursion[0]) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/java/resources/recursion_badge.png");
                Image icon2Image = ImageUtilities.icon2Image((Icon)c.icon);
                Image badgedImage = ImageUtilities.mergeImages((Image)icon2Image, (Image)badge, (int)8, (int)8);
                c.icon = ImageUtilities.image2Icon((Image)badgedImage);
            }
        } else {
            c.leaf = true;
        }
        c.occurrences = new ArrayList<CallOccurrence>(occurrences.size());
        for (TreePath occurrence : occurrences) {
            c.occurrences.add(CallOccurrence.createOccurrence(javac, occurrence, parent));
        }
        return c;
    }

    public String toString() {
        return String.format("name='%s', handle='%s', refs='%s'", this.displayName, this.selection, this.references);
    }

    private static boolean isLeaf(Element elm, ElementHandle handle, Call parent, boolean isCallerGraph, boolean[] recursion) {
        ElementKind kind = elm.getKind();
        recursion[0] = false;
        if (kind != ElementKind.METHOD && kind != ElementKind.CONSTRUCTOR) {
            return true;
        }
        if (!isCallerGraph && elm.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        while (parent != null) {
            if (handle.equals((Object)parent.identity)) {
                recursion[0] = true;
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    private static String createHtmlHeader(Element e, int occurrences, CompilationInfo javac) {
        String member;
        switch (e.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                member = Call.createHtmlHeader((ExecutableElement)e, javac);
                break;
            }
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                member = NbBundle.getMessage(Call.class, (String)"Call.staticInitializerHtmlHeader");
                break;
            }
            default: {
                member = ElementHeaders.getHeader((Element)e, (CompilationInfo)javac, (String)"%name%");
            }
        }
        String encloser = String.format("<font color=%s>%s</font>", TYPE_COLOR, javac.getElements().getBinaryName((TypeElement)e.getEnclosingElement()).toString());
        return NbBundle.getMessage(Call.class, (String)"Call.htmlHeader", (Object)member, (Object)encloser, (Object)occurrences);
    }

    private static String createHtmlHeader(ExecutableElement e, CompilationInfo javac) {
        boolean isDeprecated = javac.getElements().isDeprecated(e);
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            sb.append(e.getEnclosingElement().getSimpleName());
        } else {
            sb.append(e.getSimpleName());
        }
        if (isDeprecated) {
            sb.append("</s>");
        }
        sb.append("(");
        for (VariableElement variableElement : e.getParameters()) {
            sb.append("<font color=#707070>");
            sb.append(Call.print(variableElement.asType()));
            sb.append("</font>");
            sb.append(" ");
            sb.append(variableElement.getSimpleName());
            sb.append(", ");
        }
        if (sb.charAt(sb.length() - 1) == '(') {
            sb.append(")");
        } else {
            sb.replace(sb.length() - 2, sb.length(), ")");
        }
        return sb.toString();
    }

    private static String print(TypeMirror tm) {
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                StringBuilder sb = new StringBuilder(dt.asElement().getSimpleName().toString());
                List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                if (!typeArgs.isEmpty()) {
                    sb.append("&lt;");
                    Iterator<? extends TypeMirror> it = typeArgs.iterator();
                    while (it.hasNext()) {
                        TypeMirror ta = it.next();
                        sb.append(Call.print(ta));
                        if (!it.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("&gt;");
                }
                return sb.toString();
            }
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)tm;
                StringBuilder sb = new StringBuilder(tv.asElement().getSimpleName().toString());
                return sb.toString();
            }
            case ARRAY: {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(Call.print(at.getComponentType()));
                sb.append("[]");
                return sb.toString();
            }
            case WILDCARD: {
                WildcardType wt = (WildcardType)tm;
                StringBuilder sb = new StringBuilder("?");
                if (wt.getExtendsBound() != null) {
                    sb.append(" extends ");
                    sb.append(Call.print(wt.getExtendsBound()));
                }
                if (wt.getSuperBound() != null) {
                    sb.append(" super ");
                    sb.append(Call.print(wt.getSuperBound()));
                }
                return sb.toString();
            }
        }
        return ((Object)tm).toString();
    }

    static boolean doOpen(FileObject fo, PositionBounds bounds) {
        try {
            final int begin = bounds.getBegin().getOffset();
            final int end = bounds.getEnd().getOffset();
            DataObject od = DataObject.find((FileObject)fo);
            final EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
            boolean opened = NbDocument.openDocument((Lookup.Provider)od, (int)begin, (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
            if (opened) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane textC = NbDocument.findRecentEditorPane((EditorCookie)ec);
                        if (textC != null) {
                            textC.setSelectionStart(begin);
                            textC.setSelectionEnd(end);
                        }
                    }
                });
                return true;
            }
            return opened;
        }
        catch (DataObjectNotFoundException e) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Call.class, (String)"Call.open.warning", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
            return false;
        }
    }

    private static enum State {
        CANCELED,
        BROKEN,
        INCOMPLETE;

    }
}

