/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class SourceUtilsEx {
    public static FileObject getFile(Element element, ClasspathInfo cpInfo, Cache cache) {
        String fqn;
        Element prev;
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        Parameters.notNull((CharSequence)"cache", (Object)cache);
        Element current = element;
        Element element2 = prev = current.getKind() == ElementKind.PACKAGE ? current : null;
        while (current.getKind() != ElementKind.PACKAGE) {
            prev = current;
            current = current.getEnclosingElement();
        }
        if (prev == null) {
            return null;
        }
        ElementKind kind = prev.getKind();
        if (kind.isClass() || kind.isInterface()) {
            fqn = ((TypeElement)prev).getQualifiedName().toString();
        } else if (kind == ElementKind.PACKAGE) {
            fqn = ((PackageElement)prev).getQualifiedName().toString();
        } else {
            return null;
        }
        Object cached = cache.cacheOfSrcFiles.get(fqn);
        if (cached == null) {
            ElementHandle handle = ElementHandle.create((Element)prev);
            cached = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)cpInfo);
            cache.cacheOfSrcFiles.put(fqn, cached != null ? cached : Cache.NULL);
        } else if (cached == Cache.NULL) {
            cached = null;
        }
        return (FileObject)cached;
    }

    public static Collection<FileObject> getFiles(Collection<ElementHandle<? extends Element>> handles, ClasspathInfo cpInfo, AtomicBoolean cancel) {
        Parameters.notNull((CharSequence)"handle", handles);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        ArrayList<FileObject> result = new ArrayList<FileObject>(handles.size());
        HashMap<String, ArrayList<ResolvedElementHandle>> handlesPerPackages = new HashMap<String, ArrayList<ResolvedElementHandle>>();
        try {
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), SourceUtilsEx.createClassPath(cpInfo, ClasspathInfo.PathKind.BOOT), SourceUtilsEx.createClassPath(cpInfo, ClasspathInfo.PathKind.COMPILE)});
            for (ElementHandle<? extends Element> elementHandle : handles) {
                if (cancel != null && cancel.get()) {
                    return Collections.emptySet();
                }
                ResolvedElementHandle resolvedEHandle = ResolvedElementHandle.create(elementHandle);
                ArrayList<ResolvedElementHandle> l = (ArrayList<ResolvedElementHandle>)handlesPerPackages.get(resolvedEHandle.pkgName);
                if (l == null) {
                    l = new ArrayList<ResolvedElementHandle>();
                    handlesPerPackages.put(resolvedEHandle.pkgName, l);
                }
                l.add(resolvedEHandle);
            }
            for (Map.Entry entry : handlesPerPackages.entrySet()) {
                SourceUtilsEx.searchFiles((String)entry.getKey(), (List)entry.getValue(), cp, result);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return result;
    }

    private static void searchFiles(String pkgName, List<ResolvedElementHandle> handles, ClassPath cp, List<FileObject> result) throws IOException {
        List fos = cp.findAllResources(pkgName);
        for (FileObject fo : fos) {
            FileObject root = cp.findOwnerRoot(fo);
            assert (root != null);
            FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots();
            ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
            LinkedList<FileObject> folders = new LinkedList<FileObject>(sourcePath.findAllResources(pkgName));
            Iterator<ResolvedElementHandle> it = handles.iterator();
            while (it.hasNext()) {
                ResolvedElementHandle handle = it.next();
                if (!handle.pkg) continue;
                result.add(folders.isEmpty() ? fo : (FileObject)folders.get(0));
                it.remove();
                break;
            }
            if (handles.isEmpty()) {
                return;
            }
            boolean caseSensitive = SourceUtilsEx.isCaseSensitive();
            folders.addFirst(fo);
            for (FileObject folder : folders) {
                FileObject[] children;
                for (FileObject child : children = folder.getChildren()) {
                    SourceUtilsEx.searchChildren(child, handles, result, caseSensitive);
                    if (!handles.isEmpty()) continue;
                    return;
                }
            }
            Iterator<ResolvedElementHandle> it2 = handles.iterator();
            while (it2.hasNext()) {
                ResolvedElementHandle handle = it2.next();
                FileObject foundFo = sourceRoots.length == 0 ? SourceUtilsEx.findSource(handle.signature[0], root) : SourceUtilsEx.findSource(handle.signature[0], sourceRoots);
                if (foundFo == null) continue;
                it2.remove();
                result.add(foundFo);
            }
        }
    }

    private static void searchChildren(FileObject child, List<ResolvedElementHandle> handles, List<FileObject> result, boolean caseSensitive) {
        Iterator<ResolvedElementHandle> it = handles.iterator();
        while (it.hasNext()) {
            ResolvedElementHandle handle = it.next();
            if ((!caseSensitive || !child.getName().equals(handle.getSourceFileName())) && (caseSensitive || !child.getName().equalsIgnoreCase(handle.getSourceFileName())) || !child.isData() || !"java".equalsIgnoreCase(child.getExt())) continue;
            it.remove();
            result.add(child);
        }
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String classFileName) {
        int index = classFileName.indexOf(36);
        return index == -1 ? classFileName : classFileName.substring(0, index);
    }

    private static String[] getElementHandleSignature(ElementHandle handle) {
        try {
            Method method = ElementHandle.class.getDeclaredMethod("getSignature", new Class[0]);
            method.setAccessible(true);
            return (String[])method.invoke((Object)handle, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static ClassPath createClassPath(ClasspathInfo cpInfo, ClasspathInfo.PathKind kind) {
        try {
            Method method = SourceUtils.class.getDeclaredMethod("createClassPath", ClasspathInfo.class, ClasspathInfo.PathKind.class);
            method.setAccessible(true);
            return (ClassPath)method.invoke(null, cpInfo, kind);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static FileObject findSource(String binaryName, FileObject ... fos) throws IOException {
        try {
            Method method = SourceUtils.class.getDeclaredMethod("findSource", String.class, FileObject[].class);
            method.setAccessible(true);
            return (FileObject)method.invoke(null, binaryName, fos);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IllegalStateException(ex);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String convertPackage2Folder(String packageName) {
        return packageName.replace('.', '/');
    }

    private static final class ResolvedElementHandle {
        String pkgName;
        String className;
        String[] signature;
        boolean pkg;
        private String sourceFileName;

        private ResolvedElementHandle() {
        }

        static ResolvedElementHandle create(ElementHandle<? extends Element> handle) {
            ResolvedElementHandle reh = new ResolvedElementHandle();
            reh.pkg = handle.getKind() == ElementKind.PACKAGE;
            reh.signature = SourceUtilsEx.getElementHandleSignature(handle);
            assert (reh.signature.length >= 1);
            if (reh.pkg) {
                reh.pkgName = SourceUtilsEx.convertPackage2Folder(reh.signature[0]);
            } else {
                int index = reh.signature[0].lastIndexOf(46);
                if (index < 0) {
                    reh.pkgName = "";
                    reh.className = reh.signature[0];
                } else {
                    reh.pkgName = SourceUtilsEx.convertPackage2Folder(reh.signature[0].substring(0, index));
                    reh.className = reh.signature[0].substring(index + 1);
                }
            }
            return reh;
        }

        public String getSourceFileName() {
            if (this.sourceFileName == null) {
                this.sourceFileName = SourceUtilsEx.getSourceFileName(this.className);
            }
            return this.sourceFileName;
        }
    }

    public static final class Cache {
        private static final Object NULL = new Object();
        private final Map<String, Object> cacheOfSrcFiles = new HashMap<String, Object>();
    }
}

