/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.folding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.text.folding.TokenElement;
import org.netbeans.modules.xml.text.folding.XmlFoldTypes;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.util.NbBundle;

public class XmlFoldManager
implements FoldManager {
    private FoldOperation operation;
    private long dirtyTimeMillis = 0L;
    private Timer timer;
    private TimerTask timerTask;
    public static final int DELAY_SYNCER = 2000;
    public static final int DELAY_DIRTY = 1000;
    private Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/xml").lookup(Preferences.class);

    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        XmlFoldManager xmlFoldManager = this;
        synchronized (xmlFoldManager) {
            this.releaseTimerTask();
            this.timer = null;
        }
    }

    protected FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        this.scheduleFoldUpdate();
    }

    private BaseDocument getDocument() {
        return (BaseDocument)this.getOperation().getHierarchy().getComponent().getDocument();
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.scheduleFoldUpdate();
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.scheduleFoldUpdate();
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.scheduleFoldUpdate();
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    private synchronized void scheduleFoldUpdate() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.dirtyTimeMillis = System.currentTimeMillis();
        this.releaseTimerTask();
        this.timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long delay;
                XmlFoldManager xmlFoldManager = XmlFoldManager.this;
                synchronized (xmlFoldManager) {
                    if (XmlFoldManager.this.timerTask != this) {
                        return;
                    }
                    delay = XmlFoldManager.this.dirtyIntervalMillis();
                }
                if (delay > 1000L) {
                    XmlFoldManager.this.updateFolds();
                    XmlFoldManager.this.unsetDirty();
                }
            }
        };
        this.timer.schedule(this.timerTask, 2000L);
    }

    private synchronized void releaseTimerTask() {
        if (this.timerTask == null) {
            return;
        }
        this.timerTask.cancel();
        this.timerTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetDirty() {
        XmlFoldManager xmlFoldManager = this;
        synchronized (xmlFoldManager) {
            this.dirtyTimeMillis = 0L;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    private long dirtyIntervalMillis() {
        if (this.dirtyTimeMillis == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.dirtyTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFolds() {
        FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
        BaseDocument d = this.getDocument();
        d.readLock();
        try {
            foldHierarchy.lock();
            try {
                FoldHierarchyTransaction fht = this.getOperation().openTransaction();
                try {
                    ArrayList<Fold> existingFolds = new ArrayList<Fold>();
                    this.collectExistingFolds(foldHierarchy.getRootFold(), existingFolds);
                    for (Fold f : existingFolds) {
                        this.getOperation().removeFromHierarchy(f, fht);
                    }
                    this.createFolds(fht);
                    return;
                }
                catch (Exception ex) {
                    return;
                }
                finally {
                    fht.commit();
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
        finally {
            d.readUnlock();
        }
    }

    private void printFoldHierarchy(Fold fold, String tab) {
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.printFoldHierarchy(fold.getFold(i), tab + "==");
        }
    }

    private void collectExistingFolds(Fold fold, List<Fold> list) {
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.collectExistingFolds(fold.getFold(i), list);
        }
        if (!FoldUtilities.isRootFold((Fold)fold) && this.getOperation().owns(fold)) {
            list.add(fold);
        }
    }

    private Fold createFold(FoldType type, String description, boolean collapsed, int startOffset, int endOffset, FoldHierarchyTransaction transaction) throws BadLocationException {
        Fold fold = null;
        if (startOffset >= 0 && endOffset >= 0 && startOffset < endOffset && endOffset <= this.getDocument().getLength()) {
            fold = this.getOperation().addToHierarchy(type, description.intern(), collapsed, startOffset, endOffset, description.length(), 0, null, transaction);
        }
        return fold;
    }

    private void createFolds(FoldHierarchyTransaction fhTran) throws BadLocationException, IOException {
        BaseDocument basedoc = this.getDocument();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)basedoc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        Token token = tokenSequence.token();
        if (token != null && token.id() == XMLTokenId.TEXT && tokenSequence.moveNext()) {
            token = tokenSequence.token();
        }
        int currentTokensSize = 0;
        Stack<TokenElement> stack = new Stack<TokenElement>();
        String currentNode = null;
        while (tokenSequence.moveNext()) {
            token = tokenSequence.token();
            XMLTokenId tokenId = (XMLTokenId)token.id();
            String image = ((Object)token.text()).toString();
            TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_WHITESPACE;
            switch (tokenId) {
                case TAG: {
                    int len = image.length();
                    if (image.charAt(len - 1) == '>') {
                        int eo;
                        int so;
                        TokenElement tokenElem = null;
                        if (len == 2) {
                            if (!stack.empty()) {
                                stack.pop();
                            }
                        } else if (!stack.empty() && ((TokenElement)stack.peek()).getName().equals(currentNode)) {
                            tokenElem = (TokenElement)stack.pop();
                        }
                        if (tokenElem == null || this.isOneLiner(so = tokenElem.getStartOffset(), eo = currentTokensSize + image.length())) break;
                        String foldName = "<" + currentNode + ">";
                        boolean collapseByDefault = this.prefs.getBoolean("code-folding-collapse-tags", false);
                        Fold f = this.createFold(XmlFoldTypes.TAG, foldName, collapseByDefault, so, eo, fhTran);
                        currentNode = null;
                        break;
                    }
                    tokenType = TokenElement.TokenType.TOKEN_ELEMENT_START_TAG;
                    if (image.startsWith("</")) {
                        String tagName;
                        currentNode = tagName = image.substring(2);
                        break;
                    }
                    String tagName = image.substring(1);
                    stack.push(new TokenElement(tokenType, tagName, currentTokensSize, currentTokensSize + image.length(), -1));
                    break;
                }
                case BLOCK_COMMENT: {
                    tokenType = TokenElement.TokenType.TOKEN_COMMENT;
                    if (image.startsWith(TokenElement.Token.COMMENT_START.getValue()) && image.endsWith(TokenElement.Token.COMMENT_END.getValue())) break;
                    if (image.startsWith(TokenElement.Token.COMMENT_START.getValue())) {
                        String foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_COMMENT");
                        stack.push(new TokenElement(tokenType, foldName, currentTokensSize, currentTokensSize + image.length(), -1));
                        break;
                    }
                    if (!image.endsWith(TokenElement.Token.COMMENT_END.getValue())) break;
                    TokenElement tokenElem = (TokenElement)stack.pop();
                    int so = tokenElem.getStartOffset();
                    int eo = currentTokensSize + image.length();
                    boolean collapseByDefault = this.prefs.getBoolean("code-folding-collapse-javadoc", false);
                    Fold f = this.createFold(XmlFoldTypes.COMMENT, tokenElem.getName(), collapseByDefault, so, eo, fhTran);
                    break;
                }
                case CDATA_SECTION: {
                    tokenType = TokenElement.TokenType.TOKEN_CDATA_VAL;
                    if (image.startsWith(TokenElement.Token.CDATA_START.getValue()) && image.endsWith(TokenElement.Token.CDATA_END.getValue())) break;
                    if (image.startsWith(TokenElement.Token.CDATA_START.getValue())) {
                        String foldName = NbBundle.getMessage(XmlFoldManager.class, (String)"LBL_CDATA");
                        stack.push(new TokenElement(tokenType, foldName, currentTokensSize, currentTokensSize + image.length(), -1));
                        break;
                    }
                    if (!image.endsWith(TokenElement.Token.CDATA_END.getValue())) break;
                    TokenElement tokenElem = (TokenElement)stack.pop();
                    int so = tokenElem.getStartOffset();
                    int eo = currentTokensSize + image.length();
                    Fold f = this.createFold(XmlFoldTypes.CDATA, tokenElem.getName(), false, so, eo, fhTran);
                    break;
                }
                case PI_START: 
                case PI_TARGET: 
                case PI_CONTENT: 
                case PI_END: 
                case ARGUMENT: 
                case VALUE: 
                case TEXT: 
                case CHARACTER: 
                case WS: 
                case OPERATOR: 
                case DECLARATION: {
                    break;
                }
            }
            currentTokensSize += image.length();
        }
    }

    public boolean isOneLiner(int start, int end) {
        try {
            BaseDocument doc = this.getDocument();
            return Utilities.getLineOffset((BaseDocument)doc, (int)start) == Utilities.getLineOffset((BaseDocument)doc, (int)end);
        }
        catch (BadLocationException ex) {
            return false;
        }
    }
}

