/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.modules.profiler.categorization.api.Bundle;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.CategoryContainer;

public abstract class Categorization
implements Marker {
    private Map<Category, Set<Mark>> inheritedMarkMap = null;
    private Map<Mark, Category> reverseMap;
    private CategoryContainer root = null;

    public synchronized void reset() {
        this.root = null;
        this.inheritedMarkMap = null;
        this.reverseMap = null;
    }

    public Category getCategoryForMark(Mark mark) {
        return this.getReverseMap().get(mark);
    }

    public Set<Mark> getAllMarks(Category category) {
        Set<Mark> marks = this.getInheritedMap().get(category);
        return marks != null ? Collections.unmodifiableSet(marks) : Collections.EMPTY_SET;
    }

    public Mark[] getMarks() {
        return this.getAllMarks(this.getRoot()).toArray(new Mark[0]);
    }

    public abstract boolean isAvailable();

    protected abstract void buildCategories(CategoryContainer var1);

    private synchronized Map<Category, Set<Mark>> getInheritedMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.inheritedMarkMap;
    }

    public final synchronized Category getRoot() {
        if (this.root == null) {
            this.root = new CategoryContainer("ROOT", Bundle.ROOT_CATEGORY_NAME(), Mark.DEFAULT);
            this.buildCategories(this.root);
        }
        return this.root;
    }

    private synchronized Map<Mark, Category> getReverseMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.reverseMap;
    }

    private void initInternals() {
        this.inheritedMarkMap = new HashMap<Category, Set<Mark>>();
        this.reverseMap = new WeakHashMap<Mark, Category>();
        ArrayDeque<Category> path = new ArrayDeque<Category>();
        path.add(this.getRoot());
        this.initInternals(path);
    }

    private void initInternals(Deque<Category> path) {
        Category currentCategory = path.peek();
        this.reverseMap.put(currentCategory.getAssignedMark(), currentCategory);
        for (Category category : path) {
            Set<Mark> marks = this.inheritedMarkMap.get(category);
            if (marks == null) {
                marks = new HashSet<Mark>();
                this.inheritedMarkMap.put(category, marks);
            }
            marks.add(currentCategory.getAssignedMark());
        }
        for (Category child : currentCategory.getSubcategories()) {
            path.push(child);
            this.initInternals(path);
            path.pop();
        }
    }
}

