/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.zip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.zip.Bundle;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ImportZIP
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(ImportZIP.class);
    private static final Logger LOG = Logger.getLogger(ImportZIP.class.getName());
    private JButton folderButton;
    private JTextField folderField;
    private JLabel folderLabel;
    private JButton zipButton;
    private JTextField zipField;
    private JLabel zipLabel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackAndOpen(File zip, File root) throws IOException {
        final AtomicBoolean canceled = new AtomicBoolean();
        ArrayList<Project> projects = new ArrayList<Project>();
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_unpacking(zip.getName()), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return canceled.compareAndSet(false, true);
            }
        });
        handle.start();
        try {
            ArrayList<File> folders = new ArrayList<File>();
            FileInputStream is = new FileInputStream(zip);
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(is);
                while ((entry = zis.getNextEntry()) != null) {
                    if (canceled.get()) {
                        return;
                    }
                    String n = entry.getName();
                    File f = new File(root, n);
                    if (n.endsWith("/")) {
                        if (!f.isDirectory()) {
                            if (!f.mkdirs()) {
                                throw new IOException("could not make " + f);
                            }
                            if (entry.getTime() <= 0L || !f.setLastModified(entry.getTime())) {
                                // empty if block
                            }
                        }
                        folders.add(f);
                        continue;
                    }
                    handle.progress(Bundle.MSG_creating(n));
                    File p = f.getParentFile();
                    if (!p.isDirectory() && !p.mkdirs()) {
                        throw new IOException("could not make " + p);
                    }
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        FileUtil.copy((InputStream)zis, (OutputStream)os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    if (entry.getTime() > 0L && f.setLastModified(entry.getTime())) continue;
                }
            }
            finally {
                ((InputStream)is).close();
            }
            handle.switchToDeterminate(folders.size());
            for (int i = 0; i < folders.size(); ++i) {
                Project p;
                if (canceled.get()) {
                    return;
                }
                File folder = (File)folders.get(i);
                handle.progress(Bundle.MSG_checking(folder), i);
                FileObject fo = FileUtil.toFileObject((File)folder);
                if (fo == null || (p = ProjectManager.getDefault().findProject(fo)) == null) continue;
                projects.add(p);
            }
        }
        finally {
            handle.finish();
        }
        OpenProjects.getDefault().open(projects.toArray(new Project[projects.size()]), false, true);
    }

    private boolean check(NotificationLineSupport notifications) {
        block7: {
            notifications.clearMessages();
            if (this.zipField.getText().isEmpty()) {
                notifications.setInformationMessage(Bundle.ERR_no_zip_open());
                return false;
            }
            File zip = new File(this.zipField.getText());
            if (!zip.isFile()) {
                notifications.setErrorMessage(Bundle.ERR_zip_nonexistent(zip));
                return false;
            }
            try {
                if (!FileUtil.isArchiveFile((URL)Utilities.toURI((File)zip).toURL())) {
                    notifications.setErrorMessage(Bundle.ERR_not_zip(zip));
                    return false;
                }
            }
            catch (MalformedURLException x) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)x);
            }
        }
        if (this.folderField.getText().isEmpty()) {
            notifications.setInformationMessage(Bundle.ERR_no_folder());
            return false;
        }
        if (!new File(this.folderField.getText()).isDirectory()) {
            notifications.setErrorMessage(Bundle.ERR_folder_nonexistent(this.folderField.getText()));
            return false;
        }
        return true;
    }

    private ImportZIP() {
        this.initComponents();
        this.folderField.setText(ProjectChooser.getProjectsFolder().getAbsolutePath());
    }

    private void initComponents() {
        this.zipLabel = new JLabel();
        this.zipField = new JTextField();
        this.zipButton = new JButton();
        this.folderLabel = new JLabel();
        this.folderField = new JTextField();
        this.folderButton = new JButton();
        this.zipLabel.setLabelFor(this.zipField);
        Mnemonics.setLocalizedText((JLabel)this.zipLabel, (String)NbBundle.getMessage(ImportZIP.class, (String)"ImportZIP.zipLabel.text"));
        this.zipField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.zipButton, (String)NbBundle.getMessage(ImportZIP.class, (String)"ImportZIP.zipButton.text"));
        this.zipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportZIP.this.zipButtonActionPerformed(evt);
            }
        });
        this.folderLabel.setLabelFor(this.folderField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ImportZIP.class, (String)"ImportZIP.folderLabel.text"));
        this.folderField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)NbBundle.getMessage(ImportZIP.class, (String)"ImportZIP.folderButton.text"));
        this.folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportZIP.this.folderButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zipLabel).addComponent(this.folderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.folderField, GroupLayout.Alignment.TRAILING, -1, 199, Short.MAX_VALUE).addComponent(this.zipField, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zipButton).addComponent(this.folderButton)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zipLabel).addComponent(this.zipField, -2, -1, -2).addComponent(this.zipButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.folderField, -2, -1, -2).addComponent(this.folderButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void zipButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.LBL_zip_files(), "zip", "jar"));
        if (fc.showOpenDialog(this) == 0) {
            this.zipField.setText(fc.getSelectedFile().getAbsolutePath());
            this.firePropertyChange("validity", null, null);
        }
    }

    private void folderButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showSaveDialog(this) == 0) {
            this.folderField.setText(fc.getSelectedFile().getAbsolutePath());
            this.firePropertyChange("validity", null, null);
        }
    }

    public static final class ImportZIPAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            final ImportZIP panel = new ImportZIP();
            final JButton ok = new JButton(Bundle.LBL_import());
            NotifyDescriptor d = new NotifyDescriptor((Object)panel, Bundle.TITLE_import(), 2, -1, new Object[]{ok, NotifyDescriptor.CANCEL_OPTION}, null);
            final NotificationLineSupport notifications = d.createNotificationLineSupport();
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ok.setEnabled(panel.check(notifications));
                }
            });
            if (DialogDisplayer.getDefault().notify(d) == ok) {
                final File zip = new File(panel.zipField.getText());
                final File root = new File(panel.folderField.getText());
                ProjectChooser.setProjectsFolder((File)root);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImportZIP.unpackAndOpen(zip, root);
                        }
                        catch (IOException x) {
                            LOG.log(Level.WARNING, null, x);
                        }
                    }
                });
            }
        }
    }
}

