/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.problems;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.ui.problems.BrokenReferencesModel;
import org.netbeans.modules.project.ui.problems.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class BrokenReferencesCustomizer
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(BrokenReferencesCustomizer.class);
    private final BrokenReferencesModel model;
    private NotificationLineSupport nls;
    private JTextArea description;
    private JLabel descriptionLabel;
    private JList errorList;
    private JLabel errorListLabel;
    private JButton fix;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private static final String BROKEN_REF = "org/netbeans/modules/project/ui/resources/broken-reference.gif";
    private static final String RESOLVED_REF = "org/netbeans/modules/project/ui/resources/resolved-reference.gif";

    public BrokenReferencesCustomizer(BrokenReferencesModel model) {
        this.initComponents();
        this.model = model;
        this.errorList.setModel(model);
        this.errorList.setSelectedIndex(0);
        this.errorList.setCellRenderer(new ListCellRendererImpl());
        this.errorList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NonNull MouseEvent evt) {
                int index;
                if (evt.getClickCount() == 2 && (index = BrokenReferencesCustomizer.this.errorList.locationToIndex(evt.getPoint())) != -1 && BrokenReferencesCustomizer.this.fix.isEnabled()) {
                    BrokenReferencesCustomizer.this.fixActionImpl(BrokenReferencesCustomizer.this.errorList.getModel().getElementAt(index));
                }
            }
        });
    }

    private void initComponents() {
        this.errorListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.errorList = new JList();
        this.fix = new JButton();
        this.descriptionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JTextArea();
        this.setPreferredSize(new Dimension(550, 350));
        this.setLayout(new GridBagLayout());
        this.errorListLabel.setLabelFor(this.errorList);
        Mnemonics.setLocalizedText((JLabel)this.errorListLabel, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_List"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.errorListLabel, gridBagConstraints);
        this.errorListLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_List"));
        this.errorList.setSelectionMode(0);
        this.errorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BrokenReferencesCustomizer.this.errorListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.errorList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.5;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fix, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Fix"));
        this.fix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrokenReferencesCustomizer.this.fixActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 12);
        this.add((Component)this.fix, gridBagConstraints);
        this.fix.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Fix"));
        this.descriptionLabel.setLabelFor(this.description);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 3, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Description"));
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 60;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSN_BrokenReferencesCustomizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenReferencesCustomizer"));
    }

    private void errorListValueChanged(ListSelectionEvent evt) {
        this.updateSelection();
    }

    private void fixActionPerformed(ActionEvent evt) {
        this.fixActionImpl(this.errorList.getSelectedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixActionImpl(@NonNull Object value) {
        block23: {
            Future becomesResult;
            block24: {
                ProjectProblemsProvider.Result result;
                if (!(value instanceof BrokenReferencesModel.ProblemReference)) {
                    return;
                }
                BrokenReferencesModel.ProblemReference or = (BrokenReferencesModel.ProblemReference)value;
                this.errorList.setEnabled(false);
                this.fix.setEnabled(false);
                becomesResult = null;
                try {
                    becomesResult = or.problem.resolve();
                    assert (becomesResult != null);
                    if (becomesResult == null) {
                        this.updateAfterResolve(null);
                        break block23;
                    }
                    if (!becomesResult.isDone()) break block24;
                    result = null;
                }
                catch (Throwable throwable) {
                    if (becomesResult == null) {
                        this.updateAfterResolve(null);
                    } else if (becomesResult.isDone()) {
                        ProjectProblemsProvider.Result result2 = null;
                        try {
                            result2 = (ProjectProblemsProvider.Result)becomesResult.get();
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            this.updateAfterResolve(result2);
                        }
                    } else {
                        Future becomesResultFin = becomesResult;
                        RP.post(new Runnable(becomesResultFin){
                            final /* synthetic */ Future val$becomesResultFin;
                            {
                                this.val$becomesResultFin = future;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             */
                            @Override
                            public void run() {
                                AtomicReference result = new AtomicReference();
                                try {
                                    result.set(this.val$becomesResultFin.get());
                                }
                                catch (InterruptedException ie) {
                                    Exceptions.printStackTrace((Throwable)ie);
                                    SwingUtilities.invokeLater(new Runnable(result){
                                        final /* synthetic */ AtomicReference val$result;
                                        {
                                            this.val$result = atomicReference;
                                        }

                                        @Override
                                        public void run() {
                                            BrokenReferencesCustomizer.this.updateAfterResolve((ProjectProblemsProvider.Result)this.val$result.get());
                                        }
                                    });
                                }
                                catch (ExecutionException ee) {
                                    Exceptions.printStackTrace((Throwable)ee);
                                    {
                                        catch (Throwable throwable) {
                                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                            throw throwable;
                                        }
                                    }
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        });
                    }
                    throw throwable;
                }
                try {
                    result = (ProjectProblemsProvider.Result)becomesResult.get();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    this.updateAfterResolve(result);
                }
            }
            Future becomesResultFin = becomesResult;
            RP.post(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void updateAfterResolve(@NullAllowed ProjectProblemsProvider.Result result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        this.model.refresh();
        this.errorList.setEnabled(true);
        this.updateSelection();
        if (result != null) {
            this.notify(result.getStatus(), result.getMessage());
        }
    }

    private void updateSelection() {
        Object value = this.errorList.getSelectedValue();
        if (value instanceof BrokenReferencesModel.ProblemReference) {
            BrokenReferencesModel.ProblemReference reference = (BrokenReferencesModel.ProblemReference)value;
            if (!reference.resolved) {
                this.description.setText(reference.problem.getDescription());
                this.fix.setEnabled(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrokenReferencesCustomizer.this.jScrollPane2.getVerticalScrollBar().setValue(0);
                    }
                });
            } else {
                this.description.setText(Bundle.LBL_BrokenLinksCustomizer_Problem_Was_Resolved());
                this.fix.setEnabled(true);
            }
        } else {
            this.description.setText("");
            this.fix.setEnabled(false);
        }
        this.clearNotification();
    }

    synchronized void setNotificationLineSupport(@NullAllowed NotificationLineSupport notificationLineSupport) {
        Parameters.notNull((CharSequence)"notificationLineSupport", (Object)notificationLineSupport);
        this.nls = notificationLineSupport;
    }

    private synchronized void notify(@NonNull ProjectProblemsProvider.Status status, @NullAllowed String message) {
        if (message != null) {
            switch (status) {
                case RESOLVED: {
                    this.nls.setInformationMessage(message);
                    break;
                }
                case RESOLVED_WITH_WARNING: {
                    this.nls.setWarningMessage(message);
                    break;
                }
                case UNRESOLVED: {
                    this.nls.setErrorMessage(message);
                    break;
                }
                default: {
                    throw new IllegalStateException(status.name());
                }
            }
        }
    }

    private synchronized void clearNotification() {
        if (this.nls != null) {
            this.nls.clearMessages();
        }
    }

    private static class ListCellRendererImpl
    extends DefaultListCellRenderer {
        private ListCellRendererImpl() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof BrokenReferencesModel.ProblemReference) {
                BrokenReferencesModel.ProblemReference problemRef = (BrokenReferencesModel.ProblemReference)value;
                super.getListCellRendererComponent((JList<?>)list, problemRef.getDisplayName(), index, isSelected, cellHasFocus);
                if (problemRef.resolved) {
                    this.setIcon(ImageUtilities.loadImageIcon((String)BrokenReferencesCustomizer.RESOLVED_REF, (boolean)false));
                } else {
                    this.setIcon(ImageUtilities.loadImageIcon((String)BrokenReferencesCustomizer.BROKEN_REF, (boolean)false));
                }
            }
            return this;
        }
    }
}

