/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.problems;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectIconAnnotator;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class BrokenProjectAnnotator
implements ProjectIconAnnotator,
PropertyChangeListener {
    private static final String BROKEN_PROJECT_BADGE_PATH = "org/netbeans/modules/project/ui/resources/brokenProjectBadge.gif";
    private static final URL BROKEN_PROJECT_BADGE_URL = BrokenProjectAnnotator.class.getClassLoader().getResource("org/netbeans/modules/project/ui/resources/brokenProjectBadge.gif");
    private static final Image BROKEN_PROJECT_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/brokenProjectBadge.gif", (boolean)true);
    private static final int FIRE_DELAY = 500;
    private static final RequestProcessor FIRER = new RequestProcessor(BrokenProjectAnnotator.class.getName() + ".fire", 1, false, false);
    private static final Logger LOG = Logger.getLogger(BrokenProjectAnnotator.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor.Task task = FIRER.create(new Runnable(){

        @Override
        public void run() {
            BrokenProjectAnnotator.this.changeSupport.fireChange();
            LOG.fine("Fire.");
        }
    });
    private final Object cacheLock = new Object();
    private final Map<Project, Integer> brokenCache = new WeakHashMap<Project, Integer>();
    private final Map<ProjectProblemsProvider, Set<Reference<Project>>> problemsProvider2prj = new WeakHashMap<ProjectProblemsProvider, Set<Reference<Project>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Image annotateIcon(@NonNull Project project, @NonNull Image original, boolean openedNode) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"original", (Object)original);
        LOG.log(Level.FINE, "The annotateIcon called for project: {0}.", project);
        Integer problemsCount = null;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.brokenCache.containsKey(project)) {
                problemsCount = this.brokenCache.get(project);
                LOG.log(Level.FINE, "In cache: {0}.", problemsCount);
            } else {
                this.brokenCache.put(project, problemsCount);
                ProjectProblemsProvider ppp = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
                if (ppp != null) {
                    ppp.addPropertyChangeListener((PropertyChangeListener)this);
                    Set<Reference<Project>> projects = this.problemsProvider2prj.get(ppp);
                    if (projects == null) {
                        projects = new HashSet<Reference<Project>>();
                        this.problemsProvider2prj.put(ppp, projects);
                    }
                    projects.add(new WeakReference<Project>(project));
                }
                LOG.fine("Added listeners.");
            }
        }
        if (problemsCount == null) {
            ProjectProblemsProvider provider = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
            Collection<Object> problems = provider == null ? Collections.emptySet() : provider.getProblems();
            problemsCount = problems.size();
            Object object2 = this.cacheLock;
            synchronized (object2) {
                this.brokenCache.put(project, problemsCount);
                LOG.log(Level.FINE, "Set {0} to cache.", problemsCount);
            }
        }
        if (problemsCount > 0) {
            String message = problemsCount == 1 ? NbBundle.getMessage(BrokenProjectAnnotator.class, (String)"MSG_OneProblem") : NbBundle.getMessage(BrokenProjectAnnotator.class, (String)"MSG_MoreProblems", (Object)problemsCount);
            String messageHtml = String.format("<img src=\"%s\">&nbsp;%s", BROKEN_PROJECT_BADGE_URL.toExternalForm(), message);
            original = ImageUtilities.mergeImages((Image)original, (Image)ImageUtilities.assignToolTipToImage((Image)BROKEN_PROJECT_BADGE, (String)messageHtml), (int)8, (int)0);
        }
        return original;
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("problems".equals(name)) {
            Object object = this.cacheLock;
            synchronized (object) {
                Set<Reference<Project>> toRefresh = this.problemsProvider2prj.get(evt.getSource());
                if (toRefresh != null) {
                    LOG.fine("Event from known ProjectProblemsProvider -> clearing cache for:");
                    Iterator<Reference<Project>> it = toRefresh.iterator();
                    while (it.hasNext()) {
                        Reference<Project> ref = it.next();
                        Project prj = ref.get();
                        if (prj != null) {
                            this.brokenCache.put(prj, null);
                            LOG.log(Level.FINE, "Project: {0}", prj);
                            continue;
                        }
                        it.remove();
                    }
                } else {
                    LOG.fine("Event from unknown ProjectProblemsProvider -> clearing all caches.");
                }
            }
            this.task.schedule(500);
        }
    }
}

