/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.NewGroupPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class GroupsMenu
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static int MAX_COUNT = 20;
    private static final RequestProcessor RP = new RequestProcessor(GroupsMenu.class.getName());

    public GroupsMenu() {
        super(Bundle.GroupsMenu_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        return new Menu();
    }

    public JMenuItem getPopupPresenter() {
        return new Menu();
    }

    private static void newGroup() {
        final NewGroupPanel panel = new NewGroupPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_new_title());
        panel.setNotificationLineSupport(dd.createNotificationLineSupport());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GroupsMenu.class));
        final JButton create = new JButton(Bundle.GroupsMenu_new_create());
        create.setDefaultCapable(true);
        create.setEnabled(panel.isReady());
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ready".equals(evt.getPropertyName())) {
                    create.setEnabled(panel.isReady());
                }
            }
        });
        JButton cancel = new JButton(Bundle.GroupsMenu_new_cancel());
        dd.setOptions(new Object[]{create, cancel});
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(create)) {
            assert (panel.isReady());
            final NewGroupPanel.Type type = panel.getSelectedType();
            final boolean autoSync = panel.isAutoSyncField();
            final boolean useOpen = panel.isUseOpenedField();
            final String name = panel.getNameField();
            final String masterProject = panel.getMasterProjectField();
            final String directory = panel.getDirectoryField();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Group g = NewGroupPanel.create(type, name, autoSync, useOpen, masterProject, directory);
                    Group.setActiveGroup(g);
                }
            });
        }
    }

    private static void openProperties(Group g) {
        GroupEditPanel panel = g.createPropertiesPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.GroupsMenu_properties_title());
        panel.setNotificationLineSupport(dd.createNotificationLineSupport());
        dd.setOptionType(2);
        dd.setModal(true);
        dd.setHelpCtx(new HelpCtx(GroupsMenu.class));
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result.equals(NotifyDescriptor.OK_OPTION)) {
            panel.applyChanges();
        }
    }

    private static class Menu
    extends JMenu
    implements DynamicMenuContent {
        Menu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)Bundle.GroupsMenu_label());
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            if (!OpenProjectList.getDefault().openProjectsAPI().isDone()) {
                this.setEnabled(false);
                return new JComponent[]{this};
            }
            this.setEnabled(true);
            final Group active = Group.getActiveGroup();
            int counter = 0;
            for (final Group g : Group.allGroups()) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(g.getName());
                if (g.equals(active)) {
                    mi.setSelected(true);
                }
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                Group.setActiveGroup(g);
                            }
                        });
                    }
                });
                this.add(mi);
                if (++counter <= MAX_COUNT) continue;
                JMenuItem more = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)more, (String)Bundle.GroupsMenu_more());
                more.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object o;
                        JList<Object> lst = new JList<Object>();
                        DefaultListModel<Group> model = new DefaultListModel<Group>();
                        for (Group g : Group.allGroups()) {
                            model.addElement(g);
                        }
                        lst.setModel(model);
                        lst.setCellRenderer(new DefaultListCellRenderer(){

                            @Override
                            public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                                String text = ((Group)arg1).getName();
                                return super.getListCellRendererComponent((JList<?>)arg0, text, arg2, arg3, arg4);
                            }
                        });
                        JScrollPane pane = new JScrollPane(lst);
                        JPanel pnl = new JPanel();
                        pnl.setLayout(new BorderLayout(12, 12));
                        pnl.add(pane);
                        pnl.setPreferredSize(new Dimension(300, 300));
                        String select = Bundle.GroupsMenu_select();
                        NotifyDescriptor nd = new NotifyDescriptor((Object)pnl, Bundle.GroupsMenu_moreTitle(), 2, -1, new Object[]{select, NotifyDescriptor.CANCEL_OPTION}, (Object)select);
                        if (select == DialogDisplayer.getDefault().notify(nd) && (o = lst.getSelectedValue()) != null) {
                            RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    Group.setActiveGroup((Group)o);
                                }
                            });
                        }
                    }
                });
                this.add(more);
                break;
            }
            JMenuItem mi = new JRadioButtonMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)mi, (String)Bundle.GroupsMenu_no_group());
            if (active == null) {
                mi.setSelected(true);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            Group.setActiveGroup(null);
                        }
                    });
                }
            });
            this.add(mi);
            this.addSeparator();
            mi = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)mi, (String)Bundle.GroupsMenu_new_group());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GroupsMenu.newGroup();
                }
            });
            this.add(mi);
            if (active != null) {
                mi = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)mi, (String)Bundle.GroupsMenu_properties(active.getName()));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GroupsMenu.openProperties(active);
                    }
                });
                this.add(mi);
                mi = new JMenuItem();
                Mnemonics.setLocalizedText((AbstractButton)mi, (String)Bundle.GroupsMenu_remove(active.getName()));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NotifyDescriptor.Confirmation ask = new NotifyDescriptor.Confirmation((Object)Bundle.Delete_Confirm(active.getName()), 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)ask) == NotifyDescriptor.YES_OPTION) {
                            active.destroy();
                        }
                    }
                });
                this.add(mi);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

