/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.BrowseFolders;
import org.netbeans.modules.project.ui.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SimpleTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private Project project;
    private String expectedExtension;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SourceGroup[] folders;
    private boolean isFolder;
    private boolean freeFileExtension;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    public SimpleTargetChooserPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, boolean isFolder, boolean freeFileExtension) {
        this.project = project;
        this.folders = (SourceGroup[])folders.clone();
        this.isFolder = isFolder;
        this.freeFileExtension = freeFileExtension;
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.initValues(null, null, null);
        this.setPreferredSize(PREF_DIM);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(Bundle.LBL_SimpleTargetChooserPanel_Name());
    }

    final void initValues(FileObject template, FileObject preselectedFolder, String documentName) {
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (this.folders == null) {
            this.folders = sources.getSourceGroups("generic");
        }
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = this.getPreselectedGroup(this.folders, preselectedFolder);
        if (preselectedGroup != null) {
            this.locationComboBox.setSelectedItem(preselectedGroup);
            FileObject rootFolder = preselectedGroup.getRootFolder();
            if (rootFolder == null) {
                throw new NullPointerException("#173645: null returned illegally from " + preselectedGroup.getClass().getName() + ".getRootFolder()");
            }
            this.folderTextField.setText(this.getRelativeNativeName(rootFolder, preselectedFolder));
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        if (template != null) {
            String baseName;
            String string = baseName = this.isFolder ? Bundle.LBL_folder_name() : Bundle.LBL_SimpleTargetChooserPanelGUI_NewFilePrefix() + template.getName();
            if (documentName == null) {
                documentName = baseName;
            }
            if (preselectedFolder != null) {
                FileObject _tmp;
                int index = 0;
                while ((_tmp = preselectedFolder.getFileObject(documentName, template.getExt())) != null) {
                    documentName = baseName + ++index;
                }
            }
            this.documentNameTextField.setText(documentName);
            this.documentNameTextField.selectAll();
        }
        if (this.isFolder) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)Bundle.LBL_TargetChooser_FolderName_Label());
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)Bundle.LBL_TargetChooser_ParentFolder_Label());
            Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)Bundle.LBL_TargetChooser_CreatedFolder_Label());
        } else {
            Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)Bundle.LBL_TargetChooser_FileName_Label());
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)Bundle.LBL_TargetChooser_Folder_Label());
            Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)Bundle.LBL_TargetChooser_CreatedFile_Label());
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getTargetFolder() {
        String folderName = this.folderTextField.getText().trim();
        if (folderName.length() == 0) {
            return null;
        }
        return folderName.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI"));
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject folder) {
        for (int i = 0; folder != null && i < groups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)folder) && !groups[i].getRootFolder().equals(folder)) continue;
            return groups[i];
        }
        if (groups.length > 0) {
            return groups[0];
        }
        return null;
    }

    private String getRelativeNativeName(FileObject root, FileObject folder) {
        assert (root != null);
        String path = folder == null ? "" : FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        return path == null ? "" : path.replace('/', File.separatorChar);
    }

    private void updateCreatedFolder() {
        SourceGroup sg = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sg == null) {
            return;
        }
        FileObject root = sg.getRootFolder();
        if (root == null) {
            return;
        }
        String folderName = this.folderTextField.getText().trim();
        String documentName = this.documentNameTextField.getText().trim();
        String createdFileName = FileUtil.getFileDisplayName((FileObject)root) + (folderName.startsWith("/") || folderName.startsWith(File.separator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(File.separator) || folderName.length() == 0 ? "" : "/") + documentName + (!this.freeFileExtension || documentName.indexOf(46) == -1 ? this.expectedExtension : "");
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        this.changeSupport.fireChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = (SourceGroup)this.locationComboBox.getSelectedItem();
            if (group == null) {
                return;
            }
            fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.folderTextField.setText(relPath.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == e.getSource()) {
            this.updateCreatedFolder();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateCreatedFolder();
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SourceGroup) {
                String groupDisplayName;
                SourceGroup group = (SourceGroup)value;
                String projectDisplayName = ProjectUtils.getInformation((Project)SimpleTargetChooserPanelGUI.this.project).getDisplayName();
                if (projectDisplayName.equals(groupDisplayName = group.getDisplayName())) {
                    this.setText(groupDisplayName);
                } else {
                    this.setText(Bundle.FMT_PhysicalView_GroupName(groupDisplayName, projectDisplayName, group.getRootFolder().getName()));
                }
                this.setIcon(group.getIcon(false));
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

