/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.wizards.AnnotationGenerator;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FinishableProxyWizardPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.ServletPanel;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.modules.web.wizards.WrapperSelection;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final long serialVersionUID = -4147344271705652643L;
    private transient FileType fileType;
    private transient TargetEvaluator evaluator = null;
    private transient DeployData deployData = null;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wizard;
    private transient WizardDescriptor.Panel customPanel;

    private ServletIterator(FileType fileType) {
        this.fileType = fileType;
    }

    public static ServletIterator createServletIterator() {
        return new ServletIterator(FileType.SERVLET);
    }

    public static ServletIterator createFilterIterator() {
        return new ServletIterator(FileType.FILTER);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizard = (TemplateWizard)wiz;
        this.index = 0;
        if (this.fileType.equals(FileType.SERVLET) || this.fileType.equals(FileType.FILTER)) {
            this.deployData = new ServletData(this.fileType);
            if (Utilities.isJavaEE6(this.wizard)) {
                this.deployData.setMakeEntry(false);
            }
            this.evaluator = new TargetEvaluator(this.fileType, this.deployData);
        }
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = this.wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        this.evaluator.setInitialFolder(targetFolder, project);
        boolean canCreate = ((ServletData)this.deployData).canCreate(this.wizard);
        if (this.fileType == FileType.SERVLET) {
            this.panels = new WizardDescriptor.Panel[]{new FinishableProxyWizardPanel(this.createPackageChooserPanel(this.wizard, null), new HelpCtx(ServletIterator.class.getName() + "." + this.fileType), canCreate), ServletPanel.createServletPanel(this.evaluator, this.wizard)};
        } else if (this.fileType == FileType.FILTER) {
            this.customPanel = new WrapperSelection(this.wizard);
            this.panels = new WizardDescriptor.Panel[]{canCreate ? this.createPackageChooserPanel(this.wizard, this.customPanel) : new FinishableProxyWizardPanel(this.createPackageChooserPanel(this.wizard, this.customPanel), new HelpCtx(ServletIterator.class.getName() + "." + this.fileType), false), ServletPanel.createServletPanel(this.evaluator, this.wizard), ServletPanel.createFilterPanel(this.evaluator, this.wizard)};
        }
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private WizardDescriptor.Panel createPackageChooserPanel(TemplateWizard wizard, WizardDescriptor.Panel customPanel) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(project);
        if (customPanel == null) {
            if (sourceGroups.length == 0) {
                Sources sources = ProjectUtils.getSources((Project)project);
                sourceGroups = sources.getSourceGroups("generic");
                return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups);
            }
            return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups);
        }
        if (sourceGroups.length == 0) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sourceGroups = sources.getSourceGroups("generic");
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)customPanel);
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)customPanel);
    }

    public Set<DataObject> instantiate() throws IOException {
        WebModule wm;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        if (FileType.FILTER.equals(this.fileType) && ((WrapperSelection)this.customPanel).isWrapper()) {
            template = Templates.getTemplate((WizardDescriptor)this.wizard);
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("AdvancedFilter", "java");
        }
        HashMap<String, String> templateParameters = new HashMap<String, String>();
        templateParameters.put("servletEditorFold", NbBundle.getMessage(ServletIterator.class, (String)"MSG_ServletEditorFold"));
        this.initServletEmptyData();
        if (!this.deployData.makeEntry() && Utilities.isJavaEE6(this.wizard)) {
            if (this.fileType == FileType.SERVLET) {
                AnnotationGenerator.webServlet((ServletData)this.deployData, templateParameters);
            }
            if (this.fileType == FileType.FILTER) {
                AnnotationGenerator.webFilter((ServletData)this.deployData, templateParameters);
            }
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)this.wizard), templateParameters);
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        ContainerClassPathModifier modifier = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class);
        if (modifier != null) {
            modifier.extendClasspath(dobj.getPrimaryFile(), new String[]{"servlet-api"});
        }
        if (!this.deployData.makeEntry()) {
            return Collections.singleton(dobj);
        }
        if (!this.deployData.hasDD() && (wm = WebModule.getWebModule((FileObject)project.getProjectDirectory())) != null && wm.getDocumentBase() != null) {
            FileObject webInf = wm.getWebInf();
            if (webInf == null) {
                webInf = FileUtil.createFolder((FileObject)wm.getDocumentBase(), (String)"WEB-INF");
            }
            FileObject webXml = DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInf);
            this.deployData.setWebApp(webXml);
        }
        if (this.deployData.getClassName().length() == 0) {
            String targetName = this.wizard.getTargetName();
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            String packageName = null;
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            for (int i = 0; i < groups.length && packageName == null; ++i) {
                if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
                packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            this.deployData.setClassName(packageName.length() == 0 ? targetName : packageName + "." + targetName);
            String servletName = ((ServletData)this.deployData).createDDServletName(targetName);
            ((ServletData)this.deployData).createDDServletMapping(servletName);
        }
        this.deployData.createDDEntries();
        if (this.fileType == FileType.SERVLET && dobj.getPrimaryFile() != null) {
            dobj.getPrimaryFile().setAttribute("org.netbeans.modules.web.IsServletFile", (Object)Boolean.TRUE);
        }
        return Collections.singleton(dobj);
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizard = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ServletIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && (this.deployData.hasDD() || Utilities.isJavaEE6(this.wizard));
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private void initServletEmptyData() {
        if (this.fileType != FileType.SERVLET) {
            return;
        }
        if (!(this.deployData instanceof ServletData)) {
            return;
        }
        ServletData data = (ServletData)this.deployData;
        if (this.evaluator.getClassName() == null) {
            this.panels[1].readSettings((Object)this.wizard);
            data.createDDServletName(this.evaluator.getFileName());
            data.createDDServletMapping(data.getName());
        }
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

