/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.specs.support.bridge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.javaee.specs.support.api.JpaProvider;
import org.netbeans.modules.javaee.specs.support.spi.JpaProviderFactory;
import org.netbeans.modules.javaee.specs.support.spi.JpaSupportImplementation;

public class BridgingJpaSupportImpl
implements JpaSupportImplementation {
    private final J2eePlatform platform;

    public BridgingJpaSupportImpl(J2eePlatform platform) {
        this.platform = platform;
    }

    @Override
    public JpaProvider getDefaultProvider() {
        for (JpaProvider provider : this.getProviders()) {
            if (!provider.isDefault()) continue;
            return provider;
        }
        return null;
    }

    @Override
    public Set<JpaProvider> getProviders() {
        HashSet<JpaProvider> result = new HashSet<JpaProvider>();
        boolean check = this.platform.isToolSupported("jpaversionverification");
        boolean jpa1 = !check || this.platform.isToolSupported("jpa1.0");
        boolean jpa2 = !check || this.platform.isToolSupported("jpa2.0");
        for (Map.Entry<Provider, String> entry : BridgingJpaSupportImpl.getPossibleContainerProviders().entrySet()) {
            Provider provider = entry.getKey();
            if (!this.platform.isToolSupported(provider.getProviderClass())) continue;
            JpaProvider jpaProvider = JpaProviderFactory.createJpaProvider(provider.getProviderClass(), this.platform.isToolSupported(entry.getValue()), jpa1, jpa2);
            result.add(jpaProvider);
        }
        return result;
    }

    private static Map<Provider, String> getPossibleContainerProviders() {
        HashMap<Provider, String> candidates = new HashMap<Provider, String>();
        candidates.put(ProviderUtil.HIBERNATE_PROVIDER, "hibernatePersistenceProviderIsDefault1.0");
        candidates.put(ProviderUtil.HIBERNATE_PROVIDER2_0, "hibernatePersistenceProviderIsDefault2.0");
        candidates.put(ProviderUtil.TOPLINK_PROVIDER1_0, "toplinkPersistenceProviderIsDefault");
        candidates.put(ProviderUtil.KODO_PROVIDER, "kodoPersistenceProviderIsDefault");
        candidates.put(ProviderUtil.DATANUCLEUS_PROVIDER, "dataNucleusPersistenceProviderIsDefault");
        candidates.put(ProviderUtil.OPENJPA_PROVIDER, "openJpaPersistenceProviderIsDefault2.0");
        candidates.put(ProviderUtil.OPENJPA_PROVIDER1_0, "openJpaPersistenceProviderIsDefault1.0");
        candidates.put(ProviderUtil.ECLIPSELINK_PROVIDER, "eclipseLinkPersistenceProviderIsDefault");
        return candidates;
    }
}

