/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.netbeans.lib.ddl.impl.AbstractTableColumn;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.Table;

public class GrabTableHelper {
    public void execute(final DatabaseConnector connector, final Specification spec, final MetadataElementHandle<Table> tableHandle, final File file) throws Exception {
        MetadataModel model = connector.getDatabaseConnection().getMetadataModel();
        final Exception[] array = new Exception[1];
        model.runReadAction((Action)new Action<Metadata>(){

            public void run(Metadata metaData) {
                Table table = (Table)tableHandle.resolve(metaData);
                try {
                    CreateTable cmd = spec.createCommandCreateTable(table.getName());
                    Collection columns = table.getColumns();
                    LinkedList<TableColumn> pks = new LinkedList<TableColumn>();
                    for (Column column : columns) {
                        TableColumn col = connector.getColumnSpecification(table, column);
                        cmd.getColumns().add(col);
                        if (!col.getObjectType().equals("PRIMARY_KEY")) continue;
                        pks.add(col);
                    }
                    if (pks.size() > 1) {
                        GrabTableHelper.setPrimaryKeyColumns(pks, connector, cmd, table);
                    }
                    FileOutputStream fstream = new FileOutputStream(file);
                    ObjectOutputStream ostream = new ObjectOutputStream(fstream);
                    cmd.setSpecification(null);
                    ostream.writeObject(cmd);
                    ostream.flush();
                    ostream.close();
                }
                catch (Exception e) {
                    array[0] = e;
                }
            }
        });
        if (array[0] != null) {
            throw array[0];
        }
    }

    private static void setPrimaryKeyColumns(List<TableColumn> pks, DatabaseConnector connector, CreateTable cmd, Table table) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        assert (pks.size() > 1);
        Vector colItems = new Vector();
        for (TableColumn pKey : pks) {
            GrabTableHelper.setColumnFormatToStandard(connector, pKey);
            Hashtable<String, String> colItem = new Hashtable<String, String>();
            colItem.put("name", pKey.getColumnName());
            colItems.add(colItem);
        }
        TableColumn cmdcol = cmd.createPrimaryKeyConstraint(table.getName());
        cmdcol.setTableConstraintColumns(colItems);
        cmdcol.setColumnType(0);
        cmdcol.setColumnSize(0);
        cmdcol.setDecimalSize(0);
        cmdcol.setNullAllowed(true);
    }

    private static void setColumnFormatToStandard(DatabaseConnector connector, AbstractTableColumn column) {
        Map props = connector.getDatabaseSpecification().getProperties();
        Map cprops = connector.getDatabaseSpecification().getCommandProperties("CreateTableCommand");
        Map bindmap = (Map)cprops.get("Binding");
        String tname = (String)bindmap.get("COLUMN");
        column.setFormat((String)((Map)props.get(tname)).get("Format"));
    }
}

