/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardIterator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.ui.HostNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class HostListRootNode
extends AbstractNode {
    public static final String NODE_NAME = "remote";
    private static final String ICON_BASE = "org/netbeans/modules/remote/ui/servers.png";
    private final AddHostAction addHostAction;

    public static HostListRootNode getDefault() {
        return new HostListRootNode();
    }

    private HostListRootNode() {
        super(Children.create((ChildFactory)new HostChildren(), (boolean)true));
        this.setName(NODE_NAME);
        this.setDisplayName(NbBundle.getMessage(HostListRootNode.class, (String)"LBL_HostRootNode"));
        this.setIconBaseWithExtension(ICON_BASE);
        this.addHostAction = new AddHostAction();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.addHostAction};
    }

    private static class AddHostAction
    extends AbstractAction
    implements Runnable {
        private static final RequestProcessor RP = new RequestProcessor("AddHostAction", 1);

        public AddHostAction() {
            super(NbBundle.getMessage(HostListRootNode.class, (String)"AddHostMenuItem"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RP.post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setEnabled(true);
            } else {
                try {
                    this.work();
                }
                finally {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        private void work() {
            ArrayList<ServerRecord> hosts;
            ToolsCacheManager cacheManager = ToolsCacheManager.createInstance((boolean)true);
            ServerRecord newServerRecord = CreateHostWizardIterator.invokeMe(cacheManager);
            if (newServerRecord != null && !(hosts = new ArrayList<ServerRecord>(ServerList.getRecords())).contains(newServerRecord)) {
                hosts.add(newServerRecord);
                cacheManager.setHosts(hosts);
                cacheManager.setDefaultRecord(ServerList.getDefaultRecord());
                cacheManager.applyChanges();
            }
        }
    }

    private static class HostChildren
    extends ChildFactory<ExecutionEnvironment>
    implements PropertyChangeListener,
    Runnable {
        private final RequestProcessor.Task refreshTask;

        public HostChildren() {
            ServerList.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, null));
            this.refreshTask = new RequestProcessor("Refreshing Host List", 1).create((Runnable)this);
        }

        protected boolean createKeys(List<ExecutionEnvironment> toPopulate) {
            for (ExecutionEnvironment env : ServerList.getEnvironments()) {
                toPopulate.add(env);
            }
            return true;
        }

        protected Node createNodeForKey(ExecutionEnvironment key) {
            HostNode node = new HostNode(key);
            return node;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refreshTask.schedule(0);
        }

        @Override
        public void run() {
            this.refresh(true);
        }
    }
}

