/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;

public class FsTests {
    private FsTests() {
    }

    public static void testLs(List<FileObject> fileObjects, PrintWriter out, PrintWriter err) {
        try {
            new TestLs(fileObjects, out, err).test();
        }
        catch (IOException ex) {
            ex.printStackTrace(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFileToDevNull(FileObject fo) throws IOException {
        InputStream is = fo.getInputStream();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = rdr.readLine()) != null) {
            }
        }
        finally {
            rdr.close();
        }
    }

    private static class Counter {
        private int files = 0;
        private int directories = 0;
        private final int divider;
        private final PrintWriter writer;

        public Counter(PrintWriter writer, int divider) {
            this.divider = divider;
            this.writer = writer;
        }

        public int getFiles() {
            return this.files;
        }

        public void incrementFiles() {
            ++this.files;
            this.progress();
        }

        public int getDirectories() {
            return this.directories;
        }

        public void incrementDirectories() {
            ++this.directories;
            this.progress();
        }

        private void progress() {
            if ((this.directories + this.files) % this.divider == 0) {
                this.writer.printf("%d files in %d directories so far...\n", this.files, this.directories);
            }
        }
    }

    private static class LsProcessor
    extends BaseProcessor {
        private LsProcessor() {
        }
    }

    private static class ReadProcessor
    extends BaseProcessor {
        private ReadProcessor() {
        }

        @Override
        public void processFile(FileObject fo) throws IOException {
            if (fo.canRead()) {
                FsTests.readFileToDevNull(fo);
            } else {
                System.err.printf("Skipping %s\n", fo.getPath());
            }
        }
    }

    private static class BaseProcessor
    implements Processor {
        private BaseProcessor() {
        }

        @Override
        public void processFile(FileObject fo) throws IOException {
        }

        @Override
        public void processDir(FileObject fo) throws IOException {
        }
    }

    private static interface Processor {
        public void processFile(FileObject var1) throws IOException;

        public void processDir(FileObject var1) throws IOException;
    }

    private static class TestLs
    extends TestBase {
        public TestLs(List<FileObject> fileObjects, PrintWriter out, PrintWriter err) {
            super(fileObjects, out, err);
        }

        @Override
        protected Processor createProcessor() {
            return new LsProcessor();
        }
    }

    private static abstract class TestBase {
        private final PrintWriter out;
        private final PrintWriter err;
        private final List<FileObject> fileObjects;

        public TestBase(List<FileObject> fileObjects, PrintWriter out, PrintWriter err) {
            this.out = out;
            this.err = err;
            this.fileObjects = new ArrayList<FileObject>(fileObjects);
        }

        protected abstract Processor createProcessor();

        protected Counter createCounter() {
            return new Counter(this.out, 1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() throws IOException {
            long time = System.currentTimeMillis();
            Counter counter = this.createCounter();
            try {
                for (FileObject fo : this.fileObjects) {
                    this.recurse(fo, counter, this.createProcessor(), new HashSet<FileObject>());
                }
            }
            catch (Throwable throwable) {
                time = System.currentTimeMillis() - time;
                this.out.printf("Processing %d files in %d directories took %d seconds\n", counter.getFiles(), counter.getDirectories(), time / 1000L);
                throw throwable;
            }
            time = System.currentTimeMillis() - time;
            this.out.printf("Processing %d files in %d directories took %d seconds\n", counter.getFiles(), counter.getDirectories(), time / 1000L);
        }

        private void recurse(FileObject fo, Counter counter, Processor processor, Set<FileObject> bag) throws IOException {
            if (bag != null && !bag.contains(fo)) {
                bag.add(fo);
            }
            for (FileObject child : fo.getChildren()) {
                if (child.isFolder()) {
                    counter.incrementDirectories();
                    if (processor != null) {
                        processor.processDir(child);
                    }
                    this.recurse(child, counter, processor, bag);
                    continue;
                }
                counter.incrementFiles();
                if (processor == null) continue;
                processor.processFile(child);
            }
        }
    }
}

