/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.spi.remote.setup.HostValidator;
import org.netbeans.modules.cnd.spi.remote.setup.RemoteSyncFactoryDefaultProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HostValidatorImpl
implements HostValidator {
    private final ToolsCacheManager cacheManager;
    private Runnable runOnFinish;

    public HostValidatorImpl(ToolsCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Runnable getRunOnFinish() {
        return this.runOnFinish;
    }

    public ToolsCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public boolean validate(ExecutionEnvironment env, final PrintWriter writer) {
        boolean result = false;
        RemoteServerRecord record = (RemoteServerRecord)ServerList.get((ExecutionEnvironment)env);
        boolean alreadyOnline = record.isOnline();
        if (alreadyOnline) {
            String message = NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgAlreadyConnected1");
            message = String.format(message, env.toString());
            writer.printf("%s", message);
        } else {
            record.resetOfflineState();
        }
        if (!alreadyOnline) {
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgConnectingTo", (Object)env.getHost()));
        }
        try {
            ConnectionManager.getInstance().connectTo(env);
        }
        catch (InterruptedIOException ex) {
            return false;
        }
        catch (IOException ex) {
            writer.print("\n" + RemoteCommandSupport.getMessage(ex));
            return false;
        }
        catch (ConnectionManager.CancellationException ex) {
            return false;
        }
        if (!alreadyOnline) {
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgDone") + '\n');
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CSM_ConfHost") + '\n');
            record.init(null);
        }
        if (record.isOnline()) {
            Writer reporter = new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    String value = new String(cbuf, off, len);
                    writer.print(value);
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
            final CompilerSetManager csm = this.cacheManager.getCompilerSetManagerCopy(env, false);
            csm.initialize(false, false, reporter);
            if (record.hasProblems()) {
                try {
                    reporter.append(record.getProblems());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.runOnFinish = new Runnable(){

                @Override
                public void run() {
                    csm.finishInitialization();
                }
            };
            result = true;
        } else {
            writer.write(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.ErrConn") + '\n' + record.getReason());
        }
        if (alreadyOnline) {
            writer.write('\n' + NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgAlreadyConnected2"));
        } else {
            RemoteSyncFactoryDefaultProvider rsfdp = (RemoteSyncFactoryDefaultProvider)Lookup.getDefault().lookup(RemoteSyncFactoryDefaultProvider.class);
            if (rsfdp != null) {
                record.setSyncFactory(rsfdp.getDefaultFactory(env));
            }
        }
        return result;
    }
}

