/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NetworkRegistry;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostVisualPanel1;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class CreateHostWizardPanel1
implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private CreateHostVisualPanel1 component;
    private final CreateHostData data;
    private WizardDescriptor settings;
    private final AtomicBoolean knownError = new AtomicBoolean(false);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public CreateHostWizardPanel1(CreateHostData data) {
        this.data = data;
    }

    public CreateHostVisualPanel1 getComponent() {
        if (this.component == null) {
            this.component = new CreateHostVisualPanel1(this.data, this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewRemoteDevelopmentHostWizardP1");
    }

    public boolean isValid() {
        String user;
        String hostname = this.getComponent().getHostname();
        if (hostname == null || hostname.isEmpty()) {
            this.setError(NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.error.noHost"));
            return false;
        }
        Integer port = this.getComponent().getPort();
        if (port < 22) {
            this.setError(NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.error.invalidPort"));
            return false;
        }
        if (this.data.isManagingUser() && ((user = this.getComponent().getUser()) == null || user.isEmpty())) {
            this.setError(NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.error.noUser"));
            return false;
        }
        if (!this.getComponent().isProxyValid()) {
            this.setError(NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.error.invalidProxy"));
            return false;
        }
        if (!this.knownError.compareAndSet(true, false)) {
            this.settings.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public void readSettings(WizardDescriptor settings) {
        this.settings = settings;
        this.getComponent().init();
    }

    public void storeSettings(WizardDescriptor settings) {
        if (this.data.isManagingUser()) {
            this.data.setUserName(this.getComponent().getUser());
        }
        this.data.setHostName(this.getComponent().getHostname());
        this.data.setPort(this.getComponent().getPort());
    }

    public void prepareValidation() {
    }

    public void validate() throws WizardValidationException {
        String hostname = this.getComponent().getHostname();
        Integer port = this.getComponent().getPort();
        this.setInfo(NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.info.connecting", (Object)hostname, (Object)port));
        if (!NetworkRegistry.getInstance().isHostAccessible(hostname, port)) {
            String error = NbBundle.getMessage(CreateHostWizardPanel1.class, (String)"CreateHostWizardPanel1.error.pingFailed", (Object)hostname, (Object)port);
            this.setError(error);
            this.knownError.set(true);
            throw new WizardValidationException((JComponent)this.getComponent(), "pingFailed", error);
        }
        this.setInfo(null);
    }

    private void setError(final String error) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)error);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateHostWizardPanel1.this.settings.putProperty("WizardPanel_errorMessage", (Object)error);
                }
            });
        }
    }

    private void setInfo(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.settings.putProperty("WizardPanel_infoMessage", (Object)message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateHostWizardPanel1.this.settings.putProperty("WizardPanel_infoMessage", (Object)message);
                }
            });
        }
    }
}

