/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.proxysettings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class ProxySettingsPanel
extends JPanel {
    static final String OD_LAYER_FOLDER_NAME = "OptionsDialog";
    static final String CATEGORY_NAME = "General";
    private OptionsPanelController controller = null;
    private ScheduledFuture<?> stateQueryTask;
    private final JComponent origPanel;
    private static final RequestProcessor RP = new RequestProcessor("ProxySettingsPanel", 1);
    private JButton applyButton;
    private JPanel proxySettingPanel;

    public ProxySettingsPanel() {
        this.initComponents();
        this.origPanel = this.findGeneralOptionsPanel();
        if (this.origPanel != null) {
            this.hideUnwantedItems();
            this.proxySettingPanel.add((Component)this.origPanel, "Center");
        } else {
            this.stateQueryTask = null;
            this.proxySettingPanel.add(new JLabel(NbBundle.getMessage(ProxySettingsPanel.class, (String)"ProxySettingsPanel.error.noProxySettings")));
            this.applyButton.setVisible(false);
        }
    }

    public boolean isValidState() {
        if (this.controller == null) {
            return true;
        }
        return this.controller.isValid();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.controller != null) {
            this.stateQueryTask = RP.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ProxySettingsPanel.this.applyButton.setEnabled(ProxySettingsPanel.this.controller.isChanged() && ProxySettingsPanel.this.controller.isValid());
                }
            }, 0L, 200L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void removeNotify() {
        if (this.stateQueryTask != null) {
            this.stateQueryTask.cancel(false);
            this.stateQueryTask = null;
        }
        super.removeNotify();
    }

    private void initComponents() {
        this.proxySettingPanel = new JPanel();
        this.applyButton = new JButton();
        this.proxySettingPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.applyButton, (String)NbBundle.getMessage(ProxySettingsPanel.class, (String)"ProxySettingsPanel.applyButton.text"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProxySettingsPanel.this.applyButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proxySettingPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 249, Short.MAX_VALUE).addComponent(this.applyButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.proxySettingPanel, -1, 268, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton)));
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.controller.applyChanges();
        this.controller.update();
        this.applyButton.setEnabled(false);
        this.hideUnwantedItems();
    }

    private JComponent findGeneralOptionsPanel() {
        Lookup lookup = Lookups.forPath((String)OD_LAYER_FOLDER_NAME);
        Lookup.Result result = lookup.lookupResult(OptionsCategory.class);
        for (Lookup.Item item : result.allItems()) {
            String categoryID = item.getId().substring(OD_LAYER_FOLDER_NAME.length() + 1);
            if (!CATEGORY_NAME.equals(categoryID)) continue;
            this.controller = ((OptionsCategory)item.getInstance()).create();
            this.controller.update();
            return this.controller.getComponent(Lookup.EMPTY);
        }
        return null;
    }

    private void hideUnwantedItems() {
        int cnt = this.origPanel.getAccessibleContext().getAccessibleChildrenCount();
        boolean visible = false;
        boolean firstLabel = false;
        for (int i = 0; i < cnt; ++i) {
            Accessible accessibleChild = this.origPanel.getAccessibleContext().getAccessibleChild(i);
            if (!(accessibleChild instanceof JComponent)) continue;
            JComponent elem = (JComponent)((Object)accessibleChild);
            if (elem instanceof JSeparator) {
                elem.setVisible(false);
                visible = !visible;
                firstLabel = true;
                continue;
            }
            if (firstLabel && elem instanceof JLabel) {
                firstLabel = false;
                elem.setVisible(false);
                continue;
            }
            if (visible || !elem.isVisible()) continue;
            elem.setVisible(false);
        }
    }
}

