/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.Save;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.netbeans.modules.cnd.remote.ui.HostPropertiesDialog;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardIterator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditServerListDialog
extends JPanel
implements ActionListener,
PropertyChangeListener,
ListSelectionListener,
Save {
    private DefaultListModel model;
    private DialogDescriptor desc;
    private ServerRecord defaultRecord;
    private ProgressHandle phandle;
    private PropertyChangeSupport pcs;
    private boolean buttonsEnabled;
    private final ToolsCacheManager cacheManager;
    private final AtomicReference<ExecutionEnvironment> selectedEnv;
    private final boolean isRemoveAvaliable;
    private static final String CMD_ADD = "Add";
    private static final String CMD_REMOVE = "Remove";
    private static final String CMD_DEFAULT = "SetAsDefault";
    private static final String CMD_PATHMAPPER = "PathMapper";
    private static final String CMD_PROPERTIES = "Properties";
    private static final String CMD_RETRY = "Retry";
    private static final RequestProcessor RP = new RequestProcessor("EditServerListDialog", 1);
    private JButton btAddServer;
    private JButton btPathMapper;
    private JButton btProperties;
    private JButton btRemoveServer;
    private JButton btRetry;
    private JButton btSetAsDefault;
    private JScrollPane jScrollPane1;
    private JLabel lbDevHosts;
    private JLabel lbReason;
    private JLabel lbStatus;
    private JList lstDevHosts;
    private JPanel pbarStatusPanel;
    private JTextField tfReason;
    private JTextField tfStatus;

    public EditServerListDialog(ToolsCacheManager cacheManager, AtomicReference<ExecutionEnvironment> selectedEnv) {
        this(cacheManager, selectedEnv, true);
    }

    public EditServerListDialog(ToolsCacheManager cacheManager, AtomicReference<ExecutionEnvironment> selectedEnv, boolean removeAvaliable) {
        this.cacheManager = cacheManager;
        this.initComponents();
        this.initServerList(cacheManager.getServerUpdateCache());
        this.desc = null;
        this.tfReason.setEnabled(false);
        this.pbarStatusPanel.setVisible(false);
        this.selectedEnv = selectedEnv;
        this.isRemoveAvaliable = removeAvaliable;
        this.initListeners();
    }

    private void initListeners() {
        this.lstDevHosts.addListSelectionListener(this);
        this.btAddServer.addActionListener(this);
        if (this.isRemoveAvaliable) {
            this.btRemoveServer.addActionListener(this);
            this.btRemoveServer.setActionCommand(CMD_REMOVE);
        } else {
            this.btRemoveServer.setEnabled(false);
            this.btRemoveServer.setVisible(false);
        }
        this.btSetAsDefault.addActionListener(this);
        this.btPathMapper.addActionListener(this);
        this.btProperties.addActionListener(this);
        this.btRetry.addActionListener(this);
        this.btAddServer.setActionCommand(CMD_ADD);
        this.btSetAsDefault.setActionCommand(CMD_DEFAULT);
        this.btPathMapper.setActionCommand(CMD_PATHMAPPER);
        this.btProperties.setActionCommand(CMD_PROPERTIES);
        this.btRetry.setActionCommand(CMD_RETRY);
        this.pcs = new PropertyChangeSupport(this);
        this.pcs.addPropertyChangeListener(this);
        this.setButtons(true);
        this.valueChanged(null);
    }

    private void initServerList(ServerUpdateCache cache) {
        this.model = new DefaultListModel();
        if (cache == null) {
            for (ServerRecord rec : ServerList.getRecords()) {
                this.model.addElement(rec);
            }
            this.defaultRecord = ServerList.getDefaultRecord();
        } else {
            for (ServerRecord rec : cache.getHosts()) {
                this.model.addElement(rec);
            }
            this.defaultRecord = cache.getDefaultRecord();
            if (this.defaultRecord == null) {
                this.defaultRecord = ServerList.getDefaultRecord();
            }
        }
        this.lstDevHosts.setModel(this.model);
        this.lstDevHosts.setSelectedValue(this.defaultRecord, false);
        this.lstDevHosts.setCellRenderer(new MyCellRenderer());
    }

    private void checkDefaultButton(RemoteServerRecord record) {
        final ExecutionEnvironment env = record.getExecutionEnvironment();
        if (record.equals(this.defaultRecord)) {
            this.btSetAsDefault.setEnabled(false);
        } else if (!this.buttonsEnabled) {
            this.btSetAsDefault.setEnabled(false);
        } else if (env.isLocal()) {
            this.btSetAsDefault.setEnabled(true);
        } else {
            this.btSetAsDefault.setEnabled(false);
            final Runnable enabler = new Runnable(){

                @Override
                public void run() {
                    ServerRecord curr = (ServerRecord)EditServerListDialog.this.lstDevHosts.getSelectedValue();
                    if (curr != null && curr.getExecutionEnvironment().equals(env)) {
                        EditServerListDialog.this.btSetAsDefault.setEnabled(true);
                    }
                }
            };
            Runnable checker = new Runnable(){

                @Override
                public void run() {
                    CompilerSetManager compilerSetManagerCopy = EditServerListDialog.this.cacheManager.getCompilerSetManagerCopy(env, false);
                    if (!compilerSetManagerCopy.isEmpty()) {
                        SwingUtilities.invokeLater(enabler);
                    }
                }
            };
            RP.post(checker);
        }
    }

    private void revalidateRecord(final RemoteServerRecord record, String password, boolean rememberPassword) {
        if (!record.isOnline()) {
            record.resetOfflineState();
            this.setButtons(false);
            this.hideReason();
            this.phandle = ProgressHandleFactory.createHandle((String)"");
            this.pbarStatusPanel.removeAll();
            this.pbarStatusPanel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.phandle), "Center");
            this.pbarStatusPanel.setVisible(true);
            this.phandle.start();
            this.tfStatus.setText(NbBundle.getMessage(RemoteServerRecord.class, (String)RemoteServerRecord.State.INITIALIZING.toString()));
            RP.post(new Runnable(){

                @Override
                public void run() {
                    record.init(EditServerListDialog.this.pcs);
                    if (record.isOnline()) {
                        CompilerSetManager csm = EditServerListDialog.this.cacheManager.getCompilerSetManagerCopy(record.getExecutionEnvironment(), false);
                        csm.initialize(false, true, null);
                    }
                    EditServerListDialog.this.phandle.finish();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditServerListDialog.this.pbarStatusPanel.setVisible(false);
                            EditServerListDialog.this.setButtons(true);
                            EditServerListDialog.this.valueChanged(null);
                        }
                    });
                }
            });
        }
    }

    public void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
    }

    public List<ServerRecord> getHosts() {
        ArrayList<ServerRecord> result = new ArrayList<ServerRecord>(this.model.getSize());
        for (int i = 0; i < this.model.getSize(); ++i) {
            result.add((ServerRecord)this.model.get(i));
        }
        return result;
    }

    public ServerRecord getDefaultRecord() {
        return this.defaultRecord;
    }

    private void setButtons(boolean enable) {
        this.buttonsEnabled = enable;
        if (this.desc != null) {
            this.desc.setValid(enable);
        }
        this.btAddServer.setEnabled(enable);
        this.btAddServer.setEnabled(enable);
        if (this.isRemoveAvaliable) {
            this.btRemoveServer.setEnabled(enable);
        }
        this.btPathMapper.setEnabled(enable);
        this.btSetAsDefault.setEnabled(enable);
        this.btRetry.setEnabled(enable);
        this.btProperties.setEnabled(enable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String prop = evt.getPropertyName();
        if (source instanceof DialogDescriptor && prop.equals("valid")) {
            ((DialogDescriptor)source).setValid(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        RemoteServerRecord record = (RemoteServerRecord)this.lstDevHosts.getSelectedValue();
        if (record != null) {
            this.tfStatus.setText(record.getStateAsText());
            this.btRemoveServer.setEnabled(record.isRemote() && this.buttonsEnabled && this.isRemoveAvaliable);
            this.checkDefaultButton(record);
            this.btProperties.setEnabled(record.isRemote());
            this.btPathMapper.setEnabled(this.buttonsEnabled && record.isRemote() && record.getSyncFactory().isPathMappingCustomizable());
            if (!record.isOnline()) {
                this.showReason(record.getReason());
                this.btRetry.setEnabled(true);
            } else {
                this.hideReason();
                this.btRetry.setEnabled(false);
            }
            if (this.selectedEnv != null) {
                this.selectedEnv.set(record.getExecutionEnvironment());
            }
        } else {
            RemoteUtil.LOGGER.warning("ESLD.valueChanged: No selection in Dev Hosts list");
            if (this.selectedEnv != null) {
                this.selectedEnv.set(null);
            }
        }
    }

    private void showReason(String reason) {
        this.tfReason.setText(reason);
        this.tfReason.setEnabled(true);
    }

    private void hideReason() {
        this.tfReason.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o instanceof JButton) {
            JButton b = (JButton)o;
            if (b.getActionCommand().equals(CMD_ADD)) {
                this.cacheManager.setHosts(this.getHosts());
                ServerRecord result = CreateHostWizardIterator.invokeMe(this.cacheManager);
                if (result != null && !this.model.contains(result)) {
                    this.model.addElement(result);
                    this.lstDevHosts.setSelectedValue(result, true);
                }
            } else if (b.getActionCommand().equals(CMD_REMOVE)) {
                ServerRecord rec2delete = (ServerRecord)this.lstDevHosts.getSelectedValue();
                int idx = this.lstDevHosts.getSelectedIndex();
                if (rec2delete != null) {
                    this.model.removeElement(rec2delete);
                    this.lstDevHosts.setSelectedIndex(this.model.size() > idx ? idx : idx - 1);
                    if (this.defaultRecord.equals(rec2delete)) {
                        this.defaultRecord = (ServerRecord)this.lstDevHosts.getSelectedValue();
                    }
                }
                this.lstDevHosts.repaint();
            } else if (b.getActionCommand().equals(CMD_DEFAULT)) {
                this.defaultRecord = (ServerRecord)this.lstDevHosts.getSelectedValue();
                b.setEnabled(false);
                this.lstDevHosts.repaint();
            } else if (b.getActionCommand().equals(CMD_PATHMAPPER)) {
                EditPathMapDialog.showMe((ServerRecord)this.lstDevHosts.getSelectedValue());
            } else if (b.getActionCommand().equals(CMD_PROPERTIES)) {
                RemoteServerRecord record = (RemoteServerRecord)this.lstDevHosts.getSelectedValue();
                if (record.isRemote()) {
                    if (HostPropertiesDialog.invokeMe(record)) {
                        this.lstDevHosts.repaint();
                    }
                    this.btPathMapper.setEnabled(this.buttonsEnabled && record.isRemote() && record.getSyncFactory().isPathMappingCustomizable());
                }
            } else if (b.getActionCommand().equals(CMD_RETRY)) {
                this.revalidateRecord(this.getSelectedRecord(), null, false);
            }
        }
    }

    public void save(ToolsCacheManager cacheManager) {
        cacheManager.setHosts(this.getHosts());
        cacheManager.setDefaultRecord(this.getDefaultRecord());
    }

    private RemoteServerRecord getSelectedRecord() {
        return (RemoteServerRecord)this.lstDevHosts.getSelectedValue();
    }

    private void initComponents() {
        this.lbDevHosts = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDevHosts = new JList();
        this.btAddServer = new JButton();
        this.btRemoveServer = new JButton();
        this.btSetAsDefault = new JButton();
        this.btPathMapper = new JButton();
        this.btProperties = new JButton();
        this.lbStatus = new JLabel();
        this.tfStatus = new JTextField();
        this.btRetry = new JButton();
        this.lbReason = new JLabel();
        this.tfReason = new JTextField();
        this.pbarStatusPanel = new JPanel();
        this.setMinimumSize(new Dimension(419, 255));
        this.setLayout(new GridBagLayout());
        this.lbDevHosts.setLabelFor(this.lstDevHosts);
        Mnemonics.setLocalizedText((JLabel)this.lbDevHosts, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_ServerList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbDevHosts, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 200));
        this.lstDevHosts.setSelectionMode(0);
        this.lstDevHosts.setMinimumSize(new Dimension(200, 200));
        this.lstDevHosts.setSelectedIndex(0);
        this.jScrollPane1.setViewportView(this.lstDevHosts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1000.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btAddServer, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_AddServer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btAddServer, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btRemoveServer, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_RemoveServer"));
        this.btRemoveServer.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btRemoveServer, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btSetAsDefault, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_SetAsDefault"));
        this.btSetAsDefault.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btSetAsDefault, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btPathMapper, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_PathMapper"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btPathMapper, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btProperties, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"EditServerListDialog.btProperties.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.btProperties, gridBagConstraints);
        this.lbStatus.setLabelFor(this.tfStatus);
        Mnemonics.setLocalizedText((JLabel)this.lbStatus, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Status"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbStatus, gridBagConstraints);
        this.tfStatus.setColumns(20);
        this.tfStatus.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 6);
        this.add((Component)this.tfStatus, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btRetry, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Retry"));
        this.btRetry.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.add((Component)this.btRetry, gridBagConstraints);
        this.lbReason.setLabelFor(this.lbReason);
        Mnemonics.setLocalizedText((JLabel)this.lbReason, (String)NbBundle.getMessage(EditServerListDialog.class, (String)"LBL_Reason"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbReason, gridBagConstraints);
        this.tfReason.setEditable(false);
        this.tfReason.setPreferredSize(new Dimension(40, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 2, 0, 6);
        this.add((Component)this.tfReason, gridBagConstraints);
        this.pbarStatusPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.pbarStatusPanel, gridBagConstraints);
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel out = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                ServerRecord rec = (ServerRecord)value;
                out.setText(rec.getDisplayName());
                if (rec.equals(EditServerListDialog.this.getDefaultRecord())) {
                    out.setFont(out.getFont().deriveFont(1));
                }
            }
            return out;
        }
    }
}

