/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.remote.sync.Zipper;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class ZipSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private TimestampAndSharabilityFilter filter;
    private int totalCount;
    private int uploadCount;
    private long totalSize;
    private long uploadSize;

    public ZipSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FileObject privProjectStorageDir, FSPath ... paths) {
        super(executionEnvironment, out, err, privProjectStorageDir, paths);
    }

    private static File getTemp() {
        String tmpPath = System.getProperty("java.io.tmpdir");
        File tmpFile = CndFileUtils.createLocalFile((String)tmpPath);
        return tmpFile.exists() ? tmpFile : null;
    }

    private StringBuilder getLocalFilesString() {
        StringBuilder sb = new StringBuilder();
        for (File f : this.files) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getAbsolutePath());
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"REC"})
    private void synchronizeImpl(String remoteRoot) throws InterruptedException, ExecutionException, IOException {
        boolean success;
        long time;
        block34: {
            this.uploadCount = 0;
            this.totalCount = 0;
            this.uploadSize = 0L;
            this.totalSize = 0L;
            time = 0L;
            if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                System.out.printf("Uploading %s to %s ...\n", this.getLocalFilesString(), this.executionEnvironment);
                time = System.currentTimeMillis();
            }
            this.filter = new TimestampAndSharabilityFilter(this.privProjectStorageDir, this.executionEnvironment);
            StringBuilder script = new StringBuilder("sh -c \"");
            for (int i = 0; i < this.files.length; ++i) {
                String remoteFile = RemotePathMap.getPathMap(this.executionEnvironment).getRemotePath(this.files[i].getAbsolutePath(), true);
                if (!this.files[i].isDirectory()) continue;
                script.append(String.format("test -d %s  || echo %s; ", remoteFile, remoteFile));
            }
            script.append("\"");
            RemoteCommandSupport rcs = new RemoteCommandSupport(this.executionEnvironment, script.toString());
            if (rcs.run() != 0) {
                throw new IOException("Can not check remote directories");
            }
            ArrayList<Future> mkDirs = new ArrayList<Future>();
            String scriptOutput = rcs.getOutput().trim();
            if (scriptOutput.length() > 0) {
                String[] inexistentDirs = scriptOutput.split("\n");
                this.filter.clear();
                for (int i = 0; i < inexistentDirs.length; ++i) {
                    mkDirs.add(CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)inexistentDirs[i], (Writer)this.err));
                }
            }
            success = false;
            File zipFile = null;
            try {
                String localFileName = this.files[0].getName();
                if (localFileName.length() < 3) {
                    localFileName = localFileName + (localFileName.length() == 1 ? "_" : "__");
                }
                zipFile = File.createTempFile(localFileName, ".zip", ZipSyncWorker.getTemp());
                Zipper zipper = new Zipper(zipFile);
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    System.out.printf("\tZipping %s to %s...\n", this.getLocalFilesString(), zipFile);
                }
                long zipStart = System.currentTimeMillis();
                RemotePathMap pm = RemotePathMap.getPathMap(this.executionEnvironment);
                for (File file : this.files) {
                    String remoteDir = pm.getRemotePath(file.getAbsolutePath(), false);
                    if (remoteDir == null) {
                        throw new IOException("Can not find remote path for " + file.getAbsolutePath());
                    }
                    if (!remoteDir.startsWith(remoteRoot)) {
                        throw new IOException(remoteDir + " should start with " + remoteRoot);
                    }
                    String base = remoteDir.substring(remoteRoot.length() + 1);
                    zipper.add(file, this.filter, base);
                }
                zipper.close();
                float zipTime = (float)(System.currentTimeMillis() - zipStart) / 1000.0f;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    System.out.printf("\t%d files zipped; file size is %d\n", zipper.getFileCount(), zipFile.length());
                }
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    System.out.printf("\tZipping %s to %s took %f s\n", this.getLocalFilesString(), zipFile, Float.valueOf(zipTime));
                }
                if (zipper.getFileCount() == 0) {
                    success = true;
                    break block34;
                }
                for (Future mkDir : mkDirs) {
                    if ((Integer)mkDir.get() == 0) continue;
                    throw new IOException("Can not create directory " + remoteRoot);
                }
                String remoteFile = remoteRoot + '/' + zipFile.getName();
                long uploaStart = System.currentTimeMillis();
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: uploading %s to %s:%s ...\n", zipFile, this.executionEnvironment, remoteFile);
                }
                Future upload = CommonTasksSupport.uploadFile((String)zipFile.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remoteFile, (int)511);
                CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)upload.get();
                float uploadTime = (float)(System.currentTimeMillis() - uploaStart) / 1000.0f;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: uploading %s to %s:%s finished in %f s with rc=%d\n", zipFile, this.executionEnvironment, remoteFile, Float.valueOf(uploadTime), uploadStatus.getExitCode());
                }
                if (!uploadStatus.isOK()) {
                    if (this.err != null) {
                        this.err.println(uploadStatus.getError());
                    }
                    throw new IOException("uploading " + zipFile + " to " + this.executionEnvironment + ':' + remoteFile + " finished with error code " + uploadStatus.getExitCode());
                }
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: unzipping %s:%s ...\n", this.executionEnvironment, remoteFile);
                }
                long unzipStart = System.currentTimeMillis();
                NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                pb.setCommandLine("unzip -oqq " + remoteFile + " < /dev/null");
                pb.setWorkingDirectory(remoteRoot);
                pb.redirectError();
                NativeProcess proc = pb.call();
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (!RemoteUtil.LOGGER.isLoggable(Level.FINEST)) continue;
                        System.err.printf("\t%s\n", line);
                    }
                }
                finally {
                    in.close();
                }
                int rc = proc.waitFor();
                float unzipTime = (float)(System.currentTimeMillis() - unzipStart) / 1000.0f;
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                    System.out.printf("\tZSCP: unzipping %s:%s finished in %f s; rc=%d\n", this.executionEnvironment, remoteFile, Float.valueOf(unzipTime), rc);
                }
                if (rc != 0) {
                    throw new IOException("unzipping " + remoteFile + " at " + this.executionEnvironment + " finished with error code " + rc);
                }
                success = true;
                CommonTasksSupport.rmFile((ExecutionEnvironment)this.executionEnvironment, (String)remoteFile, (Writer)this.err);
                this.filter.flush();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (zipFile != null && zipFile.exists() && !zipFile.delete()) {
                    RemoteUtil.LOGGER.log(Level.INFO, "Can not delete temporary file {0}", zipFile.getAbsolutePath());
                }
            }
        }
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            long bps = this.uploadSize * 1000L / time;
            String speed = bps < 8192L ? bps + " b/s" : bps / 1024L + " Kb/s";
            String strTotalSize = this.totalSize < 1024L ? this.totalSize + " bytes" : this.totalSize / 1024L + " K";
            String strUploadSize = this.uploadSize < 1024L ? this.uploadSize + " bytes" : this.uploadSize / 1024L + " K";
            System.out.printf("Total: %s in %d files. Copied to %s:%s: %s in %d files. Time: %d ms. %s. Avg. speed: %s\n", strTotalSize, this.totalCount, this.executionEnvironment, remoteRoot, strUploadSize, this.uploadCount, time, success ? "OK" : "FAILURE", speed);
        }
    }

    public boolean startup(Map<String, String> env2add) {
        boolean success;
        block10: {
            if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.fileSystem)) {
                SyncUtils.warnDoubleRemote(this.executionEnvironment, this.fileSystem);
                return false;
            }
            String remoteRoot = RemotePathMap.getRemoteSyncRoot(this.executionEnvironment);
            if (remoteRoot == null) {
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            success = false;
            try {
                if (this.out != null) {
                    this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                RemotePathMap mapper = RemotePathMap.getPathMap(this.executionEnvironment);
                this.synchronizeImpl(remoteRoot);
                success = true;
            }
            catch (InterruptedException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (InterruptedIOException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (ExecutionException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
                }
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err == null) break block10;
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        return success;
    }

    public void shutdown() {
    }

    public boolean cancel() {
        return false;
    }

    private void refreshStatistics(File file, boolean accepted) {
        ++this.totalCount;
        this.totalSize += file.length();
        if (accepted) {
            ++this.uploadCount;
            this.uploadSize += file.length();
        }
    }

    private class TimestampAndSharabilityFilter
    implements FileFilter {
        private final FileData fileData;
        private final SharabilityFilter delegate;

        public TimestampAndSharabilityFilter(FileObject privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
            this.fileData = FileData.get(privProjectStorageDir, executionEnvironment);
            this.delegate = new SharabilityFilter();
        }

        @Override
        public boolean accept(File file) {
            boolean accepted = this.delegate.accept(file);
            if (accepted && !file.isDirectory()) {
                accepted = this.needsCopying(file);
                if (accepted) {
                    this.fileData.setState(file, FileState.COPIED);
                } else {
                    accepted = false;
                }
            }
            ZipSyncWorker.this.refreshStatistics(file, accepted);
            return accepted;
        }

        public void flush() {
            this.fileData.store();
        }

        private void clear() {
            this.fileData.clear();
        }

        private boolean needsCopying(File file) {
            FileData.FileInfo info = this.fileData.getFileInfo(file);
            FileState state = info == null ? FileState.INITIAL : info.state;
            switch (state) {
                case INITIAL: {
                    return true;
                }
                case TOUCHED: {
                    return true;
                }
                case COPIED: {
                    return false;
                }
                case ERROR: {
                    return true;
                }
                case UNCONTROLLED: {
                    return false;
                }
            }
            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)state)));
            return false;
        }
    }
}

