/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class SyncUtils {
    public static void arrangeComboBox(JComboBox cbSyncMode, ExecutionEnvironment execEnv) {
        ArrayList<RemoteSyncFactory> factories = new ArrayList<RemoteSyncFactory>();
        for (RemoteSyncFactory factory : RemoteSyncFactory.getFactories()) {
            if (!factory.isApplicable(execEnv)) continue;
            factories.add(factory);
        }
        cbSyncMode.setModel(new DefaultComboBoxModel<Object>(factories.toArray()));
        cbSyncMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RemoteSyncFactory factory = (RemoteSyncFactory)value;
                if (factory != null) {
                    label.setText(factory.getDisplayName());
                    label.setToolTipText(factory.getDescription());
                }
                return label;
            }
        });
    }

    static boolean isDoubleRemote(ExecutionEnvironment buildEnvironment, FileSystem sourceFileSystem) {
        ExecutionEnvironment sourceExecutionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)sourceFileSystem);
        if (sourceExecutionEnvironment.isRemote()) {
            return !buildEnvironment.equals(sourceExecutionEnvironment);
        }
        return false;
    }

    static void warnDoubleRemote(ExecutionEnvironment buildEnv, FileSystem sourceFileSystem) {
        ExecutionEnvironment sourceEnv = FileSystemProvider.getExecutionEnvironment((FileSystem)sourceFileSystem);
        String message = NbBundle.getMessage(SyncUtils.class, (String)"ErrorDoubleRemote", (Object)buildEnv, (Object)sourceFileSystem);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public static File[] toFiles(FSPath[] paths) {
        ArrayList<File> l = new ArrayList<File>(paths.length);
        for (FSPath path : paths) {
            if (!FileSystemProvider.getExecutionEnvironment((FileSystem)path.getFileSystem()).isLocal()) continue;
            l.add(new File(path.getPath()));
        }
        return l.toArray(new File[l.size()]);
    }

    public static FileSystem getSingleFileSystem(FSPath[] paths) {
        FileSystem fs = null;
        for (FSPath fsp : paths) {
            if (fs != null) {
                CndUtils.assertTrue((fs == fsp.getFileSystem() ? 1 : 0) != 0, (String)("Different file systems are unsupported: " + fs + ", " + fsp.getFileSystem()));
                break;
            }
            fs = fsp.getFileSystem();
        }
        if (fs == null) {
            CndUtils.getLogger().warning("Defaulting file systems to a local one");
            fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        return fs;
    }
}

