/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class FullRemoteSyncWorker
implements RemoteSyncWorker {
    private final ExecutionEnvironment executionEnvironment;
    private final FileSystem sourceFileSystem;
    private final PrintWriter out;
    private final PrintWriter err;
    private static final RequestProcessor RP = new RequestProcessor("FullRemoteSyncWoker", 1);

    public FullRemoteSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FSPath ... files) {
        this.executionEnvironment = executionEnvironment;
        this.sourceFileSystem = files.length == 0 ? FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()) : files[0].getFileSystem();
        this.out = out;
        this.err = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(Map<String, String> env2add) {
        if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.sourceFileSystem)) {
            SyncUtils.warnDoubleRemote(this.executionEnvironment, this.sourceFileSystem);
            return false;
        }
        try {
            final String hostName = RemoteUtil.getDisplayName(this.executionEnvironment);
            final Object lock = new Object();
            final AtomicReference<Boolean> waiting = new AtomicReference<Boolean>(true);
            if (this.out != null) {
                RequestProcessor.Task task = RP.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = lock;
                        synchronized (object) {
                            if (((Boolean)waiting.get()).booleanValue()) {
                                FullRemoteSyncWorker.this.out.println(NbBundle.getMessage(this.getClass(), (String)"FULL_Synchronizing_Message", (Object)hostName));
                            }
                        }
                    }
                });
                task.schedule(500);
            }
            ArrayList failedList = new ArrayList();
            boolean written = FileSystemProvider.waitWrites((ExecutionEnvironment)this.executionEnvironment, failedList);
            Object object = lock;
            synchronized (object) {
                waiting.set(false);
            }
            if (written) {
                return true;
            }
            if (this.err != null) {
                StringBuilder failedText = new StringBuilder();
                for (String file : failedList) {
                    if (failedText.length() > 0) {
                        failedText.append('\n');
                    }
                    failedText.append(file);
                }
                this.err.println(NbBundle.getMessage(this.getClass(), (String)"FULL_Failed_Message", (Object)hostName, (Object)failedText.toString()));
            }
            return false;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void shutdown() {
    }

    public boolean cancel() {
        return false;
    }
}

