/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

final class FtpSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker,
Cancellable {
    private TimestampAndSharabilityFilter filter;
    private int preliminaryCount;
    private int uploadCount;
    private long uploadSize;
    private volatile Thread thread;
    private boolean cancelled;
    private final PathMap mapper;
    private ProgressHandle progressHandle;

    public FtpSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FileObject privProjectStorageDir, FSPath ... paths) {
        super(executionEnvironment, out, err, privProjectStorageDir, paths);
        this.mapper = RemotePathMap.getPathMap(executionEnvironment);
    }

    private StringBuilder getLocalFilesString() {
        StringBuilder sb = new StringBuilder();
        for (File f : this.files) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(f.getAbsolutePath());
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeImpl(String remoteRoot) throws InterruptedException, ExecutionException, IOException {
        this.uploadCount = 0;
        this.uploadSize = 0L;
        long time = 0L;
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            System.out.printf("Uploading %s to %s ...\n", this.getLocalFilesString(), this.executionEnvironment);
            time = System.currentTimeMillis();
        }
        this.filter = new TimestampAndSharabilityFilter(this.privProjectStorageDir, this.executionEnvironment);
        this.preliminaryCount = 0;
        LinkedList<String> dirsToCreate = new LinkedList<String>();
        for (int i = 0; i < this.files.length; ++i) {
            File parent;
            File name = this.files[i];
            String remoteFile = this.mapper.getRemotePath(name.getAbsolutePath(), true);
            if (name.isFile() && (parent = name.getParentFile()) != null) {
                String remoteParent = this.mapper.getRemotePath(parent.getAbsolutePath(), true);
                dirsToCreate.add(remoteParent);
            }
            this.preprocessFile(name, dirsToCreate, remoteFile);
        }
        if (!dirsToCreate.isEmpty()) {
            dirsToCreate.add(0, "-p");
            ProcessUtils.ExitStatus status = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"mkdir", (String[])dirsToCreate.toArray(new String[dirsToCreate.size()]));
            if (!status.isOK()) {
                throw new IOException("Can not check remote directories: " + status.toString());
            }
        }
        this.progressHandle.switchToDeterminate(this.preliminaryCount);
        boolean success = false;
        try {
            for (File file : this.files) {
                String remoteFile = this.mapper.getRemotePath(file.getAbsolutePath(), false);
                if (remoteFile == null) {
                    throw new IOException("Can not find remote path for " + file.getAbsolutePath());
                }
                this.upload(file, remoteFile);
            }
            success = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.err.println(ex.getMessage());
        }
        if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            long bps = this.uploadSize * 1000L / time;
            String speed = bps < 8192L ? bps + " b/s" : bps / 1024L + " Kb/s";
            String strUploadSize = this.uploadSize < 1024L ? this.uploadSize + " bytes" : this.uploadSize / 1024L + " K";
            System.out.printf("\n\nCopied to %s:%s: %s in %d files. Time: %d ms. %s. Avg. speed: %s\n\n", this.executionEnvironment, remoteRoot, strUploadSize, this.uploadCount, time, success ? "OK" : "FAILURE", speed);
        }
    }

    private void preprocessFile(File file, List<String> dirsToCreate, String remoteFile) {
        if (file.isDirectory()) {
            File[] children;
            dirsToCreate.add(remoteFile);
            for (File child : children = file.listFiles(this.filter)) {
                this.preprocessFile(child, dirsToCreate, remoteFile + '/' + child.getName());
            }
        } else {
            ++this.preliminaryCount;
        }
    }

    private void upload(File srcFile, String remotePath) throws InterruptedException, ExecutionException, IOException {
        if (this.cancelled) {
            return;
        }
        if (srcFile.isDirectory()) {
            File[] srcFiles;
            for (File file : srcFiles = srcFile.listFiles(this.filter)) {
                this.upload(file, remotePath + '/' + file.getName());
            }
        } else {
            Future fileTask = CommonTasksSupport.uploadFile((String)srcFile.getAbsolutePath(), (ExecutionEnvironment)this.executionEnvironment, (String)remotePath, (int)448);
            CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)fileTask.get();
            if (uploadStatus.isOK()) {
                this.filter.setState(srcFile, FileState.COPIED);
                this.progressHandle.progress(srcFile.getAbsolutePath(), this.uploadCount++);
                this.uploadSize += srcFile.length();
            } else {
                if (this.err != null) {
                    this.err.println(uploadStatus.getError());
                }
                throw new IOException("uploading " + srcFile + " to " + this.executionEnvironment + ':' + remotePath + " finished with error code " + uploadStatus.getExitCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startup(Map<String, String> env2add) {
        if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.fileSystem)) {
            SyncUtils.warnDoubleRemote(this.executionEnvironment, this.fileSystem);
            return false;
        }
        String remoteRoot = RemotePathMap.getRemoteSyncRoot(this.executionEnvironment);
        if (remoteRoot == null) {
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            return false;
        }
        boolean success = false;
        this.thread = Thread.currentThread();
        this.cancelled = false;
        String title = "Uploading to " + ServerList.get((ExecutionEnvironment)this.executionEnvironment).getDisplayName();
        this.progressHandle = ProgressHandleFactory.createHandle((String)title, (Cancellable)this);
        this.progressHandle.start();
        try {
            if (this.out != null) {
                this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
            }
            this.synchronizeImpl(remoteRoot);
            boolean bl = success = !this.cancelled;
            if (success) {
                this.filter.flush();
            }
        }
        catch (InterruptedException ex) {
            RemoteUtil.LOGGER.finest(ex.getMessage());
        }
        catch (InterruptedIOException ex) {
            RemoteUtil.LOGGER.finest(ex.getMessage());
        }
        catch (ExecutionException ex) {
            RemoteUtil.LOGGER.log(Level.FINE, null, ex);
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.FINE, null, ex);
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)remoteRoot, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        finally {
            this.cancelled = false;
            this.thread = null;
            this.progressHandle.finish();
        }
        return success;
    }

    public void shutdown() {
    }

    public boolean cancel() {
        this.cancelled = true;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
        return true;
    }

    private static class TimestampAndSharabilityFilter
    implements FileFilter {
        private final FileData fileData;
        private final File fileDataStorageFile;
        private final SharabilityFilter delegate;

        public TimestampAndSharabilityFilter(FileObject privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
            this.fileData = FileData.get(privProjectStorageDir, executionEnvironment);
            this.fileDataStorageFile = FileUtil.toFile((FileObject)this.fileData.getDataFile());
            this.delegate = new SharabilityFilter();
        }

        @Override
        public boolean accept(File file) {
            if (file.equals(this.fileDataStorageFile)) {
                return false;
            }
            boolean accepted = this.delegate.accept(file);
            if (accepted && !file.isDirectory()) {
                accepted = this.needsCopying(file);
            }
            return accepted;
        }

        private boolean needsCopying(File file) {
            FileData.FileInfo info = this.fileData.getFileInfo(file);
            FileState state = info == null ? FileState.INITIAL : info.state;
            switch (state) {
                case INITIAL: {
                    return true;
                }
                case TOUCHED: {
                    return true;
                }
                case COPIED: {
                    return info.timestamp != file.lastModified();
                }
                case ERROR: {
                    return true;
                }
                case UNCONTROLLED: {
                    return false;
                }
            }
            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)state)));
            return false;
        }

        public void setState(File file, FileState state) {
            this.fileData.setState(file, state);
        }

        public void flush() {
            this.fileData.store();
        }

        private void clear() {
            this.fileData.clear();
        }
    }
}

