/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class FileData {
    private final Properties data = new Properties();
    private final FileObject privProjectStorageDir;
    private final String dataFileName;
    private static final String VERSION = "1.3";
    private static final String VERSION_KEY = "VERSION";
    private static Map<String, WeakReference<FileData>> instances = new HashMap<String, WeakReference<FileData>>();

    @Deprecated
    public static FileData get(File privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
        return FileData.get(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)privProjectStorageDir)), executionEnvironment);
    }

    public static FileData get(FileObject privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
        String key;
        try {
            key = FileSystemProvider.getCanonicalPath((FileObject)privProjectStorageDir);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            key = privProjectStorageDir.getPath();
        }
        key = key + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment);
        WeakReference<FileData> ref = instances.get(key);
        FileData instance = null;
        if (ref != null) {
            instance = (FileData)ref.get();
        }
        if (instance == null) {
            instance = new FileData(privProjectStorageDir, executionEnvironment);
            instances.put(key, new WeakReference<FileData>(instance));
        }
        return instance;
    }

    private FileData(FileObject privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
        this.privProjectStorageDir = privProjectStorageDir;
        this.dataFileName = "timestamps-" + executionEnvironment.getHost() + '-' + executionEnvironment.getUser() + '-' + executionEnvironment.getSSHPort();
        if (!Boolean.getBoolean("cnd.remote.timestamps.clear")) {
            try {
                this.load();
                if (!VERSION.equals(this.data.get(VERSION_KEY))) {
                    this.data.clear();
                }
            }
            catch (IOException ex) {
                this.data.clear();
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public FileObject getDataFile() throws IOException {
        return FileUtil.createData((FileObject)this.privProjectStorageDir, (String)this.dataFileName);
    }

    public FileState getState(File file) {
        FileInfo info = this.getFileInfo(file);
        return info == null ? FileState.UNCONTROLLED : info.state;
    }

    public void setState(File file, FileState state) {
        this.setFileInfo(file, state);
    }

    public FileInfo getFileInfo(File file) {
        return this.getFileInfo(this.getFileKey(file));
    }

    @SuppressWarnings(value={"RV"})
    public void store() {
        FileObject dataFile = null;
        try {
            dataFile = this.getDataFile();
            BufferedOutputStream os = new BufferedOutputStream(dataFile.getOutputStream());
            this.data.setProperty(VERSION_KEY, VERSION);
            this.data.store(os, null);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            try {
                if (dataFile != null) {
                    dataFile.delete();
                }
            }
            catch (IOException ex1) {
                System.err.printf("Error deleting file %s\n", dataFile.getPath());
            }
        }
    }

    public void clear() {
        this.data.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        FileObject dataFile = this.getDataFile();
        if (dataFile.isValid()) {
            long time = System.currentTimeMillis();
            InputStream is = dataFile.getInputStream();
            BufferedInputStream bs = new BufferedInputStream(is);
            try {
                this.data.load(bs);
            }
            finally {
                bs.close();
            }
            if (RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                time = System.currentTimeMillis() - time;
                System.out.printf("reading %d timestamps from %s took %d ms\n", this.data.size(), dataFile.getPath(), time);
            }
        }
    }

    private FileInfo getFileInfo(String fileKey) {
        String strValue = this.data.getProperty(fileKey, null);
        if (strValue != null && strValue.length() > 0) {
            char prefix = strValue.charAt(0);
            FileState state = FileState.fromId(prefix);
            strValue = strValue.substring(1);
            try {
                long timeStamp = Long.parseLong(strValue);
                return new FileInfo(state, timeStamp);
            }
            catch (NumberFormatException nfe) {
                RemoteUtil.LOGGER.warning(String.format("Incorrect status/timestamp format \"%s\" for %s", strValue, fileKey));
            }
        }
        return null;
    }

    private void setFileInfo(File file, FileState state) {
        String key = this.getFileKey(file);
        char prefix = state.id;
        this.data.put(key, String.format("%c%d", Character.valueOf(prefix), file.lastModified()));
    }

    private String getFileKey(File file) {
        String key = file.getAbsolutePath();
        if (!CndFileUtils.isSystemCaseSensitive()) {
            key = key.toLowerCase();
        }
        return key;
    }

    public static final class FileInfo {
        public final long timestamp;
        public final FileState state;

        public FileInfo(FileState mode, long timestamp) {
            this.state = mode;
            this.timestamp = timestamp;
        }

        public String toString() {
            return this.state.toString() + this.timestamp;
        }
    }
}

