/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RemoteProjectSupport {
    private RemoteProjectSupport() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration mk = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        if (mk != null) {
            return mk.getDevelopmentHost().getExecutionEnvironment();
        }
        return null;
    }

    public static boolean projectExists(Project project) {
        FileObject nbprojectFO;
        FileObject projDirFO = project.getProjectDirectory();
        return projDirFO != null && projDirFO.isValid() && (nbprojectFO = projDirFO.getFileObject("nbproject")) != null && nbprojectFO.isValid();
    }

    public static FileObject getPrivateStorage(Project project) {
        FileObject baseDir = project.getProjectDirectory();
        if (baseDir == null) {
            return null;
        }
        try {
            return FileUtil.createFolder((FileObject)baseDir, (String)"nbproject/private");
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }

    public static FSPath[] getProjectSourceDirs(Project project, AtomicReference<String> runDir) {
        MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration((Project)project);
        try {
            FileSystem fs = project.getProjectDirectory().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new FSPath[0];
        }
        if (conf == null) {
            return new FSPath[]{FSPath.toFSPath((FileObject)project.getProjectDirectory())};
        }
        return RemoteProjectSupport.getProjectSourceDirs(project, conf, runDir);
    }

    public static FSPath[] getProjectSourceDirs(Project project, MakeConfiguration conf, AtomicReference<String> runDir) {
        MakeConfigurationDescriptor mcs;
        FileObject baseDir = project.getProjectDirectory();
        if (baseDir == null) {
            return new FSPath[0];
        }
        if (conf == null) {
            return new FSPath[]{FSPath.toFSPath((FileObject)baseDir)};
        }
        if (runDir != null) {
            String d = conf.getMakefileConfiguration().getBuildCommandWorkingDirValue();
            FileSystem fs = conf.getBaseFSPath().getFileSystem();
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)d)) {
                d = conf.getBaseFSPath().getPath() + FileSystemProvider.getFileSeparatorChar((FileSystem)fs) + d;
            }
            d = FileSystemProvider.normalizeAbsolutePath((String)d, (FileSystem)fs);
            runDir.set(d);
        }
        HashSet<FSPath> sourceFilesAndDirs = new HashSet<FSPath>();
        if (!conf.isMakefileConfiguration()) {
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)baseDir));
        }
        if ((mcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)project)) == null) {
            return new FSPath[0];
        }
        if (!mcs.getBaseDirFileObject().isValid()) {
            return sourceFilesAndDirs.toArray(new FSPath[sourceFilesAndDirs.size()]);
        }
        for (String soorceRoot : mcs.getSourceRoots()) {
            FileObject fo = FileSystemProvider.getFileObject((FileObject)baseDir, (String)soorceRoot);
            if (fo == null) continue;
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)fo));
        }
        RemoteProjectSupport.addExtraFiles(mcs, sourceFilesAndDirs);
        ArrayList<Project> subProjects = new ArrayList<Project>(conf.getSubProjects());
        for (LibraryItem.ProjectItem requiredProject : conf.getRequiredProjectsConfiguration().getValue()) {
            Project p = requiredProject.getProject(conf.getBaseFSPath());
            if (p == null) continue;
            subProjects.add(p);
        }
        for (Project subProject : subProjects) {
            if (!subProject.getProjectDirectory().isValid()) continue;
            sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)subProject.getProjectDirectory()));
            MakeConfigurationDescriptor subMcs = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)subProject);
            for (String soorceRoot : mcs.getSourceRoots()) {
                FileObject fo = FileSystemProvider.getFileObject((FileObject)subProject.getProjectDirectory(), (String)soorceRoot);
                if (fo == null) continue;
                sourceFilesAndDirs.add(FSPath.toFSPath((FileObject)fo));
            }
            RemoteProjectSupport.addExtraFiles(subMcs, sourceFilesAndDirs);
        }
        return sourceFilesAndDirs.toArray(new FSPath[sourceFilesAndDirs.size()]);
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<FSPath> filesToSync) {
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getProjectItems());
        RemoteProjectSupport.addExtraFiles(subMcs, filesToSync, subMcs.getExternalFileItemsAsArray());
    }

    private static void addExtraFiles(MakeConfigurationDescriptor subMcs, Set<FSPath> filesToSync, Item[] items) {
        SharabilityFilter filter = new SharabilityFilter();
        for (Item item : items) {
            FileObject fo = item.getFileObject();
            if (fo == null || !fo.isValid()) {
                filesToSync.add(item.getFSPath());
                continue;
            }
            if (!filter.accept(fo)) {
                filesToSync.add(item.getFSPath());
                continue;
            }
            if (RemoteProjectSupport.isContained(item.getNormalizedPath(), filesToSync)) continue;
            filesToSync.add(item.getFSPath());
        }
    }

    private static boolean isContained(String itemAbsPath, Set<FSPath> paths) {
        for (FSPath dir : paths) {
            String alreadyAddedPath = dir.getPath() + '/';
            if (!itemAbsPath.startsWith(alreadyAddedPath)) continue;
            return true;
        }
        return false;
    }
}

