/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.cnd.spi.remote.setup.RemoteSyncFactoryDefaultProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class RemoteServerList
implements ServerListImplementation,
ConnectionListener {
    private static final String CND_REMOTE = "cnd.remote";
    private static final String REMOTE_SERVERS = "cnd.remote.servers";
    private static final String DEFAULT_INDEX = "cnd.remote.default";
    private int defaultIndex;
    private final PropertyChangeSupport pcs;
    private final ChangeSupport cs;
    private final ArrayList<RemoteServerRecord> unlisted;
    private final ArrayList<RemoteServerRecord> items = new ArrayList();
    private static final RequestProcessor RP = new RequestProcessor("Remote setup", 1);
    private static final Comparator<RemoteServerRecord> RECORDS_COMPARATOR = new Comparator<RemoteServerRecord>(){

        @Override
        public int compare(RemoteServerRecord o1, RemoteServerRecord o2) {
            boolean o2local;
            if (o1 == o2) {
                return 0;
            }
            boolean o1local = o1.getExecutionEnvironment().isLocal();
            if (o1local != (o2local = o2.getExecutionEnvironment().isLocal())) {
                if (o1local) {
                    return -1;
                }
                if (o2local) {
                    return 1;
                }
            }
            return o1.getServerName().compareTo(o2.getServerName());
        }
    };

    public RemoteServerList() {
        this.defaultIndex = RemoteServerList.getPreferences().getInt(DEFAULT_INDEX, 0);
        this.pcs = new PropertyChangeSupport(this);
        this.cs = new ChangeSupport((Object)this);
        this.unlisted = new ArrayList();
        RemoteServerRecord localRecord = new RemoteServerRecord(ExecutionEnvironmentFactory.getLocal(), null, RemoteSyncFactory.getDefault(), false);
        localRecord.setState(RemoteServerRecord.State.ONLINE);
        this.items.add(localRecord);
        String slist = RemoteServerList.getPreferences().get(REMOTE_SERVERS, null);
        if (slist != null) {
            List<RemoteServerRecord> toAdd = RemoteServerRecord.fromString(slist);
            for (RemoteServerRecord record : toAdd) {
                record.setState(RemoteServerRecord.State.OFFLINE);
                this.items.add(record);
            }
        }
        this.defaultIndex = Math.min(this.defaultIndex, this.items.size() - 1);
        this.refresh();
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)((Object)this), null));
    }

    public void connected(final ExecutionEnvironment env) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                RemoteServerList.this.checkSetup(env);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSetup(ExecutionEnvironment env) {
        block7: {
            ArrayList<RemoteServerRecord> recordsToNotify;
            block5: {
                ServerRecord record;
                block6: {
                    recordsToNotify = new ArrayList<RemoteServerRecord>();
                    RemoteServerList remoteServerList = this;
                    synchronized (remoteServerList) {
                        for (RemoteServerRecord rec : this.items) {
                            if (!rec.getExecutionEnvironment().equals(env)) continue;
                            recordsToNotify.add(rec);
                        }
                    }
                    if (!recordsToNotify.isEmpty()) break block5;
                    record = this.get(env);
                    if (!record.isDeleted()) break block6;
                    this.addServer(record.getExecutionEnvironment(), record.getDisplayName(), record.getSyncFactory(), false, true);
                    break block7;
                }
                if (record.isOnline()) break block7;
                record.validate(true);
                break block7;
            }
            for (RemoteServerRecord rec : recordsToNotify) {
                rec.checkHostInfo();
            }
        }
    }

    public void disconnected(ExecutionEnvironment env) {
    }

    public synchronized ServerRecord get(ExecutionEnvironment env) {
        return this.get(env, true);
    }

    public synchronized RemoteServerRecord get(ExecutionEnvironment env, boolean create) {
        for (RemoteServerRecord record : this.items) {
            if (!env.equals(record.getExecutionEnvironment())) continue;
            return record;
        }
        for (RemoteServerRecord record : this.unlisted) {
            if (!env.equals(record.getExecutionEnvironment())) continue;
            return record;
        }
        if (create) {
            RemoteServerRecord record = new RemoteServerRecord(env, null, RemoteServerList.getDefaultFactory(env), false);
            this.unlisted.add(record);
            return record;
        }
        return null;
    }

    @SuppressWarnings(value={"UG"})
    public ServerRecord get(Project project) {
        ExecutionEnvironment execEnv = RemoteProjectSupport.getExecutionEnvironment(project);
        if (execEnv != null) {
            return this.get(execEnv);
        }
        return null;
    }

    public synchronized ServerRecord getDefaultRecord() {
        return this.items.get(this.defaultIndex);
    }

    private synchronized void setDefaultIndexImpl(int defaultIndex) {
        int oldValue = this.defaultIndex;
        this.defaultIndex = defaultIndex;
        RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, defaultIndex);
        this.firePropertyChange("DEFAULT_RECORD", oldValue, defaultIndex);
    }

    public synchronized void setDefaultRecord(ServerRecord record) {
        assert (record != null);
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(record)) continue;
            this.setDefaultIndexImpl(i);
            return;
        }
        CndUtils.assertTrue((boolean)false, (String)"Can not set nonexistent record as default");
    }

    public synchronized List<ExecutionEnvironment> getEnvironments() {
        ArrayList<ExecutionEnvironment> result = new ArrayList<ExecutionEnvironment>(this.items.size());
        for (RemoteServerRecord item : this.items) {
            result.add(item.getExecutionEnvironment());
        }
        return result;
    }

    public synchronized ServerRecord addServer(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect) {
        return this.addServerImpl(execEnv, displayName, syncFactory, asDefault, connect, true);
    }

    private synchronized ServerRecord addServerImpl(ExecutionEnvironment execEnv, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect, boolean fireChanges) {
        RemoteServerRecord record = null;
        if (syncFactory == null) {
            syncFactory = RemoteServerList.getDefaultFactory(execEnv);
        }
        for (RemoteServerRecord r : this.items) {
            if (!r.getExecutionEnvironment().equals(execEnv)) continue;
            if (asDefault) {
                this.defaultIndex = this.items.indexOf(r);
                RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            }
            return r;
        }
        for (RemoteServerRecord r : this.unlisted) {
            if (!r.getExecutionEnvironment().equals(execEnv)) continue;
            record = r;
            break;
        }
        if (record == null) {
            record = new RemoteServerRecord(execEnv, displayName, syncFactory, connect);
        } else {
            record.setDeleted(false);
            record.setDisplayName(displayName);
            record.setSyncFactory(syncFactory);
            this.unlisted.remove(record);
        }
        ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
        this.items.add(record);
        Collections.sort(this.items, RECORDS_COMPARATOR);
        if (asDefault) {
            this.defaultIndex = this.items.indexOf(record);
        }
        if (fireChanges) {
            this.refresh();
            RemoteServerList.storePreferences();
            RemoteServerList.getPreferences().putInt(DEFAULT_INDEX, this.defaultIndex);
            this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
        }
        return record;
    }

    public static RemoteServerList getInstance() {
        RemoteServerList instance = null;
        for (ServerListImplementation inst : Lookup.getDefault().lookupAll(ServerListImplementation.class)) {
            if (!(inst instanceof RemoteServerList)) continue;
            instance = (RemoteServerList)inst;
            break;
        }
        return instance;
    }

    public static RemoteSyncFactory getDefaultFactory(ExecutionEnvironment env) {
        RemoteSyncFactoryDefaultProvider rsfdp = (RemoteSyncFactoryDefaultProvider)Lookup.getDefault().lookup(RemoteSyncFactoryDefaultProvider.class);
        if (rsfdp != null) {
            return rsfdp.getDefaultFactory(env);
        }
        return RemoteSyncFactory.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePreferences() {
        RemoteServerList instance = RemoteServerList.getInstance();
        if (instance == null) {
            RemoteUtil.LOGGER.warning("Can not find RemoteServerList instance");
            return;
        }
        ArrayList<RemoteServerRecord> records = new ArrayList<RemoteServerRecord>();
        RemoteServerList remoteServerList = instance;
        synchronized (remoteServerList) {
            for (RemoteServerRecord record : instance.items) {
                if (!record.isRemote()) continue;
                records.add(record);
            }
        }
        RemoteServerList.getPreferences().put(REMOTE_SERVERS, RemoteServerRecord.toString(records));
    }

    public synchronized void set(List<ServerRecord> records, ServerRecord defaultRecord) {
        ArrayList<RemoteServerRecord> oldItems = new ArrayList<RemoteServerRecord>(this.items);
        RemoteUtil.LOGGER.log(Level.FINEST, "ServerList: set {0}", records);
        Collection<ExecutionEnvironment> removed = this.clear();
        ArrayList<ExecutionEnvironment> allEnv = new ArrayList<ExecutionEnvironment>();
        for (ServerRecord rec : records) {
            this.addServerImpl(rec.getExecutionEnvironment(), rec.getDisplayName(), rec.getSyncFactory(), false, false, false);
            removed.remove(rec.getExecutionEnvironment());
            allEnv.add(rec.getExecutionEnvironment());
        }
        this.setDefaultRecord(defaultRecord);
        this.refresh();
        RemoteServerList.storePreferences();
        PasswordManager.getInstance().setServerList(allEnv);
        this.firePropertyChange("RECORD_LIST", oldItems, new ArrayList<RemoteServerRecord>(this.items));
    }

    public void save() {
        this.unlisted.clear();
    }

    private synchronized Collection<ExecutionEnvironment> clear() {
        ArrayList<ExecutionEnvironment> removed = new ArrayList<ExecutionEnvironment>();
        for (RemoteServerRecord record : this.items) {
            record.setDeleted(true);
            removed.add(record.getExecutionEnvironment());
        }
        RemoteServerList.getPreferences().remove(REMOTE_SERVERS);
        this.unlisted.addAll(this.items);
        this.items.clear();
        return removed;
    }

    private void refresh() {
        this.cs.fireChange();
    }

    public synchronized RemoteServerRecord getLocalhostRecord() {
        return this.items.get(0);
    }

    public boolean isValidExecutable(ExecutionEnvironment env, String path) {
        int exit_status;
        if (path == null || path.length() == 0) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RemoteUtil.LOGGER.warning("RemoteServerList.isValidExecutable from EDT");
        }
        if ((exit_status = RemoteCommandSupport.run(env, "test", "-x", path)) != 0 && !CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
            exit_status = RemoteCommandSupport.run(env, "test", "-x", "`which " + path + "`");
        }
        return exit_status == 0;
    }

    public synchronized Collection<? extends ServerRecord> getRecords() {
        return new ArrayList<RemoteServerRecord>(this.items);
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(property, oldValue, newValue);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(RemoteServerList.class);
    }

    public ServerRecord createServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory) {
        return new RemoteServerRecord(env, displayName, syncFactory, false);
    }
}

