/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Exceptions;

public class HostMappingProviderWindows
implements HostMappingProvider {
    @Override
    public Map<String, String> findMappings(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv) {
        Map<String, String> mappings = null;
        try {
            Process process = Runtime.getRuntime().exec("net use");
            InputStream output = process.getInputStream();
            mappings = HostMappingProviderWindows.parseNetUseOutput(otherExecEnv.getHost(), new InputStreamReader(output));
            return mappings;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyMap();
        }
    }

    @Override
    public boolean isApplicable(PlatformInfo hostPlatform, PlatformInfo otherPlatform) {
        return 3 == hostPlatform.getPlatform() && hostPlatform.isLocalhost();
    }

    static Map<String, String> parseNetUseOutput(String hostName, Reader outputReader) throws IOException {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(outputReader);
        String lastNonEmptyLine = null;
        String line = reader.readLine();
        while (line != null && !line.contains("----------------")) {
            if (line.length() > 0) {
                lastNonEmptyLine = line;
            }
            line = reader.readLine();
        }
        if (lastNonEmptyLine == null) {
            return Collections.emptyMap();
        }
        String[] words = lastNonEmptyLine.split("[ \t]+");
        if (words.length < 4) {
            return Collections.emptyMap();
        }
        int nLocal = lastNonEmptyLine.indexOf(words[1]);
        int nRemote = lastNonEmptyLine.indexOf(words[2]);
        int nNetwork = lastNonEmptyLine.indexOf(words[3]);
        line = reader.readLine();
        while (line != null) {
            if (line.indexOf(58) != -1) {
                String[] arRemote;
                String local = line.substring(nLocal, nRemote - 1).trim();
                String remote = line.substring(nRemote).trim();
                if (remote.length() > nNetwork - 1 - nRemote && remote.charAt(nNetwork - 2 - nRemote) == ' ') {
                    remote = remote.substring(0, nNetwork - 1 - nRemote).trim();
                }
                if (remote.length() > 2 && (arRemote = remote.substring(2).split("\\\\")).length >= 2) {
                    String host = arRemote[0];
                    String folder = arRemote[1];
                    if (hostName.equals(host)) {
                        mappings.put(folder, local.toLowerCase());
                    }
                }
            }
            line = reader.readLine();
        }
        return mappings;
    }
}

