/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelutil.spi.FileObjectRedirector;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CsmUtilities {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int LOCAL_MEMBER_BIT = 256;
    public static final int PUBLIC_LEVEL = 2;
    public static final int PROTECTED_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final int CONST_MEMBER_BIT = 512;
    public static final int ENUMERATOR = 1024;
    public static final int CONSTRUCTOR = 2048;
    public static final int GLOBAL = 4096;
    public static final int LOCAL = 8192;
    public static final int FILE_LOCAL = 16384;
    public static final int MEMBER = 32768;
    public static final int MACRO = 65536;
    public static final int DESTRUCTOR = 131072;
    public static final int OPERATOR = 262144;
    public static final int EXTERN = 524288;
    public static final int FORWARD = 0x100000;
    public static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace.summary") || Boolean.getBoolean("csm.utilities.trace");
    private static final RequestProcessor RP = new RequestProcessor(CsmUtilities.class.getName(), 1);
    private static final Pattern VCS_TMP_FILE = Pattern.compile("[\\\\/]vcs-[0-9]*[\\\\/]vcs-[0-9]*");
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    public static int getModifiers(CsmObject obj) {
        int mod = 0;
        if (CsmKindUtilities.isClassMember((CsmObject)obj)) {
            mod |= CsmUtilities.getMemberModifiers((CsmMember)obj);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)obj)) {
            CsmFunctionDefinition fun = (CsmFunctionDefinition)obj;
            CsmFunction decl = fun.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)decl)) {
                mod |= CsmUtilities.getMemberModifiers((CsmMember)decl);
            } else {
                if (decl == null) {
                    decl = fun;
                }
                if (CsmKindUtilities.isGlobalFunction((CsmObject)obj)) {
                    mod |= 0x1000;
                }
                if (CsmKindUtilities.isFileLocalFunction((CsmObject)decl)) {
                    mod |= 0x4000;
                }
            }
        } else {
            if (CsmKindUtilities.isGlobalVariable((CsmObject)obj) || CsmKindUtilities.isGlobalFunction((CsmObject)obj)) {
                mod |= 0x1000;
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)obj) || CsmKindUtilities.isFileLocalFunction((CsmObject)obj)) {
                mod |= 0x4000;
            }
            if (CsmKindUtilities.isEnumerator((Object)obj)) {
                mod |= 0x400;
            }
        }
        if (CsmClassifierResolver.getDefault().isForwardClass(obj)) {
            mod |= 0x100000;
        }
        if (CsmKindUtilities.isOperator((CsmObject)obj)) {
            mod |= 0x40000;
        }
        if (CsmKindUtilities.isVariable((CsmObject)obj)) {
            CsmVariable var = (CsmVariable)obj;
            mod |= var.getType() != null && var.getType().isConst() ? 512 : 0;
            if (var.isExtern()) {
                mod |= 0x80000;
            }
        }
        return mod;
    }

    public static int getMemberModifiers(CsmMember member) {
        int mod = 0;
        CsmVisibility visibility = member.getVisibility();
        if (CsmVisibility.PRIVATE == visibility) {
            mod = 2;
        } else if (CsmVisibility.PROTECTED == visibility) {
            mod = 4;
        } else if (CsmVisibility.PUBLIC == visibility) {
            mod = 1;
        }
        if (member.isStatic()) {
            mod |= 8;
        }
        mod |= 0x8000;
        if (CsmKindUtilities.isConstructor((CsmObject)member)) {
            mod |= 0x800;
        } else if (CsmKindUtilities.isDestructor((CsmObject)member)) {
            mod |= 0x20000;
        }
        return mod;
    }

    public static int getLevel(int modifiers) {
        if ((modifiers & 1) != 0) {
            return 2;
        }
        if ((modifiers & 4) != 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClass(CsmClassifier c) {
        return c.getKind() == CsmDeclaration.Kind.BUILT_IN;
    }

    public static CsmFile getCsmFile(Node node, boolean waitParsing) {
        return CsmUtilities.getCsmFile((DataObject)node.getLookup().lookup(DataObject.class), waitParsing, false);
    }

    public static DataObject getDataObject(JTextComponent component) {
        if (component == null) {
            return null;
        }
        Document doc = component.getDocument();
        return (DataObject)doc.getProperty("stream");
    }

    public static JTextComponent findOpenedEditor(DataObject dob) {
        if (dob == null) {
            return null;
        }
        List componentList = EditorRegistry.componentList();
        for (JTextComponent comp : componentList) {
            DataObject dobj;
            if (!(comp instanceof JEditorPane) || !dob.equals(dobj = CsmUtilities.getDataObject(comp))) continue;
            return (JEditorPane)comp;
        }
        return null;
    }

    public static JEditorPane findRecentEditorPaneInEQ(final EditorCookie ec) {
        assert (ec != null);
        final JEditorPane[] panes = new JEditorPane[]{null};
        if (SwingUtilities.isEventDispatchThread()) {
            panes[0] = NbDocument.findRecentEditorPane((EditorCookie)ec);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        panes[0] = NbDocument.findRecentEditorPane((EditorCookie)ec);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return panes[0];
    }

    public static TopComponent getTopComponentInEQ(final String tcID) {
        assert (tcID != null);
        final TopComponent[] tc = new TopComponent[]{null};
        if (SwingUtilities.isEventDispatchThread()) {
            tc[0] = WindowManager.getDefault().findTopComponent(tcID);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tc[0] = WindowManager.getDefault().findTopComponent(tcID);
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return tc[0];
    }

    public static File getFile(Document bDoc) {
        FileObject fo;
        DataObject dobj = NbEditorUtilities.getDataObject((Document)bDoc);
        if (dobj != null && dobj.isValid() && (fo = dobj.getPrimaryFile()) != null) {
            File file = FileUtil.toFile((FileObject)fo);
            return file;
        }
        return null;
    }

    public static CsmFile getCsmFile(JTextComponent comp, boolean waitParsing, boolean snapShot) {
        return comp == null ? null : CsmUtilities.getCsmFile(comp.getDocument(), waitParsing, snapShot);
    }

    public static CsmFile getCsmFile(Document bDoc, boolean waitParsing, boolean snapShot) {
        CsmFile csmFile = null;
        if (bDoc != null) {
            try {
                LanguagePath path;
                FileObject fileObject;
                InputAttributes inputAttributes;
                String mimeType;
                csmFile = (CsmFile)bDoc.getProperty(CsmFile.class);
                if (csmFile == null) {
                    csmFile = CsmUtilities.getCsmFile(NbEditorUtilities.getDataObject((Document)bDoc), waitParsing, snapShot);
                }
                if (csmFile == null && "text/x-dialog-binding".equals(mimeType = DocumentUtilities.getMimeType((Document)bDoc)) && (inputAttributes = (InputAttributes)bDoc.getProperty(InputAttributes.class)) != null && (csmFile = CsmUtilities.getCsmFile(fileObject = (FileObject)inputAttributes.getValue(path = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)mimeType).lookup(Language.class))), (Object)"dialogBinding.fileObject"), waitParsing, snapShot)) == null) {
                    Document d = (Document)inputAttributes.getValue(path, (Object)"dialogBinding.document");
                    csmFile = d == null ? null : CsmUtilities.getCsmFile(d, waitParsing, snapShot);
                }
            }
            catch (NullPointerException exc) {
                exc.printStackTrace(System.err);
            }
        }
        return csmFile;
    }

    public static CsmProject getCsmProject(Document bDoc) {
        CsmProject csmProject = null;
        try {
            csmProject = CsmUtilities.getCsmFile(bDoc, false, false).getProject();
        }
        catch (NullPointerException exc) {
            exc.printStackTrace(System.err);
        }
        return csmProject;
    }

    public static Collection<CsmProject> getOwnerCsmProjects(FileObject fo) {
        ArrayList<CsmProject> out = new ArrayList<CsmProject>();
        if (fo != null && fo.isValid()) {
            FileSystem fileSystem;
            String path = fo.getPath();
            try {
                fileSystem = fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                return null;
            }
            for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                NativeProject nativeProject;
                Object platformProject = csmProject.getPlatformProject();
                if (!(platformProject instanceof NativeProject) || !(nativeProject = (NativeProject)platformProject).getFileSystem().equals(fileSystem)) continue;
                NativeFileItem item = nativeProject.findFileItem(fo);
                if (item != null) {
                    out.add(csmProject);
                    continue;
                }
                ArrayList<String> sourceRoots = new ArrayList<String>();
                sourceRoots.add(nativeProject.getProjectRoot());
                sourceRoots.addAll(nativeProject.getSourceRoots());
                for (String src : sourceRoots) {
                    if (!path.startsWith(src)) continue;
                    int length = src.length();
                    if (path.length() != length && path.charAt(length) != '\\' && path.charAt(length) != '/') continue;
                    out.add(csmProject);
                }
            }
        }
        return out;
    }

    public static boolean isAnyNativeProjectOpened() {
        return !NativeProjectRegistry.getDefault().getOpenProjects().isEmpty();
    }

    public static boolean isTemporaryVCSFile(FileObject fo) {
        return VCS_TMP_FILE.matcher(fo.getPath()).find();
    }

    public static boolean isCsmSuitable(FileObject fo) {
        return CndPathUtilitities.isPathAbsolute((CharSequence)fo.getPath());
    }

    public static CsmFile[] getCsmFiles(DataObject dobj, boolean waitParsing, boolean snapShot) {
        if (dobj != null && dobj.isValid()) {
            try {
                CsmFile csmFile;
                FileObject fo;
                CsmProject csmProject;
                ArrayList<Object> files = new ArrayList<Object>();
                ArrayList<CsmFile> saFiles = new ArrayList<CsmFile>();
                NativeFileItemSet set = (NativeFileItemSet)dobj.getLookup().lookup(NativeFileItemSet.class);
                boolean hasNormalFiles = false;
                if (set != null && !set.isEmpty()) {
                    for (NativeFileItem item : set.getItems()) {
                        CsmFile file;
                        csmProject = CsmModelAccessor.getModel().getProject((Object)item.getNativeProject());
                        if (csmProject == null || (file = csmProject.findFile((Object)item, waitParsing, snapShot)) == null) continue;
                        if (item.getClass().getName().contains("StandaloneFileProvider")) {
                            saFiles.add(file);
                            continue;
                        }
                        hasNormalFiles = true;
                        files.add(file);
                    }
                    files.addAll(saFiles);
                }
                if (files.isEmpty() && (fo = dobj.getPrimaryFile()) != null && fo.isValid() && CsmUtilities.isCsmSuitable(fo) && (csmFile = CsmModelAccessor.getModel().findFile(FSPath.toFSPath((FileObject)fo), waitParsing, snapShot)) != null) {
                    files.add(csmFile);
                }
                if (CndUtils.isDebugMode()) {
                    for (int i = 0; i < files.size(); ++i) {
                        csmFile = (CsmFile)files.get(i);
                        csmProject = csmFile.getProject();
                        if (csmProject != null) {
                            Object platformProject = csmProject.getPlatformProject();
                            if (platformProject == null) {
                                CndUtils.assertTrueInConsole((boolean)false, (String)("null platform project for FILE " + csmFile + " from PROJECT " + csmProject));
                                continue;
                            }
                            if (!csmProject.isValid()) {
                                if (CsmModelAccessor.getModelState() != CsmModelState.ON) continue;
                                CndUtils.assertTrueInConsole((boolean)false, (String)("FILE " + csmFile + " from invalid PROJECT " + csmProject));
                                continue;
                            }
                            if (!hasNormalFiles || !platformProject.getClass().getName().contains("StandaloneFileProvider") || i != 0 || files.size() <= 1 || CsmModelAccessor.getModelState() != CsmModelState.ON) continue;
                            CndUtils.assertTrue((boolean)false, (String)("!!! STANDALONE FILE " + csmFile + "\nTOOK PRIORITY OVER OTHER FILES " + files));
                            continue;
                        }
                        CndUtils.assertTrue((boolean)false, (String)("FILE WITHOUT PROJECT" + csmFile));
                    }
                }
                return files.toArray(new CsmFile[files.size()]);
            }
            catch (BufferUnderflowException ex) {
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace(System.err);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new CsmFile[0];
    }

    public static CsmFile getCsmFile(DataObject dobj, boolean waitParsing, boolean snapShot) {
        CsmFile[] files = CsmUtilities.getCsmFiles(dobj, waitParsing, snapShot);
        if (files == null || files.length == 0) {
            return null;
        }
        if (waitParsing) {
            try {
                files[0].scheduleParsing(true);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return files[0];
    }

    public static CsmFile getCsmFile(FileObject fo, boolean waitParsing, boolean snapShot) {
        if (fo == null || !fo.isValid() || !CsmUtilities.isCsmSuitable(fo)) {
            return null;
        }
        try {
            return CsmUtilities.getCsmFile(DataObject.find((FileObject)fo), waitParsing, snapShot);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    public static FileObject getFileObject(CsmFile csmFile) {
        return csmFile == null ? null : csmFile.getFileObject();
    }

    public static FileObject getFileObject(Document doc) {
        FileObject fo = (FileObject)doc.getProperty(FileObject.class);
        if (fo == null) {
            DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
            if (dobj != null) {
                fo = dobj.getPrimaryFile();
            } else {
                CsmFile csmFile = CsmUtilities.getCsmFile(doc, false, false);
                if (csmFile != null) {
                    fo = CsmUtilities.getFileObject(csmFile);
                }
            }
        }
        return fo;
    }

    public static DataObject getDataObject(CsmFile csmFile) {
        return CsmUtilities.getDataObject(CsmUtilities.getFileObject(csmFile));
    }

    public static DataObject getDataObject(FileObject fo) {
        DataObject dob = null;
        if (fo != null) {
            try {
                dob = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dob;
    }

    public static Document getDocument(FileObject fo) {
        if (fo != null && fo.isValid()) {
            try {
                EditorCookie ec;
                DataObject dob = DataObject.find((FileObject)fo);
                if (dob != null && dob.isValid() && (ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null) {
                    return ec.getDocument();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static Document getDocument(CsmFile file) {
        FileObject fo = CsmUtilities.getFileObject(file);
        if (fo != null) {
            return CsmUtilities.getDocument(fo);
        }
        return null;
    }

    public static PositionBounds createPositionBounds(CsmOffsetable csmObj) {
        if (csmObj == null) {
            return null;
        }
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport(csmObj.getContainingFile());
        if (ces != null) {
            PositionRef beg = ces.createPositionRef(csmObj.getStartOffset(), Position.Bias.Forward);
            PositionRef end = ces.createPositionRef(csmObj.getEndOffset(), Position.Bias.Backward);
            return new PositionBounds(beg, end);
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(CsmFile csmFile) {
        DataObject dob = CsmUtilities.getDataObject(csmFile);
        return CsmUtilities.findCloneableEditorSupport(dob);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        if (dob == null) {
            return null;
        }
        Object obj = dob.getLookup().lookup(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getLookup().lookup(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static StyledDocument openDocument(EditorCookie cookie) {
        if (cookie == null) {
            return null;
        }
        StyledDocument document = null;
        try {
            try {
                document = cookie.openDocument();
            }
            catch (UserQuestionException e) {
                e.confirmed();
                document = cookie.openDocument();
            }
        }
        catch (UserQuestionException e) {
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return document;
    }

    public static StyledDocument openDocument(CloneableEditorSupport ces) {
        if (ces == null) {
            return null;
        }
        StyledDocument document = null;
        try {
            try {
                document = ces.openDocument();
            }
            catch (UserQuestionException e) {
                e.confirmed();
                document = ces.openDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return document;
    }

    public static boolean openSource(CsmObject element) {
        if (CsmKindUtilities.isOffsetable((Object)element)) {
            return CsmUtilities.openAtElement((CsmOffsetable)element);
        }
        if (CsmKindUtilities.isFile((CsmObject)element)) {
            CsmFile file = (CsmFile)element;
            FileTarget fileTarget = new FileTarget(file);
            return CsmUtilities.openAtElement(fileTarget);
        }
        return false;
    }

    public static boolean openSource(CsmFile file, int line, int column) {
        return CsmUtilities.openAtElement(CsmUtilities.getDataObject(file), new PointOrOffsetable(new Point(line, column)));
    }

    public static boolean openSource(FileObject fo, int line, int column) {
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            return CsmUtilities.openAtElement(dob, new PointOrOffsetable(new Point(line, column)));
        }
        catch (DataObjectNotFoundException ex) {
            return false;
        }
    }

    public static boolean openSource(FileObject fo, int offset) {
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            return CsmUtilities.openAtElement(dob, new PointOrOffsetable(offset));
        }
        catch (DataObjectNotFoundException ex) {
            return false;
        }
    }

    public static boolean openSource(PositionBounds position) {
        CloneableEditorSupport editorSupport = position.getBegin().getCloneableEditorSupport();
        editorSupport.edit();
        JEditorPane[] panes = editorSupport.getOpenedPanes();
        if (panes != null) {
            Container container;
            JumpList.checkAddEntry();
            JEditorPane pane = panes[0];
            pane.setCaretPosition(position.getBegin().getOffset());
            for (container = pane; container != null && !(container instanceof TopComponent); container = container.getParent()) {
            }
            if (container != null) {
                ((TopComponent)container).requestActive();
            }
        }
        return false;
    }

    private static boolean openAtElement(CsmOffsetable element) {
        return CsmUtilities.openAtElement(CsmUtilities.getDataObject(element.getContainingFile()), new PointOrOffsetable(element));
    }

    private static boolean openAtElement(DataObject orig, final PointOrOffsetable element) {
        DataObject dob = CsmUtilities.redirect(orig);
        if (dob != null) {
            final EditorCookie.Observable ec = (EditorCookie.Observable)dob.getLookup().lookup(EditorCookie.Observable.class);
            if (ec != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JumpList.checkAddEntry();
                        JEditorPane pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)ec);
                        if (pane != null) {
                            CsmUtilities.selectElementInPane(pane, element, false);
                        } else {
                            ec.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListenerImpl(ec, element));
                            ec.open();
                        }
                    }

                    class PropertyChangeListenerImpl
                    implements PropertyChangeListener,
                    Runnable {
                        private final EditorCookie.Observable ec;
                        private final PointOrOffsetable element;
                        private boolean detach = false;

                        public PropertyChangeListenerImpl(EditorCookie.Observable ec, PointOrOffsetable element) {
                            this.ec = ec;
                            this.element = element;
                        }

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("openedPanes".equals(evt.getPropertyName())) {
                                JEditorPane pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)this.ec);
                                if (pane != null || this.detach) {
                                    this.ec.removePropertyChangeListener((PropertyChangeListener)this);
                                }
                                if (pane != null) {
                                    SwingUtilities.invokeLater(this);
                                } else if (this.detach) {
                                    SwingUtilities.invokeLater(this);
                                }
                                this.detach = true;
                            }
                        }

                        @Override
                        public void run() {
                            JEditorPane pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)this.ec);
                            if (pane != null) {
                                CsmUtilities.selectElementInPane(pane, this.element, false);
                            }
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static void selectElementInPane(final JEditorPane pane, final PointOrOffsetable element, boolean delayProcessing) {
        Container temp;
        RP.post(new Runnable(){

            @Override
            public void run() {
                CsmUtilities.jumpToElement(pane, element);
            }
        });
        for (temp = pane; temp != null && !(temp instanceof TopComponent); temp = temp.getParent()) {
        }
        if (temp instanceof TopComponent) {
            ((TopComponent)temp).open();
            ((TopComponent)temp).requestActive();
            ((TopComponent)temp).requestVisible();
        }
    }

    private static void jumpToElement(JEditorPane pane, PointOrOffsetable pointOrOffsetable) {
        int start;
        Offsetable element = pointOrOffsetable.getOffsetable();
        Point point = pointOrOffsetable.getPoint();
        if (element == null) {
            start = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)pane.getDocument()), (int)(point.line - 1));
            start += point.column;
        } else {
            start = element.getOffset();
        }
        if (pane.getDocument() != null && start >= 0 && start < pane.getDocument().getLength()) {
            pane.setCaretPosition(start);
            if (DEBUG) {
                System.err.println("I'm going to " + start + " for element " + pointOrOffsetable);
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    private static int lineToPosition(JEditorPane pane, int docLine) {
        Document doc = pane.getDocument();
        int lineSt = 0;
        if (doc instanceof BaseDocument) {
            lineSt = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)docLine);
        } else {
            int len = doc.getLength();
            try {
                String text = doc.getText(0, len);
                boolean afterEOL = false;
                for (int i = 0; i < len; ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        if (--docLine == 0) {
                            return lineSt;
                        }
                        afterEOL = true;
                        continue;
                    }
                    if (!afterEOL) continue;
                    lineSt = i;
                    afterEOL = false;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        return lineSt;
    }

    public static String getElementJumpName(CsmObject element) {
        String text = "";
        if (element != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)element)) {
                text = ((Object)((CsmNamedElement)element).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)element)) {
                text = ((Object)((CsmStatement)element).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)element)) {
                text = ((Object)((CsmOffsetable)element).getText()).toString();
            }
            if (text.length() > 0) {
                text = "\"" + text + "\"";
            }
        }
        return text;
    }

    public static <T> Collection<T> merge(Collection<T> orig, Collection<T> newList) {
        ArrayList<T> arrayList = orig = orig != null ? orig : new ArrayList<T>();
        if (newList != null && newList.size() > 0) {
            orig.addAll(newList);
        }
        return orig;
    }

    public static <T> boolean removeAll(Collection<T> dest, Collection<T> removeItems) {
        if (dest != null && removeItems != null) {
            return dest.removeAll(removeItems);
        }
        return false;
    }

    public static String getCsmName(CsmObject obj) {
        StringBuilder buf = new StringBuilder();
        if (CsmKindUtilities.isNamedElement((CsmObject)obj)) {
            CsmNamedElement named = (CsmNamedElement)obj;
            buf.append(" [name] ").append(named.getName());
        } else {
            String simpleName = obj.getClass().getName();
            simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
            buf.append(" [class] ").append(simpleName);
        }
        if (CsmKindUtilities.isDeclaration((CsmObject)obj)) {
            CsmDeclaration decl = (CsmDeclaration)obj;
            buf.append(" [kind] ").append(decl.getKind());
        }
        return buf.toString();
    }

    public static String getSignature(CsmFunction fun) {
        return CsmUtilities.getSignature(fun, true);
    }

    public static String getSignature(CsmFunction fun, boolean showParamNames) {
        StringBuilder sb = new StringBuilder(CsmKindUtilities.isTemplate((CsmObject)fun) ? ((CsmTemplate)fun).getDisplayName() : fun.getName());
        if (!CsmKindUtilities.isProgram((CsmObject)fun)) {
            sb.append('(');
            boolean addComma = false;
            for (CsmParameter par : fun.getParameters()) {
                if (addComma) {
                    sb.append(", ");
                } else {
                    addComma = true;
                }
                if (showParamNames) {
                    sb.append(par.getDisplayText());
                    continue;
                }
                CsmType type = par.getType();
                if (type != null) {
                    sb.append(type.getText());
                    continue;
                }
                if (!par.isVarArgs()) continue;
                sb.append("...");
            }
            sb.append(')');
            if (CsmKindUtilities.isMethodDeclaration((CsmObject)fun) && ((CsmMethod)fun).isConst()) {
                sb.append(" const");
            }
        }
        return sb.toString();
    }

    private static DataObject redirect(DataObject dob) {
        if (dob == null) {
            return null;
        }
        Collection redirectors = Lookup.getDefault().lookupAll(FileObjectRedirector.class);
        for (FileObjectRedirector redirector : redirectors) {
            DataObject newDO = redirector.redirect(dob);
            if (newDO == null) continue;
            dob = newDO;
        }
        return dob;
    }

    private CsmUtilities() {
    }

    private static final class FileTarget
    implements CsmOffsetable {
        private CsmFile file;

        public FileTarget(CsmFile file) {
            this.file = file;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public String getText() {
            return "";
        }
    }

    private static class PointOrOffsetable {
        private final Object content;

        public PointOrOffsetable(Point point) {
            this.content = point;
        }

        public PointOrOffsetable(final CsmOffsetable offsetable) {
            this.content = new Offsetable(){

                @Override
                public int getOffset() {
                    return offsetable.getStartOffset();
                }
            };
        }

        public PointOrOffsetable(final int offset) {
            this.content = new Offsetable(){

                @Override
                public int getOffset() {
                    return offset;
                }
            };
        }

        public Point getPoint() {
            return this.content instanceof Point ? (Point)this.content : null;
        }

        public Offsetable getOffsetable() {
            return this.content instanceof Offsetable ? (Offsetable)this.content : null;
        }

        public String toString() {
            if (this.content instanceof Point) {
                Point point = (Point)this.content;
                return String.format("[%d:%d]", point.line, point.column);
            }
            return String.format("[%d]", ((Offsetable)this.content).getOffset());
        }
    }

    private static interface Offsetable {
        public int getOffset();
    }

    private static class Point {
        public final int line;
        public final int column;

        public Point(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }
}

